/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

/*------------------------------------------------------------------------------
	GetResForceOfOneElement3d
--------------------------------------------------------------------------------*/ 

void GetResForceOfOneElement3d(double E, double *K, double *Ux, double *Uy, double *Uz,
                        int nnx, int nny, int nnz, int node, double *F, int XorYorZ)
{
    int p,q;
    double *M;
    double LocalF;
    
    //p=NodeX+NodeY*nnx+NodeZ*nnx*nny; // p[0] points to Node 5 of Element 0  
    
   // printf("\nHier bin ich!\n"); getchar();
    /*------------------- 
       Numbering Nodes   
    
    y           3 - - 2
    |           |     |
    |           |     |
    z1 - - x    0 - - 1       
    
    y           7 - - 6
    |           |     |
    |           |     |
    z2 - - x    4 - - 5  
    
    -----! z1 > z2 !-----
    ---------------------*/
    
    q=node*72+XorYorZ*24;
    M=&(K[q]);

    /*------------------- 
       Numbering DOF   
    
    Node   DOF (x,y,z)
    1     (0,1,2)  
    2     (3,4,5)
    3     (6,7,8)
    4     (9,10,11)
    5     (12,13,14)
    6     (15,16,17)
    7     (18,19,20)
    8     (21,22,23)

    ---------------------*/
       
    nnz=nnx*nny;  
    LocalF=0.0;  
    LocalF+= M[0]*Ux[0];    
    LocalF+= M[1]*Uy[0];
    LocalF+= M[2]*Uz[0];
                 
    LocalF+= M[3]*Ux[1];
    LocalF+= M[4]*Uy[1];     
    LocalF+= M[5]*Uz[1];
           
    LocalF+= M[6]*Ux[1+nnx];      
    LocalF+= M[7]*Uy[1+nnx];
    LocalF+= M[8]*Uz[1+nnx];
    
    LocalF+= M[9] *Ux[nnx];      
    LocalF+= M[10]*Uy[nnx];
    LocalF+= M[11]*Uz[nnx];    
           
    LocalF+= M[12]*Ux[nnz];
    LocalF+= M[13]*Uy[nnz];
    LocalF+= M[14]*Uz[nnz];
           
    LocalF+= M[15]*Ux[nnz+1];
    LocalF+= M[16]*Uy[nnz+1];
    LocalF+= M[17]*Uz[nnz+1];
           
    LocalF+= M[18]*Ux[nnz+1+nnx];
    LocalF+= M[19]*Uy[nnz+1+nnx];
    LocalF+= M[20]*Uz[nnz+1+nnx];
           
    LocalF+= M[21]*Ux[nnz+nnx];
    LocalF+= M[22]*Uy[nnz+nnx];
    LocalF+= M[23]*Uz[nnz+nnx];

       
       F[0]+=(LocalF*E);    
       //printf("F: %f\n",F[0]); 
       return;
}

/*------------------------------------------------------------------------------
	GetLocalDisplacements_GS_3d
--------------------------------------------------------------------------------*/ 

int GetLocalDisplacements_GS_3d(
              int nnx, int nny, int nnz,
              MaterialBlock *Mat,
              double *MatFieldE, 
              int *MatFieldInt,
              double *Ux,  double *Uy, double *Uz,
			  double lambda,
              int *BcTypeX, int *BcTypeY, int *BcTypeZ,
              double *BcValueX, double *BcValueY, double *BcValueZ)
{
    register int i,j,k;
    register int pn, pe;
    int nex, ney, nez;
    double E0, E1, E2, E3, E4, E5, E6, E7,E;
    double F, Fx, Fy, Fz, dUx, dUy, dUz;
    double *K, *K0, *K1, *K2, *K3, *K4, *K5, *K6, *K7 ;
    int Valid[8]; 
    int knexney, kmin1nexney;
    int knnxnny, kmin1nnxnny;
    int jnex, jmin1nex;
    int jnnx, jmin1nnx;
    int imin1;
    
    
    nex=nnx-1;
    ney=nny-1;
    nez=nnz-1;

     
    for (k = 0; k < nnz; k++)  
    {
    knexney=k*nex*ney;
    kmin1nexney=(k-1)*nex*ney;
    knnxnny=k*nnx*nny;
    kmin1nnxnny=(k-1)*nnx*nny;
    for (j = 0; j < nny; j++) 
    {     
        jnex=j*nex;
        jmin1nex=(j-1)*nex;
        jnnx=j*nnx;
        jmin1nnx=(j-1)*nnx;
        for (i = 0; i < nnx; i++)   
        {
         imin1=i-1;
         Valid[0]=1; Valid[1]=1; Valid[2]=1; Valid[3]=1; 
         Valid[4]=1; Valid[5]=1; Valid[6]=1; Valid[7]=1; 
         
         if(0==i || 0==j || 0==k || i==nex || j==ney || k==nez)
         {
             if(0==i) { Valid[1]=0;Valid[2]=0;Valid[5]=0;Valid[6]=0; }
             if(0==j) { Valid[2]=0;Valid[3]=0;Valid[6]=0;Valid[7]=0; }
             if(0==k) { Valid[4]=0;Valid[5]=0;Valid[6]=0;Valid[7]=0; }
             
             if(nex==i) { Valid[0]=0;Valid[3]=0;Valid[4]=0;Valid[7]=0; }
             if(ney==j) { Valid[0]=0;Valid[1]=0;Valid[4]=0;Valid[5]=0; }
             if(nez==k) { Valid[0]=0;Valid[1]=0;Valid[2]=0;Valid[3]=0; }
	     
             pn = i+jnnx+knnxnny;
                  
         if (0==BcTypeX[pn])
         {
             F=0.0; E=0.0;
             if (1==Valid[0]){pe = i    + jnex     + knexney;     pn = i    + jnnx    + knnxnny;         E0=MatFieldE[pe]; E+=E0;K0=(Mat[MatFieldInt[pe]].K); K=K0;GetResForceOfOneElement3d(E0,K0, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 0, &F, 0);}
             if (1==Valid[1]){pe = imin1+ jnex     + knexney;     pn = imin1+ jnnx    + knnxnny;         E1=MatFieldE[pe]; E+=E1;K1=(Mat[MatFieldInt[pe]].K); K=K1;GetResForceOfOneElement3d(E1,K1, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 1, &F, 0);}
             if (1==Valid[2]){pe = imin1+ jmin1nex + knexney;     pn = imin1+ jmin1nnx+ knnxnny;         E2=MatFieldE[pe]; E+=E2;K2=(Mat[MatFieldInt[pe]].K); K=K2;GetResForceOfOneElement3d(E2,K2, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 2, &F, 0);}
             if (1==Valid[3]){pe = i    + jmin1nex + knexney;     pn = i    + jmin1nnx+ knnxnny;         E3=MatFieldE[pe]; E+=E3;K3=(Mat[MatFieldInt[pe]].K); K=K3;GetResForceOfOneElement3d(E3,K3, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 3, &F, 0);}
             if (1==Valid[4]){pe = i    + jnex     + kmin1nexney; pn = i    + jnnx    + kmin1nnxnny;     E4=MatFieldE[pe]; E+=E4;K4=(Mat[MatFieldInt[pe]].K); K=K4;GetResForceOfOneElement3d(E4,K4, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 4, &F, 0);}
             if (1==Valid[5]){pe = imin1+ jnex     + kmin1nexney; pn = imin1+ jnnx    + kmin1nnxnny;     E5=MatFieldE[pe]; E+=E5;K5=(Mat[MatFieldInt[pe]].K); K=K5;GetResForceOfOneElement3d(E5,K5, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 5, &F, 0);}
             if (1==Valid[6]){pe = imin1+ jmin1nex + kmin1nexney; pn = imin1+ jmin1nnx+ kmin1nnxnny;     E6=MatFieldE[pe]; E+=E6;K6=(Mat[MatFieldInt[pe]].K); K=K6;GetResForceOfOneElement3d(E6,K6, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 6, &F, 0);}
             if (1==Valid[7]){pe = i    + jmin1nex + kmin1nexney; pn = i    + jmin1nnx+ kmin1nnxnny;     E7=MatFieldE[pe]; E+=E7;K7=(Mat[MatFieldInt[pe]].K); K=K7;GetResForceOfOneElement3d(E7,K7, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 7, &F, 0);}
             pn = i+jnnx+knnxnny;
             Fx = BcValueX[pn]-F;
             dUx=(Fx/(E*K[0]));
             Ux[pn]+=lambda*dUx; 
             
         }
         pn = i+jnnx+knnxnny;
                  
         if (0==BcTypeY[pn])
         {
             F=0.0; E=0.0;
             if (1==Valid[0]){pe = i    + jnex     + knexney;     pn = i    + jnnx    + knnxnny;         E0=MatFieldE[pe]; E+=E0; K0=(Mat[MatFieldInt[pe]].K); K=K0;GetResForceOfOneElement3d(E0,K0, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 0, &F, 1);}
             if (1==Valid[1]){pe = imin1+ jnex     + knexney;     pn = imin1+ jnnx    + knnxnny;         E1=MatFieldE[pe]; E+=E1; K1=(Mat[MatFieldInt[pe]].K); K=K1;GetResForceOfOneElement3d(E1,K1, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 1, &F, 1);}
             if (1==Valid[2]){pe = imin1+ jmin1nex + knexney;     pn = imin1+ jmin1nnx+ knnxnny;         E2=MatFieldE[pe]; E+=E2; K2=(Mat[MatFieldInt[pe]].K); K=K2;GetResForceOfOneElement3d(E2,K2, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 2, &F, 1);}
             if (1==Valid[3]){pe = i    + jmin1nex + knexney;     pn = i    + jmin1nnx+ knnxnny;         E3=MatFieldE[pe]; E+=E3; K3=(Mat[MatFieldInt[pe]].K); K=K3;GetResForceOfOneElement3d(E3,K3, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 3, &F, 1);}
             if (1==Valid[4]){pe = i    + jnex     + kmin1nexney; pn = i    + jnnx    + kmin1nnxnny;     E4=MatFieldE[pe]; E+=E4; K4=(Mat[MatFieldInt[pe]].K); K=K4;GetResForceOfOneElement3d(E4,K4, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 4, &F, 1);}
             if (1==Valid[5]){pe = imin1+ jnex     + kmin1nexney; pn = imin1+ jnnx    + kmin1nnxnny;     E5=MatFieldE[pe]; E+=E5; K5=(Mat[MatFieldInt[pe]].K); K=K5;GetResForceOfOneElement3d(E5,K5, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 5, &F, 1);}
             if (1==Valid[6]){pe = imin1+ jmin1nex + kmin1nexney; pn = imin1+ jmin1nnx+ kmin1nnxnny;     E6=MatFieldE[pe]; E+=E6; K6=(Mat[MatFieldInt[pe]].K); K=K6;GetResForceOfOneElement3d(E6,K6, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 6, &F, 1);}
             if (1==Valid[7]){pe = i    + jmin1nex + kmin1nexney; pn = i    + jmin1nnx+ kmin1nnxnny;     E7=MatFieldE[pe]; E+=E7; K7=(Mat[MatFieldInt[pe]].K); K=K7;GetResForceOfOneElement3d(E7,K7, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 7, &F, 1);}
             pn = i+jnnx+knnxnny;
             Fy = BcValueY[pn]-F;
             dUy=(Fy/(E*K[25]));
             Uy[pn]+=lambda*dUy; 
             
         }
         
         pn = i+jnnx+knnxnny;
                  
         if (0==BcTypeZ[pn])
         {
             F=0.0; E=0.0;
             if (1==Valid[0]){pe = i    + jnex     + knexney;     pn = i    + jnnx    + knnxnny;         E0=MatFieldE[pe]; E+=E0;K0=(Mat[MatFieldInt[pe]].K); K=K0;GetResForceOfOneElement3d(E0,K0, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 0, &F, 2);}
             if (1==Valid[1]){pe = imin1+ jnex     + knexney;     pn = imin1+ jnnx    + knnxnny;         E1=MatFieldE[pe]; E+=E1;K1=(Mat[MatFieldInt[pe]].K); K=K1;GetResForceOfOneElement3d(E1,K1, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 1, &F, 2);}
             if (1==Valid[2]){pe = imin1+ jmin1nex + knexney;     pn = imin1+ jmin1nnx+ knnxnny;         E2=MatFieldE[pe]; E+=E2;K2=(Mat[MatFieldInt[pe]].K); K=K2;GetResForceOfOneElement3d(E2,K2, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 2, &F, 2);}
             if (1==Valid[3]){pe = i    + jmin1nex + knexney;     pn = i    + jmin1nnx+ knnxnny;         E3=MatFieldE[pe]; E+=E3;K3=(Mat[MatFieldInt[pe]].K); K=K3;GetResForceOfOneElement3d(E3,K3, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 3, &F, 2);}
             if (1==Valid[4]){pe = i    + jnex     + kmin1nexney; pn = i    + jnnx    + kmin1nnxnny;     E4=MatFieldE[pe]; E+=E4;K4=(Mat[MatFieldInt[pe]].K); K=K4;GetResForceOfOneElement3d(E4,K4, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 4, &F, 2);}
             if (1==Valid[5]){pe = imin1+ jnex     + kmin1nexney; pn = imin1+ jnnx    + kmin1nnxnny;     E5=MatFieldE[pe]; E+=E5;K5=(Mat[MatFieldInt[pe]].K); K=K5;GetResForceOfOneElement3d(E5,K5, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 5, &F, 2);}
             if (1==Valid[6]){pe = imin1+ jmin1nex + kmin1nexney; pn = imin1+ jmin1nnx+ kmin1nnxnny;     E6=MatFieldE[pe]; E+=E6;K6=(Mat[MatFieldInt[pe]].K); K=K6;GetResForceOfOneElement3d(E6,K6, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 6, &F, 2);}
             if (1==Valid[7]){pe = i    + jmin1nex + kmin1nexney; pn = i    + jmin1nnx+ kmin1nnxnny;     E7=MatFieldE[pe]; E+=E7;K7=(Mat[MatFieldInt[pe]].K); K=K7;GetResForceOfOneElement3d(E7,K7, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 7, &F, 2);}
             pn = i+jnnx+knnxnny;
             Fz = BcValueZ[pn]-F;
             dUz=(Fz/(E*K[50]));
             Uz[pn]+=lambda*dUz; 
             
         }
         }
         else
         {
	     //printf("i %i j %i k %i\n",i,j,k);
	     /*------------------------------------------------------------------------------ 
	     Element order: 1 : upper right; 2 : upper left; 3 : lower left ; 4 : lower right 
         -------------------------------------------------------------------------------*/
         pn = i+jnnx+knnxnny;
                  
         if (0==BcTypeX[pn])
         {
             F=0.0; 
             {pe = i    + jnex     + knexney;     pn = i    + jnnx    + knnxnny;         E0=MatFieldE[pe]; K0=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E0,K0, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 0, &F, 0);}
             {pe = imin1+ jnex     + knexney;     pn = imin1+ jnnx    + knnxnny;         E1=MatFieldE[pe]; K1=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E1,K1, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 1, &F, 0);}
             {pe = imin1+ jmin1nex + knexney;     pn = imin1+ jmin1nnx+ knnxnny;         E2=MatFieldE[pe]; K2=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E2,K2, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 2, &F, 0);}
             {pe = i    + jmin1nex + knexney;     pn = i    + jmin1nnx+ knnxnny;         E3=MatFieldE[pe]; K3=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E3,K3, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 3, &F, 0);}
             {pe = i    + jnex     + kmin1nexney; pn = i    + jnnx    + kmin1nnxnny;     E4=MatFieldE[pe]; K4=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E4,K4, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 4, &F, 0);}
             {pe = imin1+ jnex     + kmin1nexney; pn = imin1+ jnnx    + kmin1nnxnny;     E5=MatFieldE[pe]; K5=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E5,K5, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 5, &F, 0);}
             {pe = imin1+ jmin1nex + kmin1nexney; pn = imin1+ jmin1nnx+ kmin1nnxnny;     E6=MatFieldE[pe]; K6=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E6,K6, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 6, &F, 0);}
             {pe = i    + jmin1nex + kmin1nexney; pn = i    + jmin1nnx+ kmin1nnxnny;     E7=MatFieldE[pe]; K7=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E7,K7, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 7, &F, 0);}
             pn = i+jnnx+knnxnny;
             Fx = BcValueX[pn]-F;
             dUx=(Fx/((E0+E1+E2+E3+E4+E5+E6+E7)*K0[0]));
             Ux[pn]+=(lambda*dUx); 
                          
         }
         pn = i+jnnx+knnxnny;
                  
         if (0==BcTypeY[pn])
         {
             F=0.0; 
             {pe = i    + jnex     + knexney;     pn = i    + jnnx    + knnxnny;         E0=MatFieldE[pe]; K0=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E0,K0, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 0, &F, 1);}
             {pe = imin1+ jnex     + knexney;     pn = imin1+ jnnx    + knnxnny;         E1=MatFieldE[pe]; K1=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E1,K1, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 1, &F, 1);}
             {pe = imin1+ jmin1nex + knexney;     pn = imin1+ jmin1nnx+ knnxnny;         E2=MatFieldE[pe]; K2=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E2,K2, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 2, &F, 1);}
             {pe = i    + jmin1nex + knexney;     pn = i    + jmin1nnx+ knnxnny;         E3=MatFieldE[pe]; K3=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E3,K3, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 3, &F, 1);}
             {pe = i    + jnex     + kmin1nexney; pn = i    + jnnx    + kmin1nnxnny;     E4=MatFieldE[pe]; K4=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E4,K4, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 4, &F, 1);}
             {pe = imin1+ jnex     + kmin1nexney; pn = imin1+ jnnx    + kmin1nnxnny;     E5=MatFieldE[pe]; K5=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E5,K5, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 5, &F, 1);}
             {pe = imin1+ jmin1nex + kmin1nexney; pn = imin1+ jmin1nnx+ kmin1nnxnny;     E6=MatFieldE[pe]; K6=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E6,K6, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 6, &F, 1);}
             {pe = i    + jmin1nex + kmin1nexney; pn = i    + jmin1nnx+ kmin1nnxnny;     E7=MatFieldE[pe]; K7=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E7,K7, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 7, &F, 1);}
             pn = i+jnnx+knnxnny;
             Fy = BcValueY[pn]-F;
             dUy=(Fy/((E0+E1+E2+E3+E4+E5+E6+E7)*K0[25]));
             Uy[pn]+=(lambda*dUy); 
             
         }
         
         pn = i+jnnx+knnxnny;
                  
         if (0==BcTypeZ[pn])
         {
             F=0.0; 
             {pe = i    + jnex     + knexney;     pn = i    + jnnx    + knnxnny;         E0=MatFieldE[pe]; K0=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E0,K0, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 0, &F, 2);}
             {pe = imin1+ jnex     + knexney;     pn = imin1+ jnnx    + knnxnny;         E1=MatFieldE[pe]; K1=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E1,K1, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 1, &F, 2);}
             {pe = imin1+ jmin1nex + knexney;     pn = imin1+ jmin1nnx+ knnxnny;         E2=MatFieldE[pe]; K2=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E2,K2, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 2, &F, 2);}
             {pe = i    + jmin1nex + knexney;     pn = i    + jmin1nnx+ knnxnny;         E3=MatFieldE[pe]; K3=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E3,K3, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 3, &F, 2);}
             {pe = i    + jnex     + kmin1nexney; pn = i    + jnnx    + kmin1nnxnny;     E4=MatFieldE[pe]; K4=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E4,K4, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 4, &F, 2);}
             {pe = imin1+ jnex     + kmin1nexney; pn = imin1+ jnnx    + kmin1nnxnny;     E5=MatFieldE[pe]; K5=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E5,K5, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 5, &F, 2);}
             {pe = imin1+ jmin1nex + kmin1nexney; pn = imin1+ jmin1nnx+ kmin1nnxnny;     E6=MatFieldE[pe]; K6=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E6,K6, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 6, &F, 2);}
             {pe = i    + jmin1nex + kmin1nexney; pn = i    + jmin1nnx+ kmin1nnxnny;     E7=MatFieldE[pe]; K7=(Mat[MatFieldInt[pe]].K); GetResForceOfOneElement3d(E7,K7, &(Ux[pn]), &(Uy[pn]),&(Uz[pn]),nnx, nny, nnz, 7, &F, 2);}
             pn = i+jnnx+knnxnny;
             Fz = BcValueZ[pn]-F;
             dUz=(Fz/((E0+E1+E2+E3+E4+E5+E6+E7)*K0[50]));
             Uz[pn]+=(lambda*dUz); 
             
         }
         //printf("i:%i  j:%i  k:%i  F; %g  Fx: %g  dUx: %g  Ux: %g\n",i,j,k,F,Fx,dUx,Ux[pn]);
         //MyControl(); 
         }  
         }
    }
    }
   
    return(1);
}


