/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>

/*------------------------------------------------------------------------------
     MesherMainLoop3d
------------------------------------------------------------------------------*/
void MesherMainLoop3d()
{  

    
    double  lx,ly,lz;
       
    int     min_num_nodes;
    int     num_levels;
    
    MGBlock *Meshes;


    
    SolveBlock *SolBlock;
    
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    GraphicBlock *graphblock;
    MyMainWindowUI   *mainwin;
    
   
    
    PutGetAllWinStruct(1, &AllWinData);
    GeomWinData=AllWinData->GeomWinData; 
    MeshWinData=AllWinData->MeshWinData;   
    
    PutGetSolveBlock(1,&SolBlock);             
                                           
    lx=GeomWinData->lx;
    ly=GeomWinData->ly;
    lz=GeomWinData->lz;
    
    min_num_nodes=(int)(((double)(MeshWinData->MinDof))/((double)3.0));
    
    if (1==(SolBlock->MeshDefined)) FreeSolveBlock(SolBlock);
    (SolBlock->MeshDefined)=1;
    
    CreateMeshes3D(lx, ly, lz, min_num_nodes, &num_levels, &Meshes);     

    SolBlock->Meshes=Meshes;
    SolBlock->num_levels=num_levels;

    PutGetGraphicBlock(1, &graphblock);
    graphblock->show_level=num_levels-1;
    graphblock->detail_level=graphblock->show_level;
    
    PutGetMainWindow(1, &mainwin);
    mainwin->Level->maximum((int)(num_levels-1));
    mainwin->Level->value((int)(num_levels-1));
    mainwin->Detail->maximum((int)(num_levels-1));
    mainwin->Detail->value((int)(num_levels-1)); 
    
    return;
}

/*------------------------------------------------------------------------------
     CreateMeshes3D
-------------------------------------------------------------------------------*/
int  CreateMeshes3D(double lx, double ly, double lz,
                    int min_num_nodes, int *num_levels, MGBlock **Mesh_in)
{
    int i;
    int num_elem_x;
    int num_elem_y;
    int num_elem_z;
    MGBlock *Meshes;

    CalcElementSizes3d(lx, ly, lz, min_num_nodes, 
                       &num_elem_x, &num_elem_y, &num_elem_z, num_levels);
   
    InitMGData(Mesh_in, (*num_levels)); // Also valid for 3d !!!
   // if (num_levels<2) num_levels=2;  
    Meshes=(*Mesh_in);
    for (i=0; i<(*num_levels); i++)
    {
        printf("x: %i y: %i z: %i\n", num_elem_x, num_elem_y, num_elem_z);
        InitMGBlock2and3d(lx, ly, lz, num_elem_x, num_elem_y, num_elem_z, &(Meshes[i]));
        num_elem_x*=2;
	    num_elem_y*=2;
	    num_elem_z*=2;
    }
    return 0;
}

/*------------------------------------------------------------------------------
     CalcElementSizes3d
-------------------------------------------------------------------------------*/
int CalcElementSizes3d(double lx, double ly, double lz,
                       int min_num_nodes, 
                       int *num_elem_x, int *num_elem_y, int *num_elem_z,
                       int *num_levels)
{
    int nex,ney,nez;
    int nnx,nny,nnz; 
    int i;
        
    if ((lx <= ly) && (lx <= lz))
    {
           nex=2;
    	   ney=(int)floor(ly/(lx/2));
    	   nez=(int)floor(lz/(lx/2));
    }
    
    if ((ly <= lx) && (ly <= lz))
    {
           ney=2;
    	   nex=(int)floor(lx/(ly/2));
    	   nez=(int)floor(lz/(ly/2));
    }
    
    if ((lz <= lx) && (lz <= ly))
    {
           nez=2;
    	   nex=(int)floor(lx/(lz/2));
    	   ney=(int)floor(ly/(lz/2));
    }
    
    
    
    (*num_elem_x)=nex;
    (*num_elem_y)=ney;
    (*num_elem_z)=nez;
    
    nnx=nex+1;
    nny=ney+1;
    nnz=nez+1;
    
    for (i=0; (((nnx*nny*nnz) < min_num_nodes) || i<2); i++) 
    {  
        nnx=nex+1;
	    nny=ney+1;
	    nnz=nez+1;
	    nex*=2;
	    ney*=2;	  
        nez*=2;      
    }
    
    (*num_levels)=i;
    return 0;
}
