/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

int MesoPixMainLoop3d()
{    
    MesoPixTmp TmpMemory;
    AggBlock AggData;
    
    int    *px, *p, *py, *pz, *pA, *map, *pmap, *obj_matrix;
    int    *length, *incl_matrix, *fillflag, *MatFieldInt;
    double *MatFieldE;
    
    int    i,j,k,l;
    int    num_incl,nex,ney,nez, num_levels;
    int    agg_area_int, obj_area_int, aim_area_int;
    double a, b, c, phi, la, lb, lc, lmin, lx, ly, lz;

    double max_size_db;
    int    max_size_int;
    int    alloc_size;
    double rmax,rmin; // maximum radii;
   
    
    double E_Matrix, E_Inclusion;
    double Mu_Matrix, Mu_Inclusion;
    int valid;
    int X1, X2, X3;
    int  tmp, tmpx, tmpy, tmpz;
    MGBlock *Meshes;
    int trials;
    int trial_limit;
    clock_t start, ende;
    float mytime;
    double sumtrials=0.0;
    int MaterialNumBegin;
    int MaterialNumEnd;
    int AddFlag;
    int mat;
    MaterialBlock *LocalMat;
    int LocalMatNum;
    int MatId;
    int InitLen;
    int q;
    int ci,cj,ck;
       
     
    AllWinStruct *AllWinData;
    MesoWinStruct *MesoWinData;
    SolveBlock *SolBlock;
    
    PutGetSolveBlock(1,&SolBlock); 
    PutGetAllWinStruct(1, &AllWinData);
    MesoWinData=AllWinData->MesoWinData;
    
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    la=SolBlock->Meshes[num_levels-1].la;
    lb=SolBlock->Meshes[num_levels-1].lb;
    lc=SolBlock->Meshes[num_levels-1].lc;
    nex=(SolBlock->Meshes[num_levels-1].nnx)-1;
    ney=(SolBlock->Meshes[num_levels-1].nny)-1; 
    nez=(SolBlock->Meshes[num_levels-1].nnz)-1;
    trial_limit=10*nex*ney*nez;
    
    rmax=(MesoWinData->MaxSize)/2;
    rmin=(MesoWinData->MinSize)/2;
    
    AggData.lw_ratio=MesoWinData->Compactness;
    AggData.Smoothness=MesoWinData->Smoothness;
    AggData.Roughness=MesoWinData->Roughness;
    AggData.Deformed=MesoWinData->Deformed;
    AggData.RoughFlag=MesoWinData->RoughFlag;
    AggData.DeformedFlag=MesoWinData->DeformedFlag;
    
    E_Inclusion=MesoWinData->E_Inclusion;
    E_Matrix=MesoWinData->E_Matrix;
    Mu_Inclusion=MesoWinData->Mu_Inclusion;
    Mu_Matrix=MesoWinData->Mu_Matrix;
    
    MatFieldInt=SolBlock->Meshes[num_levels-1].MatFieldInt;
    MatFieldE=SolBlock->Meshes[num_levels-1].MatFieldE;
    
     
   //printf("\nAnfang\n");getchar();
    
    obj_area_int=nex*ney*nez;
    agg_area_int=0;
    aim_area_int=(int)((MesoWinData->VolFraction)*obj_area_int);
    
    max_size_db=sqrt(2*rmax*rmax)*2;  
    if (la>lb) lmin=lb; else lmin=la;
    if (lmin>lc) lmin=lc;
    
    max_size_int=(int) (max_size_db/lmin+2); 
    if(max_size_int>nex || max_size_int>ney)
    {
        printf("Aggregate size is too big compared too object dimensions");
        return 1;
    }
    InitLen=nex*ney*nez;
    InitVector_int(InitLen,    &px);       TmpMemory.px=px; 
    InitVector_int(InitLen,    &py);       TmpMemory.py=py;
    InitVector_int(InitLen,    &pz);       TmpMemory.pz=pz;
    InitVector_int(InitLen,    &pA);       TmpMemory.pA=pA;
    InitVector_int(InitLen,    &p);        TmpMemory.p=p;
    InitVector_int(InitLen,    &length);   TmpMemory.length=length;
    InitVector_int(InitLen,    &fillflag); TmpMemory.fillflag=fillflag;
     
    InitVector_int(InitLen,    &map);       TmpMemory.map=map;
    InitVector_int(InitLen,    &obj_matrix);TmpMemory.obj_matrix=obj_matrix;
    
    
    AddFlag=(int) MesoWinData->AddFlag;
    if (1==AddFlag)
    {
        MaterialNumBegin= MesoWinData->MaterialNumBegin;
        MaterialNumEnd  = MesoWinData->MaterialNumEnd;
        if (0==SolBlock->NumMaterials)
        {
            LocalMatNum=3;
            MatId=3;
            InitMaterialBlock(LocalMatNum, &LocalMat);
        }    
        else
        {    
            LocalMatNum=((SolBlock->NumMaterials)+2);
            MatId=(SolBlock->NumMaterials);
            InitMaterialBlock(LocalMatNum, &LocalMat);
            //CopyMaterialBlock((SolBlock->NumMaterials),  LocalMat, SolBlock->Material);
        }
        memcpy(obj_matrix, MatFieldInt, nex*ney*nez*sizeof(int)); 
    }
    else
    {
        MaterialNumBegin=0;
        MaterialNumEnd=0;
        LocalMatNum=3;
        MatId=1;
        InitMaterialBlock(LocalMatNum, &LocalMat);
    }  
    
   
   
   //obj_matrix=& MatFieldInt[0];
   // MatFieldInt=obj_matrix;
    
    pmap=&(map[(int)(nex*ney*nez*0.5)]);
    p[0]=0;
    num_incl=0;
    printf("GENERATING!\n"); 
   
    start = clock();
    while (agg_area_int<aim_area_int)
    {     
        GenerateOneInclusion3d(rmax, rmin, &AggData);
        tmp=p[num_incl];
       
        BitmapInclEdge3d(la, lb, lc, &AggData, &(length[num_incl]), 
                       &(px[tmp]), &(py[tmp]), &(pz[tmp]), &(pA[num_incl]), pmap,
                       &(fillflag[num_incl]));
       
        p[num_incl+1]=length[num_incl]+p[num_incl]+1;
        
        agg_area_int+=pA[num_incl];
        
        num_incl+=1;
    } 
    
     printf("Inclusions %i:\n", num_incl);
     
     printf("SORTING!\n");   
     printf("AREA %g\n", ( ((double) agg_area_int)/ ((double)obj_area_int) ));   
    InitVector_int(num_incl*4,    &incl_matrix);
    TmpMemory.incl_matrix=incl_matrix;
 
    for(i=0; i<num_incl; i++)
    {
        incl_matrix[i]  =p[i];
        incl_matrix[i+num_incl]=length[i];
        incl_matrix[i+num_incl*2]=fillflag[i];
        incl_matrix[i+num_incl*3]=pA[i];
    }
   
    shellsort3(incl_matrix, num_incl, 4, 4, 5);
    p=&(incl_matrix[0]);
    length=&(incl_matrix[num_incl]);
    fillflag=&(incl_matrix[2*num_incl]);
    
     // HACK   
        MaterialNumBegin=0;
        MaterialNumEnd=0;
        LocalMatNum=num_incl+1;
        MatId=1;
        InitMaterialBlock(LocalMatNum, &LocalMat);
     
       
    for(i=0; i<nex; i++)
    for(j=0; j<ney; j++)
    {           
        obj_matrix[i+j*nex]=-1;
        obj_matrix[i+j*nex+nex*ney*(nez-1)]=-1;
    } 
        
    for(i=0; i<nex; i++)
    for(k=0; k<nez; k++)
    {           
        obj_matrix[i+0*nex+nex*ney*k]=-1;
        obj_matrix[i+(ney-1)*nex+nex*ney*k]=-1;
    }
    
    for(j=0; j<ney; j++)
    for(k=0; k<nez; k++)
    {           
        obj_matrix[0+j*nex+nex*ney*k]=-1;
        obj_matrix[(nex-1)+j*nex+nex*ney*k]=-1;
    }   
    
    //Bewehrung
    for(i=0; i<nex; i++)
    for(j=0; j<ney; j++)
    for(k=0; k<nez; k++)
    {           
        q=(i-21)*(i-21)+(j-64)*(j-64)-8*8;
        if (q<0) obj_matrix[i+j*nex+nex*ney*k]=1;
        q=(i-64)*(i-64)+(j-42)*(j-42)-8*8;
        if (q<0) obj_matrix[i+j*nex+nex*ney*k]=1;
        q=(i-109)*(i-109)+(j-21)*(j-21)-8*8;
        if (q<0) obj_matrix[i+j*nex+nex*ney*k]=1;
        
        q=(k-88)*(k-88)+(i-42)*(i-42)-8*8;
        if (q<0) obj_matrix[i+j*nex+nex*ney*k]=1;
        
        q=(k-42)*(k-42)+(i-88)*(i-88)-8*8;
        if (q<0) obj_matrix[i+j*nex+nex*ney*k]=1;
    }
    
   
   
    trials=0;
    for(j=0; j<(num_incl); j++)
    {   
        
        trials=0;
        tmp=p[j];
        
        valid=0;
        do
        {
            valid=1; i=0;
            do
            {   
                X1=(int)((rand()/(RAND_MAX+1.0))*((double)(nex-1.0)));
                X2=(int)((rand()/(RAND_MAX+1.0))*((double)(ney-1.0)));
                X3=(int)((rand()/(RAND_MAX+1.0))*((double)(nez-1.0)));
                tmpx=(px[tmp+i]+X1);
                tmpy=(py[tmp+i]+X2);
                tmpz=(py[tmp+i]+X3);
            } while ((tmpx<1) || (tmpy<1) || (tmpz<1) ||
                     (tmpx>(nex-2)) || (tmpy>(ney-2)) || (tmpz>(nez-2)));
            
            while((i<length[j]) && (1==valid))
            {   
                tmpx=(px[tmp+i]+X1);
                tmpy=(py[tmp+i]+X2);
                tmpz=(pz[tmp+i]+X3);
                //printf("%i,%i,%i\n",tmpx,tmpy,tmpz);
                if((1>tmpx) || (1>tmpy) || (1>tmpz) || ((nex-2)<tmpx) || ((ney-2)<tmpy) || ((nez-2)<tmpz)) 
                {
                    valid=0;
                }
                else
                {
                    for(ck=tmpz-1; ck<tmpz+2; ck++)
                    for(cj=tmpy-1; cj<tmpy+2; cj++)
                    for(ci=tmpx-1; ci<tmpx+2; ci++)
                    {
                        q=ci+cj*nex+ck*nex*ney;
                        if (MaterialNumBegin>obj_matrix[q] || MaterialNumEnd<obj_matrix[q]) {valid=0;}
                    }
                }
                /* ein pixel abstand? */
                
          /*      else
                {   mat=obj_matrix[(tmpx+1)+(tmpy+0)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx+1)+(tmpy+1)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx+1)+(tmpy-1)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx-1)+(tmpy+0)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx-1)+(tmpy+1)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx-1)+(tmpy-1)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx)+(tmpy+1)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                    mat=obj_matrix[(tmpx)+(tmpy-1)*nex];
                    if (MaterialNumBegin>mat || MaterialNumEnd<mat) {valid=0;}
                } */
                i++;
            }
            
            trials++;
            
            if (trials>trial_limit)
            {
                printf("\nNo Solution - Number of trials:%i\n", trials);
                FreeMesoPixTmp(TmpMemory);
                return 1;
            }
        
        
        } while(0==valid);
        
        if((j/100.0)==floor(j/100.0)) printf("%i: %i \n", j, trials);
       printf("%i: %i \n", j, trials);
        //X1=100; X2=100;
        for(i=0; i<length[j]; i++)
        {   
            tmpx=(px[tmp+i]+X1);
            tmpy=(py[tmp+i]+X2);
            tmpz=(pz[tmp+i]+X3);
            if((0>tmpx) || (0>tmpy) || (0>tmpz) || ((nex-1)<tmpx) || ((ney-1)<tmpy) || ((nez-1)<tmpz)) 
            {
                    if (tmpx<0)tmpx+=nex;
                    if (tmpx>nex-1)tmpx-=nex;
                    if (tmpy<0)tmpy+=ney;
                    if (tmpy>ney-1)tmpy-=ney;
                    if (tmpz<0)tmpz+=nez;
                    if (tmpz>nez-1)tmpz-=nez;
            }
            obj_matrix[tmpx+tmpy*nex+tmpz*nex*ney]=MatId;
            //obj_matrix[tmpx+tmpy*nex+tmpz*nex*ney]=j;
        }
       
        sumtrials=sumtrials+ ((double) trials);
    }
   //  printf("\nMItte2\n");getchar();
    printf("Sum of trials %g \n", sumtrials);
    
    for(i=0; i<nex; i++)
    for(j=0; j<ney; j++)
    {           
        obj_matrix[i+j*nex]=0;
        obj_matrix[i+j*nex+nex*ney*(nez-1)]=0;
    } 
        
    for(i=0; i<nex; i++)
    for(k=0; k<nez; k++)
    {           
        obj_matrix[i+0*nex+nex*ney*k]=0;
        obj_matrix[i+(ney-1)*nex+nex*ney*k]=0;
    }
    
    for(j=0; j<ney; j++)
    for(k=0; k<nez; k++)
    {           
        obj_matrix[0+j*nex+nex*ney*k]=0;
        obj_matrix[(nex-1)+j*nex+nex*ney*k]=0;
    }  
    

    
    memcpy(MatFieldInt, obj_matrix, nex*ney*nez*sizeof(int));   
    
    if(0!=SolBlock->NumMaterials)
    {
       CopyMaterialBlock((SolBlock->NumMaterials), LocalMat, SolBlock->Material);
       FreeMaterialBlock((SolBlock->NumMaterials), SolBlock->Material);
    }
    
    SolBlock->Material=LocalMat;
    SolBlock->NumMaterials=MatId+2;
    
    if (0==AddFlag)
    {
        SolBlock->Material[0].E=E_Matrix;
        SolBlock->Material[0].Mu=Mu_Matrix;
    }
    
    SolBlock->Material[MatId].E=E_Inclusion;
    SolBlock->Material[MatId].Mu=Mu_Inclusion;
    SolBlock->Material[MatId+1].E=E_Inclusion;
    SolBlock->Material[MatId+1].Mu=Mu_Inclusion;
    
            
                            
    for(i=0; i<nex; i++)
    for(j=0; j<ney; j++)
    for(k=0; k<nez; k++)
    if (0==MatFieldInt[i+j*nex+k*nex*ney])
    MatFieldE[i+j*nex+k*nex*ney]=SolBlock->Material[0].E;
    else
    MatFieldE[i+j*nex+k*nex*ney]=SolBlock->Material[1].E;
    
    //MatFieldE[i+j*nex+k*nex*ney]=SolBlock->Material[MatFieldInt[i+j*nex+k*nex*ney]].E;

   /*   
    for(i=0; i<nex; i++)
    {
        for(j=0; j<ney; j++)
        {
            if ((i<((double)nex)/2.0) && (j<((double)nex)/2.0))
            {
                MatFieldE[i+j*nex]=E_Inclusion;
                //if (1==obj_matrix[i+j*nex]) //MatFieldE[i+j*nex]=(E_Inclusion+E_Matrix)*0.5;
                //MatFieldE[i+j*nex]=0.0;
                //MatFieldE[i+j*nex]=E_Inclusion*0.5;
            }
            else
            MatFieldE[i+j*nex]=E_Matrix;
        }       
        
    } 
    */
    
    
    ende = clock();
	mytime = (float)(ende - start) / (float)CLOCKS_PER_SEC;
    printf("\n Generation Time %g\n", mytime);
    
   // TransMatFieldToCoarse(Meshes, num_levels);
    
    //PrintMatrix_int(0, (nex-1), 0, (ney-1), MatFieldInt);
    FreeMesoPixTmp(TmpMemory);
   // printf("\nEnde\n");getchar();
    return 1;
}

/*------------------------------------------------------------------------------
     GenerateOneInclusion3d
------------------------------------------------------------------------------*/
void GenerateOneInclusion3d(double rmax, double rmin, AggBlock *AggData)
{
    double X1, X2;
    double x1, x2;
    double incl_size, cutted_size;
    double a,b,c;
    double rat;
    double theta, psi, phi, pot1, smooth;
    double pi=3.14159265359;
    
    rat=AggData->lw_ratio;
    smooth=AggData->Smoothness;
        
    x1=pow(rmax,(-2.5));
    x2=pow(rmin,(-2.5));
    
    X1=rand()/(RAND_MAX+1.0);
   
    incl_size=pow(x1-X1*(x1-x2),(-1.0/2.5));
    a=incl_size;
    
    X1=rand()/(RAND_MAX+1.0);
    b= a*(-X1*rat*0.1+1.0-rat*0.8);
    X1=rand()/(RAND_MAX+1.0);
    c= a*(-X1*rat*0.1+1.0-rat*0.8);
    

    X1=rand()/(RAND_MAX+1.0);theta= X1 * pi;
    X1=rand()/(RAND_MAX+1.0);psi=   X1 * pi;
    X1=rand()/(RAND_MAX+1.0);phi=   X1 * 2.0 *pi;
    
    AggData->l1= cos(psi)*cos(phi)-cos(theta)*sin(psi)*sin(phi);
    AggData->l2=-cos(psi)*sin(phi)-cos(theta)*sin(psi)*cos(phi);
    AggData->l3=sin(theta)*sin(psi);
    
    AggData->m1=sin(psi)*cos(phi)+cos(theta)*cos(psi)*sin(phi);
    AggData->m2=-sin(psi)*sin(phi)+cos(theta)*cos(psi)*cos(phi);
    AggData->m3=-sin(theta)*cos(psi);
    
    AggData->n1=sin(theta)*sin(phi);
    AggData->n2=sin(theta)*cos(phi);
    AggData->n3=cos(theta);
        
    X1=rand()/(RAND_MAX+1.0);
    if (X1>0.5) {pot1=2.0-X1*smooth*0.6-smooth*0.4;} 
           else {pot1=2.0+X1*smooth*8.3+smooth*3;}
                             
    AggData->a=a;
    AggData->b=b;
    AggData->c=c;

    AggData->pot1=pot1;
    return;
}

/*------------------------------------------------------------------------------
     GenerateOneFiber3d
------------------------------------------------------------------------------*/
void GenerateOneFiber3d(double rmax, double rmin, AggBlock *AggData)
{
    double X1, X2;
    double x1, x2;
    double incl_size, cutted_size;
    double a,b,c;
    double rat;
    double theta, psi, phi, pot1, smooth;
    double pi=3.14159265359;
    
    rat=AggData->lw_ratio;
    smooth=AggData->Smoothness;
        
    x1=pow(rmax,(-2.5));
    x2=pow(rmin,(-2.5));
    
    //X1=rand()/(RAND_MAX+1.0);
    X1=0.5;
   
    incl_size=pow(x1-X1*(x1-x2),(-1.0/2.5));
    a=incl_size;
    
    X1=rand()/(RAND_MAX+1.0);
    b= a*(1.0-rat*0.95);
    c= b;
    

    X1=rand()/(RAND_MAX+1.0);theta= X1 * pi;
    X1=rand()/(RAND_MAX+1.0);psi=   X1 * pi;
    X1=rand()/(RAND_MAX+1.0);phi=   X1 * 2.0 *pi;
    
    AggData->l1= cos(psi)*cos(phi)-cos(theta)*sin(psi)*sin(phi);
    AggData->l2=-cos(psi)*sin(phi)-cos(theta)*sin(psi)*cos(phi);
    AggData->l3=sin(theta)*sin(psi);
    
    AggData->m1=sin(psi)*cos(phi)+cos(theta)*cos(psi)*sin(phi);
    AggData->m2=-sin(psi)*sin(phi)+cos(theta)*cos(psi)*cos(phi);
    AggData->m3=-sin(theta)*cos(psi);
    
    AggData->n1=sin(theta)*sin(phi);
    AggData->n2=sin(theta)*cos(phi);
    AggData->n3=cos(theta);
        
    X1=rand()/(RAND_MAX+1.0);
    if (X1>0.5) {pot1=2.0-X1*smooth*0.6-smooth*0.4;} 
           else {pot1=2.0+X1*smooth*8.3+smooth*3;}
                             
    AggData->a=a;
    AggData->b=b;
    AggData->c=c;

    AggData->pot1=pot1;
    return;
}

/*------------------------------------------------------------------------------
     BitmapInclEdge3d
------------------------------------------------------------------------------*/
void BitmapInclEdge3d(double la, double lb, double lc, AggBlock *AggData, int *p,
                    int *px, int *py, int *pz, int *pA, int *pmap, int *fillflag)
{
    int count, count_out;
    double cosphi, sinphi;
    double pi=3.14159265359;
    int sx,sy,sz;
    int valid;
    int direct;
    int A;
    int xmin, xmax, ymin, ymax;
    int i,j;
    int xlength;
    int nofill;
    double phi;
    int a,b,c;
    int xcent, ycent;
    int z_increment;
    int xlen,ylen,zlen;
    double sqrtabc;
    
    phi=(AggData->phi);
    
    
    A=0;
    sx=0; 
    sy=0;
    sz=0;
	
    nofill=0;
    valid=1;
    count=0;
    
    A=0;
    sqrtabc=sqrt(AggData->a*AggData->a
                +AggData->b*AggData->b
                +AggData->c*AggData->c)*1.3;
    xlen=(int)((sqrtabc)/(la));
    ylen=(int)((sqrtabc)/(lb));
    zlen=(int)((sqrtabc)/(lc));
    
    for (a=-xlen; a<=xlen; a++)
    for (b=-ylen; b<=ylen; b++)
    for (c=-zlen; c<=zlen; c++)
    {
        InclFunc3d(AggData, la, lb, lc, a, b, c, &valid); 
        
        if (1==valid) 
        {
             px[count]=a;
             py[count]=b;
             pz[count]=c;
             count++;
             A++;
             
        }
    }
    
    *p=count;
    *pA=A;         
    *fillflag=0;
   
    return;
}

/*------------------------------------------------------------------------------
     InclFunc3d
------------------------------------------------------------------------------*/
void InclFunc3d(AggBlock *A,
              double la, double lb, double lc, 
              int coorx, int coory, int coorz, int *valid)
{
    double f;
    double x,y,z;
    double ang;
                                                                                                                                            
    x=la*coorx;
    y=lb*coory;
    z=lc*coorz;
    
    /*f= pow(  fabs((x*A->l1 + y*A->m1 + z*A->n1)/A->a ), A->pot1)+
       pow(  fabs((x*A->l2 + y*A->m2 + z*A->n2)/A->b ), A->pot1)+
       pow(  fabs((x*A->l3 + y*A->m3 + z*A->n3)/A->c ), A->pot1)-1.0;*/
    f= pow(  fabs((x*A->l1 + y*A->m1 + z*A->n1)/A->a ), 4.)+
       pow(  fabs((x*A->l2 + y*A->m2 + z*A->n2)/A->b ), 2.)+
       pow(  fabs((x*A->l3 + y*A->m3 + z*A->n3)/A->c ), 2.)-1.0;
    

    if (f<0) (*valid)=1; else (*valid)=0;

    return;
}
