/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


/*------------------------------------------------------------------------------
	CGSolverForBSplines_K   !neu -n35-!
------------------------------------------------------------------------------*/

void CGSolverForBSplines_K(SolveBlock *SolBlock, MGBlock *NormalMesh, MGBlock *SplineMesh,
                           int YMsF, int numXi)
{
    int i, j, ii, iii;
    int Spnnx, Spnny, SpnnN;
    int orderK,Ksize;
    double tmp1, tmp2, tmp3, tmp4;
    double err1;
    double Fehler[5000];
    double Potential[5000];
    
    double *U,*F, *Ftemp;
    double *Ux,*Uy;    
    double *Fx,*Fy;
    double *Dx,*Dy;
    double *Adx,*Ady;
    double *Rx,*Ry;
    int *SpBcTypeX, *SpBcTypeY;
    double *SpBcValueX,*SpBcValueY;
    clock_t start;
    clock_t now;        
    BSplineBlock *BSP;
    
    start=clock();
    
    AllWinStruct *AllWinData;
     
    Spnnx=SplineMesh->nnx;
    Spnny=SplineMesh->nny;
    SpnnN=Spnnx*Spnny;
    
    Ux=SplineMesh->Ux;
    Uy=SplineMesh->Uy;
    Fx=SplineMesh->Fx;
    Fy=SplineMesh->Fy;    
    Dx=SplineMesh->Dx;
    Dy=SplineMesh->Dy;
    Adx=SplineMesh->Adx;
    Ady=SplineMesh->Ady; 
    
    SpBcTypeX=SplineMesh->BcTypeX;
    SpBcTypeY=SplineMesh->BcTypeY;
    SpBcValueX=SplineMesh->BcValueX;
    SpBcValueY=SplineMesh->BcValueY; 
       
    BSP=&(SolBlock->BSplines);
    ii=0;
    
    orderK=BSP->orderK;
    Ksize=(orderK+1)*(orderK+1)*2;
    InitVector_double(Ksize,&U);
    InitVector_double(Ksize,&F);
    InitVector_double(Ksize,&Ftemp);
    
    InitVector_double(SpnnN,&Rx);
    InitVector_double(SpnnN,&Ry);    
    
    printf("\n\n-------------Start B-Spline Solver-------------\n\n");
    
    GetRestoringForceBSplines_K(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Fx, Fy, YMsF, numXi, Ftemp);

        //PrintMatrixT(6, 6, SplineMesh->Fy);
        //getchar();
        
        //printf("LENGTH %i", length);
        //printf("\nBcTypeY\n");
        //PrintMatrixIntegerT(6, 6, SplineMesh->BcTypeY);
        //printf("\nFYYYYYYYYY\n");
        //PrintMatrixT(6, 6, SplineMesh->Fy);
        //getchar();
        
    memcpy(Dx, Fx, sizeof(double)*SpnnN);
    memcpy(Dy, Fy, sizeof(double)*SpnnN);

    for(i=0; i<100000; i++)
    {
                              //printf("\nBcTypeY\n");
                              //PrintMatrixIntegerT(6, 6, SplineMesh->BcTypeY);
                              //printf("\nBcValueY\n");
                              //PrintMatrixT(10, 10, SplineMesh->Uy);
                              //getchar();
        
        ScalarProduct(SpnnN, Fx, Fx, &tmp1);
        ScalarProduct(SpnnN, Fy, Fy, &tmp2);
        tmp1=tmp1+tmp2;

                              //printf("\n 1___tmp2 %f ",tmp2);

        GetRestoringForceIncrementBSplines_K(NormalMesh, SplineMesh, BSP, U, Dx, Dy, F, Adx, Ady, YMsF, numXi, Ftemp);

                              //printf("\nFXXXXXXXXX\n");
                              //PrintMatrixT(6, 6, SplineMesh->Fx);
                              //printf("\nFYYYYYYYYY\n");
                              //PrintMatrixT(6, 6, SplineMesh->Fy);
    	                      //getchar();
        ScalarProduct(SpnnN, Dx, Adx, &tmp2);
        ScalarProduct(SpnnN, Dy, Ady, &tmp3);
                              //printf("\n 2___tmp2 %f ",tmp2);
                              //printf("\n 2___tmp3 %f ",tmp3);
        //tmp2=-(tmp2+tmp3);    //printf("\n 3___tmp2 %f ",tmp2);
        tmp2+=tmp3;
        if (tmp2==0.0) tmp2=1.0;
        tmp3=tmp1/tmp2;       //tmp3 entspricht alpha
        
        printf("\n runde %i",i);
        //printf("\n alpha tmp3 %f = tmp1 %f / tmp2 %f",tmp3,tmp1,tmp2);
        //*
        if (i > 0 && i%50 == 0)
        {
           for(j=0; j<SpnnN; j++)
           {
            Ux[j]+=tmp3*Dx[j];
            Uy[j]+=tmp3*Dy[j];
           }
           GetRestoringForceBSplines_K(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Fx, Fy, YMsF, numXi, Ftemp);
           
        }
        else //*/
        for(j=0; j<SpnnN; j++)
        {
            Ux[j]+=tmp3*Dx[j];
            Uy[j]+=tmp3*Dy[j];

            Fx[j]+=-tmp3*Adx[j];
            Fy[j]+=-tmp3*Ady[j];
        }

                              //PrintMatrixT(6, 6, SplineMesh->Uy);
                              //getchar();

   	    ScalarProduct(SpnnN, Fx, Fx, &tmp2);
        ScalarProduct(SpnnN, Fy, Fy, &tmp3);
        
        tmp2+=tmp3;
        tmp3=tmp2/tmp1; //tmp3 entspricht beta
        //printf("\n beta tmp3 %f = tmp2 %f / tmp1 %f",tmp3,tmp2,tmp1);  
        
        for(j=0; j<SpnnN; j++)
        {
            Dx[j]=Fx[j]+tmp3*Dx[j];
            Dy[j]=Fy[j]+tmp3*Dy[j];
        }

        SolBlock->err2=0.1;
        SolBlock->err1=0.1;
        SolBlock->i=i;
        
        BSP->help=i;  // Hilfsvariable zur Ausgabe von Werten in Abhngigkeit der Durchgangszahl
        
        //Fehlerermittlung        
        GetRestoringForceBSplines_K(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Rx, Ry, YMsF, numXi, Ftemp);
        ScalarProduct(SpnnN, Rx, Rx, &tmp1);
        ScalarProduct(SpnnN, Ry, Ry, &tmp2);
        tmp1+=tmp2;
        tmp1=sqrt(fabs(tmp1));
        printf("\n Fehler= %.12g\n",tmp1); //Euklidische Norm der Residuumskrfte
        //*/
        
        
        if (1==1) //(i%10==0)
        {
            //Potential der inneren Krfte
            GetBSPForceVector(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Rx, Ry, YMsF, numXi, Ftemp);
            ScalarProduct(SpnnN, Ux, Rx, &tmp2);
            ScalarProduct(SpnnN, Uy, Ry, &tmp3);
            tmp2=0.5*(tmp2+tmp3);
            //Potential der ueren (Knoten-)Krfte
            //for (j = 0; j < SpnnN; j++)
            //{
            // if (0==SpBcTypeX[j]) Rx[j] = SpBcValueX[j]; else Rx[j]=0.0;
            // if (0==SpBcTypeY[j]) Ry[j] = SpBcValueY[j]; else Ry[j]=0.0;
            //}    
            //ScalarProduct(SpnnN, Ux, Rx, &tmp3);
            //ScalarProduct(SpnnN, Uy, Ry, &tmp4);
            //Gesamtpotential
            //tmp3=tmp2-(tmp3+tmp4);
            
            printf(" Potential der inneren Kraefte= %.12g \n",tmp2);
        }
        else tmp2=0.0;
        
        if (i<5000) {Fehler[i]=tmp1; Potential[i]=tmp2;}
        //*/
        now=clock();
        printf(" verstrichene Zeit = %f sec\n",(double(now-start)/CLOCKS_PER_SEC));
        
        
        iii=MyControl();
        /*
        if (ii==0 && tmp1 < 1.0E-8)
         {ii=1;
          while(0==iii) iii=MyControl();
         }*/
        
        if (1==iii || tmp1 < 1.0E-7)  // Ausgang
        {
         //GetBSPForceVector(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Fx, Fy, YMsF, numXi, Ftemp);
         //PrintMatrixT(1,SpnnN,Fx); getchar();
         //PrintMatrixT(1,SpnnN,Fy); getchar();
         if (i<5000) PrintMatrixToFile(i+1,1,Fehler,"./fehler.txt");
         else PrintMatrixToFile(5000,1,Fehler,"./fehler.txt");
         if (i<5000) PrintMatrixToFile(i+1,1,Potential,"./potential.txt");
         else PrintMatrixToFile(5000,1,Potential,"./potential.txt");
         free(U);
         free(F);
         return;
        }
        
    }
   free(U);
   free(F);
   return;
}


/*------------------------------------------------------------------------------
	GetRestoringForceBSplines_K   !neu -n36-!
------------------------------------------------------------------------------*/

void GetRestoringForceBSplines_K(MGBlock *NormalMesh, MGBlock *SplineMesh, BSplineBlock *BSP,
                               double *U, double *Ux, double *Uy,
                               double *F, double *Fx, double *Fy,
                               int YMsF, int numXi, double *Ftemp)
{
    int i; 
    int SpnnN;
    int *SpBcTypeX, *SpBcTypeY;
    double *SpBcValueX,*SpBcValueY;
     
    SpnnN=(SplineMesh->nnx)*(SplineMesh->nny);
    SpBcTypeX=SplineMesh->BcTypeX;
    SpBcTypeY=SplineMesh->BcTypeY;
    SpBcValueX=SplineMesh->BcValueX;
    SpBcValueY=SplineMesh->BcValueY;    
    
    //PrintMatrixT(1,SpnnN,SpBcValueX); getchar();
    //PrintMatrixT(1,SpnnN,SpBcValueY); getchar();
    
    GetBSPForceVector(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Fx, Fy, YMsF, numXi, Ftemp);
    
    for (i = 0; i < SpnnN; i++)
    {
     if (0==SpBcTypeX[i]) Fx[i] = SpBcValueX[i] - Fx[i]; else Fx[i]=0.0;
     if (0==SpBcTypeY[i]) Fy[i] = SpBcValueY[i] - Fy[i]; else Fy[i]=0.0;
    }
    return;
}

/*------------------------------------------------------------------------------
	GetRestoringForceIncrementBSplines_K   !neu -n37-!
------------------------------------------------------------------------------*/

void GetRestoringForceIncrementBSplines_K(MGBlock *NormalMesh, MGBlock *SplineMesh, BSplineBlock *BSP,
                                        double *U, double *Ux, double *Uy,
                                        double *F, double *Fx, double *Fy,
                                        int YMsF, int numXi, double *Ftemp)
{
    int i; 
    int SpnnN;
    int *SpBcTypeX, *SpBcTypeY;
         
    SpnnN=(SplineMesh->nnx)*(SplineMesh->nny);
    SpBcTypeX=SplineMesh->BcTypeX;
    SpBcTypeY=SplineMesh->BcTypeY;
        
    GetBSPForceVector(NormalMesh, SplineMesh, BSP, U, Ux, Uy, F, Fx, Fy, YMsF, numXi, Ftemp);
    
    for (i = 0; i < SpnnN; i++)
    {
     if (1==SpBcTypeX[i]) Fx[i]=0.0;
     if (1==SpBcTypeY[i]) Fy[i]=0.0;
    }
    return;
}


/*------------------------------------------------------------------------------
	GetBSPForceVector     ( F = K*u )       !neu -n38-!
------------------------------------------------------------------------------*/

void GetBSPForceVector(MGBlock *NormalMesh, MGBlock *SplineMesh, BSplineBlock *BSP,
                       double *U, double *Ux, double *Uy,
                       double *F, double *Fx, double *Fy,
                       int YMsF, int numXi, double *Ftemp)
{
    int i,j,k,ks,kx,ky;
    int xi,xj;
    int iw1; 
    int nex, ney;
    int Spnnx, Spnny;    
    int orderK;
    int center;
    int TypeX, TypeY;    
    int Ksize, KsizeH;
    AllWinStruct *AllWinData;
    double la,lb;
    double xpos,ypos;
       
    double E, E1, E2, E3, E4, Eref;
    //double ***K;
    int CircleIntpntFlag;
    
            
    PutGetAllWinStruct(1, &AllWinData);
    CircleIntpntFlag=AllWinData->SolveWinData->CircleIntpntFlag;
    
    nex=NormalMesh->nex;
    ney=NormalMesh->ney;  
    la =NormalMesh->la;
    lb =NormalMesh->lb;  
    Spnnx=SplineMesh->nnx;
    Spnny=SplineMesh->nny;

    //K=BSP->K;
    orderK=BSP->orderK;
    center=BSP->SplineElemsX.center;
    
    KsizeH=(orderK+1)*(orderK+1);
    Ksize=2*KsizeH;
    
    SetVectorToZero_double(Spnnx*Spnny, Fx);
    SetVectorToZero_double(Spnnx*Spnny, Fy);
    
    printf("\nnumXi:%i\n",numXi);
    
    for (j = 0; j < ney; j++)
    {
        if (j <= center) TypeY=(j-center); // welcher Elementtyp y-Richtung
        else
        {
         iw1=ney-1-center;
         if (j >= iw1) TypeY=(j-iw1);
         else TypeY=0;   
        }        
        
        for (i = 0; i < nex; i++)
        {    
            if (i <= center) TypeX=(i-center); // welcher Elementtyp x-Richtung
            else
            {
             iw1=nex-1-center;
             if (i >= iw1) TypeX=(i-iw1);
             else TypeX=0;   
            }
            
            for (ky = 0; ky < (orderK+1); ky++)  //U global zu U lokal
            {
             for (kx = 0; kx < (orderK+1); kx++)
             {    
                k = kx + (orderK+1)*ky;
                ks=(i+Spnnx*j) + (kx + Spnnx*ky);
                
                U[k]=Ux[ks];
                U[k+KsizeH]=Uy[ks];
             }  
            }
            if (YMsF == 1) 
            {
             E1=NormalMesh->KnMatFieldE[i+j*nex+j];
             E2=NormalMesh->KnMatFieldE[i+j*nex+j+1];
             E3=NormalMesh->KnMatFieldE[i+j*nex+j+nex+2];
             E4=NormalMesh->KnMatFieldE[i+j*nex+j+nex+1];
             
             if (E1 == E2 && E1 == E3 && E1 == E4)
             {
              MatrixMultMatrix(Ksize,Ksize,1,&(BSP->K[TypeX+center][TypeY+center][numXi*numXi*Ksize*Ksize]),U,F);
              MatrixMultScalar(Ksize,1, F, E1);      
             }       
              else
              {      
               SetVectorToZero_double(Ksize, F);
               for(xi=0; xi<numXi; xi++)
               { 
                for(xj=0; xj<numXi; xj++)
                {
                 MatrixMultMatrix(Ksize,Ksize,1,&(BSP->K[TypeX+center][TypeY+center][(xi+xj*numXi)*Ksize*Ksize]),U,Ftemp);
                 if (0==CircleIntpntFlag)
                     E=GetEatIntPoints_a(NormalMesh,BSP,E1,E2,E3,E4,xi,xj);
                 else 
                 {
                      xpos=la*( ((double)i) + 0.5 + 0.5*BSP->Xi[xi] );
                      ypos=lb*( ((double)j) + 0.5 + 0.5*BSP->Xi[xj] );
                      CircleFunction(xpos, ypos, &E);
                      //E=GetEatIntPoints_a(NormalMesh,BSP,E1,E2,E3,E4,xi,xj);
                      //printf("Eref: %g E: %g", Eref,E);getchar();
                 }
                 MatrixMultScalar(Ksize,1,Ftemp,E);
                 AddMatrix(Ksize,1,F,Ftemp);
                }
               }  
              }         
            }
            else
            {
             MatrixMultMatrix(Ksize,Ksize,1,BSP->K[TypeX+center][TypeY+center],U,F);
             E=NormalMesh->MatFieldE[i + j*nex];
             MatrixMultScalar(Ksize,1, F, E);
            }
            
            for (ky = 0; ky < (orderK+1); ky++)  //F lokal zu F global 
            {
             for (kx = 0; kx < (orderK+1); kx++)
             {    
                k = kx + (orderK+1)*ky;
                ks=(i+Spnnx*j) + (kx + Spnnx*ky);
                
                Fx[ks]+=F[k];
                Fy[ks]+=F[k+KsizeH];
             }  
            }                            
        }    
    }

    return;    
}


/*------------------------------------------------------------------------------
	GetEatIntPoints
------------------------------------------------------------------------------*/

double GetEatIntPoints(MGBlock *NormalMesh, BSplineBlock *BSP, int i, int j, int nex, int xi, int xj)
{
    double E, E1, E2, E3, E4;
    double x,y,la,lb;
    
    la=NormalMesh->la;
    lb=NormalMesh->lb;
    
    x=la/2.0+(BSP->Xi[xi])*la/2.0;
    y=lb/2.0+(BSP->Xi[xj])*lb/2.0;
    
    E1=NormalMesh->KnMatFieldE[i+j*nex+j];
    E2=NormalMesh->KnMatFieldE[i+j*nex+j+1];
    E3=NormalMesh->KnMatFieldE[i+j*nex+j+nex+2];
    E4=NormalMesh->KnMatFieldE[i+j*nex+j+nex+1];
    
    E=y/lb*(x/la*(E3-E4-E2+E1)+E4-E1)+x/la*(E2-E1)+E1;
    
    return E;
}


/*------------------------------------------------------------------------------
	GetEatIntPoints_a
------------------------------------------------------------------------------*/

double GetEatIntPoints_a(MGBlock *NormalMesh, BSplineBlock *BSP, double E1, double E2, double E3, double E4, int xi, int xj)
{
    double E,r,s;
    
    r=BSP->Xi[xi];
    s=BSP->Xi[xj];
    
    E=0.25*((1.0-r)*(1.0-s)*E1+
            (1.0+r)*(1.0-s)*E2+
            (1.0+r)*(1.0+s)*E3+
            (1.0-r)*(1.0+s)*E4);

    return E;
}
