/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


/*---------------------------------------------------------
	BSplineMain
----------------------------------------------------------*/

void BSplineMain()
{
double lx, ly;
int num_elem_x,num_elem_y;
MGBlock *NormalMesh;
MGBlock *SplineMesh;
int num_levels;
SolveBlock *SolBlock;

int i, j, iii, length;
double tmp1, tmp2, tmp3;
double err1;

double K31[324], K32[324], K33[324];
double K21[324], K22[324], K23[324];
double K11[324], K12[324], K13[324];
    /*
double a[9], u[3], f[3];

a[0]=1.0;
a[1]=5.0;
a[2]=3.0;

a[3]=7.0;
a[4]=9.0;
a[5]=11.0;

a[6]=17.0;
a[7]=19.0;
a[8]=31.0;

u[0]=37.0;
u[1]=41.0;
u[2]=13.0;

MatrixMultMatrix(3,3,1,a,u,f);
PrintMatrix(3, 3, a); 
PrintMatrix(1, 3, u);  
PrintMatrix(1, 3, f);   
getchar();   */

/* NEWNEWNEW */
    
   lx=1.0;
   ly=1.0;
   
   PutGetSolveBlock(1,&SolBlock);
   num_levels=SolBlock->num_levels; 
   NormalMesh=&(SolBlock->Meshes[num_levels-1]);
   //SplineMesh=SolBlock->SplineMesh;
   // printf("\n vor Init - 1Zeiger von %p auf %p \n", &SplineMesh,SplineMesh);     getchar();   
   num_elem_x=(NormalMesh->nex)   +1  ;
   num_elem_y=(NormalMesh->ney)   +1  ;
   
   lx=((double)(NormalMesh->la))*((double)(NormalMesh->nex)) ;
   ly=((double)(NormalMesh->lb))*((double)(NormalMesh->ney)) ;
   
 //  SetQuadraticBSplines((NormalMesh->la),(NormalMesh->la));
   
   InitMGData (&SplineMesh, 1);
   SolBlock->SplineMesh=SplineMesh;
   InitMGBlock2and3d(lx, ly, 1.0, num_elem_x, num_elem_y, 0, SplineMesh);
 
   PutGetSolveBlock(1,&SolBlock);
   SplineMesh=SolBlock->SplineMesh;
  
   SetVectorToZero_double((SplineMesh->nnx)*(SplineMesh->nny),  SplineMesh->Uy);
   SetVectorToZero_double((SplineMesh->nnx)*(SplineMesh->nny),  SplineMesh->Ux);
   SplineBCmain();
 
   BuildStiffnessForBSplines(NormalMesh->la, NormalMesh->lb, K11,K12,K13,K21,K22,K23,K31,K32,K33);
   CGSolverForBSplines(SolBlock, NormalMesh, SplineMesh, K11,K12,K13,K21,K22,K23,K31,K32,K33); 
   return;    
}


/*---------------------------------------------------------
	CGSolverForBSplines
----------------------------------------------------------*/

void  CGSolverForBSplines(SolveBlock *SolBlock, MGBlock *NormalMesh, MGBlock *SplineMesh, 
      double *K11,double *K12,double *K13,double *K21,double *K22,double *K23,double *K31,double *K32,double *K33)
{
int i, j, iii, length;
double tmp1, tmp2, tmp3;
double err1;

        GetRestoringForceBSplines(
              NormalMesh->nnx, NormalMesh->nny, NormalMesh->MatFieldE, 
              SplineMesh->Ux,  SplineMesh->Uy, SplineMesh->Fx, SplineMesh->Fy,
              SplineMesh->BcTypeX, SplineMesh->BcTypeY, SplineMesh->BcValueX, SplineMesh->BcValueY,
              K11, K12, K13, K21, K22, K23, K31, K32, K33);
     
       // PrintMatrix(6, 6, SplineMesh->Fy);
       // getchar();
        length=(SplineMesh->nnx)*(SplineMesh->nny);
       // printf("LENGTH %i", length);
        //printf("\nBcTypeY\n");
        //PrintMatrixInteger(6, 6, SplineMesh->BcTypeY);
        //printf("\nFYYYYYYYYY\n");
        //PrintMatrix(6, 6, SplineMesh->Fy);
        //getchar();
        memcpy(SplineMesh->Dx, SplineMesh->Fx, sizeof(double)*length);
        memcpy(SplineMesh->Dy, SplineMesh->Fy, sizeof(double)*length);
        
        for(i=0; i<100000; i++)    
        {
            
            //printf("\nBcTypeY\n");
           // PrintMatrixInteger(6, 6, SplineMesh->BcTypeY);
           //  printf("\nBcValueY\n");
            //PrintMatrix(10, 10, SplineMesh->Uy);
            //getchar();
            ScalarProduct(((SplineMesh->nnx)*(SplineMesh->nny)), SplineMesh->Fx, SplineMesh->Fx, &tmp1);
            ScalarProduct(((SplineMesh->nnx)*(SplineMesh->nny)), SplineMesh->Fy, SplineMesh->Fy, &tmp2);
            tmp1=tmp1+tmp2; 
            
            //printf("\n 1___tmp2 %f ",tmp2);
            
            GetRestoringForceIncrementBSplines(
              NormalMesh->nnx, NormalMesh->nny, NormalMesh->MatFieldE, 
              SplineMesh->Dx,  SplineMesh->Dy, SplineMesh->Adx, SplineMesh->Ady,
              SplineMesh->BcTypeX, SplineMesh->BcTypeY, SplineMesh->BcValueX, SplineMesh->BcValueY,
              K11, K12, K13, K21, K22, K23, K31, K32, K33);
              
              //printf("\nFXXXXXXXXX\n");
             //PrintMatrix(6, 6, SplineMesh->Fx);
              //printf("\nFYYYYYYYYY\n");
              //PrintMatrix(6, 6, SplineMesh->Fy);
        	  //getchar();
            ScalarProduct(((SplineMesh->nnx)*(SplineMesh->nny)), SplineMesh->Dx, SplineMesh->Adx, &tmp2);
            ScalarProduct(((SplineMesh->nnx)*(SplineMesh->nny)), SplineMesh->Dy, SplineMesh->Ady, &tmp3);
            //printf("\n 2___tmp2 %f ",tmp2);
            //printf("\n 2___tmp3 %f ",tmp3);
            tmp2=-(tmp2+tmp3);   
             //printf("\n 3___tmp2 %f ",tmp2);
            tmp3=tmp1/tmp2; //tmp3 entspricht alpha 
            //
            printf("\n tmp3 %f = tmp1 %f / tmp2 %f",tmp3,tmp1,tmp2);
            
            for(j=0; j<length; j++) 
            {
                (SplineMesh->Ux[j])=(SplineMesh->Ux[j])+tmp3*(SplineMesh->Dx[j]);
                (SplineMesh->Uy[j])=(SplineMesh->Uy[j])+tmp3*(SplineMesh->Dy[j]);
            
                (SplineMesh->Fx[j])=(SplineMesh->Fx[j])+tmp3*(SplineMesh->Adx[j]);
                (SplineMesh->Fy[j])=(SplineMesh->Fy[j])+tmp3*(SplineMesh->Ady[j]);
            }
        	
            //PrintMatrix(6, 6, SplineMesh->Uy); 
            //getchar();
               
       	    ScalarProduct(((SplineMesh->nnx)*(SplineMesh->nny)), SplineMesh->Fx, SplineMesh->Fx, &tmp2);
            ScalarProduct(((SplineMesh->nnx)*(SplineMesh->nny)), SplineMesh->Fy, SplineMesh->Fy, &tmp3);
            tmp2=tmp2+tmp3; 
            
            tmp3=tmp2/tmp1; //tmp3 entspricht beta
            
            for(j=0; j<length; j++) 
            {
                (SplineMesh->Dx[j])=(SplineMesh->Fx[j])+tmp3*(SplineMesh->Dx[j]);
                (SplineMesh->Dy[j])=(SplineMesh->Fy[j])+tmp3*(SplineMesh->Dy[j]);
            }   
            
            
            /* P=&(Meshes[num_levels-2]);         
            GetLocalDisplacements_GS_Q9(M->nnx, M->nny, K_matrixQ9, P->MatFieldE, 
                M->dUx, M->dUy, M->Ux,  M->Uy, M->Fx, M->Fy, &err1,&err1, Omega,
                M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            TransForceOnCoarseMeshQ4onQ9(M->nnx, M->nny, M->Fx, M->Fy,
                              P->nnx, P->nny, P->Fx, P->Fy);
            TransForceOnCoarseMesh(M->nnx, M->nny, M->Fx, M->Fy,
                              P->nnx, P->nny, P->SwapX, P->SwapY);*/
            
            //SolBlock->err2=err2; 
            SolBlock->err2=0.1; 
             SolBlock->err1=0.1; 
            SolBlock->i=i; 
            printf("\n runde 1\n");
            //TransformSplinesOnMesh(NormalMesh->nnx, NormalMesh->nny, NormalMesh->Ux,  NormalMesh->Uy,
            //                                 SplineMesh->Ux, SplineMesh->Uy);
                                             
            //TransformSplinesOnMesh2(0,NormalMesh->nnx, NormalMesh->nny, 
            //                        SolBlock->BSplines.la, SolBlock->BSplines.lb,
            //                               NormalMesh->Ux,  NormalMesh->Uy,
            //                               SplineMesh->Ux, SplineMesh->Uy, &(SolBlock->BSplines));                                 
            
            iii=MyControl();
            if (1==iii) return;
        }
   return;    
}


/*---------------------------------------------------------
	BuildStiffnessForBSplines
----------------------------------------------------------*/

void BuildStiffnessForBSplines(double la, double lb,
   double *K11, double *K12, double *K13,
   double *K21, double *K22, double *K23,
   double *K31, double *K32, double *K33)
{
   
   double K[324];
   double B[54], BT[54], BTC[54];
   double C[9];
   
   double mu;
   
   double x,y;
   double i1,i2;
   double A;
   int i,j,m,n;
   
   double Nxa,Nxb,Nxc,Nya,Nyb,Nyc;
   double Nxad,Nxbd,Nxcd,Nyad,Nybd,Nycd;
   
   double N1x,N2x,N3x,N4x,N5x,N6x,N7x,N8x,N9x;
   double N1y,N2y,N3y,N4y,N5y,N6y,N7y,N8y,N9y;
   
   int  im, jm;
   
   A=la*lb;
   
   i1=0.19897625;
   i2=0.80102374;
   
   mu=0.2;
   
   C[0]=1.0/(1.0-mu*mu);
   C[1]=mu/(1.0-mu*mu);
   C[2]=0.0;
   C[3]=mu/(1.0-mu*mu);
   C[4]=1.0/(1.0-mu*mu);
   C[5]=0.0;
   C[6]=0.0;
   C[7]=0.0;
   C[8]=(1.0-mu)/2.0;
   
   SetVectorToZero_double(54,   B);
   SetVectorToZero_double(54,   BT);
   SetVectorToZero_double(324,  K);
   
   SetVectorToZero_double(324,  K11);
   SetVectorToZero_double(324,  K12);
   SetVectorToZero_double(324,  K13);
   
   SetVectorToZero_double(324,  K21);
   SetVectorToZero_double(324,  K22);
   SetVectorToZero_double(324,  K23);
   
   SetVectorToZero_double(324,  K31);
   SetVectorToZero_double(324,  K32);
   SetVectorToZero_double(324,  K33);
   
   for(im=0; im<3; im++)
   for(jm=0; jm<3; jm++) 
   for(j=0; j<4; j++) 
       {
            switch (j)
            {
                case 0: x=i1*la;y=i1*lb; break;
                case 1: x=i2*la;y=i1*lb; break;
                case 2: x=i1*la;y=i2*lb; break;
                case 3: x=i2*la;y=i2*lb; break;
            }

            switch (im) // Shape functions of x; 0=a; 1=b; 2=c
            {
                
                case 0: Nxa=x*x/(la*la)-2.0*x/la+1.0;
                        Nxb=-3.0*x*x/(2.0*la*la)+2.0*x/la;
                        Nxc=x*x/(2.0*la*la);
                        
                        Nxad=2*x/(la*la)-2.0/la;
                        Nxbd=-3.0*x/(la*la)+2.0/la;
                        Nxcd=x/(la*la);
                        break;
                
                case 1: Nxa=x*x/(2.0*la*la)-x/la+0.5;
                        Nxb=-x*x/(la*la)+x/la+0.5;
                        Nxc=x*x/(2.0*la*la); 
                        
                        Nxad=x/(la*la)-1.0/la;
                        Nxbd=-2.0*x/(la*la)+1.0/la;
                        Nxcd=x/(la*la);
                        break;
                
                case 2: Nxa=x*x/(2.0*la*la)-x/la+0.5;
                        Nxb=-3.0*x*x/(2.0*la*la)+x/la+0.5;
                        Nxc=x*x/(la*la); 
                        
                        Nxad=x/(la*la)-1.0/la;
                        Nxbd=-3.0*x/(la*la)+1.0/la;
                        Nxcd=2.0*x/(la*la);
                        break;
            }
           
            switch (jm) // Shape functions of y; 0=a; 1=b; 2=c
            {
                
                case 0: Nya=y*y/(lb*lb)-2.0*y/lb+1.0;
                        Nyb=-3.0*y*y/(2.0*lb*lb)+2.0*y/lb;
                        Nyc=y*y/(2.0*lb*lb);
                        
                        Nyad=2*y/(lb*lb)-2.0/lb;
                        Nybd=-3.0*y/(lb*lb)+2.0/lb;
                        Nycd=y/(lb*lb);
                        break;
                
                case 1: Nya=y*y/(2.0*lb*lb)-y/lb+0.5;
                        Nyb=-y*y/(lb*lb)+y/lb+0.5;
                        Nyc=y*y/(2.0*lb*lb); 
                        
                        Nyad=y/(lb*lb)-1.0/lb;
                        Nybd=-2.0*y/(lb*lb)+1.0/lb;
                        Nycd=y/(lb*lb);
                        break;
                
                case 2: Nya=y*y/(2.0*lb*lb)-y/lb+0.5;
                        Nyb=-3.0*y*y/(2.0*lb*lb)+y/lb+0.5;
                        Nyc=y*y/(lb*lb); 
                        
                        Nyad=y/(lb*lb)-1.0/lb;
                        Nybd=-3.0*y/(lb*lb)+1.0/lb;
                        Nycd=2.0*y/(lb*lb);
                        break;
            }
           
            BTMatrixForBSplines(Nxa, Nxb, Nxc, Nya, Nyb, Nyc,
                               Nxad,Nxbd,Nxcd,Nyad,Nybd,Nycd, BT);
            
            TransposeMatrix(18,3,BT,B);            
            MatrixMultMatrix(18,3,3,BT,C,BTC);
            MatrixMultMatrix(18,3,18,BTC,B,K);
            
            switch (im+3*jm) // Shape functions of y; 1=a; 2=b; 3=c
            {
                case 0: AddMatrix(18,18, K11, K); break;
                case 1: AddMatrix(18,18, K12, K); break;
                case 2: AddMatrix(18,18, K13, K); break;
                case 3: AddMatrix(18,18, K21, K); break; 
                case 4: AddMatrix(18,18, K22, K); break;
                case 5: AddMatrix(18,18, K23, K); break;
                case 6: AddMatrix(18,18, K31, K); break;
                case 7: AddMatrix(18,18, K32, K); break;  
                case 8: AddMatrix(18,18, K33, K); break;
            }           
            
   }
   
   printf("\nBT\n");
   PrintMatrix(18,3,BT);
   
   MatrixMultScalar(18,18, K11, A);
   MatrixMultScalar(18,18, K12, A);
   MatrixMultScalar(18,18, K13, A);
   MatrixMultScalar(18,18, K21, A);
   MatrixMultScalar(18,18, K22, A);
   MatrixMultScalar(18,18, K23, A);
   MatrixMultScalar(18,18, K31, A);
   MatrixMultScalar(18,18, K32, A);
   MatrixMultScalar(18,18, K33, A);

   return;    
}

/*---------------------------------------------------------
	BMatrixForBSplines
----------------------------------------------------------*/

void BTMatrixForBSplines(
               double Nxa, double Nxb, double Nxc,
               double Nya, double Nyb, double Nyc,
               double Nxad, double Nxbd, double Nxcd,
               double Nyad, double Nybd, double Nycd,
               double *BT)
{

   
   double N1x,N2x,N3x,N4x,N5x,N6x,N7x,N8x,N9x;
   double N1y,N2y,N3y,N4y,N5y,N6y,N7y,N8y,N9y;
   

            N1x=Nxad*Nya;
            N2x=Nxbd*Nya;
            N3x=Nxcd*Nya;
            N4x=Nxad*Nyb;
            N5x=Nxbd*Nyb;
            N6x=Nxcd*Nyb;
            N7x=Nxad*Nyc;
            N8x=Nxbd*Nyc;
            N9x=Nxcd*Nyc;
            
            N1y=Nxa*Nyad;
            N2y=Nxb*Nyad;
            N3y=Nxc*Nyad;
            N4y=Nxa*Nybd;
            N5y=Nxb*Nybd;
            N6y=Nxc*Nybd;
            N7y=Nxa*Nycd;
            N8y=Nxb*Nycd;
            N9y=Nxc*Nycd;
            
        
            
            BT[0]=N1x;
            BT[1]=N2x;
            BT[2]=N3x;
            BT[3]=N4x;
            BT[4]=N5x;
            BT[5]=N6x;
            BT[6]=N7x;
            BT[7]=N8x;
            BT[8]=N9x;
            
            BT[27]=N1y;
            BT[28]=N2y;
            BT[29]=N3y;
            BT[30]=N4y;
            BT[31]=N5y;
            BT[32]=N6y;
            BT[33]=N7y;
            BT[34]=N8y;
            BT[35]=N9y;
            
            BT[36]=N1y;
            BT[37]=N2y;
            BT[38]=N3y;
            BT[39]=N4y;
            BT[40]=N5y;
            BT[41]=N6y;
            BT[42]=N7y;
            BT[43]=N8y;
            BT[44]=N9y;
            
            BT[45]=N1x;
            BT[46]=N2x;
            BT[47]=N3x;
            BT[48]=N4x;
            BT[49]=N5x;
            BT[50]=N6x;
            BT[51]=N7x;
            BT[52]=N8x;
            BT[53]=N9x;
            
   
   return;    
}




/*---------------------------------------------------------
	TransposeMatrix
----------------------------------------------------------*/

void TransposeMatrix(int row, int col,double *M,double *MT)
{
   int i,j;
   
   for(i=0; i<row; i++)
   for(j=0; j<col; j++)
   MT[j+i*col]=M[i+j*row];
   
   return;    
}

/*---------------------------------------------------------
	MatrixMultMatrix
----------------------------------------------------------*/

void MatrixMultMatrix(int rowA,int colA,int colB,double *A,double *B,double *C)
{
   int i,m,n, rowB;
   
   rowB=colA;
   SetVectorToZero_double((rowA*colB),C);
   
   for(m=0; m<rowA; m++)
   for(n=0; n<colB; n++)
   for(i=0; i<colA; i++)
   C[m+n*rowA]+=A[m+i*rowA]*B[i+n*rowB];    
   
   return;    
}

/*---------------------------------------------------------
	AddMatrix
----------------------------------------------------------*/

void AddMatrix(int row, int col, double *M, double *Minc)
{
   int m,n;
   
   for(m=0; m<row; m++)
   for(n=0; n<col; n++)
   M[m+row*n]+=Minc[m+row*n];  
   
   return;    
}



/*---------------------------------------------------------
	GetRestoringForceBSplines
----------------------------------------------------------*/

int GetRestoringForceBSplines(
              int nnx, int nny, double *MatFieldE, 
        	  double *Ux,  double *Uy,
			  double *Fx, double *Fy,
			  int *BcTypeX, int *BcTypeY,
			  double *BcValueX, double *BcValueY,
	          double *K11, double *K12, double *K13,
              double *K21, double *K22, double *K23,
              double *K31, double *K32, double *K33)
{
    int i,j;
    int nex, ney, nns;
    double E;
    double U[18],F[18];
    double *K;
    int p;
    
    nex=nnx-1;
    ney=nny-1;
    nns=nex+2;

    SetVectorToZero_double((nex+2)*(ney+2), Fx);
    SetVectorToZero_double((nex+2)*(ney+2), Fy);

    for (j = 0; j < ney; j++) 
    {     
        for (i = 0; i < nex; i++)   
        {
            if((0==i) && (0==j))               {K=K11;}//printf("\nK11\n");} 
            if((0==i) && (j>0) && (j<(ney-1))) {K=K21;}//printf("\nK21\n");} 
            if((0==i) && ((ney-1)==j))         {K=K31;}//printf("\nK31\n");}  
            
            if((0<i) && (i<(nex-1)) && (0==j))               {K=K12;}//printf("\nK12\n");}  
            if((0<i) && (i<(nex-1)) && (j>0) && (j<(ney-1))) {K=K22;}//printf("\nK22\n");} 
            if((0<i) && (i<(nex-1)) && ((ney-1)==j))         {K=K32;}//printf("\nK32\n");}  
            
            if(((nex-1)==i) && (0==j))               {K=K13;}//printf("\nK13\n");}  
            if(((nex-1)==i) && (j>0) && (j<(ney-1))) {K=K23;}//printf("\nK23\n");} 
            if(((nex-1)==i) && ((ney-1)==j))         {K=K33;}//printf("\nK33\n");}  
            
            U[0]=Ux[i+j*nns];
            U[1]=Ux[1+i+j*nns];
            U[2]=Ux[2+i+j*nns];
            
            U[3]=Ux[i+(j+1)*nns];
            U[4]=Ux[1+i+(j+1)*nns];
            U[5]=Ux[2+i+(j+1)*nns];
            
            U[6]=Ux[i+(j+2)*nns];
            U[7]=Ux[1+i+(j+2)*nns];
            U[8]=Ux[2+i+(j+2)*nns];
            
            U[9]=Uy[i+j*nns];
            U[10]=Uy[1+i+j*nns];
            U[11]=Uy[2+i+j*nns];
            
            U[12]=Uy[i+(j+1)*nns];
            U[13]=Uy[1+i+(j+1)*nns];
            U[14]=Uy[2+i+(j+1)*nns];
            
            U[15]=Uy[i+(j+2)*nns];
            U[16]=Uy[1+i+(j+2)*nns];
            U[17]=Uy[2+i+(j+2)*nns];
                   
            MatrixMultMatrix(18,18,1,K,U,F);
            E= MatFieldE[i + j*nex];
            MatrixMultScalar(18,1, F, E);
          
            Fx[i+j*nns]  +=F[0];
            Fx[1+i+j*nns]+=F[1];
            Fx[2+i+j*nns]+=F[2];
            
            Fx[i+(j+1)*nns]+=F[3];
            Fx[1+i+(j+1)*nns]+=F[4];
            Fx[2+i+(j+1)*nns]+=F[5];
            
            Fx[i+(j+2)*nns]+=F[6];
            Fx[1+i+(j+2)*nns]+=F[7];
            Fx[2+i+(j+2)*nns]+=F[8];
            
            Fy[i+j*nns]+=F[9];
            Fy[1+i+j*nns]+=F[10];
            Fy[2+i+j*nns]+=F[11];
            
            Fy[i+(j+1)*nns]+=F[12];
            Fy[1+i+(j+1)*nns]+=F[13];
            Fy[2+i+(j+1)*nns]+=F[14];
            
            Fy[i+(j+2)*nns]+=F[15];
            Fy[1+i+(j+2)*nns]+=F[16];
            Fy[2+i+(j+2)*nns]+=F[17];         
            
           /* printf("\n i/j: %i/%i \n",i,j );
            PrintMatrix(1, 9, &U[0]);
            PrintMatrix(1, 9, &U[9]);
            PrintMatrix(3, 3, &F[0]);
            PrintMatrix(3, 3, &F[9]);
            getchar();*/
         }
    }
    
     for (j = 0; j < (ney+2); j++) 
    {     
        for (i = 0; i < (nex+2); i++)   
        {
          p=i+j*nns;
          if (0==BcTypeX[p]) Fx[p] = BcValueX[p] - Fx[p]; else Fx[p]=0.0;
          if (0==BcTypeY[p]) Fy[p] = BcValueY[p] - Fy[p]; else Fy[p]=0.0;
        }
    }
    return(1);
}

/*---------------------------------------------------------
	GetRestoringForceIncrementBSplines
----------------------------------------------------------*/

int GetRestoringForceIncrementBSplines(
              int nnx, int nny, double *MatFieldE, 
        	  double *Ux,  double *Uy,
			  double *Fx, double *Fy,
			  int *BcTypeX, int *BcTypeY,
			  double *BcValueX, double *BcValueY,
              double *K11, double *K12, double *K13,
              double *K21, double *K22, double *K23,
              double *K31, double *K32, double *K33)
{
    int i,j;
    int nex, ney, nns;
    double E;
    double U[18],F[18];
    double *K;
    int p;
    nex=nnx-1;
    ney=nny-1;
    nns=nex+2;
 
    SetVectorToZero_double((nex+2)*(ney+2), Fx);
    SetVectorToZero_double((nex+2)*(ney+2), Fy);
    
    for (j = 0; j < ney; j++) 
    {     
        for (i = 0; i < nex; i++)   
        {
            if((0==i) && (0==j))               K=K11; 
            if((0==i) && (j>0) && (j<(ney-1))) K=K21;
            if((0==i) && ((ney-1)==j))         K=K31; 
            
            if((0<i) && (i<(nex-1)) && (0==j))               K=K12; 
            if((0<i) && (i<(nex-1)) && (j>0) && (j<(ney-1))) K=K22;
            if((0<i) && (i<(nex-1)) && ((ney-1)==j))         K=K32; 
            
            if(((nex-1)==i) && (0==j))               K=K13; 
            if(((nex-1)==i) && (j>0) && (j<(ney-1))) K=K23;
            if(((nex-1)==i) && ((ney-1)==j))         K=K33; 
            
            U[0]=Ux[i+j*nns];
            U[1]=Ux[1+i+j*nns];
            U[2]=Ux[2+i+j*nns];
            
            U[3]=Ux[i+(j+1)*nns];
            U[4]=Ux[1+i+(j+1)*nns];
            U[5]=Ux[2+i+(j+1)*nns];
            
            U[6]=Ux[i+(j+2)*nns];
            U[7]=Ux[1+i+(j+2)*nns];
            U[8]=Ux[2+i+(j+2)*nns];
            
            U[9]=Uy[i+j*nns];
            U[10]=Uy[1+i+j*nns];
            U[11]=Uy[2+i+j*nns];
            
            U[12]=Uy[i+(j+1)*nns];
            U[13]=Uy[1+i+(j+1)*nns];
            U[14]=Uy[2+i+(j+1)*nns];
            
            U[15]=Uy[i+(j+2)*nns];
            U[16]=Uy[1+i+(j+2)*nns];
            U[17]=Uy[2+i+(j+2)*nns];
                   
            MatrixMultMatrix(18,18,1,K,U,F);
            E= MatFieldE[i + j*nex];
            MatrixMultScalar(18,1, F, E);

            Fx[i+j*nns]  +=F[0];
            Fx[1+i+j*nns]+=F[1];
            Fx[2+i+j*nns]+=F[2];
            
            Fx[i+(j+1)*nns]+=F[3];
            Fx[1+i+(j+1)*nns]+=F[4];
            Fx[2+i+(j+1)*nns]+=F[5];
            
            Fx[i+(j+2)*nns]+=F[6];
            Fx[1+i+(j+2)*nns]+=F[7];
            Fx[2+i+(j+2)*nns]+=F[8];
            
            Fy[i+j*nns]+=F[9];
            Fy[1+i+j*nns]+=F[10];
            Fy[2+i+j*nns]+=F[11];
            
            Fy[i+(j+1)*nns]+=F[12];
            Fy[1+i+(j+1)*nns]+=F[13];
            Fy[2+i+(j+1)*nns]+=F[14];
            
            Fy[i+(j+2)*nns]+=F[15];
            Fy[1+i+(j+2)*nns]+=F[16];
            Fy[2+i+(j+2)*nns]+=F[17];       

         }
    }
    
     for (j = 0; j < (ney+2); j++) 
    {     
        for (i = 0; i < (nex+2); i++)   
        {
          p=i+j*nns;
          if (0==BcTypeX[p]) Fx[p]=-Fx[p]; else Fx[p]=0.0;
          if (0==BcTypeY[p]) Fy[p]=-Fy[p]; else Fy[p]=0.0;
        }
    }
    /*
     for (j = 0; j < (ney+2); j++) 
    {     
        for (i = 0; i < (nex+2); i++)   
        {
          p=i+j*nns;
          (*err2)=Fx[p]*Fx[p];
          (*err2)=Fy[p]*Fy[p];
        }
    }
    */
    return(1);
}

/*---------------------------------------------------------
	TransformSplinesOnMesh
----------------------------------------------------------*/

// Nine functions and four nodes each!

int TransformSplinesOnMesh(int nnx, int nny, 
                           double la, double lb, 
                           double *NUx,  double *NUy,
                           double *SUx, double *SUy)
{
    int i,j;
    int nns;
    
    nns=nnx+1;
    
       for (j = 0; j < nny; j++) 
       for (i = 0; i < nnx; i++)   
       {
         NUx[i+j*nnx]=SUx[i+1+(j+1)*nns];
         NUy[i+j*nnx]=SUy[i+1+(j+1)*nns];
       }
    return(1);
}


