/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <FL/gl.h>

/*------------------------------------------------------------------------------
     WriteBmp
------------------------------------------------------------------------------*/
void WriteBmp(int nex, int ney, double *Post1, double *Post2, double *Post3, double *Post4,
              double minimum, double maximum, ColorPalette CurrentPalette)
{
  FILE *datei, *datei1;
  char str[36],str1[36]="image";
  long long i;
  unsigned int k;
  unsigned char a,j;
  long length;
  long origin;
  long p,q,r;
  double val;
  unsigned char tmp;
  int col;
  int pp; // additional pixels in row
  int z,nz,iz;
  
  printf("\nWrite BMP\n");
  i=0;j=0;z=10;nz=4;
  while(j==0)
  { 
    z=10; nz=4;                               
    while (i>(z-1)) 
    {
       z*=10; nz-=1;
    }
    sprintf(str,"%s",str1);
    for(iz=0;iz<nz;iz++) strcat(str,"0");
    sprintf(str,"%s%d",str,i);strcat(str,".bmp");
    if((datei=fopen(str, "r"))==NULL) {j=1;} else {i++; fclose(datei);}
  }
  
  pp=(4-(nex*3)%4)%4;
  length=(nex*ney)*3+ney*pp+54;
  
  z=10; nz=4;                               
  while (i>(z-1)) 
  {
      z*=10; nz-=1;
  }
  sprintf(str,"%s",str1);
  for(iz=0;iz<nz;iz++) strcat(str,"0");
  sprintf(str,"%s%d",str,i);strcat(str,".bmp");
  //sprintf(str,"%s%d",str1,i);strcat(str,".bmp");
  if ((datei=fopen(str, "wb"))==NULL) return; 
  
  // Byte 0-1 "BM"
  fprintf(datei,"%c",0x42); 
  fprintf(datei,"%c",0x4D); 
  // Byte 2-5 Length of file with header
  origin=length;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  // Byte 6-9 Null
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 14-17 Length of header
  fprintf(datei,"%c",54);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 14-17 Length of header from here
  fprintf(datei,"%c",40);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);  
  // Byte 18-21 Width of image
  origin=nex;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  // Byte 22-25 Height of image
  origin=ney;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp);
  // Byte 26-27 Number of Layers
  fprintf(datei,"%c",1); 
  fprintf(datei,"%c",0);
  // Byte 28-29 Bytes per Pixel
  fprintf(datei,"%c",24); 
  fprintf(datei,"%c",0);
  // Byte 30-33 Compression method
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 34-37 Length of file without header
  origin=(nex*ney)*3+ney*pp;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  // Byte 38-41 Resolution in x-direction Pixel per meter
  fprintf(datei,"%c",18); 
  fprintf(datei,"%c",11);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 42-45 Resolution in y-direction Pixel per meter
  fprintf(datei,"%c",18); 
  fprintf(datei,"%c",11);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);  
  // Byte 46-49 Number of used colors  
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);   
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);  
  // Byte 50-53 Number of important colors  
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);   
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  
  for(q=0; q<ney; q++)
  {
    for(p=0; p<nex; p++)
    {
      val=(Post1[p+q*nex]+Post2[p+q*nex]+Post3[p+q*nex]+Post4[p+q*nex])/4.0;
      col=PickColor(CurrentPalette.NumColor, minimum, maximum, val); 
      tmp=(unsigned char)(CurrentPalette.b[col]*255.0); 
      fprintf(datei,"%c",tmp); 
      tmp=(unsigned char)(CurrentPalette.g[col]*255.0); 
      fprintf(datei,"%c",tmp); 
      tmp=(unsigned char)(CurrentPalette.r[col]*255.0); 
      fprintf(datei,"%c",tmp); 
    }
    for(r=0; r<pp; r++)
    {
      fprintf(datei,"%c",0);  
    }
  }      
  fclose(datei);
  
  return;
}

/*------------------------------------------------------------------------------
     WriteBmp2
------------------------------------------------------------------------------*/

void WriteBmp2(int nex, int ney)
{
  FILE *datei, *datei1;
  char str[36],str1[36]="shot";
  long long i;
  unsigned int k;
  unsigned char a,j;
  long length;
  long origin;
  long p,q,r;
  double val;
  unsigned char tmp;
  int col;
  int pp; // additional pixels in row
  int z,nz,iz;

  
  printf("\nWrite BMP\n");
  i=0;j=0;z=10;nz=4;
  while(j==0)
  { 
    z=10; nz=4;                               
    while (i>(z-1)) 
    {
       z*=10; nz-=1;
    }
    sprintf(str,"%s",str1);
    for(iz=0;iz<nz;iz++) strcat(str,"0");
    sprintf(str,"%s%d",str,i);strcat(str,".bmp");
    if((datei=fopen(str, "r"))==NULL) {j=1;} else {i++; fclose(datei);}
  }
  
  pp=(4-(nex*3)%4)%4;
  length=(nex*ney)*3+ney*pp+54;
  
  z=10; nz=4;                               
  while (i>(z-1)) 
  {
      z*=10; nz-=1;
  }
  sprintf(str,"%s",str1);
  for(iz=0;iz<nz;iz++) strcat(str,"0");
  sprintf(str,"%s%d",str,i);strcat(str,".bmp");
  //sprintf(str,"%s%d",str1,i);strcat(str,".bmp");
  if ((datei=fopen(str, "wb"))==NULL) return; 
  
  // Byte 0-1 "BM"
  fprintf(datei,"%c",0x42); 
  fprintf(datei,"%c",0x4D); 
  // Byte 2-5 Length of file with header
  origin=length;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  // Byte 6-9 Null
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 14-17 Length of header
  fprintf(datei,"%c",54);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 14-17 Length of header from here
  fprintf(datei,"%c",40);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);  
  // Byte 18-21 Width of image
  origin=nex;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  // Byte 22-25 Height of image
  origin=ney;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp);
  // Byte 26-27 Number of Layers
  fprintf(datei,"%c",1); 
  fprintf(datei,"%c",0);
  // Byte 28-29 Bytes per Pixel
  fprintf(datei,"%c",24); 
  fprintf(datei,"%c",0);
  // Byte 30-33 Compression method
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 34-37 Length of file without header
  origin=(nex*ney)*3+ney*pp;
  tmp=origin%256;                          fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  origin=(origin-tmp)/256; tmp=origin%256; fprintf(datei,"%c",tmp); 
  // Byte 38-41 Resolution in x-direction Pixel per meter
  fprintf(datei,"%c",18); 
  fprintf(datei,"%c",11);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  // Byte 42-45 Resolution in y-direction Pixel per meter
  fprintf(datei,"%c",18); 
  fprintf(datei,"%c",11);
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);  
  // Byte 46-49 Number of used colors  
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);   
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);  
  // Byte 50-53 Number of important colors  
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);   
  fprintf(datei,"%c",0);
  fprintf(datei,"%c",0);
  
  for(q=0; q<ney; q++)
  {
    for(p=0; p<nex; p++)
    {
      glReadPixels(p, q, 1, 1, GL_BLUE, GL_UNSIGNED_BYTE, &tmp);
      fprintf(datei,"%c",tmp);
      glReadPixels(p, q, 1, 1, GL_GREEN, GL_UNSIGNED_BYTE, &tmp);
      fprintf(datei,"%c",tmp);
      glReadPixels(p, q, 1, 1, GL_RED, GL_UNSIGNED_BYTE, &tmp);
      fprintf(datei,"%c",tmp);
    }
    for(p=0; p<pp; p++)
    {
      fprintf(datei,"%c",0);  
    }
  } 
  

  fclose(datei);
  
  return;
}

/*------------------------------------------------------------------------------
     ReadBmp
------------------------------------------------------------------------------*/

void ReadBmp()
{
  FILE *datei;
  char str[36]="bmpname.bmp";
  int i,j,k;
  int nex,ney;
  int pp;
  int b1,b2,b3,b4;
  unsigned char  c1,c2,c3,c4;
  long length;
  unsigned char  *pixels;
  int num_levels;
  SolveBlock *SolBlock;
  MGBlock *Meshes;
  GraphicBlock *graphblock;
  MyMainWindowUI   *mainwin;
  long col;
  int *colors;
  int *colors2;
  int num_colors;
  int len_colors;
  int act=9;
  int IdenticalFlag;
  int add_colors;
  int *MatFieldInt;
  float *r,*g,*b;
  
  
  printf("\nRead BMP\n");

  if ((datei=fopen(str, "rb"))==NULL) return; 
 
  fseek(datei, (long) 28, SEEK_SET);
  c1=fgetc(datei); b1=(int) c1;
  if(24!=b1) 
  {   
      printf("Not a 24-bit RGB-Bitmap file!");
      fclose(datei); 
      return;
  }
  
    
  fseek(datei, (long) 18, SEEK_SET);
  c1=fgetc(datei); b1=(int) c1; printf("1: %i\n",b1);
  c2=fgetc(datei); b2=(int) c2; printf("2: %i\n",b2);
  c3=fgetc(datei); b3=(int) c3; printf("3: %i\n",b3);
  c4=fgetc(datei); b4=(int) c4; printf("4: %i\n",b4);
  nex=b1 + 256*b2+ 256*256*b3 + 256*256*256*b4;
  printf("BMP-Width = %i",nex);
  
  fseek(datei, (long) 22, SEEK_SET);
  c1=fgetc(datei); b1=(int) c1; printf("1: %i\n",b1);
  c2=fgetc(datei); b2=(int) c2; printf("2: %i\n",b2);
  c3=fgetc(datei); b3=(int) c3; printf("3: %i\n",b3);
  c4=fgetc(datei); b4=(int) c4; printf("4: %i\n",b4);
  ney=b1 + 256*b2+ 256*256*b3 + 256*256*256*b4;
  printf("BMP-Height = %i",ney);
  
  pp=(4-(nex*3)%4)%4;
  //if(pp!=0) pp=4-pp;
  printf("\npp: %i\n",pp);
  b1=nex;
  b2=ney;
  b3=0;
  num_levels=1;
  
  while (0==b3)
  {
      i=b1%2;
      j=b2%2;
      if (0==i && 0==j && b1>2 && b2>2)
      {
          b1/=2;
          b2/=2;
          num_levels+=1;
      } 
      else
      b3=1;
  }
  PutGetSolveBlock(1,&SolBlock);        
  if (1==(SolBlock->MeshDefined)) FreeSolveBlock(SolBlock);
  SolBlock->MeshDefined=1;
  printf("b1 %i b2 %i\n",b1,b2);
  CreateFlexibleMeshes(b1, b2, num_levels, &Meshes);    
  
    SolBlock->Meshes=Meshes;
    SolBlock->num_levels=num_levels;
    //SolBlock->K_matrix=K_matrix;
    //SolBlock->K_matrixQ9=K_matrixQ9;
    
    PutGetGraphicBlock(1, &graphblock);
    graphblock->show_level=num_levels-1;
    graphblock->detail_level=graphblock->show_level;
    
    PutGetMainWindow(1, &mainwin);
    mainwin->Level->maximum((int)(num_levels-1));
    mainwin->Level->value((int)(num_levels-1)); 
    mainwin->Detail->maximum((int)(num_levels-1));
    mainwin->Detail->value((int)(num_levels-1));
 
  printf("Number of levels = %i\n",num_levels);
  printf("pp: %i\n",pp);
  
  add_colors=10;
  len_colors=add_colors;
  num_colors=0;
  IdenticalFlag=0;
  InitVector_int(len_colors,    &colors);   
  fseek(datei, (long) 54, SEEK_SET);
  MatFieldInt=Meshes[num_levels-1].MatFieldInt;
  for(j=0;j<ney;j++)
  {
      fseek(datei, (long) 54+j*(nex*3+pp), SEEK_SET);
      for(i=0;i<nex;i++)
      {
          c1=fgetc(datei); b1=(int) c1; 
          c2=fgetc(datei); b2=(int) c2; 
          c3=fgetc(datei); b3=(int) c3; 
          col=b1 + 256*b2+ 256*256*b3;
          //printf("\nBGR %i %i %i\n",b1,b2,b3);
          //MatFieldInt[i+j*nex]=(int)col;
          IdenticalFlag=0; 
          for(k=0; k<num_colors;k++)
          {
              if (colors[k]==col) 
              {
                  IdenticalFlag=1; 
                  k=num_colors;
              }
          }
          if (0==IdenticalFlag)
          {
              num_colors+=1;
              if (num_colors>len_colors)
              {
                  len_colors+=add_colors;
                  InitVector_int(len_colors,    &colors2);  
                  memcpy(colors2, colors, num_colors*sizeof(int));
                  free(colors);
                  colors=colors2;       
              }
              colors[num_colors-1]=col;
              
          }
      }
  }
  
  printf("number of colors %i\n",num_colors);
  for(i=0; i<num_colors;i++)
  {
     // printf("Color: %i %i \n ",i,colors[i]);
  }
  shellsort3(colors, num_colors, 1, 1, 5);
  
  InitVector_float(num_colors,    &r); 
  InitVector_float(num_colors,    &g); 
  InitVector_float(num_colors,    &b); 
  graphblock->CurrentPalette[act].r=r;
  graphblock->CurrentPalette[act].g=g;
  graphblock->CurrentPalette[act].b=b;
  graphblock->CurrentPalette[act].NumColor=num_colors;;

  
  for(j=0;j<ney;j++)
  {
      fseek(datei, (long) 54+j*(nex*3+pp), SEEK_SET);
      for(i=0;i<nex;i++)
      {
          c1=fgetc(datei); b1=(int) c1; 
          c2=fgetc(datei); b2=(int) c2; 
          c3=fgetc(datei); b3=(int) c3; 
          col=b1 + 256*b2+ 256*256*b3;
          //printf("\nBGR %i %i %i\n",b1,b2,b3);
          //MatFieldInt[i+j*nex]=(int)col;
          //IdenticalFlag=0; 
          for(k=0; k<num_colors;k++)
          {
              if (colors[k]==col) 
              {
                  r[k]=(float)((float)b3) / ((float)255.0);
                  g[k]=(float)((float)b2) / ((float)255.0);
                  b[k]=(float)((float)b1) / ((float)255.0);
                  MatFieldInt[i+j*nex]=k;
                  k=num_colors;
                  //printf("\nTEST gk %f bk %f\n",g[k],b[k]);
                  
              }
          }
      }
  }
  
  if(0!=SolBlock->NumMaterials)
  {FreeMaterialBlock(SolBlock->NumMaterials, SolBlock->Material);}
  
  SolBlock->NumMaterials=num_colors;    
  InitMaterialBlock((SolBlock->NumMaterials), &(SolBlock->Material));
  
  for(i=0; i<(SolBlock->NumMaterials);i++)
  {  
    SolBlock->Material[i].E=12345.0;
    SolBlock->Material[i].Mu=0.234;
  }
  
  free(colors);
  fclose(datei);
  printf("Reading of bmp is finished \n",num_colors);
  
  return;
}

/*------------------------------------------------------------------------------
     ReadDataFile
------------------------------------------------------------------------------*/

void ReadDataFile(int nex, int ney)
{

  int i,j,k;
  int b1,b2,b3,b4;
  long length;
  int num_levels;
  SolveBlock *SolBlock;
  MGBlock *Meshes;
  GraphicBlock *graphblock;
  MyMainWindowUI   *mainwin;
 
  b1=nex;
  b2=ney;
  b3=0;
  num_levels=1;
  
  while (0==b3)
  {
      i=b1%2;
      j=b2%2;
      if (0==i && 0==j && b1>2 && b2>2)
      {
          b1/=2;
          b2/=2;
          num_levels+=1;
      } 
      else
      b3=1;
  }
  //printf("NUMLEVELS:%i\n",num_levels);
  PutGetSolveBlock(1,&SolBlock);        
  if (1==(SolBlock->MeshDefined)) FreeSolveBlock(SolBlock);
  SolBlock->MeshDefined=1;
  CreateFlexibleMeshes(b1, b2, num_levels, &Meshes);    
  SolBlock->Meshes=Meshes;
  SolBlock->num_levels=num_levels;
  
  PutGetGraphicBlock(1, &graphblock);
  graphblock->show_level=num_levels-1;
  graphblock->detail_level=graphblock->show_level;
    
  PutGetMainWindow(1, &mainwin);
  mainwin->Level->maximum((int)(num_levels-1));
  mainwin->Level->value((int)(num_levels-1)); 
  mainwin->Detail->maximum((int)(num_levels-1));
  mainwin->Detail->value((int)(num_levels-1));
  
   /* 
  if(0!=SolBlock->NumMaterials)
  {FreeMaterialBlock(SolBlock->NumMaterials, SolBlock->Material);}
  
  SolBlock->NumMaterials=num_colors;    
  InitMaterialBlock((SolBlock->NumMaterials), &(SolBlock->Material));
  
  for(i=0; i<(SolBlock->NumMaterials);i++)
  {  
    SolBlock->Material[i].E=12345.0;
    SolBlock->Material[i].Mu=0.234;
  }
  
  free(colors);
  fclose(datei);
  printf("Reading of bmp is finished \n",num_colors);
  */
  return;
}



