/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#ifndef MyDataStructures_h
#define MyDataStructures_h

class MyMainWindowUI; 
class MyInputGeomWindowUI;
class MyInputMeshWindowUI;
class MyInputMesoWindowUI;
class MyInputLoadWindowUI;
class MyInputSolveWindowUI;
class MyFileBaseWindowUI;
class MyInputAboutWindowUI;
typedef struct MGBlock;
typedef struct MaterialBlock;
typedef struct TimeBlock;
typedef struct ErrorBlock;

typedef struct MesoPixTmp
{
    int    *px, *p, *py, *pz, *pA, *map, *pmap, *obj_matrix;
    int    *length, *incl_matrix, *fillflag, *MatFieldInt;
} MesoPixTmp;


typedef struct AggBlock
    {
        double a;
        double b;
        double phi;
        double sinphi;
        double cosphi;
        double pot1, pot2;
        double lw_ratio;
        double Smoothness;
        double Roughness;
        double RoughFact;
        double Deformed;
        double DeformedFact;
        int RoughFlag;
        int DeformedFlag;
        double e1;
        double e2;
        int num1;
        int num2;
        //3d
        double c;
        double theta;
        double psi;
        double l1,l2,l3,m1,m2,m3,n1,n2,n3;
        
    } AggBlock;
    


typedef struct ColorPalette
{
    int   NumColor;   
    float *r; 
    float *g;          
    float *b;
}
ColorPalette;

typedef struct GraphicBlock
{   
    int   NewObjectFlag;
    float ExtrudeZ;
    float RotateAngleX;
    float RotateAngleZ;
    float Zoomfactor; 
    float Deflect;
    int   Frames; 
    float start;
    int   framecount; 
    int   UpdateFlag; 
    int   ShowValues;
    char  SelectObject[32];   
    int   ObjectFlag;           
    int   WinPixelWidth;
    int   WinPixelHeight;
    double xmin, xmax, ymin, ymax;
    double transX, transY;
    int    show_level, detail_level;
    double minimum,maximum;
    ColorPalette CurrentPalette[12];
    int num_palette;
    int act_palette;
    int RunFlag;
    int PostSaveStep;
    int SmoothNum;
    int IsoLines;
    int PostSmoothFlag;
    int DrawGridFlag;
    int DrawFrameFlag;
    int DrawBCFlag;
    int DrawNodeFlag;
    int DrawPatchFlag;
    double NodeSize;
    double LineThickness;
    double Extrude;
    int BmpDataFlag;
    int BmpScreenFlag;
    int RotateFlag;
    int RotateCoor;
    int TMP;
}
GraphicBlock;


typedef struct PolynomStruct
{ 			
    double *coefficient;
    int    numcoeff;	
}
PolynomStruct;



typedef struct SomePolynoms
{ 			
	PolynomStruct  *Polynom;
}
SomePolynoms;


typedef struct SomeElements   // !neu -n19-!
{ 			
	SomePolynoms  *Element;
	int            numpoly;
	int            numcoeff;
	int            numElements;
	int            center;
}
SomeElements;


typedef struct GaussValues   // !neu -n20-!
{ 			
    SomePolynoms LegPoly;
    double **Xv;
    double **Gv; 
    int numXi; 	
}
GaussValues;



typedef struct BSplineBlock   // !abgendert -a03-!
{ 			
	int            orderK;
	int            lastK;
	int            initSplineFlag;  
	int            BSPMatrBuildFlag;
               
	SomeElements   SplineElemsX;   // Onedimensional BSpline Functions for x-direction
    SomeElements   SplineElemsY;   // Onedimensional BSpline Functions for y-direction
    SomeElements   SplineElemsXdX; // Onedimensional BSpline Functions Derivative for x-direction
    SomeElements   SplineElemsYdY; // Onedimensional BSpline Functions Derivative for y-direction
	
    double         C[9];
	double         ***K;
	double         *BT,*B;
	double         *Nx,*Ny;
	double         *Xi,*Gi;        // Values Gauss Quadratur
	int            numXi;
	double         la,lb;
	
	int            help;
	// alte Eintrge
	int            numpoly;
	SomePolynoms   Polynomials[12];
	double         *K11,*K12,*K13,*K21,*K22,*K23,*K31,*K32,*K33;
	
}
BSplineBlock;
//Polynomials = Onedimensional BSpline Functions 
//Polynomials[0] = Left
//Polynomials[1] = Middle
//Polynomials[2] = Right
//Polynomials[3] = Left Derivative
//Polynomials[4] = Middle Derivative
//Polynomials[5] = Right Derivative
// Equivalent, Polynomials[6..11] for y-direction!

typedef struct TimeBlock   
{ 			
    int   T_flag;
    float T_field[14];
    /*
    0=T_start_total
    1=T_start_part
    2=T_tmp
    3=T_total
    4=T_restrict
    5=T_prolong
    6=T_error
    7=T_other
    8=T_prep
    */
}
TimeBlock;


typedef struct ErrorBlock   
{ 			
   int ErrFlag[8];
   double ErrValue[8];
   double ErrTol[8];
}
ErrorBlock;

typedef struct SolveBlock    // !abgendert -a02-!
{ 			
    
    int     num_levels;
    double  *K_matrix;
    double  *K_matrixQ9;
    double  err1, err2;
    double  lambda;  
    double  minimum, maxmimum;
    int     MeshDefined;
    int     SpMeshDefined;
    MGBlock *Meshes;
    MGBlock *SplineMesh; 
    MGBlock *PreMesh;
    MGBlock *FinerSplineMesh;
    int     FinerSplineFlag;
    int     FinerSpMeshDefined;
    int     FinerSpMeshFactor;
    int     PreMeshFlag;
    int     PreCondType;
    double  SolError;
    double  SystemEnergy;
    int SSORFlag;
    //int     BSplineFlag;
    int     i;	
    //double  lx,ly,lz;
    // CG
    double alpha, beta, sumR, sumD;		
    BSplineBlock BSplines;
    int NumMaterials;
    MaterialBlock *Material;
    int    Flag3d;
    TimeBlock  TimeData;
    ErrorBlock ErrorData;
    int cycle_len;
    int *cycle;
    int GoFlag;
}
SolveBlock;



typedef struct MaterialBlock
{ 			
    double E;
    double Mu;
    double *K;
    int Visible;
}
MaterialBlock;


typedef struct MGBlock
{
    int nnx;                    /* grid size: nn:nodes, ne:elements */                                               
    int nny; 
    int nnz; //3D			
    int nex;  																										 
    int ney;
    int nez; //3D 	
    
    int nnsize;
    int totsize;  	 

    double la;
    double lb;
    double lc;  //3D

    double *MatFieldE;          /* material data */
    double *KnMatFieldE;
    int    *MatFieldInt; 

    double *U;
    double *Ux;                 /* node displacements */
    double *Uy;	
    double *Uz;  //3D	
    
    double *dU; 	
    double *dUx;                /* displacement increments*/
    double *dUy;  
    double *dUz; //3D	
    
    double *F; 	
    double *Fx;                 /* nodal forces */    
    double *Fy;	
    double *Fz;  //3D
    
    double *D;
    double *Dx;                 /* CG */
    double *Dy;	
    double *Dz;  //3D
    
    double *Ad;
    double *Adx;
    double *Ady;
    double *Adz; //3D
    
    double *Mpc;
      	 
    double *SwapXYZ;
    double *SwapX;              /* swap memory */   
    double *SwapY;	
    double *SwapZ; //3D
    
    double *Swap;
    
    double *Post;
    
    double *Post1;
    double *Post2;
    double *Post3;
    double *Post4;	   
    
    double *Post5; //3D
    double *Post6; //3D
    double *Post7; //3D
    double *Post8; //3D
            
    
    double *EqStrain;	       

                /* boundary conditions */ 
    int    *BcType;            
    int    *BcTypeX;
    int    *BcTypeY;   
    int    *BcTypeZ; //3D
    
    double *BcValue;                    
    double *BcValueX;
    double *BcValueY; 
    double *BcValueZ; //3D
    
    double *Kappa;
    double *DamageOmega;
    
    double *weights;
    
    int    NumColIndex;
    int    *ColorIndex;
}
MGBlock;




/********************** INPUT WINDOW: GeomWinStruct ***************************/

typedef struct GeomWinStruct
{
    double lx;                                                         
    double ly;
    double lz;																	 
}
GeomWinStruct;

/********************** INPUT WINDOW: MeshWinStruct ***************************/
typedef struct MeshWinStruct
{
    int MinDof;                                                         																 
}
MeshWinStruct;

/********************** INPUT WINDOW: MesoWinStruct ***************************/
typedef struct MesoWinStruct
{
    double E_Matrix, E_Inclusion;
    double Mu_Matrix;
    double Mu_Inclusion;
    double MinSize, MaxSize;
    double VolFraction;                                                         																 
    int    FullerFlag;
    double FullerExponent;
    double Smoothness;
    double Compactness;
    double Roughness;
    double Deformed;
    int    RoughFlag;
    int    DeformedFlag;
    int    AddFlag;
    int    MaterialNumBegin;
    int    MaterialNumEnd;
    
}
MesoWinStruct;

/********************** INPUT WINDOW: LoadWinStruct ***************************/
typedef struct OneLoad
{
    int PrimFlag;
    int NumFlag; 
    int PhyFlag;
    double BCVal;  
    double BCPot;                                                         																 
}
OneLoad;

typedef struct LoadWinStruct   // !abgendert -a12-!
{
    int      num_loads;
    int      num_disp;
    int      DispType[8];
    OneLoad  LoadList[200]; 
    int      num_loads3d;
    OneLoad  LoadList3d[200];                                                    																 
}
LoadWinStruct;

/********************** INPUT WINDOW: SolveWinStruct ***************************/
typedef struct SolveWinStruct   // !abgendert -a04-!
{
    int     SolverMethod;
    double  Omega;
    int     OptFactorFlag;
    int     BSplineFlag;
    int     YMsmoothFlag;
    int     CircleElementFlag;
    int     CircleIntpntFlag;
    double  Repititions;
    int     BSpOrderK;
    int     i;         
    double  NLRadius;   
    double  LimitStrain;  
    double  DuctileStrain; 
    int     LoadSteps;          
    int     EuclidFlag;
    int     RelEnergyFlag;
    int     RelEuclidFlag;
    double  RelEnergyTol;
    double  EuclidTol;   
    double  RelEuclidTol;  
    int     PreCondType;
    int     ContFlag;       
    int     SSORFlag; 
    float   CheckTime;                       																 
}
SolveWinStruct;

/********************** INPUT WINDOW: AllWinStruct ***************************/

typedef struct AllWinStruct
{
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    MesoWinStruct *MesoWinData;
    LoadWinStruct *LoadWinData;
    SolveWinStruct *SolveWinData;                                 																	 
}
AllWinStruct;



       
#endif
