/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetBaseFileWindow
------------------------------------------------------------------------------*/
void PutGetBaseFileWindow(int choice, MyFileBaseWindowUI **inblock) 
{
     static MyFileBaseWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


/*------------------------------------------------------------------------------
     BaseWin_callback
------------------------------------------------------------------------------*/
void BaseWin_callback() {
  MyFileBaseWindowUI* basewin;
  PutGetBaseFileWindow(1, &basewin);
  basewin->m_window->hide();
}
/*------------------------------------------------------------------------------
     BaseWin_cb_OK
------------------------------------------------------------------------------*/
void BaseWin_cb_OK() 
{

    SolveBlock *SolBlock;
    int num_levels,i;
    MyFileBaseWindowUI* basewin;
    AllWinStruct *AllWinData;
    const char *file_name;
    char filename[30],type[3],empty[1]="";
    int file_length;
    
    
    PutGetBaseFileWindow(1, &basewin);     
   
   file_name=(const char*) basewin->File_Input->value();
   file_length=strlen(file_name);
   
   
   
if (file_length==0)
   {
   strcpy(filename,"inclusion");
   }
   
else 
   {
      for (i=0;i<file_length;i++)
         {
            filename[i]=file_name[i];
         }    
         
          /*             
           if (file_length>4) 
             {  type[0]=filename[file_length-4];
                type[1]=filename[file_length-3];
                type[2]=filename[file_length-2];
                   
               if (strcmp(type,".mg")==0)
                  {    
                  for (i=file_length-4;i<file_length;i++)
                      {
                      
                       filename[i]=empty[0];
                      } 
                  }  
             }
             */
             filename[i]=empty[0];
   
   }
 printf("\n File: \n %s \n",filename); 
              
               /* SAVE */
                             
   if (basewin->Check_Save->value()==1)
   {
      if (basewin->geometry->value()==1)
      {
      BaseWin_Save_Geometry(filename); 
      BaseWin_Save_EModul_Int(filename);
      }
      
            
      if (basewin->Loads->value()==1)
      {
      BaseWin_Save_Loads(filename); 
      }
      
      if (basewin->Results->value()==1)
      {
      BaseWin_Save_Results(filename); 
      }
      
      
   } 
   
                  /*  OPEN*/

   if (basewin->Check_Open->value()==1)
   {    
      if (basewin->geometry->value()==1)
      {
      BaseWin_Open_EModul_Int(filename);
      BaseWin_Open_Geometry(filename); 
      
      PutGetSolveBlock(1,&SolBlock);
      num_levels=SolBlock->num_levels;
 
      TransMatFieldToCoarse(SolBlock->Meshes, num_levels);
    
      }
  
            
      if (basewin->Loads->value()==1)
      {
      BaseWin_Open_Loads(filename); 
      }
      
      if (basewin->Results->value()==1)
      {
      BaseWin_Open_Results(filename); 
      }
      
   }    
   basewin->m_window->hide();
   UpdateSectionSliders();
}

/*------------------------------------------------------------------------------
     BaseWin_Save_Geometry
------------------------------------------------------------------------------*/
void BaseWin_Save_Geometry(char *savefile) 
{    double la,lb,lx,ly,lz;
    int nx,ny,i;
    MGBlock *BaseWinData,*P;
    SolveBlock *SolBlock;
    int num_levels,dof;
    int show_level;
    double *MatrixE;
    FILE    *outp ;
    char  filename[30];
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    int ModelDim;
    int DataLen;
    
    ModelDim=PutGetModelDim(1,123);
  
    PutGetAllWinStruct(1, &AllWinData); 
    GeomWinData=AllWinData->GeomWinData;
    MeshWinData=AllWinData->MeshWinData;
      
    PutGetSolveBlock(1,&SolBlock);
    BaseWinData=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    P=&(BaseWinData[num_levels-1]); 
    
    
                             
    dof=MeshWinData->MinDof;
    la=P->la;
    lb=P->lb;
    nx=P->nnx;
    ny=P->nny;
    lx=la*((double)nx-1.0);
    ly=lb*((double)ny-1.0);
    lz=1.0;
    
    MatrixE=&P->MatFieldE[0];
     
    printf("..............Saving....................\n");

     strcpy(filename,savefile);
     strcat(filename,".mg1");
     outp = fopen(filename,"wb");  
    
    /*Make sure if file was opened successfully*/ 
   	if (outp == NULL)  
   	{   
  		printf("Error: cannot open the file ");
   	    //getchar();
   	}
 
 	else 
	{   
	    fprintf(outp,"dof %i\n",(dof));
    	fprintf(outp,"nx %i\n",(nx));
		fprintf(outp,"ny %i\n",(ny));
		if (3==ModelDim)
		    fprintf(outp,"nz %i\n",(P->nnz));
		else
		    fprintf(outp,"nz %i\n",0);
	    fprintf(outp,"lx %g  \n",(lx));
	    fprintf(outp,"ly %g  \n",(ly));
	    fprintf(outp,"lz %g  \n",(lz));       
		fprintf(outp,"E-modul Matrix:\n");
		
        if (3==ModelDim) 
            DataLen=(nx-1)*(ny-1)*((P->nnz)-1);
        else
            DataLen=(nx-1)*(ny-1);
        
        for (i=0;i<DataLen;i++)
		{
			fprintf(outp,"%g ",
			MatrixE[i]);
						   	
		}
		fclose(outp);
		
	}
	printf("............File saved.................\n");
	printf("...to %s ...\n",filename);
}
/*------------------------------------------------------------------------------
     BaseWin_Open_Geometry
------------------------------------------------------------------------------*/
void BaseWin_Open_Geometry(char *savefile) 
{ double la,lb;
    double lx,ly,lz,length_x,length_y,length_z;
    int nx,ny,nz,i;
    MGBlock *BaseWinData,*P;
    SolveBlock *SolBlock;
    int dof,num_levels;
    int show_level;
    FILE    *inp ;
    char filename[30];
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    int ModelDim;
    int DataLen;
    
    ModelDim=PutGetModelDim(1,123);
   
    PutGetAllWinStruct(1, &AllWinData); 
    GeomWinData=AllWinData->GeomWinData;
    MeshWinData=AllWinData->MeshWinData;
    PutGetSolveBlock(1,&SolBlock);
    BaseWinData=SolBlock->Meshes;
    
    
    
    //MatrixE=&(P->MatFieldE[0]);
    printf("...loading...\n");
    strcpy(filename,savefile);
    strcat(filename,".mg1");
     inp = fopen(filename,"r");
  
         
    /*Make sure if file was opened successfully*/ 
   	if (inp == NULL)  
   	{          
		printf("Error: cannot open the file ");
        	//getchar();
   	}
    
 	else 
	{	fscanf(inp,"dof %i\n",(&dof));
        fscanf(inp,"nx %i\n ",(&nx));
		fscanf(inp,"ny %i\n",(&ny));  
		fscanf(inp,"nz %i\n",(&nz));  
     	fscanf(inp,"lx %lf \n",(&length_x)); 
	    fscanf(inp,"ly %lf \n",(&length_y));  
        fscanf(inp,"lz %lf \n",(&length_z));
	     printf("\n");
          
             GeomWinData->lx=(double) length_x;
	         GeomWinData->ly=(double) length_y;
	         GeomWinData->lz=(double) length_z;
	        
	    
               MeshWinData->MinDof=(int) dof;
              
               num_levels=SolBlock->num_levels;  
               
        P=&(BaseWinData[num_levels-1]);		
		fscanf(inp,"E-modul Matrix:\n");
		if (2==ModelDim) DataLen=((nx-1)*(ny-1)); else DataLen=((nx-1)*(ny-1)*(nz-1));
		
		for (i=0;i<DataLen;i++)
		{
			fscanf(inp,"%lf ",&(SolBlock->Meshes[num_levels-1].MatFieldE[i]));			
		
   			   	
		}
		fclose(inp);
  		//TransMatFieldToCoarse(SolBlock->Meshes, num_levels);
       printf("...File loaded...\n");
       printf("...from %s ...\n",filename);
	}	
	
}

/*------------------------------------------------------------------------------
     BaseWin_Save_Results
------------------------------------------------------------------------------*/
void BaseWin_Save_Results(char *savefile) 
{   
    int nx,ny,i;
    MGBlock *BaseWinData,*P;
    SolveBlock *SolBlock;
    int num_levels,dof;
    int show_level;
    double *U,*Ux,*Uy;
    FILE    *outp ;
    char  filename[30];
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    SolveWinStruct *SolveWinData;
    int ModelDim;
    int DataLen;
    
    ModelDim=PutGetModelDim(1,123);
  
    PutGetAllWinStruct(1, &AllWinData); 
    GeomWinData=AllWinData->GeomWinData;
    MeshWinData=AllWinData->MeshWinData;
    SolveWinData=AllWinData->SolveWinData;
      
    PutGetSolveBlock(1,&SolBlock);
    BaseWinData=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    P=&(BaseWinData[num_levels-1]); 
   
    if(1==SolveWinData->BSplineFlag)
    {
        P=SolBlock->SplineMesh;
        nx=P->nnx;
        ny=P->nny;
        Ux=P->Ux;
        Uy=P->Uy;
        DataLen=nx*ny;                                    
    }
    else
    {
        P=&(BaseWinData[num_levels-1]);
        nx=P->nnx;
        ny=P->nny;
        U=P->U;
        DataLen=nx*ny*2;
    } 
    
    printf("..............Saving....................\n");

     strcpy(filename,savefile);
     strcat(filename,".mg4");
     outp = fopen(filename,"wb");  
    
    /*Make sure if file was opened successfully*/ 
   	if (outp == NULL)  
   	{   
  		printf("Error: cannot open the file ");
   	    //getchar();
   	}
 
 	else 
	{  
       if(1==SolveWinData->BSplineFlag)
       {
           for (i=0;i<DataLen;i++)
		   {
			    fprintf(outp,"%g ",Ux[i]);
  	       }  
           for (i=0;i<DataLen;i++)
		   {
			    fprintf(outp,"%g ",Uy[i]);
  	       }                             
                                       
       }
       else
       {
           for (i=0;i<DataLen;i++)
		   {
			    fprintf(outp,"%g ",U[i]);
  	       }
       }
    fclose(outp);
		
	}
	printf("............File saved.................\n");
	printf("...to %s ...\n",filename);
}
/*------------------------------------------------------------------------------
     BaseWin_Open_Results
------------------------------------------------------------------------------*/
void BaseWin_Open_Results(char *savefile) 
{ double la,lb;
    double lx,ly,lz,length_x,length_y,length_z;
    int nx,ny,nz,i;
    MGBlock *BaseWinData,*P;
    SolveBlock *SolBlock;
    int dof,num_levels;
    int show_level;
    FILE    *inp ;
    char filename[30];
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    SolveWinStruct *SolveWinData;
    int ModelDim;
    int DataLen;
    double *U, *Ux, *Uy;
    
    ModelDim=PutGetModelDim(1,123);
  
    PutGetAllWinStruct(1, &AllWinData); 
    GeomWinData=AllWinData->GeomWinData;
    MeshWinData=AllWinData->MeshWinData;
    SolveWinData=AllWinData->SolveWinData;
      
    PutGetSolveBlock(1,&SolBlock);
    BaseWinData=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
     
    
    if(1==SolveWinData->BSplineFlag)
    {
        P=SolBlock->SplineMesh;
        nx=P->nnx;
        ny=P->nny;
        Ux=P->Ux;
        Uy=P->Uy;
        DataLen=nx*ny;                                    
    }
    else
    {  
        P=&(BaseWinData[num_levels-1]);
        nx=P->nnx;
        ny=P->nny;
        U=P->U;
        DataLen=nx*ny*2;  
    }

    ModelDim=PutGetModelDim(1,123);
   
    //MatrixE=&(P->MatFieldE[0]);
    printf("...loading...\n");
    strcpy(filename,savefile);
    strcat(filename,".mg4");
     inp = fopen(filename,"r");
  
    /*Make sure if file was opened successfully*/ 
   	if (inp == NULL)  
   	{          
		printf("Error: cannot open the file ");
        	//getchar();
   	}
    
 	else 
	{	
        
       if(1==SolveWinData->BSplineFlag)
       {
           for (i=0;i<DataLen;i++)
		   {
			    fscanf(inp,"%lf ",&(Ux[i]));	
  	       }  
           for (i=0;i<DataLen;i++)
		   {
			    fscanf(inp,"%lf ",&(Uy[i]));	
  	       }                             
                                       
       }
       else
       {  
          
		for (i=0;i<DataLen;i++)
		{
			fscanf(inp,"%lf ",&(U[i]));			
		}
       }
        fclose(inp);
        printf("...File loaded...\n");
        printf("...from %s ...\n",filename);
        	
    }	
	
}



/*------------------------------------------------------------------------------
     BaseWin_Save_EModul_Int
------------------------------------------------------------------------------*/
void BaseWin_Save_EModul_Int(char *savefile) 
{    double la,lb,lx,ly,lz;
    int nx,ny,i;
    MGBlock *BaseWinData,*P;
    SolveBlock *SolBlock;
    int num_levels,dof;
    int show_level;
    int *MatrixInt;
    FILE    *outp ;
    char filename[30];
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    int ModelDim;
    int DataLen;
    
    ModelDim=PutGetModelDim(1,123);
  
    PutGetAllWinStruct(1, &AllWinData); 
    GeomWinData=AllWinData->GeomWinData;
    MeshWinData=AllWinData->MeshWinData;
      
    PutGetSolveBlock(1,&SolBlock);
    BaseWinData=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    P=&(BaseWinData[num_levels-1]); 
       
    dof=MeshWinData->MinDof;
    la=P->la;
    lb=P->lb;
    nx=P->nnx;
    ny=P->nny;
    lx=la*((double)nx-1.0);
    ly=lb*((double)ny-1.0);
    lz=1.0;
    MatrixInt=&P->MatFieldInt[0];
     
    printf("..............Saving....................\n");
     strcpy(filename,savefile);
     strcat(filename,".mg2");
     outp = fopen(filename,"wb");  
    
    /*Make sure if file was opened successfully*/ 
   	if (outp == NULL)  
   	{   
  		printf("Error: cannot open the file ");
   	    //getchar();
   	}
 
 	else 
	{   
	    fprintf(outp,"dof %i\n",(dof));
    	fprintf(outp,"nx %i\n",(nx));
		fprintf(outp,"ny %i\n",(ny));
		if (3==ModelDim)
		    fprintf(outp,"nz %i\n",(P->nnz));
		else
		    fprintf(outp,"nz %i\n",0);
	    fprintf(outp,"lx %g  \n",(lx));
	    fprintf(outp,"ly %g  \n",(ly));
	    fprintf(outp,"lz %g  \n",(lz));       
		fprintf(outp,"E-modul Int Matrix:\n");
		
		if (3==ModelDim) 
            DataLen=(nx-1)*(ny-1)*((P->nnz)-1);
        else
            DataLen=(nx-1)*(ny-1);
            
		for (i=0;i<DataLen;i++)
		{   fprintf(outp,"%i ",
			MatrixInt[i]);
						   	
		}
		fclose(outp);
	
	}
	printf("............File saved.................\n");
	printf("...to %s ...\n",filename);
}




/*------------------------------------------------------------------------------
     BaseWin_Open_EModul_Int
------------------------------------------------------------------------------*/
void BaseWin_Open_EModul_Int(char *savefile) 
{ double la,lb;
    double lx,ly,lz,length_x,length_y,length_z;
    int nx,ny,nz,i;
    MGBlock *BaseWinData,*P,*M;
    SolveBlock *SolBlock;
    int num_levels,dof,*MatFieldInt,*obj_matrix;
    int show_level,*MatrixInt;
    int minimum, maximum;
    FILE    *inp ;
    char filename[30];
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    int ModelDim;
    int DataLen;
    MyMainWindowUI *mainwin;
    double tmp;
    
    PutGetMainWindow(1,&(mainwin));
   
    PutGetAllWinStruct(1, &AllWinData); 
    GeomWinData=AllWinData->GeomWinData;
    MeshWinData=AllWinData->MeshWinData;
    
    PutGetSolveBlock(1,&SolBlock);
    BaseWinData=SolBlock->Meshes;
    
    
    printf("...loading...\n");
     strcpy(filename,savefile);
     strcat(filename,".mg2");
     inp = fopen(filename,"r");
  
    printf("\nWhats up\n");
    /*Make sure if file was opened successfully*/ 
   	if (inp == NULL)  
   	{          
		printf("Error: cannot open the file ");
        	//getchar();
   	}
    
 	else 
	{	fscanf(inp,"dof %i\n",(&dof));
        fscanf(inp,"nx %i\n ",(&nx));
		fscanf(inp,"ny %i\n",(&ny));  
		fscanf(inp,"nz %i\n",(&nz));  
     	fscanf(inp,"lx %lf \n",(&length_x)); 
	    fscanf(inp,"ly %lf \n",(&length_y));  
        fscanf(inp,"lz %lf \n",(&length_z));
	     printf("\n");
          
             GeomWinData->lx=(double) length_x;
	         GeomWinData->ly=(double) length_y;
	         GeomWinData->lz=(double) length_z;
	        
	    
               MeshWinData->MinDof=(int) dof;
               //MesherMainLoop();
               
               if (0==nz) ModelDim=2; else ModelDim=3;
               PutGetModelDim(0,ModelDim);
               printf("\nModelDIM:%i\n",ModelDim);
               if (2==ModelDim)
               {
                    mainwin->Choice2d->show();
                    mainwin->Choice3d->hide();
               }
               else
               {
                    mainwin->Choice3d->show(); 
                    mainwin->Choice2d->hide();
               }
               
               if (2==ModelDim) ReadDataFile((nx-1),(ny-1));
               else            MesherMainLoop3d();
               
               //MOVED FROM MySolverMain
               if (0==SolBlock->PreMeshFlag)
               {
                  InitPreMeshes();
               }
               
               
               num_levels=SolBlock->num_levels;  
               
               // after ReadDataFile size of elements and geometry need to be adapted
               tmp=1.0;
               for(i=(num_levels-1); i>=0; i--)
               {
                   M=&SolBlock->Meshes[i];
                   M->la=length_x/(nx-1)*tmp;    
                   M->lb=length_y/(ny-1)*tmp;
                   tmp*=2.0;
               }
               
               
        P=&(BaseWinData[num_levels-1]);
       //obj_matrix=&P->MatFieldInt[0];
               
        MatFieldInt=&SolBlock->Meshes[num_levels-1].MatFieldInt[0];       
       	obj_matrix=& MatFieldInt[0];
       	
		fscanf(inp,"E-modul Int Matrix:\n");
		
        if (2==ModelDim) DataLen=((nx-1)*(ny-1)); else DataLen=((nx-1)*(ny-1)*(nz-1));
        for (i=0;i<DataLen;i++)
		{
			fscanf(inp,"%i ",&obj_matrix[i]);				   	
		}
		fclose(inp);
  	    //TransMatFieldToCoarse(SolBlock->Meshes, num_levels);
       printf("...File loaded...\n");
       printf("...from %s ...\n",filename);
       
       FindMinMax_int(DataLen, MatFieldInt, &minimum, &maximum);
       if(0!=SolBlock->NumMaterials)
       {FreeMaterialBlock(SolBlock->NumMaterials, SolBlock->Material);}
  
       SolBlock->NumMaterials=maximum+1;    
       InitMaterialBlock((SolBlock->NumMaterials), &(SolBlock->Material));
  
       for(i=0; i<(SolBlock->NumMaterials);i++)
       {  
           SolBlock->Material[i].E=12345.0;
           SolBlock->Material[i].Mu=0.200;
       }
       
	}	
}




/*------------------------------------------------------------------------------
     BaseWin_Save Loads
------------------------------------------------------------------------------*/
void BaseWin_Save_Loads(char *savefile) 
{   
    int i;
    //MGBlock *BaseWinData;
    int n,PrimFlag,NumFlag, PhyFlag;
   
    FILE    *outp ;
    char filename[30];
    AllWinStruct *AllWinData;
    LoadWinStruct *LoadWinData;
    OneLoad       *LoadList;
    int ModelDim;
    
    ModelDim=PutGetModelDim(1,123);
   
    PutGetAllWinStruct(1, &AllWinData); 
    LoadWinData=AllWinData->LoadWinData;
    
    if (2==ModelDim) n=LoadWinData->num_loads; else n=LoadWinData->num_loads3d;
    if (2==ModelDim) LoadList=LoadWinData->LoadList; else LoadList=LoadWinData->LoadList3d;
       
    strcpy(filename,savefile);
    strcat(filename,".mg3");
     outp = fopen(filename,"wb");  
    /*Make sure if file was opened successfully*/ 
   	if (outp == NULL)  
   	{   
  		printf("Error: cannot open the file ");
   	    //getchar();
   	}
 
 	else 
	{   
	    
   		fprintf(outp,"\n num_Loads %i \n",n);	
		for (i=0;i<n;i++)
		{
		fprintf(outp,"PrimFlag %i PhyFlag %i NumFlag %i BCVal %g BCPot %g\n",LoadList[i].PrimFlag,
        LoadList[i].PhyFlag,LoadList[i].NumFlag,LoadList[i].BCVal,LoadList[i].BCPot);
		}
        fclose(outp);
        printf("............File saved.................\n");
        printf("...to %s ...\n",filename);
	//	P->MatFieldE=MatrixE;
	}
}
/*------------------------------------------------------------------------------
     BaseWin_Open_Loads
------------------------------------------------------------------------------*/
void BaseWin_Open_Loads(char *savefile) 
{   int i,n,PrimFlag,NumFlag,PhyFlag;
    FILE    *inp ;
    double BCVal;
    double BCPot;
    char filename[30];
    AllWinStruct *AllWinData;
    LoadWinStruct *LoadWinData;
    OneLoad       *LoadList;
    int ModelDim;
        
    ModelDim=PutGetModelDim(1,123);
    
    PutGetAllWinStruct(1, &AllWinData); 
    LoadWinData=AllWinData->LoadWinData;
      
    if (2==ModelDim) n=LoadWinData->num_loads; else n=LoadWinData->num_loads3d;
    if (2==ModelDim) LoadList=LoadWinData->LoadList; else LoadList=LoadWinData->LoadList3d;
    
    //MatrixE=&(P->MatFieldE[0]);
    printf("...loading...\n");
       strcpy(filename,savefile);
       strcat(filename,".mg3");
       inp = fopen(filename,"r");
  
         
    /*Make sure if file was opened successfully*/ 
   	if (inp == NULL)  
   	{          
		printf("Error: cannot open the file ");
        	//getchar();
   	}
    
 	else 
	{	
		fscanf(inp,"\n num_Loads %i \n",&n);
 		if (2==ModelDim) LoadWinData->num_loads=n; else LoadWinData->num_loads3d=n;
		for (i=0;i<n;i++)
		{
		fscanf(inp,"PrimFlag %i PhyFlag %i NumFlag %i BCVal %lf BCPot %lf \n",
           &PrimFlag,&PhyFlag,&NumFlag,&BCVal,&BCPot);
        LoadList[i].PrimFlag=(int) PrimFlag;
        LoadList[i].PhyFlag=(int) PhyFlag;
        LoadList[i].NumFlag=(int) NumFlag;
        LoadList[i].BCVal=(double) BCVal;
        LoadList[i].BCPot=(double) BCPot;
		}
		fclose(inp); 		
       printf("...File loaded...\n");
       printf("...from %s ...\n",filename);
	}	
}


/*------------------------------------------------------------------------------
     OpenFileBaseWin
------------------------------------------------------------------------------*/
void OpenFileBaseWin()
{
    MyFileBaseWindowUI* basewin;
    
    PutGetBaseFileWindow(1, &basewin);
    basewin->m_window->set_modal();
    basewin->m_window->show();  

    Fl::check();
}









