/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

void StartGameOfLife()
{
    int i,j,k,iii, I,J,K, KK,count;
    int nex,ney, num_levels;
    SolveBlock *SolBlock;
    MGBlock *Meshes, *M;
    int *F, *G;
    double X;
    
    PutGetSolveBlock(1,&SolBlock); 
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    M=&(Meshes[num_levels-1]);
    
    nex=M->nex;
    ney=M->ney;
    
    F=M->MatFieldInt;
    G=M->BcTypeY;
    
    SetVectorToZero_int(nex*ney, F);
    SetVectorToZero_int(nex*ney, G);
    
    for(i=0; i<nex; i++)
    for(j=0; j<ney; j++)
    {
        X=rand()/(RAND_MAX+1.0);
        if (X>0.9) F[i+j*nex]=1; else F[i+j*nex]=0;
    }
    
    K=0;KK=0;
    for(k=0; k<100000; k++)
    {
        
        k=1;K++; 
        if (K>999) 
        {
            KK+=K; K=0;
            printf("G:%i\n",KK);
        }
        for(i=0; i<nex; i++)
        for(j=0; j<ney; j++)
        {
            count=0;
            
            I=i-1; if(I<0) I=nex-1; 
            J=j-1; if(J<0) J=ney-1;
            if (1==F[I+J*nex]) count++;
            
            I=i;
            J=j-1; if(J<0) J=ney-1;
            if (1==F[I+J*nex]) count++;
            
            I=i+1; if(I==nex) I=0; 
            J=j-1; if(J<0) J=ney-1;
            if (1==F[I+J*nex]) count++;
            
            I=i-1; if(I<0) I=nex-1; 
            J=j;
            if (1==F[I+J*nex]) count++;
                       
            I=i+1; if(I==nex) I=0; 
            J=j;
            if (1==F[I+J*nex]) count++;
            
            I=i-1; if(I<0) I=nex-1; 
            J=j+1; if(J==ney) J=0;
            if (1==F[I+J*nex]) count++;
            
            I=i;
            J=j+1; if(J==ney) J=0;
            if (1==F[I+J*nex]) count++;
            
            I=i+1; if(I==nex) I=0; 
            J=j+1; if(J==ney) J=0;
            if (1==F[I+J*nex]) count++;
            
            I=i;
            J=j;  
            if (0==F[I+J*nex] && 3==count) G[I+J*nex]=1;
            else
            {
               if (1<count && count<4) G[I+J*nex]=1;
            }
        }
        
        memcpy(F,G,nex*ney*sizeof(int));
        SetVectorToZero_int(nex*ney, G);                
                                                        
        iii=MyControl();
        if (1==iii) return;
    
    }
    return;
}

/*---------------------------------------------------------
	MapSxxInclusion()
----------------------------------------------------------*/
void MapSxxInclusion(int type)
{
    int i,j;
    int nex,ney,nnx,nny,num_levels;
    SolveBlock *SolBlock;
    MGBlock *Meshes, *M;
    double la,lb;
    double x,y;
    double *Ux;
    double srr,srt,stt,sxx;
    double theta,r;
    
    PutGetSolveBlock(1,&SolBlock); 
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    M=&(Meshes[num_levels-1]);
    
    nex=M->nex;nnx=nex+1;
    ney=M->ney;nny=ney+1;
    
    la=M->la;
    lb=M->lb;
    
    Ux=M->Ux;
    
    for(i=0; i<nnx; i++)
    for(j=0; j<nny; j++)
    {
        x=(i-nex/2)*la+1E-30;
        y=(j-ney/2)*lb+1E-30;
        
        r=sqrt(x*x+y*y);
        theta = atan((double) (fabs(y) / fabs(x)));
                        
        if (r<4.0)
        {
            srr = 0.6250000000e1 + 0.5882352940e1 * cos((double) (2 * theta));
            stt = 0.6250000000e1 - 0.5882352940e1 * cos((double) (2 * theta));
            srt = -0.5882352940e1 * sin((double) (2 * theta));
            sxx = srr * pow(cos(theta), 0.2e1) 
                + stt * pow(sin(theta), 0.2e1) 
                - 0.2e1 * srt * sin(theta) * cos(theta);
            
            
        }
        else
        {
            srr=0.5e1 + 0.2000000000e2 * pow(r, -0.2e1) + 0.5e1 * (0.1e1 + 0.1129411764e2 * pow(r, -0.2e1) - 0.1355294117e3 * pow(r, -0.4e1)) * cos((double) (2 * theta));
            stt= 0.5e1 - 0.2000000000e2 * pow(r, -0.2e1) - 0.5e1 * (0.1e1 - 0.1355294117e3 * pow(r, -0.4e1)) * cos((double) (2 * theta));
            srt= -0.5e1 * (0.1e1 - 0.5647058822e1 * pow(r, -0.2e1) + 0.1355294117e3 * pow(r, -0.4e1)) * sin((double) (2 * theta));
            sxx = srr * pow(cos(theta), 0.2e1) 
                + stt * pow(sin(theta), 0.2e1) 
                - 0.2e1 * srt * sin(theta) * cos(theta);
        }
        
        if (0==type)
        //sxx = srr * pow(cos(theta), 0.2e1) 
        //        + stt * pow(sin(theta), 0.2e1) 
        //        - 0.2e1 * srt * sin(theta) * cos(theta);
        sxx=0.5*(srr+stt)+0.5*(srr-stt)*cos(-2.0*theta)+srt*sin(-2.0*theta);
       
        
        if (1==type)
        //sxx = srr * pow(sin(theta), 0.2e1) + 
        //      stt * pow(cos(theta), 0.2e1) + 
        //      srt * sin(0.2e1 * theta);
        sxx=0.5*(srr+stt)-0.5*(srr-stt)*cos(-2.0*theta)-srt*sin(-2.0*theta);

        if (2==type)
        sxx=-0.5*(srr-stt)*sin(-2.0*theta)+srt*cos(-2.0*theta);        
        
        Ux[i+j*nnx]=sxx;         
    }
    
    return;
}
