/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include <FL/gl.h>
#include <GL/glu.h>
#include <FL/glut.h>
#include <FL/Fl_Gl_Window.H>

#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define frand() ((double) rand()/(RAND_MAX+1.0))

/*-----------------------------------------------------------------------------
	CreateColorPalette_32
------------------------------------------------------------------------------*/

int CreateColorPalette_32(ColorPalette *c)
{
    static float r[32], g[32], b[32];

    c->NumColor=32;
    c->r=r;
    c->g=g;
    c->b=b;

    r[31]=1.0;   g[31]=0.0;   b[31]=0.0;
    r[30]=1.0;   g[30]=0.2;   b[30]=0.0;
    r[29]=1.0;   g[29]=0.447; b[29]=0.0;
    r[28]=1.0;   g[28]=0.596; b[28]=0.0;
    r[27]=1.0;   g[27]=0.749; b[27]=0.0;
    r[26]=1.0;   g[26]=0.898; b[26]=0.0;
    r[25]=0.949; g[25]=1.0;   b[25]=0.0;
    r[24]=0.8;   g[24]=1.0;   b[24]=0.0;
    r[23]=0.647; g[23]=1.0;   b[23]=0.0;
    r[22]=0.498; g[22]=1.0;   b[22]=0.0;
    r[21]=0.349; g[21]=1.0;   b[21]=0.0;
    r[20]=0.2;   g[20]=1.0;   b[20]=0.0;
    r[19]=0.047; g[19]=1.0;   b[19]=0.0;
    r[18]=0.0;   g[18]=1.0;   b[18]=0.098;
    r[17]=0.0;   g[17]=1.0;   b[17]=0.247;
    r[16]=0.0;   g[16]=1.0;   b[16]=0.4;
    r[15]=0.0;   g[15]=1.0;   b[15]=0.549;
    r[14]=0.0;   g[14]=1.0;   b[14]=0.698;
    r[13]=0.0;   g[13]=1.0;   b[13]=0.847;
    r[12]=0.0;   g[12]=1.0;   b[12]=1.0;
    r[11]=0.0;   g[11]=1.0;   b[11]=1.0;
    r[10]=0.0;   g[10]=0.847; b[10]=1.0;
    r[9]=0.0;    g[9]=0.698;  b[9]=1.0;
    r[8]=0.0;    g[8]=0.549;  b[8]=1.0;
    r[7]=0.0;    g[7]=0.4;    b[7]=1.0;
    r[6]=0.0;    g[6]=0.247;  b[6]=1.0;
    r[5]=0.0;    g[5]=0.098;  b[5]=1.0;
    r[4]=0.047;  g[4]=0;      b[4]=1.0;
    r[3]=0.2;    g[3]=0;      b[3]=1.0;
    r[2]=0.349;  g[2]=0;      b[2]=1.0;
    r[1]=0.498;  g[1]=0;      b[1]=1.0;
    r[0]=0.647;  g[0]=0;      b[0]=1.0;
    
    return(1);
}


/*-----------------------------------------------------------------------------
	CreateColorPalette_bw32
------------------------------------------------------------------------------*/

int CreateColorPalette_bw32(ColorPalette *c)
{
    static float r[32], g[32], b[32];

    c->NumColor=32;
    c->r=r;
    c->g=g;
    c->b=b;
     
    int i;

    for(i=0; i<32; i++)
    {
    r[i]=(float) 1.0-(float)i/31.0;
    g[i]=(float) 1.0-(float)i/31.0;
    b[i]=(float) 1.0-(float)i/31.0;
    }

    return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette_bw256
------------------------------------------------------------------------------*/


int CreateColorPalette_bw256(ColorPalette *c)
{
    static float r[256], g[256], b[256];

    c->NumColor=256;
    c->r=r;
    c->g=g;
    c->b=b;
     
    int i;

    for(i=0; i<256; i++)
    {
    r[i]=(float) i/255;
    g[i]=(float) i/255;
    b[i]=(float) i/255;
    }

    return(1);
}


/*-----------------------------------------------------------------------------
	CreateColorPalette_9
------------------------------------------------------------------------------*/

int CreateColorPalette_9(ColorPalette *c)
{
    static float r[9], g[9], b[9];

    c->NumColor=9;
    c->r=r;
    c->g=g;
    c->b=b;
     
    r[8]=1.0;    g[8]=0.0;    b[8]=0.0;
    r[7]=1.0;    g[7]=0.698;  b[7]=0.0;
    r[6]=1.0;    g[6]=1.0;    b[6]=0.0;
    r[5]=0.706;  g[5]=1.0;    b[5]=0.0;
    r[4]=0.0;    g[4]=1.0;    b[4]=0.0;
    r[3]=0.0;    g[3]=1.0;    b[3]=0.706;
    r[2]=0.0;    g[2]=1.0;    b[2]=1.0;
    r[1]=0.0;    g[1]=0.698;  b[1]=1.0;
    r[0]=0.0;    g[0]=0.0;    b[0]=1.0;
    return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette7
------------------------------------------------------------------------------*/
int CreateColorPalette7(ColorPalette *c)
{
int i,j; 
float up,down;
float v,zero,one;
float up2,up3;

float r[6000], g[6000], b[6000];
static float red[6000], green[6000], blue[6000];

    c->NumColor=6000;
    c->r=red;
    c->g=green;
    c->b=blue;
     

for(i = 0;i < 1000;i++)
{
   up=    i/999.00;
   down=1.0-up;
   
     
   r[i]=1.0;            g[i]=up*0.5;           b[i]=0.0;
   r[i+1000]=1.0;       g[i+1000]=up*0.5+0.5;  b[i+1000]=0.0;
   r[i+2000]=down;      g[i+2000]=1.0;         b[i+2000]=0.0;
   r[i+3000]=0.0;       g[i+3000]=1.0;         b[i+3000]=up;
   r[i+4000]=0.0;       g[i+4000]=down;        b[i+4000]=1.0;
   r[i+5000]=up*0.647;  g[i+5000]= 0.0;        b[i+5000]=1.0;

}


for(i = 0;i < 6000;i++)
{
    red[i]=r[5999-i];         green[i]=g[5999-i];        blue[i]=b[5999-i];
}


/*
for(j = 50;j < 1002;j=j+200)
{
 
	for(i = j;i < j+100; i++)
	{
      
	  up=    i/1000.00;
      down=1.000-up;
	  
	  v=sin((i-j)/6.367/5.00);
	  v=pow(v,10.0);
	  up  =up+(1.0-up)*v;
      down=down+(1.0-down)*v;
	  zero=v;
	  one=1.0;	
	  
	  up2  =0.5*up;
      up3  =0.5*up+0.5;
	  
	  up2  =up2+(1.0-up2)*v;
      up3  =up3+(1.0-up3)*v;
      
	  r[i+1]   =one;	  g[i+1]   =  up2;	 b[i+1]   =zero;
      r[i+1001]=one;      g[i+1001]=  up3;	 b[i+1001]=zero;
      r[i+2001]=down; 	  g[i+2001]= one;	 b[i+2001]=zero;
      r[i+3001]=zero;	  g[i+3001]= one;	 b[i+3001]=up;
      r[i+4001]=zero; 	  g[i+4001]=down;	 b[i+4001]=one;
      r[i+5001]=up*0.647; g[i+5001]=zero;    b[i+5001]=one;
	  
	} 
}
*/

for(i = 0;i < 6000;i++)
{
    red[i]=r[5999-i];         green[i]=g[5999-i];        blue[i]=b[5999-i];
}


return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette7b
------------------------------------------------------------------------------*/
int CreateColorPalette7b(ColorPalette *c)
{
int i,j; 
float up,down;
float v,zero,one;
float up2,up3;

float r[6000], g[6000], b[6000];
static float red[6000], green[6000], blue[6000];

    c->NumColor=6000;
    c->r=red;
    c->g=green;
    c->b=blue;
     

for(i = 0;i < 1000;i++)
{
   up=    i/999.00;
   down=1.0-up;
   
     
   r[i]=1.0;            g[i]=up*0.5;           b[i]=0.0;
   r[i+1000]=1.0;       g[i+1000]=up*0.5+0.5;  b[i+1000]=0.0;
   r[i+2000]=down;      g[i+2000]=1.0;         b[i+2000]=0.0;
   r[i+3000]=0.0;       g[i+3000]=1.0;         b[i+3000]=up;
   r[i+4000]=0.0;       g[i+4000]=down;        b[i+4000]=1.0;
   r[i+5000]=up*0.647;  g[i+5000]= 0.0;        b[i+5000]=1.0;

}


for(i = 0;i < 6000;i++)
{
    red[i]=r[5999-i];         green[i]=g[5999-i];        blue[i]=b[5999-i];
}


for(j = 50;j < 1002;j=j+200)
{
 
	for(i = j;i < j+100; i++)
	{
      
	  up=    i/1000.00;
      down=1.000-up;
	  
	  v=sin((i-j)/6.367/5.00);
	  v=pow(v,10.0);
	  up  =up+(1.0-up)*v;
      down=down+(1.0-down)*v;
	  zero=v;
	  one=1.0;	
	  
	  up2  =0.5*up;
      up3  =0.5*up+0.5;
	  
	  up2  =up2+(1.0-up2)*v;
      up3  =up3+(1.0-up3)*v;
      
	  r[i+1]   =one;	  g[i+1]   =  up2;	 b[i+1]   =zero;
      r[i+1001]=one;      g[i+1001]=  up3;	 b[i+1001]=zero;
      r[i+2001]=down; 	  g[i+2001]= one;	 b[i+2001]=zero;
      r[i+3001]=zero;	  g[i+3001]= one;	 b[i+3001]=up;
      r[i+4001]=zero; 	  g[i+4001]=down;	 b[i+4001]=one;
      r[i+5001]=up*0.647; g[i+5001]=zero;    b[i+5001]=one;
	  
	} 
}


for(i = 0;i < 6000;i++)
{
    red[i]=r[5999-i];         green[i]=g[5999-i];        blue[i]=b[5999-i];
}


return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette_Pantone8
------------------------------------------------------------------------------*/

int CreateColorPalette_Pantone8(ColorPalette *c)
{
    static float r[8], g[8], b[8];

    c->NumColor=8;
    c->r=r;
    c->g=g;
    c->b=b;
     
    r[7]=0.906;  g[7]=0.0;    b[7]=0.259;
    r[6]=0.937;  g[6]=0.235;  b[6]=0.094;
    r[5]=1.0;    g[5]=0.510;  b[5]=0.161;
    r[4]=1.0;    g[4]=0.765;  b[4]=0.063;
    r[3]=0.259;  g[3]=0.620;  b[3]=0.161;
    r[2]=0.0;    g[2]=0.427;  b[2]=0.420;
    r[1]=0.0;    g[1]=0.271;  b[1]=0.388;
    r[0]=0.0;    g[0]=0.271;  b[0]=0.549;
    return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette_PantoneSmooth
------------------------------------------------------------------------------*/

int CreateColorPalette_PantoneSmooth(ColorPalette *c)
{
    static float r[7001], g[7001], b[7001];
    int i,j;
    c->NumColor=7001;
    c->r=r;
    c->g=g;
    c->b=b;
     
    r[7000]=0.906;  g[7000]=0.0;    b[7000]=0.259;
    r[6000]=0.937;  g[6000]=0.235;  b[6000]=0.094;
    r[5000]=1.0;    g[5000]=0.510;  b[5000]=0.161;
    r[4000]=1.0;    g[4000]=0.765;  b[4000]=0.063;
    r[3000]=0.259;  g[3000]=0.620;  b[3000]=0.161;
    r[2000]=0.0;    g[2000]=0.427;  b[2000]=0.420;
    r[1000]=0.0;    g[1000]=0.271;  b[1000]=0.388;
    r[0]=0.0;       g[0]=0.271;  b[0]=0.549;
    
    for(j=0; j<7; j++)
    {
        for(i=0; i<=1000; i++)
        {
            r[i+j*1000]=r[j*1000]*(1.0-i/1000.0)+r[(j+1)*1000]*(i/1000.0);
            g[i+j*1000]=g[j*1000]*(1.0-i/1000.0)+g[(j+1)*1000]*(i/1000.0);
            b[i+j*1000]=b[j*1000]*(1.0-i/1000.0)+b[(j+1)*1000]*(i/1000.0);
        }
    }
    return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette_BlueRed
------------------------------------------------------------------------------*/
int CreateColorPalette_BlueRed(ColorPalette *c)
{
    static float r[256], g[256], b[256];

    c->NumColor=256;
    c->r=r;
    c->g=g;
    c->b=b;
     
    int i;

    for(i=0; i<128; i++)
    {
    r[i]=(float) (i)/127.0;
    g[i]=(float) (i)/127.0;
    b[i]= 1.0;
    r[255-i]=(float) 1.0;
    g[255-i]=(float)  (i)/127.0;
    b[255-i]=(float)  (i)/127.0;
    }
    

    return(1);
}

/*-----------------------------------------------------------------------------
	CreateColorPalette_RedGreenBlue
------------------------------------------------------------------------------*/
int CreateColorPalette_RedGreenBlue(ColorPalette *c)
{
    static float r[3], g[3], b[3];

    c->NumColor=3;
    c->r=r;
    c->g=g;
    c->b=b;
    

    r[2]=1.0;    g[2]=0.0;  b[2]=0.0;
    r[1]=0.0;    g[1]=1.0;  b[1]=0.0;
    r[0]=0.0;    g[0]=0.0;  b[0]=1.0;
    

    return(1);
}



