/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
/* 
LINUX VERSION ONLY WITH #include <GL/glut.h> !!!
Windows VERSION AT HOME ONLY WITH #include <FL/glut.h> !!!
*/

//22.06??
#include <FL/gl.h>
#include <GL/glu.h>
#include <FL/glut.h>
#include <FL/Fl_Gl_Window.H>

#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define frand() ((double) rand()/(RAND_MAX+1.0))

/*------------------------------------------------------------------------------
     InitGraphicBlock
------------------------------------------------------------------------------*/
void InitGraphicBlock( ) 
{
     static GraphicBlock localblock ;
     static GraphicBlock *loc_ptr;
     static GraphicBlock **loc_dptr;
     
     loc_ptr=&localblock;
     loc_dptr=&loc_ptr;
     
     loc_ptr->Zoomfactor=(float)1.0;
     loc_ptr->ExtrudeZ=(float)0.0;
     loc_ptr->RotateAngleZ=(float)0.0;
     loc_ptr->RotateAngleX=(float)0.0;
     loc_ptr->UpdateFlag=1;
     loc_ptr->PostSmoothFlag=1;
     strcpy(loc_ptr->SelectObject, "Nothing") ;
     loc_ptr->NewObjectFlag=1;
     loc_ptr->transX=0.0;
     loc_ptr->transX=0.0;
     loc_ptr->ShowValues=0;
     
     loc_ptr->ShowValues=0;
     loc_ptr->ShowValues=0;
     loc_ptr->DrawPatchFlag=1;
     loc_ptr->DrawBCFlag=0;
     loc_ptr->DrawNodeFlag=0;
     loc_ptr->DrawGridFlag=0;
     loc_ptr->DrawFrameFlag=0;
     loc_ptr->LineThickness=2.0;
     loc_ptr->NodeSize=10.0;
     loc_ptr->Extrude=0.0;
     
     loc_ptr->BmpDataFlag=0;
     loc_ptr->BmpScreenFlag=0;
     
     loc_ptr->RotateFlag=0;
     loc_ptr->RotateCoor=0;
          
     CreateColorPalette_32(&(loc_ptr->CurrentPalette[0]));
     loc_ptr->num_palette=1;
     loc_ptr->act_palette=0;
     
     CreateColorPalette_bw32(&(loc_ptr->CurrentPalette[1]));
     loc_ptr->num_palette=2;
     loc_ptr->act_palette=0;
     
     CreateColorPalette_bw256(&(loc_ptr->CurrentPalette[2]));
     loc_ptr->num_palette=3;
     loc_ptr->act_palette=0;
     
     CreateColorPalette_9(&(loc_ptr->CurrentPalette[3]));
     loc_ptr->num_palette=4;
     loc_ptr->act_palette=0;
     
     CreateColorPalette7(&(loc_ptr->CurrentPalette[4]));
     loc_ptr->num_palette=5;
     loc_ptr->act_palette=0;
     
     CreateColorPalette7b(&(loc_ptr->CurrentPalette[5]));
     loc_ptr->num_palette=6;
     loc_ptr->act_palette=0;
     
     CreateColorPalette_Pantone8(&(loc_ptr->CurrentPalette[6]));
     loc_ptr->num_palette=7;
     loc_ptr->act_palette=0;
     
     CreateColorPalette_PantoneSmooth(&(loc_ptr->CurrentPalette[7]));
     loc_ptr->num_palette=8;
     loc_ptr->act_palette=0;
 
     CreateColorPalette_BlueRed(&(loc_ptr->CurrentPalette[8]));
     loc_ptr->num_palette=9;
     loc_ptr->act_palette=0;    
     
     CreateColorPalette_RedGreenBlue(&(loc_ptr->CurrentPalette[9]));
     loc_ptr->num_palette=10;
     loc_ptr->act_palette=0;  
                         
     PutGetGraphicBlock(0, loc_dptr);
     //printf("INITBLOCK %p, %p\n",&localblock, loc_ptr);
}

    

/*------------------------------------------------------------------------------
     PrintGraphicBlock
------------------------------------------------------------------------------*/
void PrintGraphicBlock( ) 
{
     GraphicBlock *localblock;
     
     PutGetGraphicBlock(1, &localblock);
     printf("--------------\n"); 
     printf("Zoomfactor:   %g\n", localblock->Zoomfactor);
     printf("RotateAngleX:  %g\n", localblock->RotateAngleX);
     printf("RotateAngleZ:  %g\n", localblock->RotateAngleZ);
     printf("ExtrudeZ:  %g\n",     localblock->ExtrudeZ);
     printf("UpdateFlag:   %i\n", localblock->UpdateFlag);
     printf("SelectObject: %s\n", localblock->SelectObject);
     printf("RunFlag:      %i\n", localblock->RunFlag);
     printf("IsoLines:      %i\n", localblock->IsoLines);
     //printf("SelectObject %i\n", localblock->SelectObject);
}
/*------------------------------------------------------------------------------
     ChangeZoomFactor
------------------------------------------------------------------------------*/
void ChangeGraphic_Zoomfactor(float f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->Zoomfactor=f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeRotateAngleX
------------------------------------------------------------------------------*/
void ChangeGraphic_RotateAngleX(float f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->RotateAngleX=f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}
/*------------------------------------------------------------------------------
     ChangeRotateAngleZ
------------------------------------------------------------------------------*/
void ChangeGraphic_RotateAngleZ(float f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->RotateAngleZ=f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeExtrudeZ (Multiplication)
------------------------------------------------------------------------------*/
void ChangeGraphic_ExtrudeZ(float f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->ExtrudeZ=f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeExtrude (Addition)
------------------------------------------------------------------------------*/
void ChangeGraphic_Extrude(float f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->Extrude=f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_Deflect
------------------------------------------------------------------------------*/
void ChangeGraphic_Deflect(float f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->Deflect=f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_Frames
------------------------------------------------------------------------------*/
void ChangeGraphic_Frames(int i) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->Frames=i;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_UpdateFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_UpdateFlag(int i) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->UpdateFlag=i;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_ShowValues
------------------------------------------------------------------------------*/
void ChangeGraphic_ShowValues(int i) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->ShowValues=i;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}


/*------------------------------------------------------------------------------
     ChangeGraphic_PostSmoothFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_PostSmoothFlag(int i) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->PostSmoothFlag=i;
    localblock->NewObjectFlag=1; 
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_SelectObject
------------------------------------------------------------------------------*/
void ChangeGraphic_SelectObject(void *ObjectName) 
{
    GraphicBlock *localblock;
   
    PutGetGraphicBlock(1, &localblock);
    strcpy(localblock->SelectObject, (char*) ObjectName) ;
    printf("SelectObject: %s\n", localblock->SelectObject);
    //if(0==strcmp("Test-Sample",z)) printf("okay");
    localblock->NewObjectFlag=1;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_transX
------------------------------------------------------------------------------*/
void ChangeGraphic_transX(double d) 
{
    GraphicBlock *localblock;
   
    PutGetGraphicBlock(1, &localblock);
    localblock->transX=d;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_transY
------------------------------------------------------------------------------*/
void ChangeGraphic_transY(double d) 
{
    GraphicBlock *localblock;
   
    PutGetGraphicBlock(1, &localblock);
    localblock->transY=d;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_NodeSize
------------------------------------------------------------------------------*/
void ChangeGraphic_NodeSize(double d) 
{
    GraphicBlock *localblock;
   
    PutGetGraphicBlock(1, &localblock);
    localblock->NodeSize=d;
    UpdateGraphicWindow();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_LineThickness
------------------------------------------------------------------------------*/
void ChangeGraphic_LineThickness(double d) 
{
    GraphicBlock *localblock;
   
    PutGetGraphicBlock(1, &localblock);
    localblock->LineThickness=d;
    UpdateGraphicWindow();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_ActPalette
------------------------------------------------------------------------------*/
void ChangeGraphic_ActPalette(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->act_palette=(int) f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_ShowLevel
------------------------------------------------------------------------------*/
void ChangeGraphic_ShowLevel(int f) 
{
    GraphicBlock *localblock;
    MyMainWindowUI   *mainwin;
    
    PutGetGraphicBlock(1, &localblock);
    PutGetMainWindow(1, &mainwin);
    localblock->show_level=(int) f;
    localblock->detail_level=(int) f;
    mainwin->Detail->maximum((int)(localblock->show_level));
    mainwin->Detail->value((int)(localblock->show_level));
    UpdateSectionSliders();
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_DetailLevel
------------------------------------------------------------------------------*/
void ChangeGraphic_DetailLevel(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->detail_level=(int) f;
    UpdateSectionSliders();
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_RunFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_RunFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->RunFlag=(int) f;
    //PrintGraphicBlock();
    return;
}

/*------------------------------------------------------------------------------
     ChangeGraphic_DrawGridFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_DrawGridFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->DrawGridFlag=(int) f;
    UpdateGraphicWindow();
    //PrintGraphicBlock();
    return;
}

/*------------------------------------------------------------------------------
     ChangeGraphic_DrawFrameFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_DrawFrameFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->DrawFrameFlag=(int) f;
    UpdateGraphicWindow();
    //PrintGraphicBlock();
    return;
}
/*------------------------------------------------------------------------------
     ChangeGraphic_DrawBCFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_DrawBCFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->DrawBCFlag=(int) f;
    UpdateGraphicWindow();
    //PrintGraphicBlock();
    return;
}

/*------------------------------------------------------------------------------
     ChangeGraphic_DrawNodeFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_DrawNodeFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->DrawNodeFlag=(int) f;
    UpdateGraphicWindow();
    //PrintGraphicBlock();
    return;
}

/*------------------------------------------------------------------------------
     ChangeGraphic_DrawPatchFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_DrawPatchFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->DrawPatchFlag=(int) f;
    UpdateGraphicWindow();
    //PrintGraphicBlock();
    return;
}


/*------------------------------------------------------------------------------
     ChangeGraphic_PostSaveStep
------------------------------------------------------------------------------*/
void ChangeGraphic_PostSaveStep(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->PostSaveStep=(int) f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_SmoothNum
------------------------------------------------------------------------------*/
void ChangeGraphic_SmoothNum(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->SmoothNum=(int) f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}    

/*------------------------------------------------------------------------------
     ChangeGraphic_IsoLines
------------------------------------------------------------------------------*/
void ChangeGraphic_IsoLines(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->IsoLines=(int) f;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}   

/*------------------------------------------------------------------------------
     ChangeGraphic_RotateFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_RotateFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->RotateFlag=(int) f;
    if (0==f) RemoveIdleCallback();
    if (1==f) {localblock->RotateCoor=0 ;AddIdleCallback();}
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_ShowroomFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_ShowroomFlag(int f) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    if (0==f) RemoveIdleCallback2();
    if (1==f) AddIdleCallback2();
    UpdateGraphicWindow();
    PrintGraphicBlock();
}


/*------------------------------------------------------------------------------
     ChangeGraphic_BmpDataFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_BmpDataFlag() 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->BmpDataFlag=(int) 1;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_BmpScreenFlag
------------------------------------------------------------------------------*/
void ChangeGraphic_BmpScreenFlag() 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->BmpScreenFlag=(int) 1;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_BmpDataSeqFlag
------------------------------------------------------------------------------*/

void ChangeGraphic_BmpDataSeqFlag(int i) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    if (1==i) localblock->BmpDataFlag=(int) 2;
    else localblock->BmpDataFlag=(int) 0;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}
/*------------------------------------------------------------------------------
     ChangeGraphic_BmpScreenSeqFlag
------------------------------------------------------------------------------*/

void ChangeGraphic_BmpScreenSeqFlag(int i) 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    if (1==i) localblock->BmpScreenFlag=(int) 2;
    else localblock->BmpScreenFlag=(int) 0;
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_ResetView
------------------------------------------------------------------------------*/

void ChangeGraphic_ResetView() 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->RotateAngleX=0.0;
    localblock->RotateAngleZ=0.0;
    localblock->Zoomfactor=1.0; 
    UpdateGraphicWindow();
    PrintGraphicBlock();
}

/*------------------------------------------------------------------------------
     ChangeGraphic_IsoView
------------------------------------------------------------------------------*/

void ChangeGraphic_IsoView() 
{
    GraphicBlock *localblock;
    PutGetGraphicBlock(1, &localblock);
    localblock->RotateAngleX=114.0;
    localblock->RotateAngleZ=-122.0;
    localblock->Zoomfactor=1.0; 
    UpdateGraphicWindow();
    PrintGraphicBlock();
}


/*------------------------------------------------------------------------------
     UpdateSectionSliders
------------------------------------------------------------------------------*/
void UpdateSectionSliders(void)
{
    int level;
    int valx, valy;
    
    MGBlock *M;
    MyMainWindowUI *mainwin;
    SolveBlock *SolBlock;
    
    PutGetMainWindow(1, &mainwin);
    PutGetSolveBlock(1,&SolBlock);
    
    level = (int)(mainwin->Detail->value());
    
    M=&(SolBlock->Meshes[level]);
    
    if ((M->nex)%2 == 0) valx=(M->nex)/2;
    else valx=0;
    
    if ((M->ney)%2 == 0) valy=(M->ney)/2;
    else valy=0;
    
    mainwin->x_section->value(valx);
    mainwin->y_section->value(valy);
    
    mainwin->x_section->maximum(M->nex);
    mainwin->y_section->maximum(M->ney);
}

/*------------------------------------------------------------------------------
     cb_DrawFinerSplines
------------------------------------------------------------------------------*/
void cb_DrawFinerSplines(void)
{
    int Factor, num_levels;
    int Spnex, Spney;
    double lx, ly;
    
    AllWinStruct *AllWinData;
    SolveWinStruct *SolveWinData;
    MGBlock *NormalMesh, *FinerSplineMesh; 
    MyMainWindowUI *mainwin;
    SolveBlock *SolBlock;
    
    PutGetAllWinStruct(1, &AllWinData); 
    PutGetMainWindow(1, &mainwin);
    PutGetSolveBlock(1,&SolBlock);
    
    SolveWinData=AllWinData->SolveWinData;
    num_levels=SolBlock->num_levels;
    NormalMesh=&(SolBlock->Meshes[num_levels-1]);
    
    if (0 == SolveWinData->BSplineFlag) 
    {
       mainwin->FinerSplines->value(0);
       return;
    }   
    else
    {
       if (1 == ((int)mainwin->FinerSplines->value()))
       {
           Factor = (int)mainwin->Factor->value();
           SolBlock->FinerSpMeshFactor = Factor;
           
           if (1 == SolBlock->FinerSpMeshDefined) 
           {
               FinerSplineMesh = SolBlock->FinerSplineMesh;
               FreeMGBlock(FinerSplineMesh);
           }
           else
           {
               InitMGData (&FinerSplineMesh, 1);
               SolBlock->FinerSplineMesh = FinerSplineMesh;
           }
           
           Spnex=(NormalMesh->nex)* Factor;
           Spney=(NormalMesh->ney)* Factor;
   
           lx=AllWinData->GeomWinData->lx;
           ly=AllWinData->GeomWinData->ly;
           
           InitMGBlock(lx, ly, Spnex, Spney, FinerSplineMesh);
           SolBlock->FinerSplineFlag = 1;
       }
       else
       {
           if (1 == SolBlock->FinerSplineFlag) FreeMGBlock(SolBlock->FinerSplineMesh);
           SolBlock->FinerSplineFlag = 0;
       }
       PostMainLoop();
       UpdateGraphicWindow();
    }
    
}    
