/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <stdio.h>
#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetAboutInputWindow
------------------------------------------------------------------------------*/
void PutGetAboutInputWindow(int choice, MyInputAboutWindowUI **inblock) 
{
     static MyInputAboutWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


/*------------------------------------------------------------------------------
     AboutWin_callback
------------------------------------------------------------------------------*/
void AboutWin_callback() {
  MyInputAboutWindowUI *aboutwin;
  PutGetAboutInputWindow(1, &aboutwin);
  aboutwin->m_window->hide();
  
}

/*------------------------------------------------------------------------------
     AboutWin_cb_OK
------------------------------------------------------------------------------*/
void AboutWin_cb_OK() {
  MyMainWindowUI   *mainwin;
  MyInputAboutWindowUI *aboutwin;
 
  PutGetAboutInputWindow(1, &aboutwin);
  
  aboutwin->m_window->hide(); 
}

/*------------------------------------------------------------------------------
     OpenInputAboutWin
------------------------------------------------------------------------------*/
void OpenInputAboutWin()
{
    MyInputAboutWindowUI* aboutwin;
    
    PutGetAboutInputWindow(1, &aboutwin);
    
    aboutwin->m_window->set_modal();
    aboutwin->m_window->show();  

    Fl::check();
}




