/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <stdio.h>
#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetGeomInputWindow
------------------------------------------------------------------------------*/
void PutGetGeomInputWindow(int choice, MyInputGeomWindowUI **inblock) 
{
     static MyInputGeomWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


/*void window_callback(Fl_Widget*, void*) {
  MyMainWindowUI* mainwin;
  MyInputGeomWindowUI* geomwin;
  //if (!fl_ask("Are you sure you want to quit?")) return;
  PutGetMainWindow(1, &mainwin);
  mainwin->Geometry->activate();
  PutGetGeomInputWindow(1, &geomwin);
  geomwin->m_window->hide();
  //geomwin->m_window->deactivate();
  //delete geomwin;//->m_window->delete();
   
}*/

/*------------------------------------------------------------------------------
     GeomWin_callback
------------------------------------------------------------------------------*/
void GeomWin_callback() {
  MyInputGeomWindowUI *geomwin;
  PutGetGeomInputWindow(1, &geomwin);
  geomwin->m_window->hide();
  
}

/*------------------------------------------------------------------------------
     GeomWin_cb_OK
------------------------------------------------------------------------------*/
void GeomWin_cb_OK() {
  MyMainWindowUI   *mainwin;
  MyInputGeomWindowUI *geomwin;
  AllWinStruct *AllWinData;
  GeomWinStruct *GeomWinData;
  int ModelDim;
  
  PutGetGeomInputWindow(1, &geomwin);
  PutGetMainWindow(1, &mainwin);
  //printf("LENGTH %f\n", (float)(geomwin->Length->value()));
  PutGetAllWinStruct(1, &AllWinData); 
  GeomWinData=AllWinData->GeomWinData;
  
  StoreGeomWinData(geomwin,GeomWinData); 
  PrintGeomWinData(GeomWinData); 
  geomwin->m_window->hide();
  
  ModelDim=PutGetModelDim(1,123);
  
  if (2==ModelDim)
  {
      mainwin->Choice2d->show();
      mainwin->Choice3d->hide();
  }
  else
  {
      mainwin->Choice3d->show(); 
      mainwin->Choice2d->hide();
  }
  
}

/*------------------------------------------------------------------------------
     OpenInputGeomWin
------------------------------------------------------------------------------*/
void OpenInputGeomWin()
{
    MyInputGeomWindowUI* geomwin;
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    
    
    PutGetAllWinStruct(1, &AllWinData);
    GeomWinData=AllWinData->GeomWinData;
    
    PutGetGeomInputWindow(1, &geomwin);
    
    RecoverGeomWinData(geomwin,GeomWinData); 
    
    geomwin->m_window->set_modal();
    geomwin->m_window->show();  

    Fl::check();
}

/*------------------------------------------------------------------------------
     StoreGeomWinData
------------------------------------------------------------------------------*/
void StoreGeomWinData(MyInputGeomWindowUI *geomwin,GeomWinStruct *GeomWinData) 
{
    GeomWinData->lx=(double) geomwin->Length->value();
    GeomWinData->ly=(double) geomwin->Height->value();
    GeomWinData->lz=(double) geomwin->Depth->value();
    
    PutGetModelDim(0, (int) geomwin->ModelDim->value());   
}

/*------------------------------------------------------------------------------
     RecoverGeomWinData
------------------------------------------------------------------------------*/
void RecoverGeomWinData(MyInputGeomWindowUI *geomwin,GeomWinStruct *GeomWinData) 
{
    geomwin->Length->value(GeomWinData->lx);
    geomwin->Height->value(GeomWinData->ly);
    geomwin->Depth->value(GeomWinData->lz);
    
    geomwin->ModelDim->value(PutGetModelDim(1, 123));   
}

/*------------------------------------------------------------------------------
     PrintGeomWinData
------------------------------------------------------------------------------*/
void PrintGeomWinData(GeomWinStruct *GeomWinData) 
{
    printf("\n------------------------------\n");
    printf("Length  : %g\n",GeomWinData->lx);
    printf("Heigth  : %g\n",GeomWinData->ly);
    printf("Depth   : %g\n",GeomWinData->lz);
    printf("ModelDim: %i\n",PutGetModelDim(1, 123));
    printf("------------------------------\n");
}



