/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetLoadInputWindow
------------------------------------------------------------------------------*/
void PutGetLoadInputWindow(int choice, MyInputLoadWindowUI **inblock) 
{
     static MyInputLoadWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


/*------------------------------------------------------------------------------
     LoadWin_callback
------------------------------------------------------------------------------*/
void LoadWin_callback() {
  MyInputLoadWindowUI* Loadwin;
  int ModelDim;
  
  PutGetLoadInputWindow(1, &Loadwin);
  ModelDim=PutGetModelDim(1,123);
  if (2==ModelDim) 
  {
            Loadwin->m_window->hide();
  }
  else
  {
            Loadwin->m_window3d->hide();
  }
}

/*------------------------------------------------------------------------------
     LoadWin_cb_OK
------------------------------------------------------------------------------*/
void LoadWin_cb_OK() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  int ModelDim;
  
  PutGetLoadInputWindow(1, &loadwin);
  
  ModelDim=PutGetModelDim(1,123);
  if (2==ModelDim) 
  {
            SortLoads(LoadWinData);
            loadwin->m_window->hide();
  }
  else
  {
            loadwin->m_window3d->hide();
  }
  
}

/*------------------------------------------------------------------------------
     LoadWin_cb_Add
------------------------------------------------------------------------------*/
void LoadWin_cb_Add() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  int n;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  n=LoadWinData->num_loads;
  LoadWinData->LoadList[n].PrimFlag=(int) loadwin->PrimFlag->value();
  LoadWinData->LoadList[n].NumFlag= (int) loadwin->NumFlag->value();
  LoadWinData->LoadList[n].PhyFlag= (int) loadwin->PhyFlag->value();
  LoadWinData->LoadList[n].BCVal=   (double) loadwin->BCVal->value();
  LoadWinData->LoadList[n].BCPot=   (double) loadwin->BCPot->value();
      
  LoadWinData->num_loads++;
  LoadWin_ShowLoads(loadwin, LoadWinData);
}

/*------------------------------------------------------------------------------
     LoadWin_cb_DeleteAll
------------------------------------------------------------------------------*/
void LoadWin_cb_DeleteAll() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  LoadWinData->num_loads=0;
  loadwin->BCBrowse->clear();
}

/*------------------------------------------------------------------------------
     LoadWin_cb_DeleteOne
------------------------------------------------------------------------------*/
void LoadWin_cb_DeleteOne() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  int DelVal,i,n;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  DelVal=(int) loadwin->DelVal->value();
  n=LoadWinData->num_loads;
  
  if ((DelVal>0) && (DelVal<=n))
  {
      for(i=(DelVal-1); i<n;i++)
      {
          LoadWinData->LoadList[i].PrimFlag=LoadWinData->LoadList[i+1].PrimFlag;
          LoadWinData->LoadList[i].NumFlag= LoadWinData->LoadList[i+1].NumFlag;
          LoadWinData->LoadList[i].PhyFlag= LoadWinData->LoadList[i+1].PhyFlag;
          LoadWinData->LoadList[i].BCVal  = LoadWinData->LoadList[i+1].BCVal;
          LoadWinData->LoadList[i].BCPot  = LoadWinData->LoadList[i+1].BCPot;
      }
      (LoadWinData->num_loads)--;
      LoadWin_ShowLoads(loadwin, LoadWinData);
  }
}

/*------------------------------------------------------------------------------
     LoadWin_ShowLoads
------------------------------------------------------------------------------*/
void LoadWin_ShowLoads(MyInputLoadWindowUI *loadwin, LoadWinStruct *LoadWinData) 
{
  int n,i;
  char s[100];
  char tmp[100];
  
  loadwin->BCBrowse->clear();
  
  for(i=0; i<(LoadWinData->num_loads); i++)
  {
      sprintf(s, "%2i. BC:  ",(i+1));
      if (0==LoadWinData->LoadList[i].PrimFlag)
                sprintf(tmp, "Edge  =");  
           else sprintf(tmp, "Corner=");
      strcat(s, tmp);
      sprintf(tmp, "%i  ",(LoadWinData->LoadList[i].NumFlag+1));
      strcat(s, tmp);
      if (0==LoadWinData->LoadList[i].PhyFlag) sprintf(tmp, "Ux=");
      if (1==LoadWinData->LoadList[i].PhyFlag) sprintf(tmp, "Uy=");
      if (2==LoadWinData->LoadList[i].PhyFlag) sprintf(tmp, "Fx=");
      if (3==LoadWinData->LoadList[i].PhyFlag) sprintf(tmp, "Fy=");
      strcat(s, tmp);
      sprintf(tmp, "%g  ",(LoadWinData->LoadList[i].BCVal));
      strcat(s, tmp);
      sprintf(tmp, "(z^%g)",(LoadWinData->LoadList[i].BCPot));
      strcat(s, tmp);
      loadwin->BCBrowse->add(s);	
  }

}

/*------------------------------------------------------------------------------
     OpenInputLoadWin
------------------------------------------------------------------------------*/
void OpenInputLoadWin()
{
    MyInputLoadWindowUI* loadwin;
    AllWinStruct *AllWinData;
    LoadWinStruct *LoadWinData;
    int ModelDim;
    
    
    PutGetAllWinStruct(1, &AllWinData);
    LoadWinData=AllWinData->LoadWinData;
    
    PutGetLoadInputWindow(1, &loadwin);
    
    ModelDim=PutGetModelDim(1,123);
      
    if (2==ModelDim)
    {
        loadwin->m_window->set_modal();
        loadwin->m_window->show(); 
        LoadWin_ShowLoads(loadwin, LoadWinData); 
    }
    else
    {
        loadwin->m_window3d->set_modal();
        loadwin->m_window3d->show(); 
    }
    
    LoadWin_ShowLoads(loadwin, LoadWinData); 
   //loadwin->BCBrowse->add("One1");	
    
    Fl::check();
}

/* 3D *************************************************************************/
/* 3D *************************************************************************/
/* 3D *************************************************************************/
/* 3D *************************************************************************/
/* 3D *************************************************************************/
/* 3D *************************************************************************/



/*------------------------------------------------------------------------------
     LoadWin_cb_Add3d
------------------------------------------------------------------------------*/
void LoadWin_cb_Add3d() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  int n;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  n=LoadWinData->num_loads3d;
  LoadWinData->LoadList3d[n].PrimFlag=(int) loadwin->PrimFlag3d->value();
  LoadWinData->LoadList3d[n].NumFlag= (int) loadwin->NumFlag3d->value();
  LoadWinData->LoadList3d[n].PhyFlag= (int) loadwin->PhyFlag3d->value();
  LoadWinData->LoadList3d[n].BCVal=   (double) loadwin->BCVal3d->value();
  LoadWinData->LoadList3d[n].BCPot=   (double) loadwin->BCPot3d->value();
      
  LoadWinData->num_loads3d++;
  LoadWin_ShowLoads3d(loadwin, LoadWinData);
  printf("LoadWin_cb_add3d\n");
}

/*------------------------------------------------------------------------------
     LoadWin_cb_DeleteAll3d
------------------------------------------------------------------------------*/
void LoadWin_cb_DeleteAll3d() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  LoadWinData->num_loads3d=0;
  loadwin->BCBrowse3d->clear();
}

/*------------------------------------------------------------------------------
     LoadWin_cb_DeleteOne3d
------------------------------------------------------------------------------*/
void LoadWin_cb_DeleteOne3d() 
{
  MyInputLoadWindowUI *loadwin;
  AllWinStruct *AllWinData;
  LoadWinStruct *LoadWinData;
  int DelVal,i,n;
  
  PutGetLoadInputWindow(1, &loadwin);
  PutGetAllWinStruct(1, &AllWinData); 
  LoadWinData=AllWinData->LoadWinData;
  
  DelVal=(int) loadwin->DelVal3d->value();
  n=LoadWinData->num_loads3d;
  
  if ((DelVal>0) && (DelVal<=n))
  {
      for(i=(DelVal-1); i<n;i++)
      {
          LoadWinData->LoadList3d[i].PrimFlag = LoadWinData->LoadList3d[i+1].PrimFlag ;
          LoadWinData->LoadList3d[i].NumFlag  = LoadWinData->LoadList3d[i+1].NumFlag ;
          LoadWinData->LoadList3d[i].PhyFlag  = LoadWinData->LoadList3d[i+1].PhyFlag ;
          LoadWinData->LoadList3d[i].BCVal    = LoadWinData->LoadList3d[i+1].BCVal ;
          LoadWinData->LoadList3d[i].BCPot    = LoadWinData->LoadList3d[i+1].BCPot ;
      }
      printf("Geht dieses Inkrement? : LoadWinData->num_loads3d %i", LoadWinData->num_loads3d);
      (LoadWinData->num_loads3d)--;
      printf("Geht dieses Inkrement!!!: LoadWinData->num_loads3d %i", LoadWinData->num_loads3d);
      LoadWin_ShowLoads3d(loadwin, LoadWinData);
  }
}

/*------------------------------------------------------------------------------
     LoadWin_ShowLoads3d
------------------------------------------------------------------------------*/
void LoadWin_ShowLoads3d(MyInputLoadWindowUI *loadwin, LoadWinStruct *LoadWinData) 
{
  int n,i;
  char s[200];
  char tmp[200];
  
  loadwin->BCBrowse3d->clear();
  
  for(i=0; i<(LoadWinData->num_loads3d); i++)
  {
      sprintf(s, "%2i. BC:  ",(i+1));
      if (0==LoadWinData->LoadList3d[i].PrimFlag) sprintf(tmp, "Face  ="); 
      if (1==LoadWinData->LoadList3d[i].PrimFlag) sprintf(tmp, "Edge  =");  
      if (2==LoadWinData->LoadList3d[i].PrimFlag) sprintf(tmp, "Corner=");
      
      strcat(s, tmp);
      sprintf(tmp, "%i  ",(LoadWinData->LoadList3d[i].NumFlag+1));
      strcat(s, tmp);
      
      if (0==LoadWinData->LoadList3d[i].PhyFlag) sprintf(tmp, "Ux=");
      if (1==LoadWinData->LoadList3d[i].PhyFlag) sprintf(tmp, "Uy=");
      if (2==LoadWinData->LoadList3d[i].PhyFlag) sprintf(tmp, "Uz=");
      if (3==LoadWinData->LoadList3d[i].PhyFlag) sprintf(tmp, "Fx=");
      if (4==LoadWinData->LoadList3d[i].PhyFlag) sprintf(tmp, "Fy=");
      if (5==LoadWinData->LoadList3d[i].PhyFlag) sprintf(tmp, "Fz=");
      
      strcat(s, tmp);
      sprintf(tmp, "%g  ",(LoadWinData->LoadList3d[i].BCVal));
      strcat(s, tmp);
      sprintf(tmp, "(z^%g)",(LoadWinData->LoadList3d[i].BCPot));
      strcat(s, tmp);
      loadwin->BCBrowse3d->add(s);	
  }

}


/*------------------------------------------------------------------------------
     SortLoads       !sort loads: displacements first!  !neu -n33-!
------------------------------------------------------------------------------*/

void SortLoads(LoadWinStruct *LoadWinData)
{
    int i,j,k,k1;
    int PF,NF;
    double Tval;
    int num_loads;
    int *DispType;            
    OneLoad *LoadList;        
    OneLoad TempLoad;
    
    LoadList=LoadWinData->LoadList;    
    num_loads=LoadWinData->num_loads;
    DispType=LoadWinData->DispType;
    
    /*
    PrintLoadlist(LoadList,num_loads);
    //*/
    
    for(i=0; i<num_loads; i++)
    {
     if (LoadList[i].PhyFlag == 2 || LoadList[i].PhyFlag == 3) //wenn Fx oder Fy
     {
          for(j=i+1; j<num_loads; j++)
          {
           if (LoadList[j].PhyFlag == 0 || LoadList[j].PhyFlag == 1) //wenn ux oder uy
           {
            TempLoad.BCPot=LoadList[j].BCPot;
            TempLoad.BCVal=LoadList[j].BCVal;
            TempLoad.NumFlag=LoadList[j].NumFlag;
            TempLoad.PhyFlag=LoadList[j].PhyFlag;
            TempLoad.PrimFlag=LoadList[j].PrimFlag;
            
            LoadList[j].BCPot=LoadList[i].BCPot;
            LoadList[j].BCVal=LoadList[i].BCVal;
            LoadList[j].NumFlag=LoadList[i].NumFlag;
            LoadList[j].PhyFlag=LoadList[i].PhyFlag;
            LoadList[j].PrimFlag=LoadList[i].PrimFlag;
            
            LoadList[i].BCPot=TempLoad.BCPot;
            LoadList[i].BCVal=TempLoad.BCVal;
            LoadList[i].NumFlag=TempLoad.NumFlag;
            LoadList[i].PhyFlag=TempLoad.PhyFlag;
            LoadList[i].PrimFlag=TempLoad.PrimFlag;
             
            break;    
           } 
          }  
     }   
    }
       
    k1=0;                           // zhlen der Verschiebungs-RB
    for(i=0; i<num_loads; i++)
    {
     if (LoadList[i].PhyFlag == 0 || LoadList[i].PhyFlag == 1) k1++;
    }
    LoadWinData->num_disp=k1;
    
    for(i=0; i<8; i++)              // DispType-Vektor zu Null setzen
    {
        DispType[i]=0;        
    }

    for(i=0; i<k1; i++)             // Erstellung DispType-Vektor
    {
     if (0==(LoadList[i].PrimFlag)) //nur Kanten
     {
        PF=LoadList[i].PhyFlag;
        NF=LoadList[i].NumFlag;
        Tval=LoadList[i].BCVal;
        if (0==DispType[NF+PF*4] && Tval==0.0) DispType[NF+PF*4]=1;
        if ((0==DispType[NF+PF*4] || 1==DispType[NF+PF*4]) && Tval!=0.0) DispType[NF+PF*4]=2;
     }               
    }    
    
    for(i=0; i<k1; i++)        //corners (displ) last
    {
     if (LoadList[i].PrimFlag == 1)
     {
          for(j=i+1; j<k1; j++)
          {
           if (LoadList[j].PrimFlag == 0)
           {
            TempLoad.BCPot=LoadList[j].BCPot;
            TempLoad.BCVal=LoadList[j].BCVal;
            TempLoad.NumFlag=LoadList[j].NumFlag;
            TempLoad.PhyFlag=LoadList[j].PhyFlag;
            TempLoad.PrimFlag=LoadList[j].PrimFlag;
            
            LoadList[j].BCPot=LoadList[i].BCPot;
            LoadList[j].BCVal=LoadList[i].BCVal;
            LoadList[j].NumFlag=LoadList[i].NumFlag;
            LoadList[j].PhyFlag=LoadList[i].PhyFlag;
            LoadList[j].PrimFlag=LoadList[i].PrimFlag;
            
            LoadList[i].BCPot=TempLoad.BCPot;
            LoadList[i].BCVal=TempLoad.BCVal;
            LoadList[i].NumFlag=TempLoad.NumFlag;
            LoadList[i].PhyFlag=TempLoad.PhyFlag;
            LoadList[i].PrimFlag=TempLoad.PrimFlag;
            
            break;     
           } 
          }  
     }    
    }
    
    for(i=k1; i<num_loads; i++)        //corners (Force) last
    {
     if (LoadList[i].PrimFlag == 1)
     {
          for(j=i+1; j<num_loads; j++)
          {
           if (LoadList[j].PrimFlag == 0)
           {
            TempLoad.BCPot=LoadList[j].BCPot;
            TempLoad.BCVal=LoadList[j].BCVal;
            TempLoad.NumFlag=LoadList[j].NumFlag;
            TempLoad.PhyFlag=LoadList[j].PhyFlag;
            TempLoad.PrimFlag=LoadList[j].PrimFlag;
            
            LoadList[j].BCPot=LoadList[i].BCPot;
            LoadList[j].BCVal=LoadList[i].BCVal;
            LoadList[j].NumFlag=LoadList[i].NumFlag;
            LoadList[j].PhyFlag=LoadList[i].PhyFlag;
            LoadList[j].PrimFlag=LoadList[i].PrimFlag;
            
            LoadList[i].BCPot=TempLoad.BCPot;
            LoadList[i].BCVal=TempLoad.BCVal;
            LoadList[i].NumFlag=TempLoad.NumFlag;
            LoadList[i].PhyFlag=TempLoad.PhyFlag;
            LoadList[i].PrimFlag=TempLoad.PrimFlag;
            
            break;     
           } 
          }  
     }    
    }
    
    /*
    PrintLoadlist(LoadList,num_loads);
    PrintMatrixIntegerT(1,8,DispType);
    //getchar();
    //*/                 
}
