/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <stdio.h>
#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetMeshInputWindow
------------------------------------------------------------------------------*/
void PutGetMeshInputWindow(int choice, MyInputMeshWindowUI **inblock) 
{
     static MyInputMeshWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


/*void window_callback(Fl_Widget*, void*) {
  MyMainWindowUI* mainwin;
  MyInputMeshWindowUI* Meshwin;
  //if (!fl_ask("Are you sure you want to quit?")) return;
  PutGetMainWindow(1, &mainwin);
  mainwin->Meshetry->activate();
  PutGetMeshInputWindow(1, &Meshwin);
  Meshwin->m_window->hide();
  //Meshwin->m_window->deactivate();
  //delete Meshwin;//->m_window->delete();
   
}*/

/*------------------------------------------------------------------------------
     MeshWin_callback
------------------------------------------------------------------------------*/
void MeshWin_callback() 
{
    MyInputMeshWindowUI *meshwin;
    PutGetMeshInputWindow(1, &meshwin);
    meshwin->m_window->hide();
}

/*------------------------------------------------------------------------------
     MeshWin_cb_OK
------------------------------------------------------------------------------*/
void MeshWin_cb_OK() 
{
  MyInputMeshWindowUI *meshwin;
  AllWinStruct *AllWinData;
  MeshWinStruct *MeshWinData;
  int ModelDim;
  SolveBlock *SolBlock;
 
  PutGetSolveBlock(1,&SolBlock); 
  
  PutGetMeshInputWindow(1, &meshwin);
  //printf("LENGTH %f\n", (float)(geomwin->Length->value()));
  PutGetAllWinStruct(1, &AllWinData); 
  MeshWinData=AllWinData->MeshWinData;
  
  StoreMeshWinData(meshwin,MeshWinData); 
  PrintMeshWinData(MeshWinData); 
  meshwin->m_window->hide();
  ModelDim=PutGetModelDim(1, 123); 
  if (2==ModelDim)  
  {   
      MesherMainLoop(); 
  }
  else MesherMainLoop3d();
  
  if (0==SolBlock->PreMeshFlag)
  {
      InitPreMeshes();
  }
  
  //aktualisiert die Sectionslider im Hauptfenster 
  UpdateSectionSliders();
}


/*------------------------------------------------------------------------------
     OpenInputMeshWin
------------------------------------------------------------------------------*/
void OpenInputMeshWin()
{
    MyInputMeshWindowUI* meshwin;
    AllWinStruct *AllWinData;
    MeshWinStruct *MeshWinData;
    
    
    PutGetAllWinStruct(1, &AllWinData);
    MeshWinData=AllWinData->MeshWinData;
    
    PutGetMeshInputWindow(1, &meshwin);
    
    RecoverMeshWinData(meshwin,MeshWinData); 
    
    meshwin->m_window->set_modal();
    meshwin->m_window->show();  

    Fl::check();
}


/*------------------------------------------------------------------------------
     StoreMeshWinData
------------------------------------------------------------------------------*/
void StoreMeshWinData(MyInputMeshWindowUI *meshwin,MeshWinStruct *MeshWinData) 
{
    MeshWinData->MinDof=(int) meshwin->MinDof->value();
}

/*------------------------------------------------------------------------------
     RecoverMeshWinData
------------------------------------------------------------------------------*/
void RecoverMeshWinData(MyInputMeshWindowUI *meshwin,MeshWinStruct *MeshWinData) 
{
    meshwin->MinDof->value((int) MeshWinData->MinDof);
}

/*------------------------------------------------------------------------------
     PrintMeshWinData
------------------------------------------------------------------------------*/
void PrintMeshWinData(MeshWinStruct *MeshWinData) 
{
    printf("\n------------------------------\n");
    printf("Minimum degrees of freedom: %i\n",MeshWinData->MinDof);
    printf("------------------------------\n");
}

