/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <stdio.h>
#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetMesoInputWindow
------------------------------------------------------------------------------*/
void PutGetMesoInputWindow(int choice, MyInputMesoWindowUI **inblock) 
{
     static MyInputMesoWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}

/*------------------------------------------------------------------------------
     MesoWin_callback
------------------------------------------------------------------------------*/
void MesoWin_callback() {
  MyInputMesoWindowUI *mesowin;
  PutGetMesoInputWindow(1, &mesowin);
  mesowin->m_window->hide();
  //MesoGenMainLoop();
  //MesoPixMainLoop();
  
}

/*------------------------------------------------------------------------------
     MesoWin_cb_OK
------------------------------------------------------------------------------*/
void MesoWin_cb_OK() 
{
  MyInputMesoWindowUI *mesowin;
  AllWinStruct *AllWinData;
  MesoWinStruct *MesoWinData;
  int ModelDim;
  
  ModelDim=PutGetModelDim(1,123);
    
  PutGetMesoInputWindow(1, &mesowin);
  PutGetAllWinStruct(1, &AllWinData); 
  MesoWinData=AllWinData->MesoWinData;
  
  StoreMesoWinData(mesowin,MesoWinData); 
  PrintMesoWinData(MesoWinData);
  if (2==ModelDim) MesoPixMainLoop();    
  if (3==ModelDim) MesoPixMainLoop3d();
  if (3==ModelDim) CreateColorIndex2and3d();
  else CreateColorIndexC();
  mesowin->m_window->hide();
  
  // Only for Go-Mode
    SolveBlock *SolBlock;
    PutGetSolveBlock(1,&SolBlock); 
    if (1==SolBlock->GoFlag) return;
    // End of Change  
  
  
  PostMainLoop();
  //UpdateGraphicWindow();
  //PrintGraphicBlock();
   
}

/*------------------------------------------------------------------------------
     OpenInputMesoWin
------------------------------------------------------------------------------*/
void OpenInputMesoWin()
{
    MyInputMesoWindowUI* mesowin;
    AllWinStruct *AllWinData;
    MesoWinStruct *MesoWinData;
    
    
    PutGetAllWinStruct(1, &AllWinData);
    MesoWinData=AllWinData->MesoWinData;
    
    PutGetMesoInputWindow(1, &mesowin);
    
    RecoverMesoWinData(mesowin,MesoWinData); 
    
    mesowin->m_window->set_modal();
    mesowin->m_window->show();  
    
    // Only for Go-Mode
    SolveBlock *SolBlock;
    PutGetSolveBlock(1,&SolBlock); 
    if (1==SolBlock->GoFlag) return;
    // End of Change
    
    Fl::check();
}

/*------------------------------------------------------------------------------
     StoreMesoWinData
------------------------------------------------------------------------------*/
void StoreMesoWinData(MyInputMesoWindowUI *mesowin,MesoWinStruct *MesoWinData) 
{  
  
    MesoWinData->E_Matrix      =(double) mesowin->E_Matrix->value();
    MesoWinData->E_Inclusion   =(double) mesowin->E_Inclusion->value();
    MesoWinData->Mu_Matrix     =(double) mesowin->Mu_Matrix->value();
    MesoWinData->Mu_Inclusion  =(double) mesowin->Mu_Inclusion->value();
    MesoWinData->MinSize       =(double) mesowin->MinSize->value();
    MesoWinData->MaxSize       =(double) mesowin->MaxSize->value();
    MesoWinData->VolFraction   =(double) mesowin->VolFraction->value();
    MesoWinData->FullerFlag    =(int)    mesowin->FullerFlag->value();
    MesoWinData->FullerExponent=(double) mesowin->FullerExponent->value();
    MesoWinData->Smoothness    =(double) mesowin->Smoothness->value();
    MesoWinData->Compactness   =(double) mesowin->Compactness->value();
    MesoWinData->Roughness     =(double) mesowin->Roughness->value();    
    MesoWinData->Deformed      =(double) mesowin->Deformed->value();
    MesoWinData->RoughFlag     =(int)    mesowin->RoughFlag->value();
    MesoWinData->DeformedFlag  =(int)    mesowin->DeformedFlag->value();
    MesoWinData->AddFlag       =(int)    mesowin->AddFlag->value();
    MesoWinData->MaterialNumBegin  =(int)mesowin->MaterialNumBegin->value();
    MesoWinData->MaterialNumEnd    =(int)mesowin->MaterialNumEnd->value();
    
}

/*------------------------------------------------------------------------------
     RecoverMesoWinData
------------------------------------------------------------------------------*/
void RecoverMesoWinData(MyInputMesoWindowUI *mesowin,MesoWinStruct *MesoWinData) 
{
    SolveBlock *SolBlock; 
    MGBlock *Meshes, *M;
    int num_levels;
   
    
    PutGetSolveBlock(1,&SolBlock); 
    
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    M=&(Meshes[num_levels-1]);
    
    mesowin->E_Matrix->value(MesoWinData->E_Matrix );
    mesowin->E_Inclusion->value(MesoWinData->E_Inclusion);
    mesowin->Mu_Matrix->value(MesoWinData->Mu_Matrix);
    mesowin->Mu_Inclusion->value(MesoWinData->Mu_Inclusion);
    mesowin->MinSize->value( MesoWinData->MinSize);
    mesowin->MaxSize->value( MesoWinData->MaxSize);
    mesowin->VolFraction->value(MesoWinData->VolFraction);
    mesowin->FullerFlag->value(MesoWinData->FullerFlag);
    mesowin->FullerExponent->value(MesoWinData->FullerExponent);
    mesowin->Smoothness->value(MesoWinData->Smoothness);
    mesowin->Compactness->value(MesoWinData->Compactness);
    mesowin->Roughness->value(MesoWinData->Roughness);  
    mesowin->Deformed->value(MesoWinData->Deformed); 
    mesowin->RoughFlag->value(MesoWinData->RoughFlag); 
    mesowin->DeformedFlag->value(MesoWinData->DeformedFlag); 
    mesowin->AddFlag->value(MesoWinData->AddFlag); 
    mesowin->MaterialNumBegin->value(MesoWinData->MaterialNumBegin); 
    mesowin->MaterialNumEnd->value(MesoWinData->MaterialNumEnd); 
    

    mesowin->la->value(M->la);
    mesowin->lb->value(M->lb); printf("la: %f  lb: %f\n", M->la,M->lb);
    mesowin->lc->value(M->lc);
    mesowin->lx->value(M->la*M->nex);
    mesowin->ly->value(M->lb*M->ney);
    mesowin->lz->value(M->lc*M->nez);
    mesowin->nex->value(M->nex);
    mesowin->ney->value(M->ney);
    mesowin->nez->value(M->nez);
    
}

/*------------------------------------------------------------------------------
     PrintMesoWinData
------------------------------------------------------------------------------*/
void PrintMesoWinData(MesoWinStruct *MesoWinData) 
{
    printf("\n------------------------------\n");
    printf("E_Matrix:       %g\n",MesoWinData->E_Matrix);
    printf("E_Inclusion:    %g\n",MesoWinData->E_Inclusion);
    printf("Mu_Matrix:      %g\n",MesoWinData->Mu_Matrix);
    printf("Mu_Inclusion:   %g\n",MesoWinData->Mu_Inclusion);
    printf("MinSize:        %g\n",MesoWinData->MinSize);
    printf("MaxSize:        %g\n",MesoWinData->MaxSize);
    printf("VolFraction:    %g\n",MesoWinData->VolFraction);
    printf("FullerFlag:     %i\n",MesoWinData->FullerFlag);
    printf("FullerExponent: %g\n",MesoWinData->FullerExponent);
    printf("Smoothness:     %g\n",MesoWinData->Smoothness);
    printf("Compactness:    %g\n",MesoWinData->Compactness);
    printf("Roughness:      %g\n",MesoWinData->Roughness);
    printf("Deformed:       %g\n",MesoWinData->Deformed);
    printf("RoughFlag:      %i\n",MesoWinData->RoughFlag);
    printf("DeformedFlag:   %i\n",MesoWinData->DeformedFlag);    
    printf("AddFlag:        %i\n",MesoWinData->AddFlag);    
    printf("MatNumBegin:    %i\n",MesoWinData->MaterialNumBegin);  
    printf("MaterialNumEnd: %i\n",MesoWinData->MaterialNumEnd);  
    printf("\n------------------------------\n");
}




/*------------------------------------------------------------------------------
     MesoWin_cb_Apply
------------------------------------------------------------------------------*/
void MesoWin_cb_Apply(int c) 
{
  MyInputMesoWindowUI *mesowin;
  AllWinStruct *AllWinData;
  MesoWinStruct *MesoWinData;
    
  PutGetMesoInputWindow(1, &mesowin);
  
  if (0==c)
  MesoWin_TransferEMaterial((int) mesowin->MaterialNumBegin->value(),
                       (int) mesowin->MaterialNumEnd->value(), 
                       (double) mesowin->E_Material->value());
  
  if (1==c)
  MesoWin_TransferMuMaterial((int) mesowin->MaterialNumBegin->value(),
                       (int) mesowin->MaterialNumEnd->value(), 
                       (double) mesowin->Mu_Material->value());
  
  if (2==c)
  MesoWin_TransferVisibleMaterial((int) mesowin->MaterialNumBegin->value(),
                                  (int) mesowin->MaterialNumEnd->value(),
                                  (int) 1);
  if (3==c)
  MesoWin_TransferVisibleMaterial((int) mesowin->MaterialNumBegin->value(),
                                  (int) mesowin->MaterialNumEnd->value(),
                                  (int) 0);
  
  PostMainLoop();
  //UpdateGraphicWindow();
  //PrintGraphicBlock();
   
}

/*------------------------------------------------------------------------------
     MesoWin_TransferEMaterial
------------------------------------------------------------------------------*/
void MesoWin_TransferEMaterial(int MaterialNumBegin, 
                          int MaterialNumEnd,
                          double E_Material) 
{
  SolveBlock *SolBlock;
  MGBlock *Meshes;
  int num_levels;
  int nex,ney,nez;
  int i,j,k;
  int ModelDim;
  
  ModelDim=PutGetModelDim(1,123);
  
  PutGetSolveBlock(1,&SolBlock);
  if(0==SolBlock->NumMaterials) return;
  num_levels=SolBlock->num_levels;        
  Meshes=&(SolBlock->Meshes[num_levels-1]);
  nex=Meshes->nnx-1;
  ney=Meshes->nny-1;
    
  if(0==SolBlock->NumMaterials) return;
  for(i=0; i<(SolBlock->NumMaterials); i++)
  {
      if (MaterialNumBegin<=i && MaterialNumEnd>=i)
      {
          SolBlock->Material[i].E=E_Material;    
      }
  }
  
  if (2==ModelDim)
  {
      for(j=0;j<ney;j++)
      for(i=0;i<nex;i++)
      if ((MaterialNumBegin<=Meshes->MatFieldInt[i+j*nex]) &&
          (MaterialNumEnd>=Meshes->MatFieldInt[i+j*nex]))
          Meshes->MatFieldE[i+j*nex]=E_Material;
  }
  else
  {
      nez=Meshes->nnz-1;
      for(k=0;k<nez;k++)
      for(j=0;j<ney;j++)
      for(i=0;i<nex;i++)
      if ((MaterialNumBegin<=Meshes->MatFieldInt[i+j*nex+k*nex*ney]) &&
          (MaterialNumEnd>=Meshes->MatFieldInt[i+j*nex+k*nex*ney]))
          Meshes->MatFieldE[i+j*nex+k*nex*ney]=E_Material;
      
  }
  return; 
}

/*------------------------------------------------------------------------------
     MesoWin_TransferMuMaterial
------------------------------------------------------------------------------*/
void MesoWin_TransferMuMaterial(int MaterialNumBegin, 
                          int MaterialNumEnd,
                          double Mu_Material) 
{
  SolveBlock *SolBlock;
  MGBlock *Meshes;
  int num_levels;
  int nex,ney;
  int i,j;
  
  PutGetSolveBlock(1,&SolBlock);
  num_levels=SolBlock->num_levels;        
  Meshes=&(SolBlock->Meshes[num_levels-1]);
  nex=Meshes->nnx-1;
  ney=Meshes->nny-1;
  
  if(0==SolBlock->NumMaterials) return;
  for(i=0; i<(SolBlock->NumMaterials); i++)
  {
      if (MaterialNumBegin<=i && MaterialNumEnd>=i)
      {
          SolBlock->Material[i].Mu=Mu_Material;    
      }
  }
  
  return; 
}

/*------------------------------------------------------------------------------
     MesoWin_TransferVisibleMaterial
------------------------------------------------------------------------------*/
void MesoWin_TransferVisibleMaterial(int MaterialNumBegin, 
                          int MaterialNumEnd,
                          int VisibleFlag) 
{
  SolveBlock *SolBlock;
  MGBlock *Meshes;
  int num_levels;
  int nex,ney;
  int i,j;
  
  PutGetSolveBlock(1,&SolBlock);
  num_levels=SolBlock->num_levels;        
  Meshes=&(SolBlock->Meshes[num_levels-1]);
  nex=Meshes->nnx-1;
  ney=Meshes->nny-1;
  
  if(0==SolBlock->NumMaterials) return;
  for(i=0; i<(SolBlock->NumMaterials); i++)
  {
      if (MaterialNumBegin<=i && MaterialNumEnd>=i)
      {
          SolBlock->Material[i].Visible=VisibleFlag;    
      }
  }
  
  return; 
}

/*------------------------------------------------------------------------------
     MesoWin_cb_InputControl
------------------------------------------------------------------------------*/
void MesoWin_cb_InputControl(int c) 
{
  MyInputMesoWindowUI *mesowin;
  AllWinStruct *AllWinData;
  MesoWinStruct *MesoWinData;
    
  PutGetMesoInputWindow(1, &mesowin);
  
  if (0==c)
  if (((int) mesowin->MaterialNumBegin->value())>
      ((int) mesowin->MaterialNumEnd->value()) )
      mesowin->MaterialNumEnd->value(mesowin->MaterialNumBegin->value());
  
  if (1==c)
  if (((int) mesowin->MaterialNumBegin->value())>
      ((int) mesowin->MaterialNumEnd->value()) )
      mesowin->MaterialNumBegin->value(mesowin->MaterialNumEnd->value());  
   
  return; 
}

/*------------------------------------------------------------------------------
     RecomputeSpecimenSize
------------------------------------------------------------------------------*/
void RecomputeSpecimenSize() 
{   
    MyInputMesoWindowUI* mesowin;
    AllWinStruct *AllWinData;
    MesoWinStruct *MesoWinData;
    double la, lb, nex, ney;
    
    SolveBlock *SolBlock; 
    MGBlock *Meshes, *M;
    int num_levels;
   
    
    PutGetSolveBlock(1,&SolBlock); 
    
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    M=&(Meshes[num_levels-1]);
    
    PutGetAllWinStruct(1, &AllWinData);
    MesoWinData=AllWinData->MesoWinData;
    
    PutGetMesoInputWindow(1, &mesowin);
    
    la=(double) mesowin->la->value();
    lb=(double) mesowin->lb->value();
    nex=(double) mesowin->nex->value();
    ney=(double) mesowin->ney->value();    
    
    mesowin->lx->value(la*nex);
    mesowin->ly->value(lb*ney);
    //mesowin->lz->value(1);
    
    M->la = (double)mesowin->la->value();
    M->lb = (double)mesowin->lb->value();
    return;   
}

/*------------------------------------------------------------------------------
     RecomputeElementSize
------------------------------------------------------------------------------*/
void RecomputeElementSize() 
{
    MyInputMesoWindowUI* mesowin;
    AllWinStruct *AllWinData;
    MesoWinStruct *MesoWinData;
    double lx, ly, nex, ney;
    
    SolveBlock *SolBlock; 
    MGBlock *Meshes, *M;
    int num_levels;
   
    
    PutGetSolveBlock(1,&SolBlock); 
    
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    M=&(Meshes[num_levels-1]);
    
    
    PutGetAllWinStruct(1, &AllWinData);
    MesoWinData=AllWinData->MesoWinData;
    
    PutGetMesoInputWindow(1, &mesowin);
    
    lx=(double) mesowin->lx->value();
    ly=(double) mesowin->ly->value();
    nex=(double) mesowin->nex->value();
    ney=(double) mesowin->ney->value();  
    
    mesowin->la->value(lx/nex);
    mesowin->lb->value(ly/ney);
    //mesowin->lz->value(1);
    M->la = (double)mesowin->la->value();
    M->lb = (double)mesowin->lb->value();
    
    return;   
}

