/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <stdio.h>
#include <FL/fl_ask.H>


/*------------------------------------------------------------------------------
     PutGetSolveInputWindow
------------------------------------------------------------------------------*/
void PutGetSolveInputWindow(int choice, MyInputSolveWindowUI **inblock) 
{
     static MyInputSolveWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


/*------------------------------------------------------------------------------
     SolveWin_callback
------------------------------------------------------------------------------*/
void SolveWin_callback() {
    MyInputSolveWindowUI* Solvewin;
    PutGetSolveInputWindow(1, &Solvewin);
  

    Solvewin->m_window->hide(); 
  
}


/*------------------------------------------------------------------------------
     SolveWin_cb_OK
------------------------------------------------------------------------------*/
void SolveWin_cb_OK() 
{
   MyInputSolveWindowUI* solvewin;
   AllWinStruct *AllWinData;
   SolveWinStruct *SolveWinData;
   
   PutGetSolveInputWindow(1, &solvewin);
   PutGetAllWinStruct(1, &AllWinData); 
   SolveWinData=AllWinData->SolveWinData;
   
   StoreSolveWinData(solvewin,SolveWinData); 
   PrintSolveWinData(SolveWinData);

   solvewin->m_window->hide(); 
   
   BuildStiffnessMatrices();
   SolverMainLoop();
   return;
}


/*------------------------------------------------------------------------------
     OpenInputSolveWin
------------------------------------------------------------------------------*/
void OpenInputSolveWin()
{
    MyInputSolveWindowUI* Solvewin;
    
    PutGetSolveInputWindow(1, &Solvewin);

    Solvewin->m_window->set_modal();
    Solvewin->m_window->show(); 
    
    // Only for Go-Mode
    SolveBlock *SolBlock;
    PutGetSolveBlock(1,&SolBlock); 
    if (1==SolBlock->GoFlag) return;
    // End of Change  
    
    Fl::check();
}


/*------------------------------------------------------------------------------
     StoreSolveWinData   !abgendert -a05-!
------------------------------------------------------------------------------*/
void StoreSolveWinData(MyInputSolveWindowUI *solvewin,SolveWinStruct *SolveWinData) 
{  
    int orderK; 

     orderK =(int) solvewin->BSpOrderK->value();
     //if (orderK > 10) orderK=10;   spter ndern
     if (orderK <  1) orderK=1;
     SolveWinData->BSpOrderK     = orderK;
     SolveWinData->SolverMethod  =(int) solvewin->SolverMethod->value();
     SolveWinData->Omega         =(double) solvewin->Omega->value();
     SolveWinData->OptFactorFlag =(int) solvewin->OptFactorFlag->value();
     SolveWinData->BSplineFlag   =(int) solvewin->BSplineFlag->value();
     SolveWinData->YMsmoothFlag  =(int) solvewin->YMsmoothFlag->value();
     SolveWinData->CircleElementFlag =(int) solvewin->CircleElementFlag->value();
     SolveWinData->CircleIntpntFlag  =(int) solvewin->CircleIntpntFlag->value();
     SolveWinData->Repititions   =(double) solvewin->Repititions->value();
     SolveWinData->NLRadius      =(double) solvewin->NLRadius->value();
     SolveWinData->LimitStrain   =(double) solvewin->LimitStrain->value();
     SolveWinData->DuctileStrain =(double) solvewin->DuctileStrain->value();
     SolveWinData->LoadSteps     =(int) solvewin->LoadSteps->value();    
     SolveWinData->RelEnergyFlag =(int) solvewin->RelEnergyFlag->value(); 
     SolveWinData->RelEuclidFlag =(int) solvewin->RelEuclidFlag->value(); 
     SolveWinData->EuclidFlag    =(int) solvewin->EuclidFlag->value(); 
     SolveWinData->RelEnergyTol  =(double) solvewin->RelEnergyTol->value();
     SolveWinData->RelEuclidTol  =(double) solvewin->RelEuclidTol->value();
     SolveWinData->EuclidTol     =(double) solvewin->EuclidTol->value();
     SolveWinData->PreCondType   =(int) solvewin->PreCondType->value(); 
     SolveWinData->ContFlag      =(int) solvewin->ContFlag->value(); 
     SolveWinData->SSORFlag      =(int) solvewin->SSORFlag->value(); 
     SolveWinData->CheckTime     =(float) solvewin->CheckTime->value(); 


}


/*------------------------------------------------------------------------------
     RecoverSolveWinData   !abgendert -a07-!
------------------------------------------------------------------------------*/
void RecoverSolveWinData(MyInputSolveWindowUI *solvewin,SolveWinStruct *SolveWinData) 
{

    int orderK; 
  

     solvewin->SolverMethod->value(SolveWinData->SolverMethod ); 
     solvewin->Omega->value(SolveWinData->Omega);  
     solvewin->OptFactorFlag->value(SolveWinData->OptFactorFlag);
     solvewin->BSplineFlag->value(SolveWinData->BSplineFlag);
     solvewin->YMsmoothFlag->value(SolveWinData->YMsmoothFlag);
     solvewin->CircleElementFlag->value(SolveWinData->CircleElementFlag);
     solvewin->CircleIntpntFlag->value(SolveWinData->CircleIntpntFlag);
     solvewin->BSpOrderK->value(SolveWinData->BSpOrderK);
     solvewin->Repititions->value(SolveWinData->Repititions);    
     solvewin->NLRadius->value(SolveWinData->NLRadius); 
     solvewin->LimitStrain->value(SolveWinData->LimitStrain); 
     solvewin->DuctileStrain->value(SolveWinData->DuctileStrain); 
     solvewin->LoadSteps->value(SolveWinData->LoadSteps);        
     solvewin->RelEnergyFlag->value(SolveWinData->RelEnergyFlag);    
     solvewin->RelEuclidFlag->value(SolveWinData->RelEuclidFlag);  
     solvewin->EuclidFlag->value(SolveWinData->EuclidFlag); 
     solvewin->EuclidTol->value(SolveWinData->EuclidTol); 
     solvewin->RelEuclidTol->value(SolveWinData->RelEuclidTol); 
     solvewin->RelEnergyTol->value(SolveWinData->RelEnergyTol);  
     solvewin->PreCondType->value(SolveWinData->PreCondType);  
     solvewin->ContFlag->value(SolveWinData->ContFlag);  
     solvewin->SSORFlag->value(SolveWinData->SSORFlag); 
     solvewin->CheckTime->value(SolveWinData->CheckTime); 

 
}


/*------------------------------------------------------------------------------
     PrintSolveWinData   !abgendert -a06-!
------------------------------------------------------------------------------*/
void PrintSolveWinData(SolveWinStruct *SolveWinData) 
{
    printf("\n------------------------------\n");
    printf("SolverMethod:  (0=J, 1=GS, 2=BJ)  %i\n",SolveWinData->SolverMethod); 
    printf("Omega:                            %f\n",SolveWinData->Omega);
    printf("OptFactorFlag:                    %i\n",SolveWinData->OptFactorFlag);
    printf("BSplineFlag:                      %i\n",SolveWinData->BSplineFlag);
    printf("B-Spline order:                   %i\n",SolveWinData->BSpOrderK);
    printf("YMsmoothFlag:                     %i\n",SolveWinData->YMsmoothFlag);  
    printf("Repititions:                      %f\n",SolveWinData->Repititions);
    printf("NLRadius:                         %f\n",SolveWinData->NLRadius);
    printf("Limit Strain:                     %f\n",SolveWinData->LimitStrain);
    printf("Ductile Strain:                   %f\n",SolveWinData->DuctileStrain);
    printf("LoadSteps:                        %i\n",SolveWinData->LoadSteps);
    printf("\n------------------------------\n");
}




