/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
/*********************************************************************************
                               MAIN PROGRAM OF SOLVER
********************************************************************************/
void MesherMainLoop()
{  

    
    double  lx,ly,lz;
    double  mu;
    
    int     min_num_nodes;
    int     num_levels;
    
    double  *K_matrix, *K_matrixQ9;
    
    
    MGBlock *Meshes;


    
    SolveBlock *SolBlock;
    
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    MeshWinStruct *MeshWinData;
    GraphicBlock *graphblock;
    MyMainWindowUI   *mainwin;
    
   
    
    PutGetAllWinStruct(1, &AllWinData);
    GeomWinData=AllWinData->GeomWinData; 
    MeshWinData=AllWinData->MeshWinData;   
    
    PutGetSolveBlock(1,&SolBlock);             
                                           
    lx=GeomWinData->lx;
    ly=GeomWinData->ly;
    lz=GeomWinData->lz;
    
    
    
    min_num_nodes=(MeshWinData->MinDof)/2;
    mu=0.2; 
    
    if (1==(SolBlock->MeshDefined)) FreeSolveBlock(SolBlock);
    (SolBlock->MeshDefined)=1;
    
    //if (0!=(SolBlock->NumMaterials)) 
    //{
    //    FreeMaterialBlock(SolBlock->Material);
    //(SolBlock->MeshDefined)=1;
    //SolBlock->NumMaterials=0;
    //}
    CreateMeshes(lx, ly, min_num_nodes, &num_levels, &Meshes);     
    //GetStiffnessMatrix(mu, lz, Meshes[0].la, Meshes[0].lb, &K_matrix); 
    //GetStiffnessMatrixPStrain(mu, lz, Meshes[0].la, Meshes[0].lb, &K_matrix);
    //GetStiffnessMatrixQ9(mu, lz, Meshes[0].la, Meshes[0].lb, &K_matrixQ9);
    
    SolBlock->Meshes=Meshes;
    SolBlock->num_levels=num_levels;
    //SolBlock->K_matrix=K_matrix;
    //SolBlock->K_matrixQ9=K_matrixQ9;
    
    PutGetGraphicBlock(1, &graphblock);
    graphblock->show_level=num_levels-1;
    graphblock->detail_level=graphblock->show_level;
    
    PutGetMainWindow(1, &mainwin);
    mainwin->Level->maximum((int)(num_levels-1));
    mainwin->Level->value((int)(num_levels-1)); 
    mainwin->Detail->maximum((int)(num_levels-1));
    mainwin->Detail->value((int)(num_levels-1));
    
    return;
}



/*********************************************************************************
                                 SUBROUTINES
********************************************************************************/


/*------------------------------------------------------------------------------
     CalcElementSizes
-------------------------------------------------------------------------------*/
int CalcElementSizes(double lx, double ly, int min_num_nodes, int *num_elem_x, int *num_elem_y, int *num_levels)
{
    int nex,ney;
    int nnx,nny; 
    int i;
        
    if (lx <= ly)
    {
        nex=2;
    	ney=(int)floor(ly/(lx/2));
    }
    else
    {
        ney=2;
        nex=(int)floor(lx/(ly/2));
    }
    
    (*num_elem_x)=nex;
    (*num_elem_y)=ney;
    
    nnx=nex+1;
    nny=ney+1;
    
    for (i=0; (((nnx*nny) < min_num_nodes) || i<2); i++) 
    {  
        nnx=nex+1;
	    nny=ney+1;
	    nex*=2;
	    ney*=2;	  
     
      
    }
    
    (*num_levels)=i;
    return 0;
}



/*------------------------------------------------------------------------------
     CreateMeshes
-------------------------------------------------------------------------------*/
int  CreateMeshes(double lx, double ly, int min_num_nodes, int *num_levels, MGBlock **Mesh_in)
{
    int i;
    int num_elem_x;
    int num_elem_y;
    MGBlock *Meshes;

    CalcElementSizes(lx, ly, min_num_nodes, &num_elem_x, &num_elem_y, num_levels);
   
    InitMGData (Mesh_in, (*num_levels));
   // if (num_levels<2) num_levels=2;  
    Meshes=(*Mesh_in);
    for (i=0; i<(*num_levels); i++)
    {
        InitMGBlock2and3d(lx, ly, 1.0, num_elem_x, num_elem_y, 0, &(Meshes[i]));
        num_elem_x*=2;
	    num_elem_y*=2;

    }
    return 0;
}

/*------------------------------------------------------------------------------
     CreateFlexibleMeshes
-------------------------------------------------------------------------------*/
int  CreateFlexibleMeshes(int nx, int ny,  int num_levels, MGBlock **Mesh_in)
{
    int i;
    int num_elem_x;
    int num_elem_y;

    MGBlock *Meshes;

    
    num_elem_x=nx;
    num_elem_y=ny;  
     
    InitMGData (Mesh_in, (num_levels));
    Meshes=(*Mesh_in);
    for (i=0; i<(num_levels); i++)
    {
       
        InitMGBlock2and3d((double)num_elem_x, (double)num_elem_y, 1.0, 
                                  num_elem_x, num_elem_y, 0, &(Meshes[i]));
      
        num_elem_x*=2;
	    num_elem_y*=2;

    }
    return 0;
}




/*------------------------------------------------------------------------------
     CircularField
-------------------------------------------------------------------------------*/
int CircularField(double xc,double yc, double r, double value, MGBlock *Mesh)
{
    double la,lb;
    int nex,ney;
    double x,y;
    int i;
    int j;
    int ne;
    double step;
    double *M;
    
    la=Mesh->la;
    lb=Mesh->lb;
    nex=Mesh->nex;
    ney=Mesh->ney;
    M=Mesh->MatFieldE;
      
    for(i = 0; i < nex; i++)
    {    
 	    for(j = 0; j < ney; j++)
        {
            x = (i+0.5)*la;
            y = (j+0.5)*lb;
             
	        if (((x-xc)*(x-xc) + (y-yc)*(y-yc) - r*r) < 0)   
	        {
	             M[i+nex*j] = value;
	        }
        }
    }   
  
    return(1);
}


/*------------------------------------------------------------------------------
     CreateMatFieldOnMesh
-------------------------------------------------------------------------------*/
int CreateMatFieldOnMesh(MGBlock *Mesh)
{   
    int nex,ney;
    double lx,ly;
    double E_matrix;
    double E_incl;
    double *M;
    
    int i,j;
    
    E_matrix=10000.0;
    E_incl=  20000.0;
    
    nex=Mesh->nex;
    ney=Mesh->ney;
    
    lx=(Mesh->la)*nex;
    ly=(Mesh->lb)*ney;
    
    M=Mesh->MatFieldE;
    
    
    for(i = 0; i < nex; i++)
    {    
	for(j = 0; j < ney; j++)
        {
	        M[i+nex*j] = E_matrix;  
        }
    }

   CircularField((0.4*lx), (0.4*ly), (0.38*ly), E_incl,  Mesh);
   CircularField((0.7*lx), (0.2*ly), (0.1*ly), E_incl,  Mesh);
   CircularField((0.6*lx), (0.6*ly), (0.15*ly), E_incl, Mesh);

   return(1); 
}



