/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


/*---------------------------------------------------------
	MGSolver
----------------------------------------------------------*/

void MGSolver(int num_iterations, int num_levels, double *K_matrix, 
SolveWinStruct *SolveWinData, SolveBlock *SolBlock, MGBlock *M, MGBlock *Meshes)   
{    
int i, j, ii, iii, c, length;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *P, *Q;
int lambda;


    Omega=1.0;    
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    
    i=0;
    while (0==num_iterations || i<num_iterations)     
    {              
        i++;
        for(j=1; j<(num_levels-1);j++)
        {
            P=&(Meshes[j]);           
            
            ChangeTimeFlag(9);
            GetRestoringForce2(M->nnx, M->nny, M->MatFieldE, 
                M->MatFieldInt, SolBlock->Material,
                M->Ux,  M->Uy, M->Fx, M->Fy, 
                M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            
            ChangeTimeFlag(4);  
            TransForceOnCoarseMesh(M->nnx, M->nny, M->Fx, M->Fy,
                               P->nnx, P->nny, P->BcValueX, P->BcValueY);
            
            ChangeTimeFlag(7);                           
            SetVectorToZero_double((P->nnx*P->nny),  P->Ux);  
            SetVectorToZero_double((P->nnx*P->nny),  P->Uy);           
            
            c=num_levels-j;
            Repitition_int= c*c*((int)Repititions);
            printf("Repitition_int: %i",Repitition_int);
            ChangeTimeFlag(10);
            for(ii=0; ii<Repitition_int; ii++)//((num_levels-j)*(num_levels-j))
            {
               GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
               P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            }
            
            ChangeTimeFlag(5);
            InterpolDispsOnFineMesh(P->nnx, P->nny, P->Ux,  P->Uy,
                                M->nnx, M->nny, M->dUx, M->dUy, M->weights);
            
            ChangeTimeFlag(12);
            lambda=1;            
            AddIncrement(M->nnx, M->nny, M->Ux,  M->Uy, M->dUx, M->dUy,
                M->BcTypeX, M->BcTypeY, lambda);
            
            ChangeTimeFlag(10);  
            GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
            M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            ChangeTimeFlag(7);
        }

        if(0==num_iterations)
        {
            SolBlock->err2=err2;               
            SolBlock->i=i;
            iii=MyControl();
            if (1==iii) return;
        }
    }
return;
}

/*---------------------------------------------------------
	MGSolverVariable
----------------------------------------------------------*/

void MGSolverVariable(int num_iterations, int num_levels, double *K_matrix, 
SolveWinStruct *SolveWinData, SolveBlock *SolBlock, MGBlock *M, MGBlock *Meshes)   
{    
int i, j, ii, iii, c, length;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *P, *Q;
int lambda;
int *cycle;
int SSORFlag;

//int cycle[20]={6,1,5,4,4,4,3,4,2,4,3,4,4,4,5,4,6,4,-1,-1};
/*int cycle[24]={6,0,
              1,180,
              6,1,
              2,125,
              6,1,
              3,80,
              6,1,
              4,45,
              6,1,
              5,20,
              6,1,
              -1,-1}; */// entspricht MGSolver (Computers&Structures)
/*int cycle[28]={6,0,
               5,4,
               4,4,
               3,4,
               2,4,
               1,4,
               0,4,
               1,4,
               2,4,
               3,4,
               4,4,
               5,4,
               6,4,
               -1,-1}; */ // entspricht dem MGVCycle              
/*int cycle[12]={6,0,
               4,4,
               2,4,
               4,4,
               6,4,
              -1,-1}; */              
    ChangeTimeFlag(7);
    if (0==num_iterations) {ReadCycle(); printf("\nCycle is read!\n");}
    if ((num_levels-1)!=SolBlock->cycle[0]) CreateCycle();
    cycle=SolBlock->cycle;
    
    SSORFlag=SolBlock->SSORFlag;
    Omega=1.0;    
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    
    i=0;
    c=-2;
    while (0==num_iterations || i<num_iterations)     
    {              
        
        c+=2;
        if (0>cycle[c]) {c=0; i++; if (num_iterations!=0 && i>=num_iterations) return;}
        //printf("c:%i",c);
        
        if(cycle[c]>cycle[c+2])
        {
            M=&(Meshes[cycle[c]]);
            P=&(Meshes[cycle[c+2]]);    
        }
        else
        {
            M=&(Meshes[cycle[c+2]]);
            P=&(Meshes[cycle[c]]);    
        }        
        
        if (0==c)
        {
            ChangeTimeFlag(10);
                for(ii=0; ii<cycle[c+1]; ii++)
                GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
                M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
        }
        
        if (cycle[c+2]>(-1) && cycle[c+2]<cycle[c])
        {
            ChangeTimeFlag(9);
            GetRestoringForce2(M->nnx, M->nny, M->MatFieldE, M->MatFieldInt, SolBlock->Material,
                M->Ux,  M->Uy, M->Fx, M->Fy, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            ChangeTimeFlag(4);
            TransForceOnCoarseMesh(M->nnx, M->nny, M->Fx, M->Fy,
                                   P->nnx, P->nny, P->BcValueX, P->BcValueY);
            ChangeTimeFlag(12);                  
            SetVectorToZero_double((P->nnx*P->nny),  P->Ux);  
            SetVectorToZero_double((P->nnx*P->nny),  P->Uy);           
    
            ChangeTimeFlag(10);  
                for(ii=0; ii<cycle[c+3]; ii++)
            {
                   GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
                   P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            }
        }
       
        if (cycle[c+2]>(-1) && cycle[c+2]>cycle[c])
        {
            ChangeTimeFlag(5); 
            InterpolDispsOnFineMesh(P->nnx, P->nny, P->Ux,  P->Uy,
                                M->nnx, M->nny, M->dUx, M->dUy, M->weights);
            lambda=1;  
            ChangeTimeFlag(12);          
            AddIncrement(M->nnx, M->nny, M->Ux,  M->Uy, M->dUx, M->dUy,
                M->BcTypeX, M->BcTypeY, lambda);
            ChangeTimeFlag(10); 
            for(ii=0; ii<cycle[c+3]; ii++)//((num_levels-j)*(num_levels-j))
            {
                GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
                M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            }
        }

        if(0==num_iterations && 0==c)
        {
            SolBlock->err2=err2;               
            SolBlock->i=i;
            iii=MyControl();
            if (1==iii) return;
        }
    }
return;
}

/*---------------------------------------------------------
	ReadCycle
----------------------------------------------------------*/

void ReadCycle()
{
  FILE    *inp;
  int     i;
  int     *vector;
  int     length;
  SolveBlock *SolBlock;

  PutGetSolveBlock(1,&SolBlock); 
      
  if ((inp = fopen("./cycle.tmp","rb"))==NULL) return; 
 
  //if (SolBlock->cycle_len>0) free(SolBlock->cycle);
  fscanf(inp,"%i,\n",&length);
  InitVector_int(length,&vector);
  
  for(i=0; i<length; i+=2)
  {
      fscanf(inp,"%i,%i,\n", vector+i,vector+i+1);
      //printf("%i,%i,%i\n",i,vector[i],vector+i+1);
  } 
  fclose(inp);
  
  if (SolBlock->cycle_len>0) free(SolBlock->cycle);
  SolBlock->cycle_len=length;
  SolBlock->cycle=vector;
  
  return;
}

/*---------------------------------------------------------
	WriteCycle
----------------------------------------------------------*/

void WriteCycle()
{
  FILE    *outp;
  int     i;
  int     *vector;
  int     length;
  SolveBlock *SolBlock;

  PutGetSolveBlock(1,&SolBlock); 
      
  if ((outp = fopen("./cycle.tmp","wb"))==NULL) return; 
  
  fprintf(outp,"%i\n",SolBlock->cycle_len);
  for(i=0; i<SolBlock->cycle_len; i+=2)
  fprintf(outp,"%i,%i,\n",SolBlock->cycle[i],SolBlock->cycle[i+1]);
  fclose(outp);   

  return;
}

/*---------------------------------------------------------
	CreateCycle
----------------------------------------------------------*/

void CreateCycle()
{
  SolveBlock *SolBlock;
  int num_levels;
  int i,j,c,flag,cc,first,second;
  int length, tmp;
  int *vector;
  int CycleType;
  int Smooth;
  MyInputSolveWindowUI* solvewin;
 
  PutGetSolveInputWindow(1, &solvewin);
  
  CycleType=(int) solvewin->Cycle->value(); 
  printf("\nCycle Type:%i\n",CycleType);
  Smooth=(int) solvewin->Smooth->value(); 
  
  PutGetSolveBlock(1,&SolBlock); 
  if (SolBlock->cycle_len>0) free(SolBlock->cycle);
  
  num_levels=SolBlock->num_levels;
  
  if (0==CycleType) // V-Cycle
  {
      length=num_levels*4;
      InitVector_int(length,&vector);
      
      c=num_levels;
      flag=0;
      
      for(i=0; i<length; i+=2)
      {
          if (0==flag) c--; else c++;
          vector[i]=c; vector[i+1]=Smooth;
          if (0==c) flag=1;
      }
      
      vector[length-2]=-1;
      vector[length-1]=-1;
  }
  
  if (1==CycleType) // F-Cycle
  {
      length=(num_levels+(num_levels-1)*(num_levels-1))*2+2;
      InitVector_int(length,&vector);
      
      c=num_levels;
      flag=0;
      cc=1;
      for(i=0; i<length/2; i++)
      {
          if (0==flag) c--; else c++;
          vector[i*2]=c; vector[i*2+1]=Smooth;
          if (0==c) flag=1;
          if (1==flag && c==cc) {cc++; flag=0;}
      }
      
      vector[length-2]=-1;
      vector[length-1]=-1;
  }
  
  if (2==CycleType) // W-Cycle
  {
      length=2;
      for(i=0; i<(num_levels-1); i++)
      length*=2;
      
      tmp=length-1;
      length*=2;
      InitVector_int(length,&vector);
      
      for(i=0; i<length; i++) 
      vector[i]=-1;
      
      vector[0]=num_levels-1;
      vector[(tmp-1)]=num_levels-1;
      
      cc=num_levels-2;
     
      do
      {
          for(i=0; i<tmp; i++)
          {
              if(((i-1)>-1) && ((i-1)<tmp)) if ((cc+1)==vector[i-1] && -1==vector[i]) vector[i]=cc;
              if(((i+1)>-1) && ((i+1)<tmp)) if ((cc+1)==vector[i+1] && -1==vector[i]) vector[i]=cc;
          }
          
          
          i=0;
          while(cc!=vector[i]) {i++;}
          first=i; i++; 
          
          while(i<tmp)
          {
             while(cc!=vector[i] && i<tmp) {i++;}
             if(i<tmp)
             {
                 second=i;// printf("first:%i second:%i cc:%i i:%i\n",first,second,cc,i);getchar();
                 if(-1==(vector[(first+second)/2])) vector[(first+second)/2]=cc;
                 first=second; i++;
             }          
          }
          cc--;
      }
      while (0<cc);
      
      for(i=0; i<tmp; i++)
      if (-1==vector[i]) vector[i]=0;
      
      for(i=tmp-1; i>=0; i--)
      vector[i*2]=vector[i];
      
      for(i=0; i<tmp; i++)
      vector[i*2+1]=Smooth; 
      
      vector[length-2]=-1;
      vector[length-1]=-1;
  }
  
  if (3==CycleType) // Modified Cycle
  {
      length=(num_levels)*4;
      
      InitVector_int(length,&vector);
      
      for(i=0; i<length; i++) 
      vector[i]=-1;
      
      vector[0]=num_levels-1;
      
      first=0;
      
      for(i=0; i<length-2; i+=4)
      {
        vector[i]=num_levels-1;
        vector[i+1]=Smooth;
        vector[i+2]=first; 
        vector[i+3]=(num_levels-1-first)*(num_levels-1-first)*Smooth;
        first++;
      }
      vector[length-2]=-1;
      vector[length-1]=-1;
  
  }
  

  
  SolBlock->cycle_len=length;
  SolBlock->cycle=vector; 
  WriteCycle();

  return;
}


/*---------------------------------------------------------
	MGSolver2and3d
----------------------------------------------------------*/

void MGSolver2and3d(int num_levels, double *K_matrix, SolveWinStruct *SolveWinData, 
                       SolveBlock *SolBlock, MGBlock *M, MGBlock *Meshes)   
{    
int i, j, ii, iii, c, length;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *P, *Q;
double lambda;
int ModelDim;

    ModelDim=PutGetModelDim(1,123);


    Omega=1.0;    
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    
    
    for(i=0; i<100000; i++)      
    {              
        
        for(j=1; j<(num_levels-1);j++)
        {
            printf("Iteration: %i Level: %i\n",i,j);
            P=&(Meshes[j]);           
            
            
            
            if (2==ModelDim)
                GetRestoringForce2(M->nnx, M->nny, M->MatFieldE, 
                M->MatFieldInt, SolBlock->Material,
                M->Ux,  M->Uy, M->Fx, M->Fy, 
                M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            else    
                GetRestoringForce3d(M->nnx, M->nny, M->nnz, SolBlock->Material, M->MatFieldE, 
        	    M->MatFieldInt, M->Ux,  M->Uy, M->Uz, M->Fx,  M->Fy, M->Fz,
                M->BcTypeX, M->BcTypeY, M->BcTypeZ, M->BcValueX, M->BcValueY, M->BcValueZ);
            
            printf("1: \n");
            
            if (2==ModelDim)  
                TransForceOnCoarseMesh(M->nnx, M->nny, M->Fx, M->Fy,
                               P->nnx, P->nny, P->BcValueX, P->BcValueY);
            else
                TransForceOnCoarseMesh3d(M->nnx, M->nny, M->nnz, 
                M->Fx, M->Fy, M->Fz, P->nnx, P->nny, P->nnz,
                P->BcValueX, P->BcValueY, P->BcValueZ);
            
            printf("2: \n");                          
            if (2==ModelDim)
            {
                SetVectorToZero_double((P->nnx*P->nny),  P->Ux);  
                SetVectorToZero_double((P->nnx*P->nny),  P->Uy);           
            }
            else
            {
                SetVectorToZero_double((P->nnx*P->nny*P->nnz),  P->Ux);  
                SetVectorToZero_double((P->nnx*P->nny*P->nnz),  P->Uy);  
                SetVectorToZero_double((P->nnx*P->nny*P->nnz),  P->Uz);              
            }
            
            printf("3: \n");  
            
            c=num_levels-j;
            Repitition_int= c*c*((int)Repititions);

            if (2==ModelDim)
            for(ii=0; ii<Repitition_int; ii++)//((num_levels-j)*(num_levels-j))
            {
               GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
               P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            }
            else
            for(ii=0; ii<Repitition_int; ii++)//((num_levels-j)*(num_levels-j))
            {
               GetLocalDisplacements_GS_3d(P->nnx, P->nny, P->nnz, SolBlock->Material, P->MatFieldE, 
               P->MatFieldInt, P->Ux,  P->Uy, P->Uz, Omega, P->BcTypeX, P->BcTypeY, P->BcTypeZ, P->BcValueX, P->BcValueY, P->BcValueZ);
             
            }
            printf("4: \n"); 
            
            if (2==ModelDim)
            InterpolDispsOnFineMesh(P->nnx, P->nny, P->Ux,  P->Uy,
                                M->nnx, M->nny, M->dUx, M->dUy, M->weights);
            else
            InterpolDispsOnFineMesh3d(P->nnx, P->nny, P->nnz, P->Ux,  P->Uy, P->Uz,
                  M->nnx, M->nny, M->nnz, M->dUx, M->dUy, M->dUz, M->weights);
            
            printf("5: \n"); 
            lambda=1.0;   
            
            if (2==ModelDim)                  
            AddIncrement(M->nnx, M->nny, M->Ux,  M->Uy, M->dUx, M->dUy,
                M->BcTypeX, M->BcTypeY, lambda);
            else 
            AddIncrement3d(M->nnx, M->nny, M->nnz, M->Ux,  M->Uy, M->Uz, 
                           M->dUx, M->dUy, M->dUz,M->BcTypeX, M->BcTypeY, M->BcTypeZ, lambda);

            printf("6: \n");
            if (2==ModelDim)  
            GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
            M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            else
            GetLocalDisplacements_GS_3d(M->nnx, M->nny, M->nnz, SolBlock->Material, M->MatFieldE, 
            M->MatFieldInt, M->Ux,  M->Uy, M->Uz, Omega, M->BcTypeX, M->BcTypeY, M->BcTypeZ, M->BcValueX, M->BcValueY, M->BcValueZ);
             
            
            
        }
        
        SolBlock->err2=err2;               
        SolBlock->i=i;
        iii=MyControl();
        if (1==iii) return;
    }
return;
}


/*---------------------------------------------------------
	MGSolver3d
----------------------------------------------------------*/

void MGSolver3d(int num_levels, double *K_matrix, SolveWinStruct *SolveWinData, 
                       SolveBlock *SolBlock, MGBlock *M, MGBlock *Meshes)   
{    
int i, j, ii, iii, c, length;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *P, *Q;
double lambda;
int ModelDim;

    ModelDim=PutGetModelDim(1,123);


    Omega=1.0;    
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    
    
    for(i=0; i<100000; i++)      
    {              
        
        for(j=1; j<(num_levels-1);j++)
        {
            printf("Iteration: %i Level: %i\n",i,j);
            P=&(Meshes[j]);           
// iii=MyControl();
                ChangeTimeFlag(9);
                GetRestoringForce3d(M->nnx, M->nny, M->nnz, SolBlock->Material, M->MatFieldE, 
        	    M->MatFieldInt, M->Ux,  M->Uy, M->Uz, M->Fx,  M->Fy, M->Fz,
                M->BcTypeX, M->BcTypeY, M->BcTypeZ, M->BcValueX, M->BcValueY, M->BcValueZ);
            
//            printf("1: \n");
//iii=MyControl();
                ChangeTimeFlag(4);  
                TransForceOnCoarseMesh3d(M->nnx, M->nny, M->nnz, 
                M->Fx, M->Fy, M->Fz, P->nnx, P->nny, P->nnz,
                P->BcValueX, P->BcValueY, P->BcValueZ);
//        iii=MyControl();    
//            printf("2: \n");                          

//iii=MyControl();
                ChangeTimeFlag(7);  
                SetVectorToZero_double((P->nnx*P->nny*P->nnz),  P->Ux);  
                SetVectorToZero_double((P->nnx*P->nny*P->nnz),  P->Uy);  
                SetVectorToZero_double((P->nnx*P->nny*P->nnz),  P->Uz);              

            
//            printf("3: \n");  
//    iii=MyControl();        
            c=num_levels-j;
            Repitition_int= c*c*((int)Repititions);

            ChangeTimeFlag(10);
            for(ii=0; ii<Repitition_int; ii++)//((num_levels-j)*(num_levels-j))
            {
               GetLocalDisplacements_GS_3d(P->nnx, P->nny, P->nnz, SolBlock->Material, P->MatFieldE, 
               P->MatFieldInt, P->Ux,  P->Uy, P->Uz, Omega, P->BcTypeX, P->BcTypeY, P->BcTypeZ, P->BcValueX, P->BcValueY, P->BcValueZ);
             
            }
//            printf("4: \n"); 
//iii=MyControl();
            ChangeTimeFlag(5);
            InterpolDispsOnFineMesh3d(P->nnx, P->nny, P->nnz, P->Ux,  P->Uy, P->Uz,
                  M->nnx, M->nny, M->nnz, M->dUx, M->dUy, M->dUz, M->weights);
           
//            printf("5: \n"); 
            lambda=1.0;   
//iii=MyControl();
            ChangeTimeFlag(12);
            AddIncrement3d(M->nnx, M->nny, M->nnz, M->Ux,  M->Uy, M->Uz, 
                           M->dUx, M->dUy, M->dUz,M->BcTypeX, M->BcTypeY, M->BcTypeZ, lambda);

//            printf("6: \n");
//            iii=MyControl();
            ChangeTimeFlag(10);
            GetLocalDisplacements_GS_3d(M->nnx, M->nny, M->nnz, SolBlock->Material, M->MatFieldE, 
            M->MatFieldInt, M->Ux,  M->Uy, M->Uz, Omega, M->BcTypeX, M->BcTypeY, M->BcTypeZ, M->BcValueX, M->BcValueY, M->BcValueZ);
//             iii=MyControl();
       }
        
        SolBlock->err2=err2;               
        SolBlock->i=i;
        iii=MyControl();
        if (1==iii) return;
    }
return;
}

/*---------------------------------------------------------
	MGVCycle
----------------------------------------------------------*/

void MGVCycle(int num_iterations, int num_levels, double *K_matrix, SolveWinStruct *SolveWinData, 
                       SolveBlock *SolBlock, MGBlock *M, MGBlock *Meshes)   
{    
int i, j, ii, iii, c, length;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *P, *Q;
int lambda;


    Omega=1.0;    
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    
    i=0;
    while (0==num_iterations || i<num_iterations)     
    {    
        i++;             
        MGSubVCycle((num_levels-1), SolveWinData, SolBlock, Meshes);    
        if(0==num_iterations)
        {
            SolBlock->err2=err2;               
            SolBlock->i=i;
            iii=MyControl();
            if (1==iii) return;
        }
    }
return;
}

/*---------------------------------------------------------
	MGSubVCycle
----------------------------------------------------------*/

void MGSubVCycle(int act_level, SolveWinStruct *SolveWinData, 
                       SolveBlock *SolBlock, MGBlock *Meshes)     
{    
int i, j, ii, iii, c, length;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *M, *P, *Q;
int lambda;


    Omega=1.0;    
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    
    
    for(i=0; i<100000; i++)      
    {       
            if (act_level<1) return;      
            M=&(Meshes[act_level]);
            P=&(Meshes[act_level-1]);           
            
            ChangeTimeFlag(9);
            GetRestoringForce2(M->nnx, M->nny, M->MatFieldE, 
                M->MatFieldInt, SolBlock->Material,
                M->Ux,  M->Uy, M->Fx, M->Fy, 
                M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            
            ChangeTimeFlag(4);  
            TransForceOnCoarseMesh(M->nnx, M->nny, M->Fx, M->Fy,
                               P->nnx, P->nny, P->BcValueX, P->BcValueY);
            
            ChangeTimeFlag(7);                           
            SetVectorToZero_double((P->nnx*P->nny),  P->Ux);  
            SetVectorToZero_double((P->nnx*P->nny),  P->Uy);           
            
            ChangeTimeFlag(10);
            GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
            P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
            P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
            P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            GetLocalDisplacements_GS_real3(P->nnx, P->nny, SolBlock->Material, P->MatFieldE,
            P->MatFieldInt, P->Ux,  P->Uy, Omega, P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY);
            act_level--;
            MGSubVCycle(act_level, SolveWinData, SolBlock, Meshes);  
            
            
            ChangeTimeFlag(5);
            InterpolDispsOnFineMesh(P->nnx, P->nny, P->Ux,  P->Uy,
                                M->nnx, M->nny, M->dUx, M->dUy, M->weights);
            
            ChangeTimeFlag(12);
            lambda=1;            
            AddIncrement(M->nnx, M->nny, M->Ux,  M->Uy, M->dUx, M->dUy,
                M->BcTypeX, M->BcTypeY, lambda);
            
            ChangeTimeFlag(10);  
            GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
            M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            ChangeTimeFlag(7);
            GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
            M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY);
            GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
            M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            ChangeTimeFlag(7);
            GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
            M->MatFieldInt, M->Ux,  M->Uy, Omega, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
            ChangeTimeFlag(7);
        }
        
    
return;
}

/*---------------------------------------------------------
	TEST1
----------------------------------------------------------*/

void TEST1()
{
    
    SolveBlock *SolBlock;
    MGBlock *P, *M, *Meshes;
    int i,j,k;
    int num_levels;

    PutGetSolveBlock(1,&SolBlock); 
    
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    
    M=&(Meshes[num_levels-1]);
    P=&(Meshes[num_levels-3]);
    
    for(i=0; i<(P->nnx); i++)
    for(j=0; j<(P->nny); j++)
    for(k=0; k<(P->nnz); k++)
    P->Ux[i+j*P->nnx+k*P->nnx*P->nny]=double (k+j+i);
    
    
    InterpolDispsOnFineMesh3d(P->nnx, P->nny, P->nnz, P->Ux,  P->Uy, P->Uz,
                M->nnx, M->nny, M->nnz, M->Ux, M->Uy, M->Uz, M->weights);
    printf("\nInterpoliert!\n");
return;
}

/*---------------------------------------------------------
	TEST2
----------------------------------------------------------*/

void TEST2()
{
    
    SolveBlock *SolBlock;
    MGBlock *P, *M, *Meshes;
    int i,j,k;
    int num_levels;

    PutGetSolveBlock(1,&SolBlock); 
    
    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;
    
    M=&(Meshes[num_levels-1]);
    P=&(Meshes[num_levels-3]);
    
    for(i=0; i<(M->nnx); i++)
    for(j=0; j<(M->nny); j++)
    for(k=0; k<(M->nnz); k++)
    M->Ux[i+j*M->nnx+k*M->nnx*M->nny]=double (10.0);
    
    TransForceOnCoarseMesh3d(M->nnx, M->nny, M->nnz, 
                M->Ux, M->Uy, M->Uz, P->nnx, P->nny, P->nnz,
                P->Ux, P->Uy, P->Uz);
    

    printf("\nInterpoliert!\n");
return;
}

/*---------------------------------------------------------
	OneMGCycle
----------------------------------------------------------*/

int OneMGCycle(MGBlock *Meshes, int num_levels, double Omega,
               double Repititions, double *K_matrix,
               double *act_error)
{

   MGBlock *M, *P;
   int j;
   int ii;
   double err1;
   double err2;
   double lambda;
   int    Repitition_int;
   
   M=&(Meshes[num_levels-1]); 
               
   for(j=1; j<(num_levels-1);j++)
        {
            P=&(Meshes[j]);           
            
            GetRestoringForce(M->nnx, M->nny, K_matrix, M->MatFieldE, 
                M->Ux,  M->Uy, M->Fx, M->Fy, &err1, &err2, 
                M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
                
            (*act_error)=err2;
                  
            TransForceOnCoarseMesh(M->nnx, M->nny, M->Fx, M->Fy,
                               P->nnx, P->nny, P->BcValueX, P->BcValueY);
                        
            SetVectorToZero_double((P->nnx*P->nny),  P->Ux);  
            SetVectorToZero_double((P->nnx*P->nny),  P->Uy);           
            
            Repitition_int= (int) ( ((double)(num_levels-j))
                                    *((double)(num_levels-j))
                                    *   Repititions);
           
            for(ii=0; ii<Repitition_int; ii++)//((num_levels-j)*(num_levels-j))
            {
                GetLocalDisplacements_GS_real(P->nnx, P->nny, K_matrix, P->MatFieldE, 
                P->dUx, P->dUy, P->Ux,  P->Uy, P->Fx, P->Fy, &err1,&err1, Omega,
                P->BcTypeX, P->BcTypeY, P->BcValueX, P->BcValueY); 
            }
                       
            
            InterpolDispsOnFineMesh(P->nnx, P->nny, P->Ux,  P->Uy,
                                M->nnx, M->nny, M->dUx, M->dUy, M->weights);
           
            lambda=1;            
            AddIncrement(M->nnx, M->nny, M->Ux,  M->Uy, M->dUx, M->dUy,
                M->BcTypeX, M->BcTypeY, lambda);
             
            GetLocalDisplacements_GS_real(M->nnx, M->nny, K_matrix, M->MatFieldE, 
            M->dUx, M->dUy, M->Ux,  M->Uy, M->Fx, M->Fy, &err1,&err1, Omega,
            M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
        }
   return(1);
}







