/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"
#include "MyMainWindowUI.h"


#include <math.h>
#include <stdio.h>

/* Mulgrido */

int main () {
    MainRoutine();
    return 0;
    }
    
int MainRoutine()
{    
    static int argc;
    static char **argv;
    int i;
    float r;
    
    
    InitGraphicBlock( );
    InitSolveBlock( );
    InitSamplePoints(10);
            
    MyMainWindowUI* mainwin;
    MyInputGeomWindowUI* geomwin;
    MyInputMeshWindowUI* meshwin;
    MyInputMesoWindowUI* mesowin;
    MyInputLoadWindowUI* loadwin;
    MyInputSolveWindowUI* solvewin;
    MyFileBaseWindowUI* basewin;
    MyInputAboutWindowUI* aboutwin;
    
    static AllWinStruct AllWinData_s;
    static AllWinStruct *AllWinData_p;
    static AllWinStruct **AllWinData_dp;
    
    
    GeomWinStruct *GeomWinData;
    MesoWinStruct *MesoWinData;
    MeshWinStruct *MeshWinData;
    LoadWinStruct *LoadWinData;
        
    AllWinData_p=&AllWinData_s;
    AllWinData_dp=&AllWinData_p; 
       
    
    //Fl::scheme("plastic");
    
    mainwin = new MyMainWindowUI();
    PutGetMainWindow(0, &mainwin);
    PutGetGraphicWindow(0, &(mainwin->g_window));
    mainwin->m_window->show();
    mainwin->g_window->redraw();
    
    
    geomwin = new MyInputGeomWindowUI();
    //geomwin->m_window->callback(window_callback);
    geomwin->m_window->hide();
    PutGetGeomInputWindow(0, &geomwin);
    
    aboutwin = new MyInputAboutWindowUI();
    aboutwin->m_window->hide();
    PutGetAboutInputWindow(0, &aboutwin);
    
    meshwin = new MyInputMeshWindowUI();
    meshwin->m_window->hide();
    PutGetMeshInputWindow(0, &meshwin);
    
          
    mesowin = new MyInputMesoWindowUI();
    mesowin->m_window->hide();
    PutGetMesoInputWindow(0, &mesowin);
    
    
    loadwin = new MyInputLoadWindowUI();
    loadwin->m_window->hide();
    loadwin->m_window3d->hide();
    PutGetLoadInputWindow(0, &loadwin);
    
    
    solvewin = new MyInputSolveWindowUI();
    solvewin->m_window->hide();
    PutGetSolveInputWindow(0, &solvewin);
    
    basewin = new MyFileBaseWindowUI();
    basewin->m_window->hide();
    PutGetBaseFileWindow(0, &basewin);
    
    PutGetAllWinStruct(0, AllWinData_dp);
    InitAllWinStruct(AllWinData_p);
    
    MeshWinData=AllWinData_p->MeshWinData; 
    StoreMeshWinData(meshwin,MeshWinData);  
    
    GeomWinData=AllWinData_p->GeomWinData; 
    StoreGeomWinData(geomwin,GeomWinData);      
    
    MesoWinData=AllWinData_p->MesoWinData; 
    StoreMesoWinData(mesowin,MesoWinData);          
    
    LoadWinData=AllWinData_p->LoadWinData;
    LoadWinData->num_loads=0; 
    LoadWinData->num_loads3d=0; 
                             
                                                                                              
    Fl::run();
    return 0;
}

    

