/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
// generated by Fast Light User Interface Designer (fluid) version 1.0107

#ifndef MyMainWindowUI_h
#define MyMainWindowUI_h
#include <FL/Fl.H>
class MyGraphicsWindow;
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Roller.H>
#include <FL/Fl_Value_Output.H>
#include <FL/Fl_Slider.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Text_Display.H>

class MyMainWindowUI {
public:
  MyMainWindowUI();
  Fl_Double_Window *m_window;
  MyGraphicsWindow *g_window;
private:
  void cb_Redraw_i(Fl_Round_Button*, void*);
  static void cb_Redraw(Fl_Round_Button*, void*);
  void cb_Zoom_i(Fl_Roller*, void*);
  static void cb_Zoom(Fl_Roller*, void*);
public:
  Fl_Value_Output *ZoomDisplay;
  Fl_Value_Output *MinX;
  Fl_Value_Output *MaxX;
  Fl_Value_Output *MinY;
  Fl_Value_Output *MaxY;
private:
  void cb__i(Fl_Slider*, void*);
  static void cb_(Fl_Slider*, void*);
  void cb_1_i(Fl_Slider*, void*);
  static void cb_1(Fl_Slider*, void*);
public:
  Fl_Choice *Choice2dold;
  static Fl_Menu_Item menu_Choice2dold[];
private:
  void cb_Nothing_i(Fl_Menu_*, void*);
  static void cb_Nothing(Fl_Menu_*, void*);
  void cb_Material_i(Fl_Menu_*, void*);
  static void cb_Material(Fl_Menu_*, void*);
  void cb_Color_i(Fl_Menu_*, void*);
  static void cb_Color(Fl_Menu_*, void*);
  void cb_E_i(Fl_Menu_*, void*);
  static void cb_E(Fl_Menu_*, void*);
  void cb_Displacement_i(Fl_Menu_*, void*);
  static void cb_Displacement(Fl_Menu_*, void*);
  void cb_Displacement1_i(Fl_Menu_*, void*);
  static void cb_Displacement1(Fl_Menu_*, void*);
  void cb_Increment_i(Fl_Menu_*, void*);
  static void cb_Increment(Fl_Menu_*, void*);
  void cb_Increment1_i(Fl_Menu_*, void*);
  static void cb_Increment1(Fl_Menu_*, void*);
  void cb_Unbalanced_i(Fl_Menu_*, void*);
  static void cb_Unbalanced(Fl_Menu_*, void*);
  void cb_Unbalanced1_i(Fl_Menu_*, void*);
  static void cb_Unbalanced1(Fl_Menu_*, void*);
  void cb_Increment2_i(Fl_Menu_*, void*);
  static void cb_Increment2(Fl_Menu_*, void*);
  void cb_Increment3_i(Fl_Menu_*, void*);
  static void cb_Increment3(Fl_Menu_*, void*);
  void cb_Strain_i(Fl_Menu_*, void*);
  static void cb_Strain(Fl_Menu_*, void*);
  void cb_Strain1_i(Fl_Menu_*, void*);
  static void cb_Strain1(Fl_Menu_*, void*);
  void cb_Strain2_i(Fl_Menu_*, void*);
  static void cb_Strain2(Fl_Menu_*, void*);
  void cb_Stress_i(Fl_Menu_*, void*);
  static void cb_Stress(Fl_Menu_*, void*);
  void cb_Stress1_i(Fl_Menu_*, void*);
  static void cb_Stress1(Fl_Menu_*, void*);
  void cb_Stress2_i(Fl_Menu_*, void*);
  static void cb_Stress2(Fl_Menu_*, void*);
  void cb_Mises_i(Fl_Menu_*, void*);
  static void cb_Mises(Fl_Menu_*, void*);
  void cb_Eq_i(Fl_Menu_*, void*);
  static void cb_Eq(Fl_Menu_*, void*);
  void cb_Damage_i(Fl_Menu_*, void*);
  static void cb_Damage(Fl_Menu_*, void*);
  void cb_NLEq_i(Fl_Menu_*, void*);
  static void cb_NLEq(Fl_Menu_*, void*);
public:
  Fl_Choice *Choice3d;
  static Fl_Menu_Item menu_Choice3d[];
private:
  void cb_Nothing1_i(Fl_Menu_*, void*);
  static void cb_Nothing1(Fl_Menu_*, void*);
  void cb_Material1_i(Fl_Menu_*, void*);
  static void cb_Material1(Fl_Menu_*, void*);
  void cb_Color1_i(Fl_Menu_*, void*);
  static void cb_Color1(Fl_Menu_*, void*);
  void cb_E1_i(Fl_Menu_*, void*);
  static void cb_E1(Fl_Menu_*, void*);
  void cb_Displacement2_i(Fl_Menu_*, void*);
  static void cb_Displacement2(Fl_Menu_*, void*);
  void cb_Displacement3_i(Fl_Menu_*, void*);
  static void cb_Displacement3(Fl_Menu_*, void*);
  void cb_Displacement4_i(Fl_Menu_*, void*);
  static void cb_Displacement4(Fl_Menu_*, void*);
  void cb_Increment4_i(Fl_Menu_*, void*);
  static void cb_Increment4(Fl_Menu_*, void*);
  void cb_Increment5_i(Fl_Menu_*, void*);
  static void cb_Increment5(Fl_Menu_*, void*);
  void cb_Increment6_i(Fl_Menu_*, void*);
  static void cb_Increment6(Fl_Menu_*, void*);
  void cb_Unbalanced2_i(Fl_Menu_*, void*);
  static void cb_Unbalanced2(Fl_Menu_*, void*);
  void cb_Unbalanced3_i(Fl_Menu_*, void*);
  static void cb_Unbalanced3(Fl_Menu_*, void*);
  void cb_Unbalanced4_i(Fl_Menu_*, void*);
  static void cb_Unbalanced4(Fl_Menu_*, void*);
  void cb_Increment7_i(Fl_Menu_*, void*);
  static void cb_Increment7(Fl_Menu_*, void*);
  void cb_Increment8_i(Fl_Menu_*, void*);
  static void cb_Increment8(Fl_Menu_*, void*);
  void cb_Increment9_i(Fl_Menu_*, void*);
  static void cb_Increment9(Fl_Menu_*, void*);
  void cb_Strain3_i(Fl_Menu_*, void*);
  static void cb_Strain3(Fl_Menu_*, void*);
  void cb_Strain4_i(Fl_Menu_*, void*);
  static void cb_Strain4(Fl_Menu_*, void*);
  void cb_Strain5_i(Fl_Menu_*, void*);
  static void cb_Strain5(Fl_Menu_*, void*);
  void cb_Strain6_i(Fl_Menu_*, void*);
  static void cb_Strain6(Fl_Menu_*, void*);
  void cb_Strain7_i(Fl_Menu_*, void*);
  static void cb_Strain7(Fl_Menu_*, void*);
  void cb_Strain8_i(Fl_Menu_*, void*);
  static void cb_Strain8(Fl_Menu_*, void*);
  void cb_Stress3_i(Fl_Menu_*, void*);
  static void cb_Stress3(Fl_Menu_*, void*);
  void cb_Stress4_i(Fl_Menu_*, void*);
  static void cb_Stress4(Fl_Menu_*, void*);
  void cb_Stress5_i(Fl_Menu_*, void*);
  static void cb_Stress5(Fl_Menu_*, void*);
  void cb_Stress6_i(Fl_Menu_*, void*);
  static void cb_Stress6(Fl_Menu_*, void*);
  void cb_Stress7_i(Fl_Menu_*, void*);
  static void cb_Stress7(Fl_Menu_*, void*);
  void cb_Stress8_i(Fl_Menu_*, void*);
  static void cb_Stress8(Fl_Menu_*, void*);
  void cb_Mises1_i(Fl_Menu_*, void*);
  static void cb_Mises1(Fl_Menu_*, void*);
  void cb_Eq1_i(Fl_Menu_*, void*);
  static void cb_Eq1(Fl_Menu_*, void*);
  void cb_NLEq1_i(Fl_Menu_*, void*);
  static void cb_NLEq1(Fl_Menu_*, void*);
public:
  Fl_Choice *Choice2d;
  static Fl_Menu_Item menu_Choice2d[];
private:
  void cb_Nothing2_i(Fl_Menu_*, void*);
  static void cb_Nothing2(Fl_Menu_*, void*);
  void cb_Material2_i(Fl_Menu_*, void*);
  static void cb_Material2(Fl_Menu_*, void*);
  void cb_Color2_i(Fl_Menu_*, void*);
  static void cb_Color2(Fl_Menu_*, void*);
  void cb_E2_i(Fl_Menu_*, void*);
  static void cb_E2(Fl_Menu_*, void*);
  void cb_Displacement5_i(Fl_Menu_*, void*);
  static void cb_Displacement5(Fl_Menu_*, void*);
  void cb_Displacement6_i(Fl_Menu_*, void*);
  static void cb_Displacement6(Fl_Menu_*, void*);
  void cb_Strain9_i(Fl_Menu_*, void*);
  static void cb_Strain9(Fl_Menu_*, void*);
  void cb_Straina_i(Fl_Menu_*, void*);
  static void cb_Straina(Fl_Menu_*, void*);
  void cb_Strainb_i(Fl_Menu_*, void*);
  static void cb_Strainb(Fl_Menu_*, void*);
  void cb_Stress9_i(Fl_Menu_*, void*);
  static void cb_Stress9(Fl_Menu_*, void*);
  void cb_Stressa_i(Fl_Menu_*, void*);
  static void cb_Stressa(Fl_Menu_*, void*);
  void cb_Stressb_i(Fl_Menu_*, void*);
  static void cb_Stressb(Fl_Menu_*, void*);
  void cb_Macro_i(Fl_Button*, void*);
  static void cb_Macro(Fl_Button*, void*);
  void cb_Mesh_i(Fl_Button*, void*);
  static void cb_Mesh(Fl_Button*, void*);
  void cb_Meso_i(Fl_Button*, void*);
  static void cb_Meso(Fl_Button*, void*);
  void cb_Loads_i(Fl_Button*, void*);
  static void cb_Loads(Fl_Button*, void*);
  void cb_Solve_i(Fl_Button*, void*);
  static void cb_Solve(Fl_Button*, void*);
  void cb_Color3_i(Fl_Value_Slider*, void*);
  static void cb_Color3(Fl_Value_Slider*, void*);
public:
  Fl_Counter *Level;
private:
  void cb_Level_i(Fl_Counter*, void*);
  static void cb_Level(Fl_Counter*, void*);
  void cb_Cont_i(Fl_Button*, void*);
  static void cb_Cont(Fl_Button*, void*);
  void cb_Pause_i(Fl_Button*, void*);
  static void cb_Pause(Fl_Button*, void*);
  void cb_Step_i(Fl_Button*, void*);
  static void cb_Step(Fl_Button*, void*);
  void cb_Stop_i(Fl_Button*, void*);
  static void cb_Stop(Fl_Button*, void*);
  void cb_Deflect_i(Fl_Value_Input*, void*);
  static void cb_Deflect(Fl_Value_Input*, void*);
  void cb_Frames_i(Fl_Value_Input*, void*);
  static void cb_Frames(Fl_Value_Input*, void*);
public:
  Fl_Check_Button *ShowValues;
private:
  void cb_ShowValues_i(Fl_Check_Button*, void*);
  static void cb_ShowValues(Fl_Check_Button*, void*);
  void cb_File_i(Fl_Button*, void*);
  static void cb_File(Fl_Button*, void*);
  void cb_Energy_i(Fl_Button*, void*);
  static void cb_Energy(Fl_Button*, void*);
  void cb_EX_i(Fl_Button*, void*);
  static void cb_EX(Fl_Button*, void*);
  void cb_PSave_i(Fl_Button*, void*);
  static void cb_PSave(Fl_Button*, void*);
  void cb_2_i(Fl_Value_Input*, void*);
  static void cb_2(Fl_Value_Input*, void*);
  void cb_RX_i(Fl_Roller*, void*);
  static void cb_RX(Fl_Roller*, void*);
  void cb_RZ_i(Fl_Roller*, void*);
  static void cb_RZ(Fl_Roller*, void*);
  void cb_Z_i(Fl_Value_Input*, void*);
  static void cb_Z(Fl_Value_Input*, void*);
  void cb_Smooth_i(Fl_Button*, void*);
  static void cb_Smooth(Fl_Button*, void*);
  void cb_3_i(Fl_Value_Input*, void*);
  static void cb_3(Fl_Value_Input*, void*);
  void cb_PostSmooth_i(Fl_Round_Button*, void*);
  static void cb_PostSmooth(Fl_Round_Button*, void*);
  void cb_Iso_i(Fl_Value_Input*, void*);
  static void cb_Iso(Fl_Value_Input*, void*);
  void cb_Grid_i(Fl_Round_Button*, void*);
  static void cb_Grid(Fl_Round_Button*, void*);
  void cb_B_i(Fl_Round_Button*, void*);
  static void cb_B(Fl_Round_Button*, void*);
  void cb_Draw_i(Fl_Round_Button*, void*);
  static void cb_Draw(Fl_Round_Button*, void*);
  void cb_Patch_i(Fl_Round_Button*, void*);
  static void cb_Patch(Fl_Round_Button*, void*);
  void cb_Size_i(Fl_Value_Input*, void*);
  static void cb_Size(Fl_Value_Input*, void*);
  void cb_Thick_i(Fl_Value_Input*, void*);
  static void cb_Thick(Fl_Value_Input*, void*);
  void cb_Extr_i(Fl_Value_Input*, void*);
  static void cb_Extr(Fl_Value_Input*, void*);
  void cb_Data_i(Fl_Button*, void*);
  static void cb_Data(Fl_Button*, void*);
  void cb_Screenshot_i(Fl_Button*, void*);
  static void cb_Screenshot(Fl_Button*, void*);
  void cb_Sequence_i(Fl_Round_Button*, void*);
  static void cb_Sequence(Fl_Round_Button*, void*);
  void cb_Sequence1_i(Fl_Round_Button*, void*);
  static void cb_Sequence1(Fl_Round_Button*, void*);
  void cb_Read_i(Fl_Button*, void*);
  static void cb_Read(Fl_Button*, void*);
  void cb_Rotate_i(Fl_Round_Button*, void*);
  static void cb_Rotate(Fl_Round_Button*, void*);
  void cb_Draw1_i(Fl_Round_Button*, void*);
  static void cb_Draw1(Fl_Round_Button*, void*);
public:
  Fl_Counter *Detail;
private:
  void cb_Detail_i(Fl_Counter*, void*);
  static void cb_Detail(Fl_Counter*, void*);
public:
  Fl_Button *ResetView;
private:
  void cb_ResetView_i(Fl_Button*, void*);
  static void cb_ResetView(Fl_Button*, void*);
public:
  Fl_Button *IsoView;
private:
  void cb_IsoView_i(Fl_Button*, void*);
  static void cb_IsoView(Fl_Button*, void*);
public:
  Fl_Round_Button *Showroom;
private:
  void cb_Showroom_i(Fl_Round_Button*, void*);
  static void cb_Showroom(Fl_Round_Button*, void*);
  void cb_TEST1_i(Fl_Button*, void*);
  static void cb_TEST1(Fl_Button*, void*);
  void cb_TEST2_i(Fl_Button*, void*);
  static void cb_TEST2(Fl_Button*, void*);
  void cb_GoL_i(Fl_Button*, void*);
  static void cb_GoL(Fl_Button*, void*);
public:
  Fl_Value_Slider *x_section;
  Fl_Value_Slider *y_section;
private:
  void cb_Section_i(Fl_Button*, void*);
  static void cb_Section(Fl_Button*, void*);
public:
  Fl_Round_Button *FinerSplines;
private:
  void cb_FinerSplines_i(Fl_Round_Button*, void*);
  static void cb_FinerSplines(Fl_Round_Button*, void*);
public:
  Fl_Value_Input *Factor;
private:
  void cb_Factor_i(Fl_Value_Input*, void*);
  static void cb_Factor(Fl_Value_Input*, void*);
  void cb_Sxx_i(Fl_Button*, void*);
  static void cb_Sxx(Fl_Button*, void*);
  void cb_Syy_i(Fl_Button*, void*);
  static void cb_Syy(Fl_Button*, void*);
  void cb_Sxy_i(Fl_Button*, void*);
  static void cb_Sxy(Fl_Button*, void*);
  void cb_Cir_i(Fl_Button*, void*);
  static void cb_Cir(Fl_Button*, void*);
  void cb_E11_i(Fl_Button*, void*);
  static void cb_E11(Fl_Button*, void*);
  void cb_E21_i(Fl_Button*, void*);
  static void cb_E21(Fl_Button*, void*);
  void cb_EY_i(Fl_Button*, void*);
  static void cb_EY(Fl_Button*, void*);
  void cb_GO_i(Fl_Button*, void*);
  static void cb_GO(Fl_Button*, void*);
  void cb_About_i(Fl_Button*, void*);
  static void cb_About(Fl_Button*, void*);
};

class MyInputGeomWindowUI {
public:
  MyInputGeomWindowUI();
  Fl_Double_Window *m_window;
  Fl_Value_Input *Length;
  Fl_Value_Input *Height;
  Fl_Value_Input *Depth;
private:
  void cb_OK_i(Fl_Button*, void*);
  static void cb_OK(Fl_Button*, void*);
  void cb_Cancel_i(Fl_Button*, void*);
  static void cb_Cancel(Fl_Button*, void*);
public:
  Fl_Value_Slider *ModelDim;
};

class MyInputMeshWindowUI {
public:
  MyInputMeshWindowUI();
  Fl_Double_Window *m_window;
private:
  void cb_OK1_i(Fl_Button*, void*);
  static void cb_OK1(Fl_Button*, void*);
  void cb_Cancel1_i(Fl_Button*, void*);
  static void cb_Cancel1(Fl_Button*, void*);
public:
  Fl_Value_Input *MinDof;
};

class MyInputMesoWindowUI {
public:
  MyInputMesoWindowUI();
  Fl_Double_Window *m_window;
  Fl_Value_Input *E_Matrix;
  Fl_Value_Input *E_Inclusion;
  Fl_Value_Input *Mu_Matrix;
  Fl_Value_Input *Mu_Inclusion;
  Fl_Value_Input *MinSize;
  Fl_Value_Input *MaxSize;
  Fl_Value_Input *VolFraction;
  Fl_Round_Button *FullerFlag;
  Fl_Value_Input *FullerExponent;
  Fl_Value_Slider *Smoothness;
  Fl_Value_Slider *Compactness;
  Fl_Text_Display *Longishness;
  Fl_Value_Slider *Deformed;
  Fl_Value_Slider *Roughness;
  Fl_Round_Button *DeformedFlag;
private:
  void cb_Generate_i(Fl_Button*, void*);
  static void cb_Generate(Fl_Button*, void*);
  void cb_Cancel2_i(Fl_Button*, void*);
  static void cb_Cancel2(Fl_Button*, void*);
public:
  Fl_Value_Input *E_Material;
  Fl_Value_Input *MaterialNumBegin;
private:
  void cb_MaterialNumBegin_i(Fl_Value_Input*, void*);
  static void cb_MaterialNumBegin(Fl_Value_Input*, void*);
  void cb_Apply_i(Fl_Button*, void*);
  static void cb_Apply(Fl_Button*, void*);
public:
  Fl_Value_Input *MaterialNumEnd;
private:
  void cb_MaterialNumEnd_i(Fl_Value_Input*, void*);
  static void cb_MaterialNumEnd(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *Mu_Material;
private:
  void cb_Apply1_i(Fl_Button*, void*);
  static void cb_Apply1(Fl_Button*, void*);
  void cb_Finish_i(Fl_Button*, void*);
  static void cb_Finish(Fl_Button*, void*);
public:
  Fl_Round_Button *AddFlag;
private:
  void cb_Material3_i(Fl_Button*, void*);
  static void cb_Material3(Fl_Button*, void*);
public:
  Fl_Round_Button *RoughFlag;
  Fl_Value_Input *la;
private:
  void cb_la_i(Fl_Value_Input*, void*);
  static void cb_la(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *lb;
private:
  void cb_lb_i(Fl_Value_Input*, void*);
  static void cb_lb(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *lc;
  Fl_Value_Input *lx;
private:
  void cb_lx_i(Fl_Value_Input*, void*);
  static void cb_lx(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *ly;
private:
  void cb_ly_i(Fl_Value_Input*, void*);
  static void cb_ly(Fl_Value_Input*, void*);
public:
  Fl_Value_Input *lz;
  Fl_Value_Input *nex;
  Fl_Value_Input *ney;
  Fl_Value_Input *nez;
private:
  void cb_Invisible_i(Fl_Button*, void*);
  static void cb_Invisible(Fl_Button*, void*);
  void cb_Visible_i(Fl_Button*, void*);
  static void cb_Visible(Fl_Button*, void*);
};
#include <FL/Fl_Browser.H>

class MyInputLoadWindowUI {
public:
  MyInputLoadWindowUI();
  Fl_Double_Window *m_window;
private:
  void cb_Add_i(Fl_Button*, void*);
  static void cb_Add(Fl_Button*, void*);
public:
  Fl_Choice *PrimFlag;
  static Fl_Menu_Item menu_PrimFlag[];
  Fl_Choice *NumFlag;
  static Fl_Menu_Item menu_NumFlag[];
  Fl_Choice *PhyFlag;
  static Fl_Menu_Item menu_PhyFlag[];
  Fl_Value_Input *BCVal;
  Fl_Browser *BCBrowse;
private:
  void cb_OK2_i(Fl_Button*, void*);
  static void cb_OK2(Fl_Button*, void*);
  void cb_Delete_i(Fl_Button*, void*);
  static void cb_Delete(Fl_Button*, void*);
public:
  Fl_Value_Input *DelVal;
private:
  void cb_Delete1_i(Fl_Button*, void*);
  static void cb_Delete1(Fl_Button*, void*);
public:
  Fl_Value_Input *BCPot;
  Fl_Double_Window *m_window3d;
private:
  void cb_Add1_i(Fl_Button*, void*);
  static void cb_Add1(Fl_Button*, void*);
public:
  Fl_Choice *PrimFlag3d;
  static Fl_Menu_Item menu_PrimFlag3d[];
  Fl_Choice *NumFlag3d;
  static Fl_Menu_Item menu_NumFlag3d[];
  Fl_Choice *PhyFlag3d;
  static Fl_Menu_Item menu_PhyFlag3d[];
  Fl_Value_Input *BCVal3d;
  Fl_Browser *BCBrowse3d;
private:
  void cb_OK3_i(Fl_Button*, void*);
  static void cb_OK3(Fl_Button*, void*);
  void cb_Delete2_i(Fl_Button*, void*);
  static void cb_Delete2(Fl_Button*, void*);
public:
  Fl_Value_Input *DelVal3d;
private:
  void cb_Delete3_i(Fl_Button*, void*);
  static void cb_Delete3(Fl_Button*, void*);
public:
  Fl_Value_Input *BCPot3d;
};

class MyInputSolveWindowUI {
public:
  MyInputSolveWindowUI();
  Fl_Double_Window *m_window;
  Fl_Round_Button *OptFactorFlag;
  Fl_Value_Input *Omega;
  Fl_Choice *SolverMethod;
  static Fl_Menu_Item menu_SolverMethod[];
private:
  void cb_OK4_i(Fl_Button*, void*);
  static void cb_OK4(Fl_Button*, void*);
  void cb_Cancel3_i(Fl_Button*, void*);
  static void cb_Cancel3(Fl_Button*, void*);
public:
  Fl_Value_Input *Repititions;
  Fl_Value_Input *NLRadius;
  Fl_Value_Input *LimitStrain;
  Fl_Value_Input *DuctileStrain;
  Fl_Value_Input *LoadSteps;
  Fl_Round_Button *BSplineFlag;
  Fl_Value_Input *BSpOrderK;
  Fl_Round_Button *EuclidFlag;
  Fl_Round_Button *RelEnergyFlag;
  Fl_Value_Input *EuclidTol;
  Fl_Value_Input *RelEnergyTol;
  Fl_Choice *PreCondType;
  static Fl_Menu_Item menu_PreCondType[];
  Fl_Check_Button *YMsmoothFlag;
  Fl_Check_Button *ContFlag;
  Fl_Check_Button *CircleElementFlag;
  Fl_Check_Button *CircleIntpntFlag;
  Fl_Choice *Cycle;
  static Fl_Menu_Item menu_Cycle[];
private:
  void cb_Create_i(Fl_Button*, void*);
  static void cb_Create(Fl_Button*, void*);
public:
  Fl_Value_Input *Smooth;
  Fl_Round_Button *RelEuclidFlag;
  Fl_Value_Input *RelEuclidTol;
  Fl_Round_Button *SSORFlag;
  Fl_Value_Input *CheckTime;
};
#include <FL/Fl_File_Input.H>

class MyFileBaseWindowUI {
public:
  MyFileBaseWindowUI();
  Fl_Double_Window *m_window;
private:
  void cb_OK5_i(Fl_Button*, void*);
  static void cb_OK5(Fl_Button*, void*);
  void cb_Cancel4_i(Fl_Button*, void*);
  static void cb_Cancel4(Fl_Button*, void*);
public:
  Fl_Check_Button *Check_Save;
private:
  void cb_Check_Save_i(Fl_Check_Button*, int*);
  static void cb_Check_Save(Fl_Check_Button*, int*);
public:
  Fl_Check_Button *Check_Open;
private:
  void cb_Check_Open_i(Fl_Check_Button*, int*);
  static void cb_Check_Open(Fl_Check_Button*, int*);
public:
  Fl_Round_Button *geometry;
  Fl_Round_Button *Loads;
  Fl_File_Input *File_Input;
  Fl_Round_Button *Results;
};
#include <FL/Fl_Text_Editor.H>

class MyInputAboutWindowUI {
public:
  MyInputAboutWindowUI();
  Fl_Double_Window *m_window;
private:
  void cb_OK6_i(Fl_Button*, void*);
  static void cb_OK6(Fl_Button*, void*);
};
#endif
