/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


/*------------------------------------------------------------------------------
     InitMaterialBlock
------------------------------------------------------------------------------*/
void InitMaterialBlock(int num, MaterialBlock **M)
{
    int i;
    int c=2;            // just any value to allocate M->K such that "free" is possible at any time.
    MaterialBlock *Mat; 
    
    *M = (MaterialBlock *) malloc(sizeof(MaterialBlock)*(num));
    Mat=*M;
    for(i=0; i<num; i++)
    {
        Mat[i].E=0.0;
        Mat[i].Mu=0.0;
        InitVector_double(c, &(Mat[i].K));  
        Mat[i].Visible=1;   
    }
    return;
}

/*------------------------------------------------------------------------------
     FreeMaterialBlock
------------------------------------------------------------------------------*/
void FreeMaterialBlock(int num, MaterialBlock *M)
{
    int i;
    
    for(i=0; i<num; i++)
    {
        free(M[i].K);     
    }
    free(M);
    return;
}

/*------------------------------------------------------------------------------
     CopyMaterialBlock
------------------------------------------------------------------------------*/
void CopyMaterialBlock(int num, MaterialBlock *Mnew, MaterialBlock *Mold)
{
    int i;
    
    for(i=0; i<num; i++)
    {
        Mnew[i].E=Mold[i].E;
        Mnew[i].Mu=Mold[i].Mu;     
    }
    return;
}

/*------------------------------------------------------------------------------
     MaterialInfo
------------------------------------------------------------------------------*/
void MaterialInfo()
{
    int i;
    int num;
    MaterialBlock *M;
    SolveBlock *SolBlock;
        
    PutGetSolveBlock(1,&SolBlock); 
    M=SolBlock->Material;
    num=SolBlock->NumMaterials;
    
    printf("\n");
    for(i=0; i<num; i++)
    {
        printf("Material Number: %i   E-Modul: %f   Poisson's ratio: %f   Visible: %i\n",
        i, M[i].E, M[i].Mu, M[i].Visible);     
    }

    return;
}

/*------------------------------------------------------------------------------
     CreateColorIndex2and3d
------------------------------------------------------------------------------*/
void CreateColorIndex2and3d()
{
    int i,j,k,p,nn,nnn,mm,m;
    SolveBlock *SolBlock;
    int nex,ney,nez,nxy,NumMat,ActIndex,cont,nnsize, num_levels;
    int *ColorIndex, *MatFieldInt;
    MGBlock *M;
    int *FreeMap;
    int *FreeList;
    int LenList;
    int ModelDim;
    int z,zz;
    
    z=0;zz=0;    
    ModelDim=PutGetModelDim(1,123);
    PutGetSolveBlock(1,&SolBlock); 
    num_levels=SolBlock->num_levels;
    M=&(SolBlock->Meshes[num_levels-1]);
    NumMat=SolBlock->NumMaterials;
    ColorIndex=M->ColorIndex;
    MatFieldInt=M->MatFieldInt;
    nex=M->nex;
    ney=M->ney;
    if (2==ModelDim) nnsize=nex*ney;
    else {nez=M->nez; nnsize=nex*ney*nez;}
    printf("\nCreate-Color Index\n");

    ActIndex=-1;
    
    // Abuse BcTypeX and ByTypeY as int-Field for lists!
    FreeMap= M->BcTypeX;
    FreeList=M->BcTypeY;
    SetVectorToZero_int(nnsize,  FreeMap);
      
    for(i=0; i<nnsize; i++)
    {
        M->ColorIndex[i]=-1; 
        FreeList[i]=i;   
    }    
    
    LenList=nnsize;
    
    if (2==ModelDim)
    {
    for(k=0; k<NumMat; k++)
    for(nnn=0; nnn<LenList; nnn++)
    {
    nn=FreeList[nnn];
    while(-1==ColorIndex[nn] &&  k==MatFieldInt[nn])
    {

        ActIndex++;
        ColorIndex[nn]=ActIndex;
        cont=1;
        while (0!=cont)
        {
            
            cont=0;zz=0;
            for(mm=0; mm<LenList; mm++)
            {
                zz++;
                m=FreeList[mm];
                if(k==MatFieldInt[m] && -1==ColorIndex[m])
                {
                    p=m-nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m-nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m-nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m-1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m+1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m+nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m+nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                    p=m+nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate;}      
                }                
                
                NextCoordinate:;
                
            }
            printf("zz:%i",zz);
        }
                z++;
            printf("z:%i\n",z);
        UpdateList(FreeMap, FreeList, &LenList);
    }
    }
    }
    else
    {
    nxy=nex*ney;
    for(k=0; k<NumMat; k++)
    for(nnn=0; nnn<LenList; nnn++)
    {
    nn=FreeList[nnn];
    while(-1==ColorIndex[nn] &&  k==MatFieldInt[nn])
    {

        ActIndex++;
        ColorIndex[nn]=ActIndex;
        cont=1;
        while (0!=cont)
        {
            cont=0;
            for(mm=0; mm<LenList; mm++)
            {
                m=FreeList[mm];
                if(k==MatFieldInt[m] && -1==ColorIndex[m])
                {
                    p=m-nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex-1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-1+nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+1+nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex-1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex-nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-1-nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+1-nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                
                }                
                NextCoordinate3d:;
            }
        }

        UpdateList(FreeMap, FreeList, &LenList);
    }
    }
    }
    
    ActIndex++;
    M->NumColIndex=ActIndex;
    printf("Finish-Color Index\n");
    ReSortColorIndex2and3d();
    return;
}

/*------------------------------------------------------------------------------
     CreateColorIndexB
------------------------------------------------------------------------------*/
void CreateColorIndexB()
{
    int i,j,k,p,nn,nnn,mm,m;
    SolveBlock *SolBlock;
    int nex,ney,nez,nxy,NumMat,ActIndex,cont,nnsize, num_levels;
    int *ColorIndex, *MatFieldInt;
    MGBlock *M;
    int *FreeMap;
    int *FreeList;
    int LenList;
    int ModelDim;
    int LastFound;
    int FirstFound;
    int nex2;
  

    

    LastFound=0;  
    ModelDim=PutGetModelDim(1,123);
    PutGetSolveBlock(1,&SolBlock); 
    num_levels=SolBlock->num_levels;
    M=&(SolBlock->Meshes[num_levels-1]);
    NumMat=SolBlock->NumMaterials;
    ColorIndex=M->ColorIndex;
    MatFieldInt=M->MatFieldInt;
    nex=M->nex;
    ney=M->ney;
    nex2=2*nex;
    if (2==ModelDim) nnsize=nex*ney;
    else {nez=M->nez; nnsize=nex*ney*nez;}
    printf("\nCreate-Color Index\n");

    ActIndex=-1;
    
    // Abuse BcTypeX and ByTypeY as int-Field for lists!
    FreeMap= M->BcTypeX;
    FreeList=M->BcTypeY;
    SetVectorToZero_int(nnsize,  FreeMap);
      
    for(i=0; i<nnsize; i++)
    {
        M->ColorIndex[i]=-1; 
        FreeList[i]=i;   
    }    
    
    LenList=nnsize;
    
    if (2==ModelDim)
    {
    for(k=0; k<NumMat; k++)
    {
        for(i=0; i<nnsize; i++)
        {
            FreeList[i]=i;   
        }    
        LenList=nnsize;
        UpdateMatList(k, MatFieldInt, FreeList, &LenList);
             
    for(nnn=0; nnn<LenList; nnn++)
    {
    nn=FreeList[nnn];
    while(-1==ColorIndex[nn] &&  k==MatFieldInt[nn])
    {

        ActIndex++;
        ColorIndex[nn]=ActIndex;
        cont=1;
                
        while (0!=cont)
        {
            cont=0;LastFound=nnsize;
            for(mm=0; mm<LenList; mm++)
            {
                m=FreeList[mm];
                if(-1==ColorIndex[m])
                {
                    if (m-nex2>LastFound){mm=LenList; goto NextCoordinate;}
                    p=m-nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m-nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m-nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m-1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m+1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m+nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m+nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                    p=m+nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; LastFound=p;goto NextCoordinate;}      
                }                
                NextCoordinate:;
            }
        }
        UpdateList(FreeMap, FreeList, &LenList);
    }
    }
    }
    }
    else
    {
    nxy=nex*ney;
    for(k=0; k<NumMat; k++)
    for(nnn=0; nnn<LenList; nnn++)
    {
    nn=FreeList[nnn];
    while(-1==ColorIndex[nn] &&  k==MatFieldInt[nn])
    {

        ActIndex++;
        ColorIndex[nn]=ActIndex;
        cont=1;
        while (0!=cont)
        {
            cont=0;
            for(mm=0; mm<LenList; mm++)
            {
                m=FreeList[mm];
                if(k==MatFieldInt[m] && -1==ColorIndex[m])
                {
                    p=m-nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+1;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+1; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex-1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-1+nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+1+nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+1+nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex-1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex-nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-nex+1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m-1-nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+1-nxy;     if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex-nxy;   if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                    p=m+nex+1-nxy; if (p>=0 && p<nnsize) if (ActIndex==ColorIndex[p]) {ColorIndex[m]=ActIndex; cont++; FreeMap[m]=1; goto NextCoordinate3d;}      
                
                }                
                NextCoordinate3d:;
            }
        }

        UpdateList(FreeMap, FreeList, &LenList);
    }
    }
    }
    
    ActIndex++;
    M->NumColIndex=ActIndex;
    printf("Finish-Color Index\n");
    ReSortColorIndex2and3d();
    return;
}

/*------------------------------------------------------------------------------
     CreateColorIndexC
------------------------------------------------------------------------------*/
void CreateColorIndexC()
{
    int i,j,k,p,nn,nnn,mm,m;
    SolveBlock *SolBlock;
    int nex,ney,nez,nxy,NumMat,ActIndex,cont,nnsize, num_levels;
    int *ColorIndex, *MatFieldInt;
    MGBlock *M;
    int *List1;
    int *List2;
    int ModelDim;
    int Flag, Flag2;
      
 
    ModelDim=PutGetModelDim(1,123);
    PutGetSolveBlock(1,&SolBlock); 
    num_levels=SolBlock->num_levels;
    M=&(SolBlock->Meshes[num_levels-1]);
    NumMat=SolBlock->NumMaterials;
    ColorIndex=M->ColorIndex;
    MatFieldInt=M->MatFieldInt;
    nex=M->nex;
    ney=M->ney;
    if (2==ModelDim) nnsize=nex*ney;
    else {nez=M->nez; nnsize=nex*ney*nez;}
    printf("\nCreate-Color Index\n");

    ActIndex=-1;
    
    // Abuse BcTypeX and ByTypeY as int-Field for lists!
    //List1= M->BcTypeX;
    List2= M->BcTypeY;

      
    for(i=0; i<nnsize; i++)
    {
        M->ColorIndex[i]=-1; 
        List2[i]=i;
    }    
    
    if (2==ModelDim)
    {
        for(i=0; i<nnsize; i++)
        {
            p=i-1;     if (p>=0 && p<nnsize) if (MatFieldInt[i]==MatFieldInt[p]) {ColorIndex[i]=ColorIndex[p]; goto NextCoordinate2;}
            p=i-nex-1; if (p>=0 && p<nnsize) if (MatFieldInt[i]==MatFieldInt[p]) {ColorIndex[i]=ColorIndex[p]; goto NextCoordinate2;}      
            p++;       if (p>=0 && p<nnsize) if (MatFieldInt[i]==MatFieldInt[p]) {ColorIndex[i]=ColorIndex[p]; goto NextCoordinate2;} 
            p++;       if (p>=0 && p<nnsize) if (MatFieldInt[i]==MatFieldInt[p]) {ColorIndex[i]=ColorIndex[p]; goto NextCoordinate2;} 
                 
            ActIndex++;
            ColorIndex[i]=ActIndex;
            NextCoordinate2:;  
        }
      do
      { 
        Flag=0;
        for(i=0; i<nnsize; i++)
        {
            p=i-1; if (p>=0 && p<nnsize) 
                       if ((MatFieldInt[i]==MatFieldInt[p])&&(ColorIndex[i]!=ColorIndex[p])) 
                          {
                           if (ColorIndex[i]>ColorIndex[p]) 
                               {List2[ColorIndex[p]]=ColorIndex[i];} else
                               {List2[ColorIndex[i]]=ColorIndex[p];} 
                           Flag=1;
                          }   
            p=i-nex;   if (p>=0 && p<nnsize) 
                       if ((MatFieldInt[i]==MatFieldInt[p])&&(ColorIndex[i]!=ColorIndex[p])) 
                          { 
                           if (ColorIndex[i]>ColorIndex[p]) 
                               {List2[ColorIndex[i]]=ColorIndex[p];} else
                               {List2[ColorIndex[p]]=ColorIndex[i];} 
                           Flag=1;    
                          }    
         }
         
         for(i=0; i<nnsize; i++)
         {
              if (List2[ColorIndex[i]]!=i) {ColorIndex[i]=List2[ColorIndex[i]];}         
         }
       } while (1==Flag);    
    }
    //SetVectorToZero_int(nnsize, List2);
    
    //for(i=0; i<nnsize; i++)
    //{
    //    if (0==List2[Colorindex[i]]) List2[Colorindex[i]]=1;
    //}
    
    ActIndex++;
    M->NumColIndex=ActIndex;
    printf("Finish-Color Index\n");
    ReSortColorIndex2and3d(); 
    printf("... and resorted\n");
    
    
    return;
}


/*------------------------------------------------------------------------------
     UpdateList
------------------------------------------------------------------------------*/
void UpdateList(int *Map, int *List, int *ListSize)
{
   int i,j;
   
   j=0;
   for(i=0; i<(*ListSize); i++)
   {
       if (0==Map[List[i]]) 
       {
           List[j]=List[i];
           j++;    
       }   
   }
   (*ListSize)=j;
   return;
}

/*------------------------------------------------------------------------------
     UpdateMatList
------------------------------------------------------------------------------*/
void UpdateMatList(int k, int *Map, int *List, int *ListSize)
{
   int i,j;
   
   j=0;
   for(i=0; i<(*ListSize); i++)
   {
       if (k==Map[List[i]]) 
       {
           List[j]=List[i];
           j++;    
       }   
   }
   (*ListSize)=j;
   return;
}

/*------------------------------------------------------------------------------
     ReSortColorIndex2and3d
------------------------------------------------------------------------------*/
void ReSortColorIndex2and3d()
{
    int i,j,nex,ney,nez,nnsize, NumColIndex;
    SolveBlock *SolBlock;
    int *ColorIndex;
    MGBlock *M;
    int *Area;
    int *Vector;
    int num_levels; 
    int ModelDim; 
     
    PutGetSolveBlock(1,&SolBlock); 
    num_levels=SolBlock->num_levels;
    M=&(SolBlock->Meshes[num_levels-1]);
    nex=M->nex;
    ney=M->ney;
    ModelDim=PutGetModelDim(1,123);
    if (2==ModelDim) nnsize=nex*ney;
    else {nez=M->nez; nnsize=nex*ney*nez;}
    ColorIndex=M->ColorIndex;
    NumColIndex=M->NumColIndex;
    InitVector_int(NumColIndex*2, &Area);
    InitVector_int(NumColIndex, &Vector);
    
    for(i=0; i<nnsize; i++)       Area[ColorIndex[i]+NumColIndex]++;
    for(i=0; i<NumColIndex; i++)  Area[i]=i;
    
    //for(i=0; i<NumColIndex; i++)  printf("Num: %i   Area: %i\n", i, Area[i+NumColIndex]);
    shellsort3(Area,NumColIndex,2,2,5);
    
    //for(i=0; i<NumColIndex; i++)  printf("Num: %i   Area: %i\n", Area[i], Area[i+NumColIndex]);
    
    for(i=0; i<NumColIndex; i++) 
    {
        Vector[Area[i]]=i;
    }
    
    
    for(i=0; i<nnsize; i++) 
    {
        ColorIndex[i]=Vector[ColorIndex[i]];
    }    
   
   free(Area);
   free(Vector);
   return;
}


