/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


/*---------------------------------------------------------
	NLSolver
----------------------------------------------------------*/

void NLSolver(int num_levels, double *K_matrix, SolveWinStruct *SolveWinData, 
               SolveBlock *SolBlock, MGBlock *M, MGBlock *Meshes)   
{
int i, j, ii, iii, jjj, length,ix,iy;
double tmp1, tmp2, tmp3;
double err1,err2; 
double Omega;
int Repitition_int;
double Repititions;
MGBlock *P, *Q;
int lambda;
MGBlock *MeshNL, *MNL, *PNL;
MGBlock *MeshTmp;

double Radius;
double LimitStrain;
double DuctileStrain;
double loadfactor;
double loadstep;
double maxstrain, elemnum, Zaehler, Nenner, multiplier;
int nnsize;
double firsteq, secondeq;
int    firsti, secondi;
double X,Y;

double lx,ly;
int nex,ney;
GraphicBlock *graphblock;

    PutGetGraphicBlock(1, &graphblock);

    Radius=SolveWinData->NLRadius;
    LimitStrain=SolveWinData->LimitStrain;
    DuctileStrain=SolveWinData->DuctileStrain;
    
    loadfactor=1.0;
    loadstep=0.1;      
     
    InitMGData (&MeshNL, num_levels);
    for (i=0; i<(num_levels); i++)
    {
        P=&(Meshes[i]);
        lx=((double(P->nex))*(P->la));
        ly=((double(P->ney))*(P->lb));
        nex=P->nex;
        ney=P->ney;
        Q=&(MeshNL[i]);
        InitMGBlock2and3d(lx,ly,1.0,nex,ney,0,Q);
    }
    
    
    M=&(Meshes[num_levels-1]); 
    SetVectorToZero_double(((M->nnx)*(M->nny)),  M->Kappa);  
    printf("\n Anzahl %i\n",((M->nnx)*(M->nny)) );
    
     Omega=1.0; 
       
    // First Linear Step
    i=0;
    MGCGSolver(num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
    //MGSolverVariable(0,num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
    UpdateGraphicWindow(); 
    
    printf("\n Linear ging schon gut \n"); //getchar();    
    
    // Nonlinear Incremental Step
    for(i=0; i<num_levels; i++)
    {
        CopyMGBlock(&(Meshes[i]), &(MeshNL[i]) );
    } 
          
         M=&(Meshes[num_levels-1]);
         MNL=&(MeshNL[num_levels-1]);
         
         for(jjj=0; jjj<100000; jjj++)
         {
         
         PostEqStrainCenter(M->nnx, M->nny, M->la, M->lb, M->Ux, M->Uy,
                            M->MatFieldE, M->MatFieldInt, M->Swap);
         
         PostEqStrainNonLocal(M->nnx, M->nny, M->la, M->lb, 
                            M->MatFieldInt, Radius, M->Swap, M->EqStrain);
         //printf("\n Die Dehnungen auch?! \n");getchar();   
         firsteq=0.0;    
         secondeq=0.0;
         nnsize=(((M->nnx)-1)*((M->nny)-1));                                  
         for(ix=0; ix<nex; ix++)
         for(iy=0; iy<ney; iy++)
         //for(i=0; i<nnsize; i++)
         {   i=ix+nex*iy;
         if( ( (M->EqStrain[i]) > secondeq) && ( (M->DamageOmega[i]) < 1E-12) )//&& ix>128 && ix<256) //&& ((MNL->Kappa[i])<=0.0))
             {
                 if ( (M->EqStrain[i]) > firsteq)
                 {
                     secondeq=firsteq;
                     secondi=firsti;
                     firsteq=M->EqStrain[i];
                     firsti=i;
                 }
                 else
                 {
                     secondeq=M->EqStrain[i];
                     secondi=i;
                 }
             }
             
         } 
         //iii=MyControl();printf("ich warte1\n");getchar();
         
         //printf("maxstrain %g\n",firsteq);
         printf("loadfactor %g   ",loadfactor);
         //printf("ux-mitte %g\n",M->Ux[2144]*loadfactor);
         //SaveTwoValues(loadfactor,M->Ux[2144]*loadfactor); 
         //SaveTwoValues(loadfactor,M->Ux[593]*loadfactor); // 128 --> 8513
         //SaveTwoValues(loadfactor,M->Ux[2144]*loadfactor); 
         
         loadfactor=LimitStrain/(secondeq+(firsteq-secondeq)/2);
         //Y=(secondeq+(firsteq-secondeq)/2.0);
         //X=LimitStrain+Y;
         //loadfactor=LimitStrain/Y*1.01;
         printf("\nLimitStrain: %g   Classic X: %g   New X: %g   loadfactor: %g",
         LimitStrain, Y,X,loadfactor);
         
         
         nnsize=(((M->nnx))*((M->nny)));
         for(i=0; i<nnsize; i++)
         {
             (M->Ux[i])*=loadfactor;
             (M->Uy[i])*=loadfactor;
         }
         //iii=MyControl();printf("ich warte2\n");getchar();
         nnsize=(((M->nnx)-1)*((M->nny)-1));
         for(i=0; i<nnsize; i++)
         {
             (M->EqStrain[i])*=loadfactor;
         } 
         
         for(ix=0; ix<nex; ix++)
         for(iy=0; iy<ney; iy++)
         //for(i=0; i<nnsize; i++)
         {   i=ix+nex*iy;
             if( (M->EqStrain[i])>(M->Kappa[i]) )
             {
                 (M->Kappa[i])=(M->EqStrain[i]);
                 (MNL->Kappa[i])=1.0;
             }
             else
             {
                 (MNL->Kappa[i])=-1.0;
             }
             if(((M->Kappa[i])>LimitStrain)  && ((MNL->Kappa[i])==1.0) )// && ix>128 && ix<256)
             {
                 (M->DamageOmega[i])=1.0-LimitStrain/(M->Kappa[i])
                 *exp(-((M->Kappa[i])-LimitStrain)/(DuctileStrain-LimitStrain));
             }
             else
             {
                 //(M->DamageOmega[i])=0.0;
             }
             (M->MatFieldE[i])=(1-M->DamageOmega[i])*(MNL->MatFieldE[i]);
             if (M->MatFieldE[i]<1E-8) M->MatFieldE[i]=1E-8;
         } 
         
         TransMatFieldToCoarse(Meshes, num_levels);    
         // iii=MyControl();printf("ich warte3\n");getchar();
         
         //UpdateGraphicWindow();
         /* Stop Process to create Images */
        // if (jjj==200 || jjj==385 || jjj==552 || jjj==595 || jjj==620 )
         if (jjj==2000)
         {
              printf("\njjj=%i\n",jjj);
              (graphblock->TMP)=1;
              iii=MyControl();
         } 
         
         
         nnsize=(((M->nnx))*((M->nny)));
         for(i=0; i<nnsize; i++)
         {
             (M->Ux[i])/=loadfactor;
             (M->Uy[i])/=loadfactor;
         }                                                                                                                            
         
         for(i=0; i<nnsize; i++)
         {
             if (M->DamageOmega[i]>1E-12) M->ColorIndex[i]=1;
             else M->ColorIndex[i]=0; 
         }
         M->ColorIndex[firsti]=2;
         
         i=0;
         iii=0;
         
         //SetVectorToZero_double(((M->nnx)*(M->nny)),  M->Ux);  
         //SetVectorToZero_double(((M->nnx)*(M->nny)),  M->Uy);           
         MGCGSolver(num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
         //MGSolverVariable(0,num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);

         //UpdateGraphicWindow(); 
         
         for(i=0; i<nnsize; i++)
         {
             (MNL->Ux[i])=(M->Ux[i]);
             (MNL->Uy[i])=(M->Uy[i]);
         } 
         nnsize=(((M->nnx)-1)*((M->nny)-1));            
         for(i=0; i<nnsize; i++)
         {
         (M->MatFieldE[i])=(MNL->MatFieldE[i]);
         }
    }

return;
}
