/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


/*---------------------------------------------------------
	InitQuadraticBSplines
----------------------------------------------------------*/
void InitQuadraticBSplines()
{
    int i,j;
    int numpoly, numcoeff;
    SolveBlock *SolBlock;
    BSplineBlock *BSP;
    PolynomStruct *P;
    double *C;
    
    PutGetSolveBlock(1,&SolBlock);
    BSP=&(SolBlock->BSplines);
    
    BSP->numpoly=3;
    numpoly=BSP->numpoly;
    
    numcoeff=3;
    
    BSP=&(SolBlock->BSplines);
    
     // Left BC, Middle, Right BC + Derivatives
     // 6 for x and 6 for y
    
    for(i=0; i<12; i++) 
    {
        InitPolynomStruct(&(BSP->Polynomials[i].Polynom), numpoly);
        
        for(j=0; j<numcoeff; j++)
        {
          BSP->Polynomials[i].Polynom[j].numcoeff=numcoeff;
          InitVector_double(numcoeff, &(BSP->Polynomials[i].Polynom[j].coefficient));
        }
    }  

return;
}

/*---------------------------------------------------------
	SetQuadraticBSplines
----------------------------------------------------------*/
void SetQuadraticBSplines(SomePolynoms *Polynomials, double la)
{

    double *C;

    // Polynomials=0 means LEFT Boundary Element, Polynom[0] means first shape function
    C=&(Polynomials[0].Polynom[0].coefficient[0]); C[0]=1.0;    C[1]=-2.0/la;    C[2]=1.0/(la*la);
    C=&(Polynomials[0].Polynom[1].coefficient[0]); C[0]=0.0;    C[1]=2.0/la;     C[2]=-3.0/(2.0*la*la);    
    C=&(Polynomials[0].Polynom[2].coefficient[0]); C[0]=0.0;    C[1]=0.0;        C[2]=1.0/(2.0*la*la);    

    // Polynomials=1 means Middle Element, Polynom[0] means first shape function  
    C=&(Polynomials[1].Polynom[0].coefficient[0]); C[0]=0.5;    C[1]=-1.0/la;    C[2]=1.0/(2.0*la*la);
    C=&(Polynomials[1].Polynom[1].coefficient[0]); C[0]=0.5;    C[1]=1.0/la;     C[2]=-1.0/(la*la);    
    C=&(Polynomials[1].Polynom[2].coefficient[0]); C[0]=0.0;    C[1]=0.0;        C[2]=1.0/(2.0*la*la);     

    // Polynomials=2 means Right Boundary Element, Polynom[0] means first shape function  
    C=&(Polynomials[2].Polynom[0].coefficient[0]); C[0]=0.5;    C[1]=-1.0/la;    C[2]=1.0/(2.0*la*la);
    C=&(Polynomials[2].Polynom[1].coefficient[0]); C[0]=0.5;    C[1]=1.0/la;     C[2]=-3.0/(2.0*la*la);    
    C=&(Polynomials[2].Polynom[2].coefficient[0]); C[0]=0.0;    C[1]=0.0;        C[2]=1.0/(la*la); 
              
    
    // Polynomials=3 means LEFT Boundary Element, DERIVATIVE
    C=&(Polynomials[3].Polynom[0].coefficient[0]); C[0]=-2.0/la;C[1]=2.0/(la*la);    C[2]=0.0;
    C=&(Polynomials[3].Polynom[1].coefficient[0]); C[0]=2.0/la; C[1]=-3.0/(la*la);   C[2]=0.0;    
    C=&(Polynomials[3].Polynom[2].coefficient[0]); C[0]=0.0;    C[1]=1.0/(la*la);    C[2]=0.0;    
    
    // Polynomials=4 means MIDDLE Element, DERIVATIVE  
    C=&(Polynomials[4].Polynom[0].coefficient[0]); C[0]=-1.0/la;C[1]=1.0/(la*la);    C[2]=0.0;
    C=&(Polynomials[4].Polynom[1].coefficient[0]); C[0]=1.0/la; C[1]=-2.0/(la*la);   C[2]=0.0;    
    C=&(Polynomials[4].Polynom[2].coefficient[0]); C[0]=0.0;    C[1]=1.0/(la*la);    C[2]=0.0;     
        
    // Polynomials=5 means RIGHT Boundary Element, DERIVATIVE    
    C=&(Polynomials[5].Polynom[0].coefficient[0]); C[0]=-1.0/la;C[1]=1.0/(la*la);    C[2]=0.0;
    C=&(Polynomials[5].Polynom[1].coefficient[0]); C[0]=1.0/la; C[1]=-3.0/(la*la);   C[2]=0.0;    
    C=&(Polynomials[5].Polynom[2].coefficient[0]); C[0]=0.0;    C[1]=2.0/(la*la);    C[2]=0.0;                                      
    
return;
}
