/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"
#include <stdio.h>

/*------------------------------------------------------------------------------
     PutGetSolveBlock
------------------------------------------------------------------------------*/
void PutGetSolveBlock(int choice, SolveBlock **inblock) 
{
     static SolveBlock *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}

/*------------------------------------------------------------------------------
     InitSolveBlock  !abgendert -a01-!
------------------------------------------------------------------------------*/
void InitSolveBlock()
{
     static SolveBlock localblock ;
     static SolveBlock *loc_ptr;
     static SolveBlock **loc_dptr;
     BSplineBlock *BSP;

     loc_ptr=&localblock;
     loc_dptr=&loc_ptr;
     BSP=&(localblock.BSplines); 
     
     localblock.PreMeshFlag=0;
     localblock.MeshDefined=0;
     localblock.SpMeshDefined=0;
     localblock.FinerSpMeshDefined=0;
     localblock.cycle_len=0;
     PutGetSolveBlock(0, loc_dptr);
     
     InitBSplineBlocktoZero(BSP);     // variables for BSPlineBlock
     
     localblock.GoFlag=0;
}


/*------------------------------------------------------------------------------
     InitBSplineBlocktoZero   !neu -n01-!
------------------------------------------------------------------------------*/
void InitBSplineBlocktoZero(BSplineBlock *BSP)
{
     BSP->initSplineFlag=0;   
     BSP->BSPMatrBuildFlag=0;
     BSP->orderK=0;
     BSP->lastK=0;   
     BSP->la=0;               
     BSP->lb=0;              
     BSP->Xi = NULL;
     BSP->Gi = NULL;
}
