/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

/*********************************************************************************
                               MAIN PROGRAM OF SOLVER
********************************************************************************/



void SolverMainLoop(void)
{    
  
    int     i,ii,j,iii;

    double  mu;
    
    int     num_levels;
    
    double  *K_matrix, *K_matrixQ9, *K_matrixEAS;
    
    MGBlock *Meshes, *M, *P, *Q;
    double  err1, err2;
    double  minimum, maximum;
    
    double lambda;
    
    int SolverMethod;
    int OptFactorFlag;
    double Omega;
    int Frames, framecount;
    
    clock_t start, ende;
    float zeit;
    double Repititions;
    int Repitition_int;
    
    //CG
    double tmp1,tmp2,tmp3,tmp4;
    int length;
    
    int ModelDim;
    

    SolveBlock *SolBlock;
    
    AllWinStruct *AllWinData;
    GeomWinStruct *GeomWinData;
    GraphicBlock *graphblock;
    SolveWinStruct *SolveWinData;
       
/*--------- end of declaration--------- */
      

    PutGetAllWinStruct(1, &AllWinData); 
    SolveWinData=AllWinData->SolveWinData;
    
    PutGetGraphicBlock(1, &graphblock);
    (graphblock->RunFlag)=0;
    (graphblock->TMP)=0;
    Frames=1; framecount=0;
        
    PutGetAllWinStruct(1, &AllWinData);
    GeomWinData=AllWinData->GeomWinData;   
    
    PutGetSolveBlock(1,&SolBlock); 

    //TIMECONTROL
    ChangeTimeFlag(0);
    ChangeTimeFlag(8);


    Meshes=SolBlock->Meshes;
    num_levels=SolBlock->num_levels;    
    K_matrix=SolBlock->Material[0].K;
    K_matrixQ9=SolBlock->K_matrixQ9;    
    GetEASStiffnessMatrix(1.0, 0.2, 1.0, &K_matrixEAS);
    //TransMatFieldToCoarse(Meshes, num_levels);
    
    M=&(Meshes[num_levels-1]);
    P=&(Meshes[num_levels-2]);
    
    ModelDim=PutGetModelDim(1,123);
   
    
    if (0==SystemCheck2()) return;

    
    if (2==ModelDim)
    {
        if (0==SolveWinData->ContFlag)
        {
            SetVectorToZero_double((M->nnx)*(M->nny),  M->Uy);
            SetVectorToZero_double((M->nnx)*(M->nny),  M->Ux);
        }
    }
    else
    {
        SetVectorToZero_double((M->nnx)*(M->nny)*(M->nnz),  M->Ux);
        SetVectorToZero_double((M->nnx)*(M->nny)*(M->nnz),  M->Uy);
        SetVectorToZero_double((M->nnx)*(M->nny)*(M->nnz),  M->Uz);
    }
    
    
    //InitializeUx(M->nnx, M->nny, M->Ux);
    //StartVectorZero(M->nnx, M->nny, M->Ux);
 
                
    SolverMethod=(SolveWinData->SolverMethod);
    OptFactorFlag=(SolveWinData->OptFactorFlag);
    Omega=(SolveWinData->Omega);
    Repititions=(SolveWinData->Repititions);
    SolBlock->ErrorData.ErrFlag[0]=SolveWinData->EuclidFlag;
    SolBlock->ErrorData.ErrFlag[2]=SolveWinData->RelEnergyFlag;
    SolBlock->ErrorData.ErrFlag[1]=SolveWinData->RelEuclidFlag;
    SolBlock->ErrorData.ErrTol[0]=SolveWinData->EuclidTol;
    SolBlock->ErrorData.ErrTol[2]=SolveWinData->RelEnergyTol;
    SolBlock->ErrorData.ErrTol[1]=SolveWinData->RelEuclidTol;
    SolBlock->PreCondType=SolveWinData->PreCondType;
    
    if (2==ModelDim)
    {
        for (i=0; i<num_levels; i++)
        {
            M=&(Meshes[i]);
            printf("Level:%i  Nodes:%i   nnx:%i   nny:%i la:%g   lb:%g\n", 
                    i, (M->nnx)*(M->nny),M->nnx, M->nny,M->la, M->lb);
        }
    }
    else
    {
        for (i=0; i<num_levels; i++)
        {
            M=&(Meshes[i]);
            printf("Level:%i  Nodes:%i   nnx:%i   nny:%i   nnz:%i  la:%g  lb:%g  lc:%g\n", 
                    i, (M->nnx)*(M->nny)*(M->nnz),M->nnx, M->nny, M->nnz, M->la, M->lb, M->lc);
        }
    }
    
    //printf("\nIm Solver\n"); getchar();
    
    if (2==ModelDim)
        for(i=0; i<num_levels; i++) BCmain(i);
    else
        for(i=0; i<num_levels; i++) BCmain3d(i);
    //printf("\nNach BCs\n"); getchar();
    //printf("ENDE\n");getchar();
    
    TransMatFieldToCoarse(Meshes, num_levels);
    
    //TIMECONTROL
    //SolBlock->TimeData.T_tmp = clock();    
    //SolBlock->TimeData.T_prep += 
    //    ((SolBlock->TimeData.T_tmp)-(SolBlock->TimeData.T_start_part)) 
    //                                                   /((float)CLOCKS_PER_SEC;
    //SolBlock->TimeData.T_start_part = SolBlock->TimeData.T_tmp;

    
    /* MOVED TO OTHER ROUTINES: MeshWin_cb_OK() and void BaseWin_Open_EModul_Int(char *savefile) 
    if (0==SolBlock->PreMeshFlag)
    {
        InitPreMeshes();
    }*/
              
    if (0==SolverMethod)      
         {
              if (0==(SolveWinData->BSplineFlag))
              {

                  CGSolver2and3d(SolBlock, M);
                  //CGSolver(num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
              }
              else 
              {
                   BSplineMain3();   //BSplineMain2();
                   
              }     
         }
    if (1==SolverMethod)      GSSolver(SolBlock->Material[0].K, SolBlock, M, Omega);
    if (2==SolverMethod)      PCGSolver(K_matrix, SolBlock, M);
    if (3==SolverMethod)      MGSolverVariable(0,num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
    if (4==SolverMethod)      
    {
         if (2==ModelDim)MGSolver(0,num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
         if (3==ModelDim)MGSolver3d(num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
    }
    if (5==SolverMethod)      NLSolver(num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);   
    if (6==SolverMethod)      MGVCycle(0, num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
    if (7==SolverMethod)      MGCGSolver(num_levels, SolBlock->Material[0].K, SolveWinData, SolBlock, M, Meshes);
    return;
}

/*********************************************************************************
                              SYSTEMCHECK
********************************************************************************/
int SystemCheck(void)
{    
    int i, j, ModelDim, n, num_levels;
    SolveBlock *SolBlock;
    MGBlock *Meshes, *PreMesh;
    MGBlock *M, *P;
    double tmp, tmp2, tmp3;
   
    int success;
    float T, UserT;
    AllWinStruct *AllWinData;
    SolveWinStruct *SolveWinData;
       
    PutGetAllWinStruct(1, &AllWinData); 
    SolveWinData=AllWinData->SolveWinData;
       
    
    ModelDim=PutGetModelDim(1,123);
    PutGetSolveBlock(1,&SolBlock); 

    Meshes=SolBlock->Meshes;
    PreMesh=SolBlock->PreMesh;
    num_levels=SolBlock->num_levels;
    
    ChangeTimeFlag(13);
    for(j=0; j<num_levels; j++)
    {
        M=&(Meshes[num_levels-1]);
        P=&(Meshes[num_levels-1]);
        if(2==ModelDim) n=(M->nex)*(M->ney);
        else n=(M->nex)*(M->ney)*(M->nez);
        tmp2=0.0;
        tmp=0.0;
        if (n>10000) n=10000;
        for(i=0; i<n; i++)
        {
            P->U[i]=((double)i/(double)n);
            P->dU[i]=(((double)i+3.14152)/(double)n);
            tmp+=P->U[i];
            P->U[i]=P->dU[i];
            P->dU[i]=P->F[i];
            P->F[i]=P->D[i];
            P->D[i]=P->Ad[i];
            P->Ad[i]=P->SwapXYZ[i];
            P->SwapXYZ[i]=P->Swap[i];
            P->Swap[i]=P->BcValue[i];
            tmp+=P->Swap[i]+P->SwapXYZ[i]+P->Ad[i]+P->D[i]+P->F[i]+P->dU[i];
            tmp+=P->U[i];
            if (tmp>112212121.1212) tmp=0.0;
            P->Swap[i]=P->SwapXYZ[i];
            P->SwapXYZ[i]=P->Ad[i];
            P->Ad[i]=P->D[i];
            P->D[i]=P->F[i];
            P->F[i]=P->dU[i];
            P->dU[i]=P->U[i];
           
            M->U[i]=((double)i/(double)n);
            M->dU[i]=(((double)i+3.14152)/(double)n);
            tmp+=M->U[i];
            M->U[i]=M->dU[i];
            M->dU[i]=M->F[i];
            M->F[i]=M->D[i];
            M->D[i]=M->Ad[i];
            M->Ad[i]=M->SwapXYZ[i];
            M->SwapXYZ[i]=M->Swap[i];
            M->Swap[i]=M->BcValue[i];
            tmp+=M->Swap[i]+M->SwapXYZ[i]+M->Ad[i]+M->D[i]+M->F[i]+M->dU[i];
            tmp+=M->U[i];
            if (tmp>112212121.1212) tmp=0.0;
            M->Swap[i]=M->SwapXYZ[i];
            M->SwapXYZ[i]=M->Ad[i];
            M->Ad[i]=M->D[i];
            M->D[i]=M->F[i];
            M->F[i]=M->dU[i];
            M->dU[i]=M->U[i];
           
            
            P->U[i]+=M->MatFieldE[i]; 
            P->dU[i]+=M->Post[i];
            tmp-=P->U[i]+P->dU[i]; 
            P->U[i]+=M->Kappa[i]; 
            P->dU[i]+=M->DamageOmega[i];
            tmp-=P->U[i]+P->dU[i];
            P->U[i]+=M->BcValue[i]; 
            P->dU[i]+=(double) M->BcType[i];
            tmp-=P->U[i]+P->dU[i];
            P->U[i]+=M->ColorIndex[i]; 
            P->dU[i]+=(double) M->MatFieldInt[i];
            tmp-=P->U[i]+P->dU[i]; 
            P->U[i]+=M->EqStrain[i]; 
            P->dU[i]+=M->KnMatFieldE[i];
            tmp-=P->U[i]+P->dU[i]; 
      
        }
        
        
    }
    
    ChangeTimeFlag(8);
    PrintCheckTimeData();
    

    T=SolBlock->TimeData.T_field[13];
    UserT=SolveWinData->CheckTime;
    if (T>UserT) 
    {
        success=0;
        printf("\nFailure due to user definition of checktime!\n");
    }
    else success=1;

    
    return success;
}

/*********************************************************************************
                              SYSTEMCHECK2
********************************************************************************/
int SystemCheck2(void)
{    
    int i, j, ModelDim, n, num_levels;
    SolveBlock *SolBlock;
    MGBlock *Meshes, *PreMesh;
    MGBlock *M, *P;
    double tmp, tmp2, tmp3;
   
    int success;
    float T, UserT;
    AllWinStruct *AllWinData;
    SolveWinStruct *SolveWinData;
       
    PutGetAllWinStruct(1, &AllWinData); 
    SolveWinData=AllWinData->SolveWinData;
       
    
    ModelDim=PutGetModelDim(1,123);
    PutGetSolveBlock(1,&SolBlock); 

    Meshes=SolBlock->Meshes;
    PreMesh=SolBlock->PreMesh;
    num_levels=SolBlock->num_levels;
    M=&Meshes[num_levels-1];
    
    ChangeTimeFlag(13);
    
    for(i=0; i<num_levels; i++)
    GetLocalDisplacements_GS_real3(M->nnx, M->nny, SolBlock->Material, M->MatFieldE,
                M->MatFieldInt, M->Ux,  M->Uy, 1.0, M->BcTypeX, M->BcTypeY, M->BcValueX, M->BcValueY); 
    
    
    ChangeTimeFlag(8);
    PrintCheckTimeData();
    

    T=SolBlock->TimeData.T_field[13];
    UserT=SolveWinData->CheckTime;
    if (T>UserT) 
    {
        success=0;
        printf("\nFailure due to user definition of checktime!\n");
    }
    else success=1;

    
    return success;
}



