/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

/*********************************************************************************
                            Stiffness Matrices
********************************************************************************/

/*------------------------------------------------------------------------------
     GetStiffnessMatrix
-------------------------------------------------------------------------------*/
int GetStiffnessMatrix(double nu, double h, double a, double b, double **K)
{
    double E;
    *K = (double *) malloc(sizeof(double)*(8*8));
     
    E=1.00; 
    
    ((*K)[0+8*0]) = -(double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[0+8*1]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[0+8*2]) = (double) (E * h * (-a * a + a * a * nu + 4 * b * b) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[0+8*3]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[0+8*4]) = (double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[0+8*5]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[0+8*6]) = -(double) (E * h * (b * b - a * a + a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[0+8*7]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[1+8*0]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[1+8*1]) = (double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[1+8*2]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[1+8*3]) = -(double) (E * h * (-b * b + b * b * nu + a * a) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[1+8*4]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[1+8*5]) = -(double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[1+8*6]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[1+8*7]) = (double) (E * h * (-b * b + b * b * nu + 4 * a * a) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[2+8*0]) = (double) (E * h * (-a * a + a * a * nu + 4 * b * b) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[2+8*1]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[2+8*2]) = -(double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[2+8*3]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[2+8*4]) = -(double) (E * h * (b * b - a * a + a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[2+8*5]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[2+8*6]) = (double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[2+8*7]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[3+8*0]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[3+8*1]) = -(double) (E * h * (-b * b + b * b * nu + a * a) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[3+8*2]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[3+8*3]) = (double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[3+8*4]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[3+8*5]) = (double) (E * h * (-b * b + b * b * nu + 4 * a * a) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[3+8*6]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[3+8*7]) = -(double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[4+8*0]) = (double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[4+8*1]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[4+8*2]) = -(double) (E * h * (b * b - a * a + a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[4+8*3]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[4+8*4]) = -(double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[4+8*5]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[4+8*6]) = (double) (E * h * (-a * a + a * a * nu + 4 * b * b) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[4+8*7]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[5+8*0]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[5+8*1]) = -(double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[5+8*2]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[5+8*3]) = (double) (E * h * (-b * b + b * b * nu + 4 * a * a) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[5+8*4]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[5+8*5]) = (double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[5+8*6]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[5+8*7]) = -(double) (E * h * (-b * b + b * b * nu + a * a) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[6+8*0]) = -(double) (E * h * (b * b - a * a + a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[6+8*1]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[6+8*2]) = (double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[6+8*3]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[6+8*4]) = (double) (E * h * (-a * a + a * a * nu + 4 * b * b) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[6+8*5]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[6+8*6]) = -(double) (E * h * (2 * b * b + a * a - a * a * nu) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[6+8*7]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[7+8*0]) = (double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[7+8*1]) = (double) (E * h * (-b * b + b * b * nu + 4 * a * a) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[7+8*2]) = -(double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[7+8*3]) = -(double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.12e2;
    ((*K)[7+8*4]) = -(double) (E * h * (3 * nu - 1) / (-1 + nu * nu)) / 0.8e1;
    ((*K)[7+8*5]) = -(double) (E * h * (-b * b + b * b * nu + a * a) / a / b / (-1 + nu * nu)) / 0.6e1;
    ((*K)[7+8*6]) = (double) (E * h / (-1 + nu)) / 0.8e1;
    ((*K)[7+8*7]) = (double) (E * h * (-2 * a * a - b * b + b * b * nu) / a / b / (-1 + nu * nu)) / 0.6e1;


    return(1);
  
}

/*------------------------------------------------------------------------------
     GetStiffnessMatrixPStrain
-------------------------------------------------------------------------------*/
int GetStiffnessMatrixPStrain(double nu, double h, double a, double b, double **K)
{
    double E;
    *K = (double *) malloc(sizeof(double)*(8*8));
     
    E=1.00; 
    
    ((*K)[0+8*0]) = (double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[0+8*1]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[0+8*2]) = (double) (E * h * (4 * b * b - 4 * b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[0+8*3]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[0+8*4]) = -(double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[0+8*5]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[0+8*6]) = -(double) (E * h * (b * b - b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[0+8*7]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[1+8*0]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[1+8*1]) = (double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[1+8*2]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[1+8*3]) = (double) (E * h * (b * b - 2 * b * b * nu - a * a + a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[1+8*4]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[1+8*5]) = -(double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[1+8*6]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[1+8*7]) = -(double) (E * h * (b * b - 2 * b * b * nu - 4 * a * a + 4 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[2+8*0]) = (double) (E * h * (4 * b * b - 4 * b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[2+8*1]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[2+8*2]) = (double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[2+8*3]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[2+8*4]) = -(double) (E * h * (b * b - b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[2+8*5]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[2+8*6]) = -(double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[2+8*7]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[3+8*0]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[3+8*1]) = (double) (E * h * (b * b - 2 * b * b * nu - a * a + a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[3+8*2]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[3+8*3]) = (double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[3+8*4]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[3+8*5]) = -(double) (E * h * (b * b - 2 * b * b * nu - 4 * a * a + 4 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[3+8*6]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[3+8*7]) = -(double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[4+8*0]) = -(double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[4+8*1]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[4+8*2]) = -(double) (E * h * (b * b - b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[4+8*3]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[4+8*4]) = (double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[4+8*5]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[4+8*6]) = (double) (E * h * (4 * b * b - 4 * b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[4+8*7]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[5+8*0]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[5+8*1]) = -(double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[5+8*2]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[5+8*3]) = -(double) (E * h * (b * b - 2 * b * b * nu - 4 * a * a + 4 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[5+8*4]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[5+8*5]) = (double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[5+8*6]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[5+8*7]) = (double) (E * h * (b * b - 2 * b * b * nu - a * a + a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[6+8*0]) = -(double) (E * h * (b * b - b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[6+8*1]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[6+8*2]) = -(double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[6+8*3]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[6+8*4]) = (double) (E * h * (4 * b * b - 4 * b * b * nu - a * a + 2 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[6+8*5]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[6+8*6]) = (double) (E * h * (-2 * b * b + 2 * b * b * nu - a * a + 2 * a * a * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;
    ((*K)[6+8*7]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[7+8*0]) = (double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[7+8*1]) = -(double) (E * h * (b * b - 2 * b * b * nu - 4 * a * a + 4 * a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.12e2;
    ((*K)[7+8*2]) = -(double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[7+8*3]) = -(double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.12e2;
    ((*K)[7+8*4]) = -(double) (E * h * (-1 + 4 * nu) / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[7+8*5]) = (double) (E * h * (b * b - 2 * b * b * nu - a * a + a * a * nu) / a / (1 + nu) / (-1 + 2 * nu) / b) / 0.6e1;
    ((*K)[7+8*6]) = (double) (E * h / (1 + nu) / (-1 + 2 * nu)) / 0.8e1;
    ((*K)[7+8*7]) = (double) (E * h * (-2 * a * a + 2 * a * a * nu - b * b + 2 * b * b * nu) / a / b / (1 + nu) / (-1 + 2 * nu)) / 0.6e1;


    return(1);
  
}


/*------------------------------------------------------------------------------
     GetStiffnessMatrixQ9
-------------------------------------------------------------------------------*/
int GetStiffnessMatrixQ9(double nu, double h, double a, double b, double **K)
{
    double E;
    *K = (double *) malloc(sizeof(double)*(18*18));
     
    E=1.00; 
    
    ((*K)[0+18*0]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[0+18*1]) = -(double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[0+18*2]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[0+18*3]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[0+18*4]) = -(double) (h * E / b * (8 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[0+18*5]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[0+18*6]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[0+18*7]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[0+18*8]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[0+18*9]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[0+18*10]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[0+18*11]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[0+18*12]) = (double) (h * E / b * (7 * b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[0+18*13]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[0+18*14]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[0+18*15]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[0+18*16]) = -(double) (h * E / b * (a * a * nu - a * a - 2 * b * b) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[0+18*17]) = (double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[1+18*0]) = -(double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[1+18*1]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[1+18*2]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[1+18*3]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[1+18*4]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[1+18*5]) = (double) (h * E / a / b * (-2 * b * b + 2 * b * b * nu + 7 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[1+18*6]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[1+18*7]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[1+18*8]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[1+18*9]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[1+18*10]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[1+18*11]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[1+18*12]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[1+18*13]) = -(double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 8 * a * a) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[1+18*14]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[1+18*15]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[1+18*16]) = (double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[1+18*17]) = -(double) (h * E / a / b * (-2 * a * a + b * b * nu - b * b) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[2+18*0]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[2+18*1]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[2+18*2]) = 0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-8 * b * b - 7 * a * a + 7 * a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[2+18*4]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[2+18*5]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[2+18*6]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[2+18*7]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[2+18*8]) = -0.16e2 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (b * b - 2 * a * a + 2 * a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[2+18*10]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[2+18*11]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[2+18*12]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[2+18*13]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[2+18*14]) = 0.4e1 / 0.45e2 * (double) E * (double) h / (double) b / (double) a * (double) (2 * b * b - a * a + a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[2+18*16]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[2+18*17]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[3+18*0]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[3+18*1]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[3+18*3]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (2 * b * b * nu - 2 * b * b - 7 * a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[3+18*4]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[3+18*5]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[3+18*6]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[3+18*7]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[3+18*9]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (b * b * nu - b * b + 8 * a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[3+18*10]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[3+18*11]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[3+18*12]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[3+18*13]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[3+18*15]) = -0.4e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (2 * a * a - b * b + b * b * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[3+18*16]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[3+18*17]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[4+18*0]) = -(double) (h * E / b * (8 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[4+18*1]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[4+18*2]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[4+18*3]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[4+18*4]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[4+18*5]) = (double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[4+18*6]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[4+18*7]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[4+18*8]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[4+18*9]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[4+18*10]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[4+18*11]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[4+18*12]) = -(double) (h * E / b * (a * a * nu - a * a - 2 * b * b) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[4+18*13]) = -(double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[4+18*14]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[4+18*15]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[4+18*16]) = (double) (h * E / b * (7 * b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[4+18*17]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[5+18*0]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[5+18*1]) = (double) (h * E / a / b * (-2 * b * b + 2 * b * b * nu + 7 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[5+18*2]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[5+18*3]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[5+18*4]) = (double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[5+18*5]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[5+18*6]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[5+18*7]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[5+18*8]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[5+18*9]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[5+18*10]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[5+18*11]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[5+18*12]) = -(double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[5+18*13]) = -(double) (h * E / a / b * (-2 * a * a + b * b * nu - b * b) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[5+18*14]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[5+18*15]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[5+18*16]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[5+18*17]) = -(double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 8 * a * a) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[6+18*0]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[6+18*1]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[6+18*2]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[6+18*3]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[6+18*4]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[6+18*5]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[6+18*6]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (-7 * b * b - 2 * a * a + 2 * a * a * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[6+18*8]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (8 * b * b - a * a + a * a * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[6+18*10]) = -0.4e1 / 0.45e2 * (double) E * (double) h / (double) b / (double) a * (double) (2 * b * b - a * a + a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[6+18*12]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[6+18*13]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[6+18*14]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[6+18*15]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[6+18*16]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[6+18*17]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[7+18*0]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[7+18*1]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[7+18*2]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[7+18*3]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[7+18*4]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[7+18*5]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[7+18*7]) = 0.4e1 / 0.45e2 * (double) E * (double) h / (double) b / (double) a * (double) (-7 * b * b + 7 * b * b * nu - 8 * a * a) / (double) (-1 + nu * nu);
    ((*K)[7+18*9]) = -0.16e2 / 0.45e2 / (double) b * (double) E * (double) h * (double) (-2 * b * b + 2 * b * b * nu + a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[7+18*11]) = 0.4e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (2 * a * a - b * b + b * b * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[7+18*12]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[7+18*13]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[7+18*14]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[7+18*15]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[7+18*16]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[7+18*17]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[8+18*0]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*1]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[8+18*2]) = -0.16e2 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (b * b - 2 * a * a + 2 * a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[8+18*4]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*5]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[8+18*6]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (8 * b * b - a * a + a * a * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*8]) = 0.64e2 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*10]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (8 * b * b - a * a + a * a * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*12]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*13]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[8+18*14]) = -0.16e2 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (b * b - 2 * a * a + 2 * a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[8+18*16]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[8+18*17]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[9+18*0]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[9+18*1]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[9+18*3]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (b * b * nu - b * b + 8 * a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[9+18*4]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[9+18*5]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[9+18*7]) = -0.16e2 / 0.45e2 / (double) b * (double) E * (double) h * (double) (-2 * b * b + 2 * b * b * nu + a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[9+18*9]) = 0.64e2 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[9+18*11]) = -0.16e2 / 0.45e2 / (double) b * (double) E * (double) h * (double) (-2 * b * b + 2 * b * b * nu + a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[9+18*12]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[9+18*13]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[9+18*15]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (b * b * nu - b * b + 8 * a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[9+18*16]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[9+18*17]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[10+18*0]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[10+18*1]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[10+18*2]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[10+18*3]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[10+18*4]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[10+18*5]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[10+18*6]) = -0.4e1 / 0.45e2 * (double) E * (double) h / (double) b / (double) a * (double) (2 * b * b - a * a + a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[10+18*8]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (8 * b * b - a * a + a * a * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[10+18*10]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (-7 * b * b - 2 * a * a + 2 * a * a * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[10+18*12]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[10+18*13]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[10+18*14]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[10+18*15]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[10+18*16]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[10+18*17]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[11+18*0]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[11+18*1]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[11+18*2]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[11+18*3]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[11+18*4]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[11+18*5]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[11+18*7]) = 0.4e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (2 * a * a - b * b + b * b * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[11+18*9]) = -0.16e2 / 0.45e2 / (double) b * (double) E * (double) h * (double) (-2 * b * b + 2 * b * b * nu + a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[11+18*11]) = 0.4e1 / 0.45e2 * (double) E * (double) h / (double) b / (double) a * (double) (-7 * b * b + 7 * b * b * nu - 8 * a * a) / (double) (-1 + nu * nu);
    ((*K)[11+18*12]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[11+18*13]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[11+18*14]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[11+18*15]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[11+18*16]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[11+18*17]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[12+18*0]) = (double) (h * E / b * (7 * b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[12+18*1]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[12+18*2]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[12+18*3]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[12+18*4]) = -(double) (h * E / b * (a * a * nu - a * a - 2 * b * b) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[12+18*5]) = -(double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[12+18*6]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[12+18*7]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[12+18*8]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[12+18*9]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[12+18*10]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[12+18*11]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[12+18*12]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[12+18*13]) = (double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[12+18*14]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[12+18*15]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[12+18*16]) = -(double) (h * E / b * (8 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[12+18*17]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[13+18*0]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[13+18*1]) = -(double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 8 * a * a) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[13+18*2]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[13+18*3]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[13+18*4]) = -(double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[13+18*5]) = -(double) (h * E / a / b * (-2 * a * a + b * b * nu - b * b) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[13+18*6]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[13+18*7]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[13+18*8]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[13+18*9]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[13+18*10]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[13+18*11]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[13+18*12]) = (double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[13+18*13]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[13+18*14]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[13+18*15]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[13+18*16]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[13+18*17]) = (double) (h * E / a / b * (-2 * b * b + 2 * b * b * nu + 7 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[14+18*0]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[14+18*1]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[14+18*2]) = 0.4e1 / 0.45e2 * (double) E * (double) h / (double) b / (double) a * (double) (2 * b * b - a * a + a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[14+18*4]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[14+18*5]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[14+18*6]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[14+18*7]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[14+18*8]) = -0.16e2 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (b * b - 2 * a * a + 2 * a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[14+18*10]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[14+18*11]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[14+18*12]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[14+18*13]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[14+18*14]) = 0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-8 * b * b - 7 * a * a + 7 * a * a * nu) / (double) (-1 + nu * nu);
    ((*K)[14+18*16]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[14+18*17]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[15+18*0]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[15+18*1]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[15+18*3]) = -0.4e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (2 * a * a - b * b + b * b * nu) / (double) a / (double) (-1 + nu * nu);
    ((*K)[15+18*4]) = (double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[15+18*5]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[15+18*6]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[15+18*7]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[15+18*9]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (b * b * nu - b * b + 8 * a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[15+18*10]) = -0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[15+18*11]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[15+18*12]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[15+18*13]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[15+18*15]) = 0.8e1 / 0.45e2 * (double) E * (double) h / (double) b * (double) (2 * b * b * nu - 2 * b * b - 7 * a * a) / (double) a / (double) (-1 + nu * nu);
    ((*K)[15+18*16]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[15+18*17]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[16+18*0]) = -(double) (h * E / b * (a * a * nu - a * a - 2 * b * b) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[16+18*1]) = (double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[16+18*2]) = (double) (h * E / b * (-8 * b * b - a * a + a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[16+18*3]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[16+18*4]) = (double) (h * E / b * (7 * b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[16+18*5]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[16+18*6]) = (double) (h * E / b * (-b * b - 2 * a * a + 2 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[16+18*7]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[16+18*8]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[16+18*9]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[16+18*10]) = -(double) (h * E / b * (7 * b * b - 8 * a * a + 8 * a * a * nu) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[16+18*11]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[16+18*12]) = -(double) (h * E / b * (8 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.180e3;
    ((*K)[16+18*13]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[16+18*14]) = (double) (h * E / b * (32 * b * b - 7 * a * a + 7 * a * a * nu) / a / (-1 + nu * nu)) / 0.90e2;
    ((*K)[16+18*15]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[16+18*16]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) b * (double) (a * a * nu - a * a - 2 * b * b) / (double) a / (double) (-1 + nu * nu);
    ((*K)[16+18*17]) = -(double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[17+18*0]) = (double) (h * E / (-1 + nu)) / 0.72e2;
    ((*K)[17+18*1]) = -(double) (h * E / a / b * (-2 * a * a + b * b * nu - b * b) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[17+18*2]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[17+18*3]) = (double) (h * E / b * (-2 * b * b + 2 * b * b * nu - a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[17+18*4]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[17+18*5]) = -(double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 8 * a * a) / (-1 + nu * nu)) / 0.180e3;
    ((*K)[17+18*6]) = -(double) (h * E / (-1 + nu)) / 0.18e2;
    ((*K)[17+18*7]) = (double) (h * E / a / b * (-b * b + b * b * nu - 8 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[17+18*8]) = 0.2e1 / 0.9e1 * (double) h * (double) E / (double) (-1 + nu);
    ((*K)[17+18*9]) = -0.4e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);
    ((*K)[17+18*10]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[17+18*11]) = (double) (h * E / a / b * (-7 * b * b + 7 * b * b * nu + 32 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[17+18*12]) = -(double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.24e2;
    ((*K)[17+18*13]) = (double) (h * E / a / b * (-2 * b * b + 2 * b * b * nu + 7 * a * a) / (-1 + nu * nu)) / 0.90e2;
    ((*K)[17+18*14]) = (double) (h * E * (-1 + 3 * nu) / (-1 + nu * nu)) / 0.6e1;
    ((*K)[17+18*15]) = -(double) (h * E / b * (-8 * b * b + 8 * b * b * nu + 7 * a * a) / a / (-1 + nu * nu)) / 0.45e2;
    ((*K)[17+18*16]) = -(double) (h * E / (-1 + nu)) / 0.8e1;
    ((*K)[17+18*17]) = 0.7e1 / 0.45e2 * (double) h * (double) E / (double) a / (double) b * (double) (-2 * a * a + b * b * nu - b * b) / (double) (-1 + nu * nu);


    return(1);
  
}


/*---------------------------------------------------------
	GetEASStiffnessMatrix
----------------------------------------------------------*/

int GetEASStiffnessMatrix(double E, double nu, double h, double **K)
{
      int i;	
      *K = (double *) malloc(sizeof(double)*(8*8));
  
      ((*K)[0+8*0]) =  44792 	;      
      ((*K)[0+8*1]) =  15625 	;
      ((*K)[0+8*2]) = -23958 	;
      ((*K)[0+8*3]) = -5208.3	;
      ((*K)[0+8*4]) = -28125 	;
      ((*K)[0+8*5]) = -15625 	;
      ((*K)[0+8*6]) =  7291.7 	;
      ((*K)[0+8*7]) =  5208.3	;
      
      ((*K)[1+8*0]) = 15625	;
      ((*K)[1+8*1]) = 44792	;
      ((*K)[1+8*2]) = 5208.3	;
      ((*K)[1+8*3]) = 7291.7	;
      ((*K)[1+8*4]) = -15625	;
      ((*K)[1+8*5]) = -28125	;
      ((*K)[1+8*6]) = -5208.3	;
      ((*K)[1+8*7]) = -23958	;
      
      ((*K)[2+8*0]) = -23958	;
      ((*K)[2+8*1]) = 5208.3	;
      ((*K)[2+8*2]) = 44792	;
      ((*K)[2+8*3]) = -15625	;
      ((*K)[2+8*4]) = 7291.7	;
      ((*K)[2+8*5]) = -5208.3	;
      ((*K)[2+8*6]) = -28125	;
      ((*K)[2+8*7]) = 15625	;
     	 
      ((*K)[3+8*0]) = -5208.3	;
      ((*K)[3+8*1]) = 7291.7	;
      ((*K)[3+8*2]) = -15625	;
      ((*K)[3+8*3]) = 44792	;
      ((*K)[3+8*4]) = 5208.3	;
      ((*K)[3+8*5]) = -23958	;
      ((*K)[3+8*6]) = 15625	;
      ((*K)[3+8*7]) = -28125	;
      
      ((*K)[4+8*0]) = -28125	;
      ((*K)[4+8*1]) = -15625	;
      ((*K)[4+8*2]) = 7291.7	;
      ((*K)[4+8*3]) = 5208.3	;
      ((*K)[4+8*4]) = 44792	;
      ((*K)[4+8*5]) = 15625	;
      ((*K)[4+8*6]) = -23958	;
      ((*K)[4+8*7]) = -5208.3	;
      
      ((*K)[5+8*0]) = -15625	;
      ((*K)[5+8*1]) = -28125	;
      ((*K)[5+8*2]) = -5208.3	;
      ((*K)[5+8*3]) = -23958	;
      ((*K)[5+8*4]) = 15625	;
      ((*K)[5+8*5]) = 44792	;
      ((*K)[5+8*6]) = 5208.3	;
      ((*K)[5+8*7]) = 7291.7	;
      
      ((*K)[6+8*0]) = 7291.7	;
      ((*K)[6+8*1]) = -5208.3	;
      ((*K)[6+8*2]) = -28125	;
      ((*K)[6+8*3]) = 15625	;
      ((*K)[6+8*4]) = -23958	;
      ((*K)[6+8*5]) = 5208.3	;
      ((*K)[6+8*6]) = 44792	;
      ((*K)[6+8*7]) = -15625	;
      
      ((*K)[7+8*0]) = 5208.3	;
      ((*K)[7+8*1]) = -23958	;
      ((*K)[7+8*2]) = 15625	;
      ((*K)[7+8*3]) = -28125	;
      ((*K)[7+8*4]) = -5208.3	;
      ((*K)[7+8*5]) = 7291.7	;
      ((*K)[7+8*6]) = -15625	;
      ((*K)[7+8*7]) = 44792	;

	for(i=0; i<64; i++)
	{
	 ((*K)[i])=((*K)[i])*E/100000; 
	}

  return(1);
  
}


