/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

/*---------------------------------------------------------
	InitTimeData
----------------------------------------------------------*/
void InitTimeData(TimeBlock *TimeData)
{
    int i;
    for(i=0; i<14; i++)
    TimeData->T_field[i]=0.0;
    TimeData->T_flag=0;

return;
}
/*  Vector of time control: TimeBlock
    0=T_start_total
    1=T_start_part
    2=T_total1        : continuously updated
    3=T_total2        : one update
    4=T_restrict
    5=T_prolong
    6=T_error
    7=T_other
    8=T_prep
    9=T_resforce
    10=T_smooth
    11=T_control
    12=T_vector
    13=T_system       : check fitness of current process
*/

/*---------------------------------------------------------
	UpdateTimeData
----------------------------------------------------------*/
void UpdateTimeData(TimeBlock *TimeData)
{
    float tmp;
    float add;
    float *T;
    
    T=TimeData->T_field;
    
    tmp=((float)clock())/((float)CLOCKS_PER_SEC);
    
    if (0==TimeData->T_flag)
    {
        InitTimeData(TimeData);
        T[0]=tmp;
        T[1]=tmp;
    }
    else
    {
        add=tmp-(T[1]);
        T[TimeData->T_flag]+=add;
        T[2]+=add;
        T[3]=tmp-(T[0]);
        T[1]=tmp;
    }
    
return;
}
/*---------------------------------------------------------
	ChangeTimeFlag
----------------------------------------------------------*/
void ChangeTimeFlag(int flag)
{
    SolveBlock *SolBlock;
    PutGetSolveBlock(1,&SolBlock); 
    UpdateTimeData(&(SolBlock->TimeData));  
    SolBlock->TimeData.T_flag=flag;

return;
}

/*---------------------------------------------------------
	PrintTimeData
----------------------------------------------------------*/
void PrintTimeData(void)
{
    float *T;
    SolveBlock *SolBlock;
    PutGetSolveBlock(1,&SolBlock);  
    T=SolBlock->TimeData.T_field;
    printf("Effective:%5.2f  Total:%5.2f/%5.2f Rest:%5.2f Pro:%5.2f Err:%5.2f Oth:%5.2f Prep: %5.2f Resf: %5.2f Smo:%5.2f Contr:%5.2f Vec:%5.2f\n",
    T[4]+T[5]+T[9]+T[10]+T[12],T[2], T[3], T[4], T[5], T[6], T[7], T[8], T[9], T[10], T[11], T[12]);
return;
}

/*---------------------------------------------------------
	PrintCheckTimeData
----------------------------------------------------------*/
void PrintCheckTimeData(void)
{
    float *T;
    SolveBlock *SolBlock;
    PutGetSolveBlock(1,&SolBlock);  
    T=SolBlock->TimeData.T_field;
    printf("\nSystem Check: %e\n",T[13]);
return;
}
