/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner (Email: info@mulgrido.de)
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
#include <FL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <FL/Fl_Gl_Window.H>

#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define frand() ((double) rand()/(RAND_MAX+1.0))
/*------------------------------------------------------------------------------
     Class Definition MyGraphicsWindow
------------------------------------------------------------------------------*/

MyGraphicsWindow::MyGraphicsWindow(int X,int Y,int W,int H, char*l)
                 : Fl_Gl_Window(X, Y, W, H, 0) {
    

    }

void MyGraphicsWindow::draw_overlay() {
    }

int MyGraphicsWindow::handle(int Event) {
    return Fl_Gl_Window::handle(Event);
    }

void MyGraphicsWindow::draw() 
{
    if (!valid()) 
    {
        MySetViewport(w(),h());
        MyGlContext();
        printf("\n invalid!\n");
    }
    DrawStructure();
}

/*------------------------------------------------------------------------------
     Subroutines for Graphics
------------------------------------------------------------------------------*/   

/*------------------------------------------------------------------------------
     PutGetMainWindow
------------------------------------------------------------------------------*/
void PutGetMainWindow(int choice, MyMainWindowUI **inblock) 
{
     static MyMainWindowUI *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}
/*------------------------------------------------------------------------------
     PutGetGraphicWindow
------------------------------------------------------------------------------*/
void PutGetGraphicWindow(int choice, MyGraphicsWindow **inblock) 
{
     static MyGraphicsWindow *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}
/*------------------------------------------------------------------------------
     idleCallback
------------------------------------------------------------------------------*/
void IdleCallback(void * data)
{
    GraphicBlock *localblock;
                
    PutGetGraphicBlock(1, &localblock);
    localblock->NewObjectFlag=1; 
    UpdateGraphicWindow();
}

/*------------------------------------------------------------------------------
     AddIdleCallback
------------------------------------------------------------------------------*/
void AddIdleCallback()
{
    Fl::add_idle(IdleCallback);
}

/*------------------------------------------------------------------------------
     RemoveIdleCallback
------------------------------------------------------------------------------*/
void RemoveIdleCallback()
{
    Fl::remove_idle(IdleCallback);
}

/*------------------------------------------------------------------------------
     idleCallback2
------------------------------------------------------------------------------*/
void IdleCallback2(void * data)
{
    GraphicBlock *localblock;
                
    PutGetGraphicBlock(1, &localblock);
    localblock->RotateAngleZ+=6.0; 
    if (180.0<localblock->RotateAngleZ) localblock->RotateAngleZ-=360.0;
    UpdateGraphicWindow();
}

/*------------------------------------------------------------------------------
     AddIdleCallback2
------------------------------------------------------------------------------*/
void AddIdleCallback2()
{
    Fl::add_idle(IdleCallback2);
}

/*------------------------------------------------------------------------------
     RemoveIdleCallback2
------------------------------------------------------------------------------*/
void RemoveIdleCallback2()
{
    Fl::remove_idle(IdleCallback2);
}


/*------------------------------------------------------------------------------
     UpdateGraphicWindow
------------------------------------------------------------------------------*/
void UpdateGraphicWindow() 
{
    MyGraphicsWindow *g_window;
    GraphicBlock *localblock;
    int i;
    
    // Fl::add_idle(idleCallback);                
    PutGetGraphicBlock(1, &localblock);
    if(1==(localblock->UpdateFlag))
    {
        PutGetGraphicWindow(1, &g_window); 
        g_window->redraw(); 
        Fl::check();
    }
}
/*------------------------------------------------------------------------------
     PutGetGraphicBlock
------------------------------------------------------------------------------*/
void PutGetGraphicBlock(int choice, GraphicBlock **inblock) 
{
     static GraphicBlock *localblock;
     if (0==choice) {localblock=(*inblock);}
     if (1==choice) {(*inblock)=localblock;}
}


