/*
-------------------------------------------------------------------------
Mulgrido, a grid-based finite element program. 
Copyright (C) 2008 Stefan Hfner
Coding Support: Marco Kessel and David Schneider
Supervision: Carsten Knke, Professor for Statics of Structures, 
Institute of Structural Mechanics, Bauhaus-University Weimar.

This file is part of Mulgrido.

    Mulgrido is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Mulgrido is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Mulgrido.  If not, see <http://www.gnu.org/licenses/>.
-------------------------------------------------------------------------
*/
// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "MyMainWindowUI.h"
#include "MyDataStructures.h"
#include "MyDeclarations.h"

void MyMainWindowUI::cb_Redraw_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_UpdateFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Redraw(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Redraw_i(o,v);
}

void MyMainWindowUI::cb_Zoom_i(Fl_Roller* o, void*) {
  ChangeGraphic_Zoomfactor((float)o->value());
ZoomDisplay->value((float)o->value());
}
void MyMainWindowUI::cb_Zoom(Fl_Roller* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Zoom_i(o,v);
}

void MyMainWindowUI::cb__i(Fl_Slider* o, void*) {
  ChangeGraphic_transY((double) o->value() );
}
void MyMainWindowUI::cb_(Fl_Slider* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb__i(o,v);
}

void MyMainWindowUI::cb_1_i(Fl_Slider* o, void*) {
  ChangeGraphic_transX((double) o->value() );
}
void MyMainWindowUI::cb_1(Fl_Slider* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_1_i(o,v);
}

void MyMainWindowUI::cb_Nothing_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Nothing(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Nothing_i(o,v);
}

void MyMainWindowUI::cb_Material_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Material(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Material_i(o,v);
}

void MyMainWindowUI::cb_Color_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Color(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Color_i(o,v);
}

void MyMainWindowUI::cb_E_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_E(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_E_i(o,v);
}

void MyMainWindowUI::cb_Displacement_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement_i(o,v);
}

void MyMainWindowUI::cb_Displacement1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement1_i(o,v);
}

void MyMainWindowUI::cb_Increment_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment_i(o,v);
}

void MyMainWindowUI::cb_Increment1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment1_i(o,v);
}

void MyMainWindowUI::cb_Unbalanced_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Unbalanced(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Unbalanced_i(o,v);
}

void MyMainWindowUI::cb_Unbalanced1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Unbalanced1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Unbalanced1_i(o,v);
}

void MyMainWindowUI::cb_Increment2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment2_i(o,v);
}

void MyMainWindowUI::cb_Increment3_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment3(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment3_i(o,v);
}

void MyMainWindowUI::cb_Strain_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain_i(o,v);
}

void MyMainWindowUI::cb_Strain1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain1_i(o,v);
}

void MyMainWindowUI::cb_Strain2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain2_i(o,v);
}

void MyMainWindowUI::cb_Stress_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress_i(o,v);
}

void MyMainWindowUI::cb_Stress1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress1_i(o,v);
}

void MyMainWindowUI::cb_Stress2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress2_i(o,v);
}

void MyMainWindowUI::cb_Mises_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Mises(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Mises_i(o,v);
}

void MyMainWindowUI::cb_Eq_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Eq(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Eq_i(o,v);
}

void MyMainWindowUI::cb_Damage_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Damage(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Damage_i(o,v);
}

void MyMainWindowUI::cb_NLEq_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_NLEq(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_NLEq_i(o,v);
}

Fl_Menu_Item MyMainWindowUI::menu_Choice2dold[] = {
 {"Nothing", 0,  (Fl_Callback*)MyMainWindowUI::cb_Nothing, (void*)("Nothing"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Material Type", 0,  (Fl_Callback*)MyMainWindowUI::cb_Material, (void*)("Material Type"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Color Index", 0,  (Fl_Callback*)MyMainWindowUI::cb_Color, (void*)("Color Index"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"E-Modul", 0,  (Fl_Callback*)MyMainWindowUI::cb_E, (void*)("E-Modul"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Ux", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement, (void*)("Displacement Ux"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Uy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement1, (void*)("Displacement Uy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dUx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment, (void*)("Increment dUx"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dUy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment1, (void*)("Increment dUy"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Unbalanced Fx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Unbalanced, (void*)("Unbalanced Fx"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Unbalanced Fy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Unbalanced1, (void*)("Unbalanced Fy"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dFx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment2, (void*)("Increment dFx"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dFy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment3, (void*)("Increment dFy"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain, (void*)("Strain Exy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain1, (void*)("Strain Exx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Eyy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain2, (void*)("Strain Eyy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress, (void*)("Stress Sxx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress1, (void*)("Stress Sxy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Syy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress2, (void*)("Stress Syy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Mises Stress", 0,  (Fl_Callback*)MyMainWindowUI::cb_Mises, (void*)("Mises Stress"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Eq Strain", 0,  (Fl_Callback*)MyMainWindowUI::cb_Eq, (void*)("Eq Strain"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"Damage", 0,  (Fl_Callback*)MyMainWindowUI::cb_Damage, (void*)("Damage"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {"NLEq Strain", 0,  (Fl_Callback*)MyMainWindowUI::cb_NLEq, (void*)("NLEq Strain"), 16, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyMainWindowUI::cb_Nothing1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Nothing1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Nothing1_i(o,v);
}

void MyMainWindowUI::cb_Material1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Material1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Material1_i(o,v);
}

void MyMainWindowUI::cb_Color1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Color1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Color1_i(o,v);
}

void MyMainWindowUI::cb_E1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_E1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_E1_i(o,v);
}

void MyMainWindowUI::cb_Displacement2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement2_i(o,v);
}

void MyMainWindowUI::cb_Displacement3_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement3(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement3_i(o,v);
}

void MyMainWindowUI::cb_Displacement4_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement4(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement4_i(o,v);
}

void MyMainWindowUI::cb_Increment4_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment4(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment4_i(o,v);
}

void MyMainWindowUI::cb_Increment5_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment5(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment5_i(o,v);
}

void MyMainWindowUI::cb_Increment6_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment6(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment6_i(o,v);
}

void MyMainWindowUI::cb_Unbalanced2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Unbalanced2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Unbalanced2_i(o,v);
}

void MyMainWindowUI::cb_Unbalanced3_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Unbalanced3(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Unbalanced3_i(o,v);
}

void MyMainWindowUI::cb_Unbalanced4_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Unbalanced4(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Unbalanced4_i(o,v);
}

void MyMainWindowUI::cb_Increment7_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment7(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment7_i(o,v);
}

void MyMainWindowUI::cb_Increment8_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment8(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment8_i(o,v);
}

void MyMainWindowUI::cb_Increment9_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Increment9(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Increment9_i(o,v);
}

void MyMainWindowUI::cb_Strain3_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain3(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain3_i(o,v);
}

void MyMainWindowUI::cb_Strain4_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain4(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain4_i(o,v);
}

void MyMainWindowUI::cb_Strain5_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain5(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain5_i(o,v);
}

void MyMainWindowUI::cb_Strain6_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain6(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain6_i(o,v);
}

void MyMainWindowUI::cb_Strain7_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain7(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain7_i(o,v);
}

void MyMainWindowUI::cb_Strain8_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain8(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain8_i(o,v);
}

void MyMainWindowUI::cb_Stress3_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress3(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress3_i(o,v);
}

void MyMainWindowUI::cb_Stress4_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress4(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress4_i(o,v);
}

void MyMainWindowUI::cb_Stress5_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress5(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress5_i(o,v);
}

void MyMainWindowUI::cb_Stress6_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress6(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress6_i(o,v);
}

void MyMainWindowUI::cb_Stress7_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress7(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress7_i(o,v);
}

void MyMainWindowUI::cb_Stress8_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress8(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress8_i(o,v);
}

void MyMainWindowUI::cb_Mises1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Mises1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Mises1_i(o,v);
}

void MyMainWindowUI::cb_Eq1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Eq1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Eq1_i(o,v);
}

void MyMainWindowUI::cb_NLEq1_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_NLEq1(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_NLEq1_i(o,v);
}

Fl_Menu_Item MyMainWindowUI::menu_Choice3d[] = {
 {"Nothing", 0,  (Fl_Callback*)MyMainWindowUI::cb_Nothing1, (void*)("Nothing"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Material Type", 0,  (Fl_Callback*)MyMainWindowUI::cb_Material1, (void*)("Material Type"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Color Index", 0,  (Fl_Callback*)MyMainWindowUI::cb_Color1, (void*)("Color Index"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"E-Modul", 0,  (Fl_Callback*)MyMainWindowUI::cb_E1, (void*)("E-Modul"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Ux", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement2, (void*)("Displacement Ux"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Uy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement3, (void*)("Displacement Uy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Uz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement4, (void*)("Displacement Uz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dUx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment4, (void*)("Increment dUx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dUy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment5, (void*)("Increment dUy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dUz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment6, (void*)("Increment dUz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Unbalanced Fx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Unbalanced2, (void*)("Unbalanced Fx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Unbalanced Fy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Unbalanced3, (void*)("Unbalanced Fy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Unbalanced Fz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Unbalanced4, (void*)("Unbalanced Fz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dFx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment7, (void*)("Increment dFx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dFy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment8, (void*)("Increment dFy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Increment dFz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Increment9, (void*)("Increment dFz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain3, (void*)("Strain Exx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Eyy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain4, (void*)("Strain Eyy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Ezz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain5, (void*)("Strain Ezz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain6, (void*)("Strain Exy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Eyz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain7, (void*)("Strain Eyz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain8, (void*)("Strain Exz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress3, (void*)("Stress Sxx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Syy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress4, (void*)("Stress Syy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Szz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress5, (void*)("Stress Szz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress6, (void*)("Stress Sxy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Syz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress7, (void*)("Stress Syz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxz", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress8, (void*)("Stress Sxz"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Mises Stress", 0,  (Fl_Callback*)MyMainWindowUI::cb_Mises1, (void*)("Mises Stress"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Eq Strain", 0,  (Fl_Callback*)MyMainWindowUI::cb_Eq1, (void*)("Eq Strain"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"NLEq Strain", 0,  (Fl_Callback*)MyMainWindowUI::cb_NLEq1, (void*)("NLEq Strain"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyMainWindowUI::cb_Nothing2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Nothing2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Nothing2_i(o,v);
}

void MyMainWindowUI::cb_Material2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Material2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Material2_i(o,v);
}

void MyMainWindowUI::cb_Color2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Color2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Color2_i(o,v);
}

void MyMainWindowUI::cb_E2_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_E2(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_E2_i(o,v);
}

void MyMainWindowUI::cb_Displacement5_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement5(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement5_i(o,v);
}

void MyMainWindowUI::cb_Displacement6_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Displacement6(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Displacement6_i(o,v);
}

void MyMainWindowUI::cb_Strain9_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strain9(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strain9_i(o,v);
}

void MyMainWindowUI::cb_Straina_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Straina(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Straina_i(o,v);
}

void MyMainWindowUI::cb_Strainb_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Strainb(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Strainb_i(o,v);
}

void MyMainWindowUI::cb_Stress9_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stress9(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stress9_i(o,v);
}

void MyMainWindowUI::cb_Stressa_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stressa(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stressa_i(o,v);
}

void MyMainWindowUI::cb_Stressb_i(Fl_Menu_*, void* v) {
  ChangeGraphic_SelectObject
((void*)v);
}
void MyMainWindowUI::cb_Stressb(Fl_Menu_* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stressb_i(o,v);
}

Fl_Menu_Item MyMainWindowUI::menu_Choice2d[] = {
 {"Nothing", 0,  (Fl_Callback*)MyMainWindowUI::cb_Nothing2, (void*)("Nothing"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Material Type", 0,  (Fl_Callback*)MyMainWindowUI::cb_Material2, (void*)("Material Type"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Color Index", 0,  (Fl_Callback*)MyMainWindowUI::cb_Color2, (void*)("Color Index"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"E-Modul", 0,  (Fl_Callback*)MyMainWindowUI::cb_E2, (void*)("E-Modul"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Ux", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement5, (void*)("Displacement Ux"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Displacement Uy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Displacement6, (void*)("Displacement Uy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strain9, (void*)("Strain Exy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Exx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Straina, (void*)("Strain Exx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Strain Eyy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Strainb, (void*)("Strain Eyy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxx", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stress9, (void*)("Stress Sxx"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Sxy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stressa, (void*)("Stress Sxy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Stress Syy", 0,  (Fl_Callback*)MyMainWindowUI::cb_Stressb, (void*)("Stress Syy"), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyMainWindowUI::cb_Macro_i(Fl_Button*, void*) {
  OpenInputGeomWin();
}
void MyMainWindowUI::cb_Macro(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Macro_i(o,v);
}

void MyMainWindowUI::cb_Mesh_i(Fl_Button*, void*) {
  OpenInputMeshWin();
}
void MyMainWindowUI::cb_Mesh(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Mesh_i(o,v);
}

void MyMainWindowUI::cb_Meso_i(Fl_Button*, void*) {
  OpenInputMesoWin();
}
void MyMainWindowUI::cb_Meso(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Meso_i(o,v);
}

void MyMainWindowUI::cb_Loads_i(Fl_Button*, void*) {
  OpenInputLoadWin();
}
void MyMainWindowUI::cb_Loads(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Loads_i(o,v);
}

void MyMainWindowUI::cb_Solve_i(Fl_Button*, void*) {
  OpenInputSolveWin();
}
void MyMainWindowUI::cb_Solve(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Solve_i(o,v);
}

void MyMainWindowUI::cb_Color3_i(Fl_Value_Slider* o, void*) {
  ChangeGraphic_ActPalette((int)o->value());
}
void MyMainWindowUI::cb_Color3(Fl_Value_Slider* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Color3_i(o,v);
}

void MyMainWindowUI::cb_Level_i(Fl_Counter* o, void*) {
  ChangeGraphic_ShowLevel((int)o->value());
}
void MyMainWindowUI::cb_Level(Fl_Counter* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Level_i(o,v);
}

void MyMainWindowUI::cb_Cont_i(Fl_Button*, void*) {
  ChangeGraphic_RunFlag((int)0);
}
void MyMainWindowUI::cb_Cont(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Cont_i(o,v);
}

void MyMainWindowUI::cb_Pause_i(Fl_Button*, void*) {
  ChangeGraphic_RunFlag((int)1);
}
void MyMainWindowUI::cb_Pause(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Pause_i(o,v);
}

void MyMainWindowUI::cb_Step_i(Fl_Button*, void*) {
  ChangeGraphic_RunFlag((int)2);
}
void MyMainWindowUI::cb_Step(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Step_i(o,v);
}

void MyMainWindowUI::cb_Stop_i(Fl_Button*, void*) {
  ChangeGraphic_RunFlag((int)3);
}
void MyMainWindowUI::cb_Stop(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Stop_i(o,v);
}

void MyMainWindowUI::cb_Deflect_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_Deflect((float)o->value());
}
void MyMainWindowUI::cb_Deflect(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Deflect_i(o,v);
}

void MyMainWindowUI::cb_Frames_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_Frames((int)o->value());
}
void MyMainWindowUI::cb_Frames(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Frames_i(o,v);
}

void MyMainWindowUI::cb_ShowValues_i(Fl_Check_Button* o, void*) {
  ChangeGraphic_ShowValues
((int)(double)o->value());
}
void MyMainWindowUI::cb_ShowValues(Fl_Check_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_ShowValues_i(o,v);
}

void MyMainWindowUI::cb_File_i(Fl_Button*, void*) {
  OpenFileBaseWin();
}
void MyMainWindowUI::cb_File(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_File_i(o,v);
}

void MyMainWindowUI::cb_Energy_i(Fl_Button*, void*) {
  PostSystemEnergy();
}
void MyMainWindowUI::cb_Energy(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Energy_i(o,v);
}

void MyMainWindowUI::cb_EX_i(Fl_Button*, void*) {
  PostHomogen1();
}
void MyMainWindowUI::cb_EX(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_EX_i(o,v);
}

void MyMainWindowUI::cb_PSave_i(Fl_Button*, void*) {
  PostSave();
}
void MyMainWindowUI::cb_PSave(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_PSave_i(o,v);
}

void MyMainWindowUI::cb_2_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_PostSaveStep((int)o->value());
}
void MyMainWindowUI::cb_2(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_2_i(o,v);
}

void MyMainWindowUI::cb_RX_i(Fl_Roller* o, void*) {
  ChangeGraphic_RotateAngleX((float)o->value());
}
void MyMainWindowUI::cb_RX(Fl_Roller* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_RX_i(o,v);
}

void MyMainWindowUI::cb_RZ_i(Fl_Roller* o, void*) {
  ChangeGraphic_RotateAngleZ((float)o->value());
}
void MyMainWindowUI::cb_RZ(Fl_Roller* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_RZ_i(o,v);
}

void MyMainWindowUI::cb_Z_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_ExtrudeZ((float)o->value());
}
void MyMainWindowUI::cb_Z(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Z_i(o,v);
}

void MyMainWindowUI::cb_Smooth_i(Fl_Button*, void*) {
  MesoSmooth();
}
void MyMainWindowUI::cb_Smooth(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Smooth_i(o,v);
}

void MyMainWindowUI::cb_3_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_SmoothNum((int)o->value());
}
void MyMainWindowUI::cb_3(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_3_i(o,v);
}

void MyMainWindowUI::cb_PostSmooth_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_PostSmoothFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_PostSmooth(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_PostSmooth_i(o,v);
}

void MyMainWindowUI::cb_Iso_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_IsoLines((int)o->value());
}
void MyMainWindowUI::cb_Iso(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Iso_i(o,v);
}

void MyMainWindowUI::cb_Grid_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_DrawGridFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Grid(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Grid_i(o,v);
}

void MyMainWindowUI::cb_B_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_DrawBCFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_B(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_B_i(o,v);
}

void MyMainWindowUI::cb_Draw_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_DrawNodeFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Draw(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Draw_i(o,v);
}

void MyMainWindowUI::cb_Patch_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_DrawPatchFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Patch(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Patch_i(o,v);
}

void MyMainWindowUI::cb_Size_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_NodeSize((double)o->value());
}
void MyMainWindowUI::cb_Size(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Size_i(o,v);
}

void MyMainWindowUI::cb_Thick_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_LineThickness((double)o->value());
}
void MyMainWindowUI::cb_Thick(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Thick_i(o,v);
}

void MyMainWindowUI::cb_Extr_i(Fl_Value_Input* o, void*) {
  ChangeGraphic_Extrude((float)o->value());
}
void MyMainWindowUI::cb_Extr(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Extr_i(o,v);
}

void MyMainWindowUI::cb_Data_i(Fl_Button*, void*) {
  ChangeGraphic_BmpDataFlag();
}
void MyMainWindowUI::cb_Data(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Data_i(o,v);
}

void MyMainWindowUI::cb_Screenshot_i(Fl_Button*, void*) {
  ChangeGraphic_BmpScreenFlag();
}
void MyMainWindowUI::cb_Screenshot(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Screenshot_i(o,v);
}

void MyMainWindowUI::cb_Sequence_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_BmpDataSeqFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Sequence(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Sequence_i(o,v);
}

void MyMainWindowUI::cb_Sequence1_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_BmpScreenSeqFlag ((int)(double)o->value());
}
void MyMainWindowUI::cb_Sequence1(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Sequence1_i(o,v);
}

void MyMainWindowUI::cb_Read_i(Fl_Button*, void*) {
  ReadBmp();
}
void MyMainWindowUI::cb_Read(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Read_i(o,v);
}

void MyMainWindowUI::cb_Rotate_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_RotateFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Rotate(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Rotate_i(o,v);
}

void MyMainWindowUI::cb_Draw1_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_DrawFrameFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Draw1(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Draw1_i(o,v);
}

void MyMainWindowUI::cb_Detail_i(Fl_Counter* o, void*) {
  ChangeGraphic_DetailLevel((int)o->value());
}
void MyMainWindowUI::cb_Detail(Fl_Counter* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Detail_i(o,v);
}

void MyMainWindowUI::cb_ResetView_i(Fl_Button*, void*) {
  ChangeGraphic_ResetView();
}
void MyMainWindowUI::cb_ResetView(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_ResetView_i(o,v);
}

void MyMainWindowUI::cb_IsoView_i(Fl_Button*, void*) {
  ChangeGraphic_IsoView();
}
void MyMainWindowUI::cb_IsoView(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_IsoView_i(o,v);
}

void MyMainWindowUI::cb_Showroom_i(Fl_Round_Button* o, void*) {
  ChangeGraphic_ShowroomFlag
((int)(double)o->value());
}
void MyMainWindowUI::cb_Showroom(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Showroom_i(o,v);
}

void MyMainWindowUI::cb_TEST1_i(Fl_Button*, void*) {
  TEST1();
}
void MyMainWindowUI::cb_TEST1(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_TEST1_i(o,v);
}

void MyMainWindowUI::cb_TEST2_i(Fl_Button*, void*) {
  TEST2();
}
void MyMainWindowUI::cb_TEST2(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_TEST2_i(o,v);
}

void MyMainWindowUI::cb_GoL_i(Fl_Button*, void*) {
  StartGameOfLife();
}
void MyMainWindowUI::cb_GoL(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_GoL_i(o,v);
}

void MyMainWindowUI::cb_Section_i(Fl_Button*, void*) {
  cb_PrintSectionvalues();
}
void MyMainWindowUI::cb_Section(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Section_i(o,v);
}

void MyMainWindowUI::cb_FinerSplines_i(Fl_Round_Button*, void*) {
  cb_DrawFinerSplines();
}
void MyMainWindowUI::cb_FinerSplines(Fl_Round_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_FinerSplines_i(o,v);
}

void MyMainWindowUI::cb_Factor_i(Fl_Value_Input*, void*) {
  cb_DrawFinerSplines();
}
void MyMainWindowUI::cb_Factor(Fl_Value_Input* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Factor_i(o,v);
}

void MyMainWindowUI::cb_Sxx_i(Fl_Button*, void*) {
  MapSxxInclusion(0);
}
void MyMainWindowUI::cb_Sxx(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Sxx_i(o,v);
}

void MyMainWindowUI::cb_Syy_i(Fl_Button*, void*) {
  MapSxxInclusion(1);
}
void MyMainWindowUI::cb_Syy(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Syy_i(o,v);
}

void MyMainWindowUI::cb_Sxy_i(Fl_Button*, void*) {
  MapSxxInclusion(2);
}
void MyMainWindowUI::cb_Sxy(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Sxy_i(o,v);
}

void MyMainWindowUI::cb_Cir_i(Fl_Button*, void*) {
  createKnMatFieldCircle();
}
void MyMainWindowUI::cb_Cir(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_Cir_i(o,v);
}

void MyMainWindowUI::cb_E11_i(Fl_Button*, void*) {
  PostEnergies();
}
void MyMainWindowUI::cb_E11(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_E11_i(o,v);
}

void MyMainWindowUI::cb_E21_i(Fl_Button*, void*) {
  PostAverages();
}
void MyMainWindowUI::cb_E21(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_E21_i(o,v);
}

void MyMainWindowUI::cb_EY_i(Fl_Button*, void*) {
  PostHomogenY();
}
void MyMainWindowUI::cb_EY(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_EY_i(o,v);
}

void MyMainWindowUI::cb_GO_i(Fl_Button*, void*) {
  PerformMC();
}
void MyMainWindowUI::cb_GO(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_GO_i(o,v);
}

void MyMainWindowUI::cb_About_i(Fl_Button*, void*) {
  OpenInputAboutWin();
}
void MyMainWindowUI::cb_About(Fl_Button* o, void* v) {
  ((MyMainWindowUI*)(o->parent()->user_data()))->cb_About_i(o,v);
}

MyMainWindowUI::MyMainWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(1013, 695, "MULGRIDO");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { MyGraphicsWindow* o = g_window = new MyGraphicsWindow(0, 0, 995, 545, "label");
      o->box(FL_DOWN_BOX);
      o->color(FL_BACKGROUND2_COLOR);
      o->selection_color(FL_BACKGROUND_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(14);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->align(FL_ALIGN_CENTER);
      o->when(FL_WHEN_RELEASE);
    }
    { Fl_Round_Button* o = new Fl_Round_Button(710, 590, 20, 20, "Redraw");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->value(1);
      o->labeltype(FL_NO_LABEL);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_Redraw);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();
    }
    { Fl_Roller* o = new Fl_Roller(615, 570, 85, 20, "Zoom");
      o->type(1);
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)48);
      o->selection_color(FL_LIGHT1);
      o->labelfont(1);
      o->minimum(0.01);
      o->maximum(10);
      o->step(0.02);
      o->value(1);
      o->callback((Fl_Callback*)cb_Zoom);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Output* o = ZoomDisplay = new Fl_Value_Output(715, 570, 40, 15, "x");
      o->box(FL_FLAT_BOX);
      o->value(1);
    }
    { Fl_Value_Output* o = MinX = new Fl_Value_Output(438, 646, 60, 13, "x ");
      o->box(FL_FLAT_BOX);
      o->labelsize(11);
      o->textsize(11);
      o->hide();
      o->deactivate();
    }
    { Fl_Value_Output* o = MaxX = new Fl_Value_Output(499, 646, 55, 13, "max(x)");
      o->box(FL_FLAT_BOX);
      o->labeltype(FL_NO_LABEL);
      o->labelsize(11);
      o->textsize(11);
      o->hide();
      o->deactivate();
    }
    { Fl_Value_Output* o = MinY = new Fl_Value_Output(438, 668, 60, 10, "y ");
      o->box(FL_FLAT_BOX);
      o->labelsize(11);
      o->textsize(11);
      o->hide();
      o->deactivate();
    }
    { Fl_Value_Output* o = MaxY = new Fl_Value_Output(499, 668, 52, 10, "max(y)");
      o->box(FL_FLAT_BOX);
      o->labeltype(FL_NO_LABEL);
      o->labelsize(11);
      o->textsize(11);
      o->hide();
      o->deactivate();
    }
    { Fl_Slider* o = new Fl_Slider(995, 0, 20, 545);
      o->color((Fl_Color)53);
      o->minimum(-1);
      o->step(0.01);
      o->callback((Fl_Callback*)cb_);
    }
    { Fl_Slider* o = new Fl_Slider(0, 545, 995, 20);
      o->type(1);
      o->color((Fl_Color)53);
      o->minimum(-1);
      o->step(0.01);
      o->callback((Fl_Callback*)cb_1);
    }
    { Fl_Choice* o = Choice2dold = new Fl_Choice(400, 570, 130, 20, "View");
      o->box(FL_NO_BOX);
      o->down_box(FL_BORDER_BOX);
      o->selection_color(FL_YELLOW);
      o->labelfont(1);
      o->textcolor(7);
      o->hide();
      o->menu(menu_Choice2dold);
    }
    { Fl_Choice* o = Choice3d = new Fl_Choice(400, 570, 130, 20, "View");
      o->box(FL_NO_BOX);
      o->down_box(FL_BORDER_BOX);
      o->selection_color(FL_YELLOW);
      o->labelfont(1);
      o->textcolor(7);
      o->menu(menu_Choice3d);
    }
    { Fl_Choice* o = Choice2d = new Fl_Choice(400, 570, 130, 20, "View");
      o->down_box(FL_BORDER_BOX);
      o->labelfont(1);
      o->menu(menu_Choice2d);
    }
    { Fl_Button* o = new Fl_Button(10, 570, 60, 20, "Macro");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)218);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Macro);
    }
    { Fl_Button* o = new Fl_Button(75, 570, 60, 20, "Mesh");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)218);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Mesh);
    }
    { Fl_Button* o = new Fl_Button(140, 570, 60, 20, "Meso");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)218);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Meso);
    }
    { Fl_Button* o = new Fl_Button(205, 570, 60, 20, "Loads");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)218);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Loads);
    }
    { Fl_Button* o = new Fl_Button(270, 570, 60, 20, "Solve");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)218);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Solve);
    }
    { Fl_Value_Slider* o = new Fl_Value_Slider(755, 628, 95, 20, "Color Palette");
      o->type(1);
      o->maximum(9);
      o->step(1);
      o->callback((Fl_Callback*)cb_Color3);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Counter* o = Level = new Fl_Counter(400, 595, 130, 15, "Level");
      o->box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(1);
      o->minimum(0);
      o->maximum(1);
      o->step(1);
      o->callback((Fl_Callback*)cb_Level);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(917, 592, 15, 15, "Cont.");
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_FRAME);
      o->color((Fl_Color)2);
      o->callback((Fl_Callback*)cb_Cont);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Button* o = new Fl_Button(917, 572, 15, 15, "Pause");
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_FRAME);
      o->color((Fl_Color)3);
      o->callback((Fl_Callback*)cb_Pause);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Button* o = new Fl_Button(942, 572, 15, 15, "Step");
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_FRAME);
      o->color((Fl_Color)4);
      o->callback((Fl_Callback*)cb_Step);
      o->align(FL_ALIGN_RIGHT);
    }
    { Fl_Button* o = new Fl_Button(942, 592, 15, 15, "Stop");
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_UP_FRAME);
      o->color((Fl_Color)1);
      o->callback((Fl_Callback*)cb_Stop);
      o->align(FL_ALIGN_RIGHT);
    }
    { Fl_Value_Input* o = new Fl_Value_Input(615, 590, 85, 20, "Deflect");
      o->value(1);
      o->callback((Fl_Callback*)cb_Deflect);
    }
    { Fl_Value_Input* o = new Fl_Value_Input(615, 610, 85, 20, "Frames");
      o->value(1);
      o->callback((Fl_Callback*)cb_Frames);
    }
    { Fl_Check_Button* o = ShowValues = new Fl_Check_Button(995, 545, 20, 20);
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_ShowValues);
      o->align(FL_ALIGN_BOTTOM_LEFT);
    }
    { Fl_Button* o = new Fl_Button(10, 595, 60, 20, "File");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_File);
    }
    { Fl_Button* o = new Fl_Button(270, 595, 60, 20, "Energy");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_YELLOW);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Energy);
      o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(223, 671, 25, 20, "EX");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_RED);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_EX);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(140, 620, 60, 20, "PSave");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)92);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_PSave);
      o->deactivate();
    }
    { Fl_Value_Input* o = new Fl_Value_Input(205, 620, 60, 20);
      o->box(FL_PLASTIC_DOWN_BOX);
      o->color((Fl_Color)92);
      o->labelfont(1);
      o->minimum(1);
      o->maximum(1000);
      o->step(1);
      o->value(1);
      o->textfont(1);
      o->callback((Fl_Callback*)cb_2);
      o->deactivate();
    }
    { Fl_Roller* o = new Fl_Roller(799, 572, 50, 15, "RX");
      o->type(1);
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)48);
      o->selection_color(FL_LIGHT1);
      o->labelfont(1);
      o->minimum(-180);
      o->maximum(180);
      o->step(1);
      o->callback((Fl_Callback*)cb_RX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Roller* o = new Fl_Roller(799, 592, 50, 15, "RZ");
      o->type(1);
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)48);
      o->selection_color(FL_LIGHT1);
      o->labelfont(1);
      o->minimum(-180);
      o->maximum(180);
      o->step(1);
      o->callback((Fl_Callback*)cb_RZ);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = new Fl_Value_Input(615, 630, 85, 20, "Z");
      o->callback((Fl_Callback*)cb_Z);
    }
    { Fl_Button* o = new Fl_Button(140, 595, 60, 20, "Smooth");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_GREEN);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Smooth);
    }
    { Fl_Value_Input* o = new Fl_Value_Input(205, 595, 60, 20);
      o->box(FL_PLASTIC_DOWN_BOX);
      o->color(FL_GREEN);
      o->labelfont(1);
      o->maximum(1000);
      o->step(1);
      o->textfont(1);
      o->callback((Fl_Callback*)cb_3);
      o->align(FL_ALIGN_RIGHT);
    }
    { Fl_Round_Button* o = new Fl_Round_Button(535, 570, 20, 20, "PostSmooth");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->value(1);
      o->labeltype(FL_NO_LABEL);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_PostSmooth);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = new Fl_Value_Input(965, 621, 35, 20, "Iso");
      o->callback((Fl_Callback*)cb_Iso);
    }
    { Fl_Round_Button* o = new Fl_Round_Button(900, 640, 20, 20, "Grid");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Grid);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();
    }
    { Fl_Round_Button* o = new Fl_Round_Button(900, 620, 20, 20, "B.C.");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_B);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Round_Button* o = new Fl_Round_Button(910, 651, 20, 20, "Draw Node");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Draw);
      o->align(FL_ALIGN_LEFT);
      o->hide();
    }
    { Fl_Round_Button* o = new Fl_Round_Button(900, 661, 20, 20, "Patch");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->value(1);
      o->callback((Fl_Callback*)cb_Patch);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();
    }
    { Fl_Value_Input* o = new Fl_Value_Input(975, 650, 35, 15, "Size");
      o->value(10);
      o->callback((Fl_Callback*)cb_Size);
      o->hide();
    }
    { Fl_Value_Input* o = new Fl_Value_Input(965, 662, 35, 20, "Thick");
      o->value(2);
      o->callback((Fl_Callback*)cb_Thick);
      o->deactivate();
    }
    { Fl_Value_Input* o = new Fl_Value_Input(965, 641, 35, 20, "Extr.");
      o->callback((Fl_Callback*)cb_Extr);
    }
    { Fl_Button* o = new Fl_Button(10, 644, 85, 20, "Data Image");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->callback((Fl_Callback*)cb_Data);
    }
    { Fl_Button* o = new Fl_Button(10, 668, 85, 20, "Screenshot");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->callback((Fl_Callback*)cb_Screenshot);
    }
    { Fl_Round_Button* o = new Fl_Round_Button(97, 646, 20, 20, "Sequence");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Sequence);
      o->align(FL_ALIGN_RIGHT);
      o->deactivate();
    }
    { Fl_Round_Button* o = new Fl_Round_Button(97, 669, 20, 20, "Sequence");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Sequence1);
      o->align(FL_ALIGN_RIGHT);
      o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(10, 620, 85, 20, "Read Image");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->callback((Fl_Callback*)cb_Read);
      //o->deactivate();
    }
    { Fl_Round_Button* o = new Fl_Round_Button(480, 670, 20, 20, "Rotate-3D");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Rotate);
      o->align(68);
      o->hide();
    }
    { Fl_Round_Button* o = new Fl_Round_Button(810, 680, 20, 20, "Draw Frame");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Draw1);
      o->align(FL_ALIGN_LEFT);
      o->hide();
    }
    { Fl_Counter* o = Detail = new Fl_Counter(400, 613, 130, 15, "Detail");
      o->box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(1);
      o->minimum(0);
      o->maximum(1);
      o->step(1);
      o->callback((Fl_Callback*)cb_Detail);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();
    }
    { Fl_Button* o = ResetView = new Fl_Button(756, 572, 15, 15);
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_UP_FRAME);
      o->color((Fl_Color)176);
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_ResetView);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Button* o = IsoView = new Fl_Button(756, 591, 15, 15);
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_UP_FRAME);
      o->color(FL_BLUE);
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_IsoView);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Round_Button* o = Showroom = new Fl_Round_Button(710, 608, 20, 20);
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Showroom);
      o->align(72);
      o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(565, 653, 85, 21, "TEST1");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->callback((Fl_Callback*)cb_TEST1);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(565, 675, 85, 20, "TEST2");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->callback((Fl_Callback*)cb_TEST2);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(660, 650, 25, 25, "GoL");
      o->box(FL_OFLAT_BOX);
      o->color((Fl_Color)247);
      o->labelfont(4);
      o->callback((Fl_Callback*)cb_GoL);
      o->hide();
    }
    { Fl_Value_Slider* o = x_section = new Fl_Value_Slider(285, 646, 115, 15, "x");
      o->type(1);
      o->labelsize(11);
      o->maximum(0);
      o->step(1);
      o->align(FL_ALIGN_LEFT);
      o->hide();
      o->deactivate();
    }
    { Fl_Value_Slider* o = y_section = new Fl_Value_Slider(285, 668, 115, 15, "y");
      o->type(1);
      o->labelsize(11);
      o->maximum(0);
      o->step(1);
      o->align(FL_ALIGN_LEFT);
      o->hide();
      o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(205, 657, 60, 20, "Section");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)198);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Section);
      o->deactivate();
    }
    { Fl_Round_Button* o = FinerSplines = new Fl_Round_Button(910, 680, 20, 20, "FinerSplines");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->callback((Fl_Callback*)cb_FinerSplines);
      o->align(FL_ALIGN_LEFT);
      o->hide();
    }
    { Fl_Value_Input* o = Factor = new Fl_Value_Input(975, 680, 35, 15, "Factor");
      o->minimum(2);
      o->maximum(20);
      o->step(1);
      o->value(2);
      o->callback((Fl_Callback*)cb_Factor);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(650, 675, 25, 20, "Sxx");
      o->box(FL_OFLAT_BOX);
      o->color((Fl_Color)247);
      o->labelfont(4);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Sxx);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(675, 675, 25, 20, "Syy");
      o->box(FL_OFLAT_BOX);
      o->color((Fl_Color)247);
      o->labelfont(4);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Syy);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(700, 675, 25, 20, "Sxy");
      o->box(FL_OFLAT_BOX);
      o->color((Fl_Color)247);
      o->labelfont(4);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Sxy);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(685, 650, 25, 20, "Cir");
      o->box(FL_OFLAT_BOX);
      o->color((Fl_Color)247);
      o->labelfont(4);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Cir);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(185, 670, 20, 20, "E1");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_YELLOW);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_E11);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(204, 670, 20, 20, "E2");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_YELLOW);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_E21);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(247, 671, 25, 20, "EY");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_RED);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_EY);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(290, 625, 25, 20, "GO");
      o->box(FL_OVAL_BOX);
      o->color(FL_RED);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_GO);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(358, 648, 60, 20, "About");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)208);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_About);
    }
    { Fl_Text_Display* o = new Fl_Text_Display(495, 646, 20, 25, "Mulgrido");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(17);
      o->align(FL_ALIGN_LEFT);
    }
    o->end();
    o->resizable(o);
  }
}

void MyInputGeomWindowUI::cb_OK_i(Fl_Button*, void*) {
  GeomWin_cb_OK();
}
void MyInputGeomWindowUI::cb_OK(Fl_Button* o, void* v) {
  ((MyInputGeomWindowUI*)(o->parent()->user_data()))->cb_OK_i(o,v);
}

void MyInputGeomWindowUI::cb_Cancel_i(Fl_Button*, void*) {
  GeomWin_callback();
}
void MyInputGeomWindowUI::cb_Cancel(Fl_Button* o, void* v) {
  ((MyInputGeomWindowUI*)(o->parent()->user_data()))->cb_Cancel_i(o,v);
}

MyInputGeomWindowUI::MyInputGeomWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(216, 199, "Macroscale Geometry");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Value_Input* o = Length = new Fl_Value_Input(75, 21, 95, 20, "Length");
      o->value(100);
    }
    { Fl_Value_Input* o = Height = new Fl_Value_Input(75, 46, 95, 20, "Height");
      o->value(100);
    }
    { Fl_Value_Input* o = Depth = new Fl_Value_Input(75, 71, 95, 19, "Depth");
      o->value(100);
    }
    { Fl_Button* o = new Fl_Button(138, 164, 60, 20, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)224);
      o->callback((Fl_Callback*)cb_OK);
    }
    { Fl_Button* o = new Fl_Button(13, 164, 60, 20, "Cancel");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_BLACK);
      o->callback((Fl_Callback*)cb_Cancel);
    }
    { Fl_Value_Slider* o = ModelDim = new Fl_Value_Slider(75, 101, 60, 20, "D-Model");
      o->type(5);
      o->minimum(2);
      o->maximum(3);
      o->step(1);
      o->value(2);
      o->textfont(1);
      o->textsize(14);
      o->align(FL_ALIGN_RIGHT);
      o->deactivate();
    }
    o->end();
    o->resizable(o);
  }
}

void MyInputMeshWindowUI::cb_OK1_i(Fl_Button*, void*) {
  MeshWin_cb_OK();
}
void MyInputMeshWindowUI::cb_OK1(Fl_Button* o, void* v) {
  ((MyInputMeshWindowUI*)(o->parent()->user_data()))->cb_OK1_i(o,v);
}

void MyInputMeshWindowUI::cb_Cancel1_i(Fl_Button*, void*) {
  MeshWin_callback();
}
void MyInputMeshWindowUI::cb_Cancel1(Fl_Button* o, void* v) {
  ((MyInputMeshWindowUI*)(o->parent()->user_data()))->cb_Cancel1_i(o,v);
}

MyInputMeshWindowUI::MyInputMeshWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(266, 230, "Mesh");
    w = o;
    o->selection_color(FL_FOREGROUND_COLOR);
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Button* o = new Fl_Button(190, 195, 60, 20, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)240);
      o->callback((Fl_Callback*)cb_OK1);
    }
    { Fl_Button* o = new Fl_Button(15, 195, 60, 20, "Cancel");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_FOREGROUND_COLOR);
      o->callback((Fl_Callback*)cb_Cancel1);
    }
    { Fl_Value_Input* o = MinDof = new Fl_Value_Input(145, 20, 90, 20, "Degrees of Freedom");
      o->maximum(0);
      o->value(20000);
    }
    { Fl_Value_Input* o = new Fl_Value_Input(150, 90, 85, 20, "Max. Element Length");
      o->deactivate();
    }
    o->end();
    o->resizable(o);
  }
}

void MyInputMesoWindowUI::cb_Generate_i(Fl_Button*, void*) {
  MesoWin_cb_OK();
}
void MyInputMesoWindowUI::cb_Generate(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Generate_i(o,v);
}

void MyInputMesoWindowUI::cb_Cancel2_i(Fl_Button*, void*) {
  MesoWin_callback();
}
void MyInputMesoWindowUI::cb_Cancel2(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Cancel2_i(o,v);
}

void MyInputMesoWindowUI::cb_MaterialNumBegin_i(Fl_Value_Input*, void*) {
  MesoWin_cb_InputControl((int) 0);
}
void MyInputMesoWindowUI::cb_MaterialNumBegin(Fl_Value_Input* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_MaterialNumBegin_i(o,v);
}

void MyInputMesoWindowUI::cb_Apply_i(Fl_Button*, void*) {
  MesoWin_cb_Apply((int) 0);
}
void MyInputMesoWindowUI::cb_Apply(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Apply_i(o,v);
}

void MyInputMesoWindowUI::cb_MaterialNumEnd_i(Fl_Value_Input*, void*) {
  MesoWin_cb_InputControl((int) 1);
}
void MyInputMesoWindowUI::cb_MaterialNumEnd(Fl_Value_Input* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_MaterialNumEnd_i(o,v);
}

void MyInputMesoWindowUI::cb_Apply1_i(Fl_Button*, void*) {
  MesoWin_cb_Apply((int) 1);
}
void MyInputMesoWindowUI::cb_Apply1(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Apply1_i(o,v);
}

void MyInputMesoWindowUI::cb_Finish_i(Fl_Button*, void*) {
  MesoWin_callback();
}
void MyInputMesoWindowUI::cb_Finish(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Finish_i(o,v);
}

void MyInputMesoWindowUI::cb_Material3_i(Fl_Button*, void*) {
  MaterialInfo();
}
void MyInputMesoWindowUI::cb_Material3(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Material3_i(o,v);
}

void MyInputMesoWindowUI::cb_la_i(Fl_Value_Input*, void*) {
  RecomputeSpecimenSize();
}
void MyInputMesoWindowUI::cb_la(Fl_Value_Input* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_la_i(o,v);
}

void MyInputMesoWindowUI::cb_lb_i(Fl_Value_Input*, void*) {
  RecomputeSpecimenSize();
}
void MyInputMesoWindowUI::cb_lb(Fl_Value_Input* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_lb_i(o,v);
}

void MyInputMesoWindowUI::cb_lx_i(Fl_Value_Input*, void*) {
  RecomputeElementSize();
}
void MyInputMesoWindowUI::cb_lx(Fl_Value_Input* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_lx_i(o,v);
}

void MyInputMesoWindowUI::cb_ly_i(Fl_Value_Input*, void*) {
  RecomputeElementSize();
}
void MyInputMesoWindowUI::cb_ly(Fl_Value_Input* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_ly_i(o,v);
}

void MyInputMesoWindowUI::cb_Invisible_i(Fl_Button*, void*) {
  MesoWin_cb_Apply((int) 3);
}
void MyInputMesoWindowUI::cb_Invisible(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Invisible_i(o,v);
}

void MyInputMesoWindowUI::cb_Visible_i(Fl_Button*, void*) {
  MesoWin_cb_Apply((int) 2);
}
void MyInputMesoWindowUI::cb_Visible(Fl_Button* o, void* v) {
  ((MyInputMesoWindowUI*)(o->parent()->user_data()))->cb_Visible_i(o,v);
}

MyInputMesoWindowUI::MyInputMesoWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(372, 594, "Mesoscale Geometry");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Text_Display* o = new Fl_Text_Display(-5, 15, 15, 20, "Young\'s Modulus");
      o->box(FL_NO_BOX);
      o->align(FL_ALIGN_RIGHT);
    }
    { Fl_Value_Input* o = E_Matrix = new Fl_Value_Input(125, 15, 60, 20);
      o->value(100000);
      o->align(FL_ALIGN_BOTTOM_LEFT);
    }
    { Fl_Value_Input* o = E_Inclusion = new Fl_Value_Input(195, 15, 60, 20);
      o->value(200000);
      o->align(FL_ALIGN_BOTTOM_LEFT);
    }
    { Fl_Value_Input* o = Mu_Matrix = new Fl_Value_Input(125, 38, 60, 20, "Matrix");
      o->value(0.2);
      o->align(FL_ALIGN_BOTTOM_LEFT);
    }
    { Fl_Value_Input* o = Mu_Inclusion = new Fl_Value_Input(195, 38, 60, 20, "Inclusion");
      o->value(0.2);
      o->align(FL_ALIGN_BOTTOM_LEFT);
    }
    { Fl_Value_Input* o = MinSize = new Fl_Value_Input(125, 98, 55, 20, "Aggregate sizes");
      o->maximum(0);
      o->value(8);
    }
    { Fl_Value_Input* o = MaxSize = new Fl_Value_Input(200, 98, 55, 20, "to");
      o->value(32);
    }
    { Fl_Value_Input* o = VolFraction = new Fl_Value_Input(125, 123, 55, 20, "Volume Fraction");
      o->value(0.4);
    }
    { Fl_Round_Button* o = FullerFlag = new Fl_Round_Button(125, 150, 20, 20, "Fuller Curve");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->value(1);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = FullerExponent = new Fl_Value_Input(220, 150, 35, 20, "Exponent");
      o->value(0.5);
    }
    { Fl_Value_Slider* o = Smoothness = new Fl_Value_Slider(125, 210, 130, 20, "rounded");
      o->type(1);
      o->color(FL_BACKGROUND2_COLOR);
      o->value(0.5);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Slider* o = Compactness = new Fl_Value_Slider(125, 185, 130, 20, "compact");
      o->type(1);
      o->color(FL_BACKGROUND2_COLOR);
      o->value(0.5);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Text_Display* o = Longishness = new Fl_Text_Display(307, 185, 20, 20, "longish");
      o->box(FL_NO_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Slider* o = Deformed = new Fl_Value_Slider(125, 260, 130, 20, "symmetric");
      o->type(1);
      o->color(FL_BACKGROUND2_COLOR);
      o->value(0.5);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Slider* o = Roughness = new Fl_Value_Slider(125, 235, 130, 20, "smooth");
      o->type(1);
      o->color(FL_BACKGROUND2_COLOR);
      o->value(0.5);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Round_Button* o = DeformedFlag = new Fl_Round_Button(31, 259, 25, 25, "I/O");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Text_Display* o = new Fl_Text_Display(298, 210, 18, 20, "sharp");
      o->box(FL_NO_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Button* o = new Fl_Button(275, 320, 75, 20, "Generate");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)222);
      o->callback((Fl_Callback*)cb_Generate);
    }
    { Fl_Button* o = new Fl_Button(283, 458, 60, 20, "Cancel");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_FOREGROUND_COLOR);
      o->callback((Fl_Callback*)cb_Cancel2);
    }
    { Fl_Text_Display* o = new Fl_Text_Display(321, 260, 18, 20, "deformed");
      o->box(FL_NO_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Text_Display* o = new Fl_Text_Display(300, 235, 10, 20, "rough");
      o->box(FL_NO_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = E_Material = new Fl_Value_Input(121, 372, 85, 20, "Young\'s Modulus");
      o->value(100000);
      //o->deactivate();
    }
    { Fl_Value_Input* o = MaterialNumBegin = new Fl_Value_Input(122, 322, 56, 20, "Material Number");
      o->maximum(16);
      o->step(1);
      o->callback((Fl_Callback*)cb_MaterialNumBegin);
      //o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(210, 372, 45, 20, "Apply");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)232);
      o->callback((Fl_Callback*)cb_Apply);
      //o->deactivate();
    }
    { Fl_Value_Input* o = MaterialNumEnd = new Fl_Value_Input(195, 320, 60, 22, "to");
      o->maximum(16);
      o->step(1);
      o->callback((Fl_Callback*)cb_MaterialNumEnd);
      //o->deactivate();
    }
    { Fl_Value_Input* o = Mu_Material = new Fl_Value_Input(121, 397, 85, 20, "Poisson\'s Ratio");
      o->step(0.01);
      o->value(0.2);
      //o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(210, 394, 45, 20, "Apply");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)232);
      o->callback((Fl_Callback*)cb_Apply1);
      //o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(210, 419, 45, 20, "Finish");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)89);
      o->callback((Fl_Callback*)cb_Finish);
      //o->deactivate();
    }
    { Fl_Round_Button* o = AddFlag = new Fl_Round_Button(176, 291, 20, 20, "Add?");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Text_Display* o = new Fl_Text_Display(-5, 37, 15, 20, "Poisson\'s Ratio");
      o->box(FL_NO_BOX);
      o->align(FL_ALIGN_RIGHT);
    }
    { Fl_Button* o = new Fl_Button(120, 419, 85, 20, "Material Info ");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)79);
      o->callback((Fl_Callback*)cb_Material3);
      //o->deactivate();
    }
    { Fl_Round_Button* o = RoughFlag = new Fl_Round_Button(31, 235, 25, 25, "I/O");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = la = new Fl_Value_Input(125, 492, 52, 20, "Element Size");
      o->maximum(16);
      o->step(1e-005);
      o->callback((Fl_Callback*)cb_la);
      o->deactivate();
    }
    { Fl_Value_Input* o = lb = new Fl_Value_Input(195, 492, 55, 20, "x ");
      o->maximum(16);
      o->step(1e-005);
      o->callback((Fl_Callback*)cb_lb);
      o->deactivate();
    }
    { Fl_Value_Input* o = lc = new Fl_Value_Input(268, 493, 55, 20, "x ");
      o->maximum(16);
      o->step(1e-005);
      o->deactivate();
    }
    { Fl_Value_Input* o = lx = new Fl_Value_Input(125, 517, 52, 20, "Specimen Size");
      o->maximum(16);
      o->step(1);
      o->callback((Fl_Callback*)cb_lx);
      o->deactivate();
    }
    { Fl_Value_Input* o = ly = new Fl_Value_Input(195, 517, 55, 20, "x ");
      o->maximum(16);
      o->step(1);
      o->callback((Fl_Callback*)cb_ly);
      o->deactivate();
    }
    { Fl_Value_Input* o = lz = new Fl_Value_Input(268, 517, 55, 20, "x ");
      o->maximum(16);
      o->step(1);
      o->deactivate();
    }
    { Fl_Value_Input* o = nex = new Fl_Value_Input(125, 543, 52, 20, "Element Number");
      o->maximum(16);
      o->step(1);
      o->deactivate();
    }
    { Fl_Value_Input* o = ney = new Fl_Value_Input(195, 543, 55, 20, "x ");
      o->maximum(16);
      o->step(1);
      o->deactivate();
    }
    { Fl_Value_Input* o = nez = new Fl_Value_Input(268, 543, 55, 20, "x ");
      o->maximum(16);
      o->step(1);
      o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(275, 390, 60, 15, "Invisible");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_WHITE);
      o->selection_color((Fl_Color)55);
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Invisible);
      //o->deactivate();
    }
    { Fl_Button* o = new Fl_Button(275, 370, 60, 15, "Visible");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)3);
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Visible);
      //o->deactivate();
    }
    o->end();
  }
}

void MyInputLoadWindowUI::cb_Add_i(Fl_Button*, void*) {
  LoadWin_cb_Add();
}
void MyInputLoadWindowUI::cb_Add(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_Add_i(o,v);
}

Fl_Menu_Item MyInputLoadWindowUI::menu_PrimFlag[] = {
 {"Edge", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Corner", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item MyInputLoadWindowUI::menu_NumFlag[] = {
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item MyInputLoadWindowUI::menu_PhyFlag[] = {
 {"Ux", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Uy", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Fx", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Fy", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyInputLoadWindowUI::cb_OK2_i(Fl_Button*, void*) {
  LoadWin_cb_OK();
}
void MyInputLoadWindowUI::cb_OK2(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_OK2_i(o,v);
}

void MyInputLoadWindowUI::cb_Delete_i(Fl_Button*, void*) {
  LoadWin_cb_DeleteOne();
}
void MyInputLoadWindowUI::cb_Delete(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_Delete_i(o,v);
}

void MyInputLoadWindowUI::cb_Delete1_i(Fl_Button*, void*) {
  LoadWin_cb_DeleteAll();
}
void MyInputLoadWindowUI::cb_Delete1(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_Delete1_i(o,v);
}

void MyInputLoadWindowUI::cb_Add1_i(Fl_Button*, void*) {
  LoadWin_cb_Add3d();
}
void MyInputLoadWindowUI::cb_Add1(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_Add1_i(o,v);
}

Fl_Menu_Item MyInputLoadWindowUI::menu_PrimFlag3d[] = {
 {"Face", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Edge", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Corner", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item MyInputLoadWindowUI::menu_NumFlag3d[] = {
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"7", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"9", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"10", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"11", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"12", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item MyInputLoadWindowUI::menu_PhyFlag3d[] = {
 {"Ux", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Uy", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Uz", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Fx", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},

 {"Fy", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Fz", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyInputLoadWindowUI::cb_OK3_i(Fl_Button*, void*) {
  LoadWin_cb_OK();
}
void MyInputLoadWindowUI::cb_OK3(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_OK3_i(o,v);
}

void MyInputLoadWindowUI::cb_Delete2_i(Fl_Button*, void*) {
  LoadWin_cb_DeleteOne3d();
}
void MyInputLoadWindowUI::cb_Delete2(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_Delete2_i(o,v);
}

void MyInputLoadWindowUI::cb_Delete3_i(Fl_Button*, void*) {
  LoadWin_cb_DeleteAll3d();
}
void MyInputLoadWindowUI::cb_Delete3(Fl_Button* o, void* v) {
  ((MyInputLoadWindowUI*)(o->parent()->user_data()))->cb_Delete3_i(o,v);
}

MyInputLoadWindowUI::MyInputLoadWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(391, 338, "Loads and  Boundary Conditions");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Button* o = new Fl_Button(305, 10, 60, 20, "Add");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)3);
      o->callback((Fl_Callback*)cb_Add);
    }
    { Fl_Choice* o = PrimFlag = new Fl_Choice(25, 10, 75, 20);
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_PrimFlag);
    }
    { Fl_Choice* o = NumFlag = new Fl_Choice(100, 10, 35, 20);
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_NumFlag);
    }
    { Fl_Choice* o = PhyFlag = new Fl_Choice(135, 10, 40, 20);
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_PhyFlag);
    }
    BCVal = new Fl_Value_Input(175, 10, 55, 20);
    BCBrowse = new Fl_Browser(25, 35, 265, 205);
    { Fl_Button* o = new Fl_Button(310, 300, 60, 20, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)240);
      o->callback((Fl_Callback*)cb_OK2);
    }
    { Fl_Button* o = new Fl_Button(90, 255, 60, 20, "Delete");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_RED);
      o->callback((Fl_Callback*)cb_Delete);
    }
    DelVal = new Fl_Value_Input(25, 255, 60, 20);
    { Fl_Button* o = new Fl_Button(25, 300, 85, 20, "Delete all");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_FOREGROUND_COLOR);
      o->callback((Fl_Callback*)cb_Delete1);
    }
    BCPot = new Fl_Value_Input(235, 10, 55, 20);
    o->end();
    o->resizable(o);
  }
  { Fl_Double_Window* o = m_window3d = new Fl_Double_Window(391, 338, "Loads and  Boundary Conditions");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Button* o = new Fl_Button(305, 10, 60, 20, "Add");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)3);
      o->callback((Fl_Callback*)cb_Add1);
    }
    { Fl_Choice* o = PrimFlag3d = new Fl_Choice(25, 10, 75, 20);
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_PrimFlag3d);
    }
    { Fl_Choice* o = NumFlag3d = new Fl_Choice(100, 10, 35, 20);
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_NumFlag3d);
    }
    { Fl_Choice* o = PhyFlag3d = new Fl_Choice(135, 10, 40, 20);
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_PhyFlag3d);
    }
    BCVal3d = new Fl_Value_Input(175, 10, 55, 20);
    BCBrowse3d = new Fl_Browser(25, 35, 265, 205);
    { Fl_Button* o = new Fl_Button(310, 300, 60, 20, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)240);
      o->callback((Fl_Callback*)cb_OK3);
    }
    { Fl_Button* o = new Fl_Button(90, 255, 60, 20, "Delete");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_RED);
      o->callback((Fl_Callback*)cb_Delete2);
    }
    DelVal3d = new Fl_Value_Input(25, 255, 60, 20);
    { Fl_Button* o = new Fl_Button(25, 300, 85, 20, "Delete all");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_FOREGROUND_COLOR);
      o->callback((Fl_Callback*)cb_Delete3);
    }
    { Fl_Value_Input* o = BCPot3d = new Fl_Value_Input(235, 10, 55, 20);
      o->deactivate();
    }
    o->end();
    o->resizable(o);
  }
}

Fl_Menu_Item MyInputSolveWindowUI::menu_SolverMethod[] = {
 {"Conjugate Gradient", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Gauss-Seidel", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"PCG (off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"MG - Cycle", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"MG - CS (off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"NL (off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"MG - V (off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"MGCG", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Jacobi (off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"Gauss-Seidel (lex,off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {"Block Jacobi (off)", 0,  0, 0, 1, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyInputSolveWindowUI::cb_OK4_i(Fl_Button*, void*) {
  SolveWin_cb_OK();
}
void MyInputSolveWindowUI::cb_OK4(Fl_Button* o, void* v) {
  ((MyInputSolveWindowUI*)(o->parent()->user_data()))->cb_OK4_i(o,v);
}

void MyInputSolveWindowUI::cb_Cancel3_i(Fl_Button*, void*) {
  SolveWin_callback();
}
void MyInputSolveWindowUI::cb_Cancel3(Fl_Button* o, void* v) {
  ((MyInputSolveWindowUI*)(o->parent()->user_data()))->cb_Cancel3_i(o,v);
}

Fl_Menu_Item MyInputSolveWindowUI::menu_PreCondType[] = {
 {"MG - Cycle", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"MG - CS", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"MG - V", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item MyInputSolveWindowUI::menu_Cycle[] = {
 {"V-Cycle", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"F-Cycle", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"W-Cycle", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"MyCycle", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MyInputSolveWindowUI::cb_Create_i(Fl_Button*, void*) {
  CreateCycle();
}
void MyInputSolveWindowUI::cb_Create(Fl_Button* o, void* v) {
  ((MyInputSolveWindowUI*)(o->parent()->user_data()))->cb_Create_i(o,v);
}

MyInputSolveWindowUI::MyInputSolveWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(554, 571, "Solver Algorithm");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Round_Button* o = OptFactorFlag = new Fl_Round_Button(135, 65, 20, 20, "Optimal Relaxation");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->value(1);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = Omega = new Fl_Value_Input(135, 40, 70, 20, "Relaxation Factor");
      o->maximum(100);
      o->value(1);
    }
    { Fl_Choice* o = SolverMethod = new Fl_Choice(135, 15, 160, 20, "Solver Method");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_SolverMethod);
    }
    { Fl_Button* o = new Fl_Button(270, 465, 60, 20, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_MAGENTA);
      o->callback((Fl_Callback*)cb_OK4);
    }
    { Fl_Button* o = new Fl_Button(50, 460, 60, 20, "Cancel");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_FOREGROUND_COLOR);
      o->callback((Fl_Callback*)cb_Cancel3);
    }
    { Fl_Value_Input* o = Repititions = new Fl_Value_Input(135, 100, 70, 20, "Repititions");
      o->maximum(100);
      o->value(5);
    }
    { Fl_Value_Input* o = NLRadius = new Fl_Value_Input(135, 150, 70, 20, "Non-Local Radius");
      o->maximum(100);
      o->value(10);
      o->deactivate();
    }
    { Fl_Value_Input* o = LimitStrain = new Fl_Value_Input(265, 375, 70, 20, "Limit Elastic Strain");
      o->value(0.0001);
      o->deactivate();
    }
    { Fl_Value_Input* o = DuctileStrain = new Fl_Value_Input(265, 400, 70, 20, "Ductility Strain Parameter");
      o->maximum(100);
      o->value(0.00017);
      o->deactivate();
    }
    { Fl_Value_Input* o = LoadSteps = new Fl_Value_Input(265, 430, 70, 20, "LoadSteps");
      o->maximum(10000);
      o->value(20);
      o->deactivate();
    }
    { Fl_Round_Button* o = BSplineFlag = new Fl_Round_Button(315, 65, 20, 20, "use B-Splines");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();

    }
    { Fl_Value_Input* o = BSpOrderK = new Fl_Value_Input(315, 100, 70, 20, "B-Spline order");
      o->minimum(1);
      o->maximum(10);
      o->step(1);
      o->value(2);
      o->deactivate();
    }
    { Fl_Round_Button* o = EuclidFlag = new Fl_Round_Button(200, 210, 20, 20, "Euclidean Norm");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Round_Button* o = RelEnergyFlag = new Fl_Round_Button(200, 255, 20, 20, "Relative Error Energy");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = EuclidTol = new Fl_Value_Input(230, 210, 140, 20);
      o->maximum(100);
      o->value(1e-006);
    }
    { Fl_Value_Input* o = RelEnergyTol = new Fl_Value_Input(230, 255, 140, 20);
      o->maximum(100);
      o->value(1e-006);
    }
    { Fl_Choice* o = PreCondType = new Fl_Choice(140, 290, 160, 20, "Preconditioner");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_PreCondType);
    }
    { Fl_Check_Button* o = YMsmoothFlag = new Fl_Check_Button(225, 130, 170, 45, "with smoothed Young\264s Modulus");
      o->down_box(FL_DOWN_BOX);
      o->align(198|FL_ALIGN_INSIDE);
      o->deactivate();
    }
    { Fl_Check_Button* o = ContFlag = new Fl_Check_Button(20, 320, 20, 35, "Continue computation");
      o->down_box(FL_DOWN_BOX);
      o->align(200);
    }
    { Fl_Check_Button* o = CircleElementFlag = new Fl_Check_Button(370, 175, 15, 20, "Map circle on elements");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->align(196);
      o->deactivate();
    }
    { Fl_Check_Button* o = CircleIntpntFlag = new Fl_Check_Button(370, 190, 15, 20, "Map circle on int.points");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->align(196);
      o->deactivate();
    }
    { Fl_Choice* o = Cycle = new Fl_Choice(360, 15, 80, 20, "Cycle");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_Cycle);
    }
    { Fl_Button* o = new Fl_Button(445, 15, 50, 45, "Create");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)3);
      o->callback((Fl_Callback*)cb_Create);
    }
    { Fl_Value_Input* o = Smooth = new Fl_Value_Input(360, 40, 80, 20, "Smooth");
      o->value(1);
    }
    { Fl_Round_Button* o = RelEuclidFlag = new Fl_Round_Button(200, 232, 20, 20, "Relative Error Euclid");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->value(1);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Value_Input* o = RelEuclidTol = new Fl_Value_Input(230, 232, 140, 20);
      o->maximum(100);
      o->value(1e-006);
    }
    { Fl_Round_Button* o = SSORFlag = new Fl_Round_Button(420, 65, 20, 20, "SSOR");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->align(FL_ALIGN_LEFT);
      o->deactivate();
    }
    { Fl_Value_Input* o = CheckTime = new Fl_Value_Input(140, 510, 80, 20, "Check Time");
      o->value(10000);
      o->deactivate();
    }
    o->end();
    o->resizable(o);
  }
}

void MyFileBaseWindowUI::cb_OK5_i(Fl_Button*, void*) {
  BaseWin_cb_OK();
}
void MyFileBaseWindowUI::cb_OK5(Fl_Button* o, void* v) {
  ((MyFileBaseWindowUI*)(o->parent()->user_data()))->cb_OK5_i(o,v);
}

void MyFileBaseWindowUI::cb_Cancel4_i(Fl_Button*, void*) {
  BaseWin_callback();
}
void MyFileBaseWindowUI::cb_Cancel4(Fl_Button* o, void* v) {
  ((MyFileBaseWindowUI*)(o->parent()->user_data()))->cb_Cancel4_i(o,v);
}

void MyFileBaseWindowUI::cb_Check_Save_i(Fl_Check_Button* o, int*) {
  if (o->value()==1)
{Check_Open->value(0);};
}
void MyFileBaseWindowUI::cb_Check_Save(Fl_Check_Button* o, int* v) {
  ((MyFileBaseWindowUI*)(o->parent()->user_data()))->cb_Check_Save_i(o,v);
}

void MyFileBaseWindowUI::cb_Check_Open_i(Fl_Check_Button* o, int*) {
  if (o->value()==1)
{Check_Save->value(0);};
}
void MyFileBaseWindowUI::cb_Check_Open(Fl_Check_Button* o, int* v) {
  ((MyFileBaseWindowUI*)(o->parent()->user_data()))->cb_Check_Open_i(o,v);
}

MyFileBaseWindowUI::MyFileBaseWindowUI() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = m_window = new Fl_Double_Window(439, 162, "File Load Save");
    w = o;
    o->user_data((void*)(this));
    o->align(FL_ALIGN_CENTER);
    { Fl_Button* o = new Fl_Button(365, 115, 60, 20, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_MAGENTA);
      o->callback((Fl_Callback*)cb_OK5);
    }
    { Fl_Button* o = new Fl_Button(235, 115, 60, 20, "Cancel");
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_FOREGROUND_COLOR);
      o->callback((Fl_Callback*)cb_Cancel4);
    }
    { Fl_Check_Button* o = Check_Save = new Fl_Check_Button(10, 10, 25, 25, "Save");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Check_Save, (void*)(0));
    }
    { Fl_Check_Button* o = Check_Open = new Fl_Check_Button(135, 10, 25, 25, "Open");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Check_Open, (void*)(0));
    }
    { Fl_Round_Button* o = geometry = new Fl_Round_Button(60, 55, 25, 25, "geometry");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->user_data((void*)(0));
    }
    { Fl_Round_Button* o = Loads = new Fl_Round_Button(60, 85, 25, 25, "Loads");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->user_data((void*)(0));
    }
    File_Input = new Fl_File_Input(235, 40, 195, 35, "File_Input");
    { Fl_Round_Button* o = Results = new Fl_Round_Button(60, 115, 25, 25, "Results");
      o->down_box(FL_ROUND_DOWN_BOX);
      o->user_data((void*)(0));
    }
    o->end();
    o->resizable(o);
  }
}

#include <FL/Fl_Image.H>
static unsigned char idata_Version1b[] =
{234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,67,67,67,121,121,121,164,164,164,
202,202,202,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,202,202,
202,164,164,164,121,121,121,67,67,67,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,134,134,134,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,134,134,134,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,90,90,90,67,67,67,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,67,67,67,90,90,90,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,145,145,145,0,0,0,
195,195,195,221,221,221,221,221,221,221,221,221,195,195,195,0,0,0,145,145,145,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,188,188,188,0,0,0,154,154,154,221,221,221,221,221,221,221,221,221,154,
154,154,0,0,0,180,180,180,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,145,145,145,67,67,
67,0,0,0,107,107,107,188,188,188,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,
0,195,195,195,67,67,67,107,107,107,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,145,145,145,67,67,67,0,0,0,145,145,145,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,145,145,145,67,
67,67,0,0,0,67,67,67,145,145,145,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,0,0,0,107,107,107,221,221,221,221,221,221,221,221,221,107,107,107,0,0,0,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,107,107,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,0,0,0,107,107,107,0,0,0,145,145,145,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,90,90,90,0,0,0,0,0,0,0,0,0,
0,0,0,121,121,121,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,107,107,107,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,107,107,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,107,107,107,0,0,0,208,208,208,221,221,221,208,208,208,0,0,0,107,107,
107,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,164,164,164,0,0,0,107,107,107,195,195,195,221,221,221,
195,195,195,90,90,90,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,145,145,
145,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,164,
164,164,0,0,0,107,107,107,195,195,195,221,221,221,195,195,195,107,107,107,0,0,0,
0,0,0,221,221,221,221,221,221,164,164,164,0,0,0,107,107,107,195,195,195,221,
221,221,195,195,195,107,107,107,0,0,0,164,164,164,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,154,154,154,0,0,0,180,180,180,221,221,221,180,180,180,0,0,0,154,154,154,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,107,107,107,0,0,0,195,195,195,221,221,221,221,221,221,221,
221,221,188,188,188,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,202,202,202,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,107,107,
107,0,0,0,195,195,195,221,221,221,221,221,221,221,221,221,188,188,188,0,0,0,0,0,
0,221,221,221,221,221,221,90,90,90,0,0,0,195,195,195,221,221,221,221,221,221,
221,221,221,195,195,195,0,0,0,90,90,90,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,195,195,195,0,0,0,134,134,134,221,221,
221,134,134,134,0,0,0,188,188,188,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
0,0,0,67,67,67,221,221,221,67,67,67,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,134,134,134,0,0,0,180,
180,180,0,0,0,121,121,121,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,202,202,202,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,107,107,107,0,0,0,
195,195,195,221,221,221,221,221,221,221,221,221,195,195,195,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,107,107,107,0,0,0,188,188,188,221,221,221,221,
221,221,221,221,221,195,195,195,0,0,0,0,0,0,221,221,221,221,221,221,90,90,90,0,
0,0,195,195,195,221,221,221,221,221,221,221,221,221,188,188,188,0,0,0,90,90,
90,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,172,172,172,0,0,0,0,0,0,0,0,0,
164,164,164,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,67,67,
67,0,0,0,172,172,172,221,221,221,208,208,208,107,107,107,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,164,164,164,0,0,0,107,107,
107,195,195,195,221,221,221,195,195,195,107,107,107,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,164,164,164,0,0,0,67,67,67,195,195,195,221,221,221,195,
195,195,107,107,107,0,0,0,0,0,0,221,221,221,221,221,221,164,164,164,0,0,0,107,
107,107,195,195,195,221,221,221,195,195,195,107,107,107,0,0,0,154,154,154,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,202,202,
202,0,0,0,0,0,0,0,0,0,202,202,202,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,145,145,145,0,0,0,0,0,0,0,0,0,0,0,0,121,121,121,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,107,107,107,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,107,107,107,0,0,0,0,0,0,0,0,0,0,0,0,134,134,134,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,107,107,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,
107,107,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,67,67,67,0,0,0,67,67,67,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,145,145,145,67,67,67,0,0,0,
134,134,134,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,145,145,145,67,67,67,0,0,0,107,107,107,
188,188,188,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,145,145,145,67,67,67,0,0,0,145,145,145,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,145,145,145,67,67,67,0,0,0,67,67,67,145,
145,145,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,90,90,90,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,172,172,172,
221,221,221,221,221,221,208,208,208,121,121,121,0,0,0,145,145,145,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,154,154,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,67,67,208,208,
208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,164,164,164,107,107,107,0,0,0,0,0,0,90,90,90,
145,145,145,208,208,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,

221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,

221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,

221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,
0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,
0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,
0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,
0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,
0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,221,221,221,221,221,221,0,0,
0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,
221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,
0,0,0,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,
221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,
221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,
221,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,0,0,0,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,
0,0,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,
221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,0,
0,0,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,
221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,221,221,221,221,221,221,
221,221,0,0,0,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,0,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,0,0,0,221,
221,221,221,221,221,221,221,221,221,221,22